import { ReactElement } from "react";
import { Spinner } from "../spinner";

interface OnboardingMessageLogProps {
	messages: string[];
}

export function OnboardingMessageLog({
	messages,
}: OnboardingMessageLogProps): ReactElement {
	const message = messages[messages.length - 1];
	return (
		<div>
			<p>
				Working on it. You can follow the progress here or move along and we
				will finish everything in the background
			</p>
			<div className="flex flex-col gap-2 items-center p-5 rounded-2xl glass-card">
				<Spinner />
				<p>{message}</p>
			</div>
		</div>
	);
}
