import { ReactElement } from "react";

interface OnboardingCompleteMessageProps {
	title: string;
	description: string;
}

export function OnboardingCompleteMessage({
	title,
	description,
}: OnboardingCompleteMessageProps): ReactElement {
	return (
		<div>
			<h3 className="text-[14px]/5 font-medium flex gap-1 items-center justify-center">
				<i className="codicon codicon-pass-filled"></i>
				<span>{title}</span>
			</h3>
			<p>{description}</p>
		</div>
	);
}
