import { ReactElement, useEffect } from "react";
import LoadingLogo from "../loading-logo";
import { ThemeType } from "../../types/shared-types";

interface LoadingViewProps {
	title: string;
	subTitle: string;
	themeType: ThemeType;
	onCompleted: () => void;
	minDurationSeconds: number;
}

export function LoadingView({
	title,
	subTitle,
	themeType,
	onCompleted,
	minDurationSeconds,
}: LoadingViewProps): ReactElement {
	// Close itself after the specified timeout
	useEffect(() => {
		setTimeout(onCompleted, minDurationSeconds * 1000);
	}, []);

	return (
		<div
			className={`h-full w-full relative flex items-center justify-center text-center`}
		>
			<div>
				<LoadingLogo themeType={themeType} />
				<h1 className="text-[26px] font-normal mt-3 mb-1 text-[var(--vscode-textLink-foreground)]">
					{title}
				</h1>
				<p className="text-[12px]/5 font-normal">{subTitle}</p>
			</div>
		</div>
	);
}
