import { ThemeType } from "../../types/shared-types";
import logoLoaderImagePath from "./logoLoader.svg";
import logoLoaderLightImagePath from "./logoLoader-light.svg";

interface LoadingLogoProps {
	themeType: ThemeType;
}

export default function LoadingLogo({
	themeType,
}: LoadingLogoProps): React.ReactElement {
	const isDark = themeType === "dark" || themeType === "hcDark";
	return (
		<div className="flex flex-col items-center gap-2">
			<img
				src={isDark ? logoLoaderImagePath : logoLoaderLightImagePath}
				alt="Logo"
				className="w-16 h-16 animate-float"
			/>
		</div>
	);
}
