import { PropsWithChildren, ReactElement } from "react";

interface LinkButtonProps {
	onClick: (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
}

/**
 * Button that appear like a link in Kiro colors
 */
export function LinkButton({
	onClick,
	children,
}: PropsWithChildren<LinkButtonProps>): ReactElement {
	return (
		<button
			className="inline link-button hover:underline bg-inherit border-none cursor-pointer"
			onClick={onClick}
		>
			{children}
		</button>
	);
}
