import { ReactElement } from "react";
import ghostSrc from "../kiro-logo/ghost3.svg";
import watermarkSrc from "../kiro-logo/kiro-watermark-logo-small.svg";

interface KiroMainLogoTitleProps {
	description?: string;
}

export function KiroMainLogoTitle({
	description,
}: KiroMainLogoTitleProps): ReactElement {
	return (
		<header className="flex gap-4 mb-5 w-full text-left justify-start items-center">
			<img alt="" src={ghostSrc} className="h-13" />
			<h1 className="flex flex-col items-start gap-1">
				<svg
					width="75"
					height="24"
					viewBox="0 0 75 24"
					fill="none"
					xmlns="http://www.w3.org/2000/svg"
				>
					<path
						d="M26.3409 0.000976562C25.1116 0.000976562 24.1014 0.422747 23.4203 1.22108C22.7562 1.99892 22.4199 3.09467 22.4199 4.47585V19.5233C22.4199 20.8847 22.7463 21.9592 23.3892 22.7187C23.7312 23.168 24.2116 23.5114 24.817 23.7396C25.2409 23.9141 25.739 23.9996 26.3402 23.9996C27.5836 23.9996 28.6066 23.5792 29.299 22.7837C29.9786 22.003 30.3227 20.9066 30.3227 19.5233V4.47585C30.3227 3.09326 29.9779 1.99609 29.299 1.21613C28.6066 0.421334 27.5836 0.000976562 26.3402 0.000976562H26.3409ZM29.08 19.5233C29.08 20.5978 28.8383 21.4202 28.3615 21.9677C27.9058 22.4912 27.2254 22.7569 26.3402 22.7569C25.9015 22.7569 25.556 22.7017 25.2847 22.588L25.2628 22.5795C24.8707 22.4333 24.5705 22.2235 24.3712 21.9571L24.3458 21.9253C23.8922 21.3969 23.6626 20.5887 23.6626 19.5233V4.47585C23.6626 3.39776 23.8993 2.57399 24.3656 2.02717C24.8093 1.5072 25.4733 1.24368 26.3402 1.24368C27.2071 1.24368 27.9058 1.50932 28.3615 2.03212C28.8383 2.57965 29.08 3.40199 29.08 4.47585V19.5233Z"
						fill="currentColor"
					/>
					<path
						d="M44.9513 6.10698C44.468 5.65553 43.7651 5.43652 42.8035 5.43652H39.168V10.2088H42.8035C45.2515 10.2088 45.6168 8.7238 45.6168 7.83787C45.6168 7.10171 45.3928 6.51956 44.9513 6.10698ZM42.8035 8.96541H40.4107V6.67923H42.8035C44.2525 6.67923 44.3741 7.27692 44.3741 7.83787C44.3741 8.39881 44.184 8.96612 42.8035 8.96612V8.96541Z"
						fill="currentColor"
					/>
					<path
						d="M51.2776 11.9742C51.9445 10.8339 52.2829 9.44217 52.2829 7.83704C52.2829 5.13332 51.349 3.07674 49.5065 1.72524C47.9458 0.580732 45.8137 0 43.1686 0H36.4711C35.2517 0 34.2506 0.428838 33.5766 1.23988C32.9231 2.02549 32.5918 3.13185 32.5918 4.52645V19.4728C32.5918 20.8674 32.9231 21.9731 33.5766 22.7594C34.2506 23.5705 35.2517 23.9993 36.4711 23.9993C37.6905 23.9993 38.7177 23.5726 39.403 22.7644C40.0714 21.9766 40.4105 20.8689 40.4105 19.4728V15.643H41.2929L44.7306 21.7131C45.3205 22.7778 46.2658 23.9986 48.3471 23.9986C49.8484 23.9986 51.0968 23.2709 51.7715 22.0021C52.5133 20.6075 52.3783 18.8589 51.4196 17.4382L49.19 14.1417C50.0681 13.5716 50.7682 12.8453 51.2776 11.9749V11.9742ZM48.0151 13.39L47.4004 13.7129L50.3903 18.1334C51.0904 19.1719 51.1992 20.4301 50.6743 21.4185C50.2221 22.2684 49.3743 22.7559 48.3478 22.7559C47.3764 22.7559 46.5745 22.4754 45.8172 21.1084L42.0177 14.4003H39.1678V19.4728C39.1678 20.5658 38.9283 21.403 38.4556 21.9604C38.0077 22.4888 37.3401 22.7566 36.4711 22.7566C35.6021 22.7566 34.9691 22.4902 34.5325 21.9653C34.0698 21.4086 33.8352 20.57 33.8352 19.4728V4.52645C33.8352 3.42928 34.0698 2.59139 34.5325 2.03397C34.9691 1.50905 35.6212 1.24271 36.4711 1.24271H43.1686C45.5106 1.24271 47.4478 1.75632 48.7717 2.72703C50.2772 3.83197 51.0409 5.55085 51.0409 7.83704C51.0409 10.4666 50.0229 12.3352 48.0158 13.3893L48.0151 13.39Z"
						fill="currentColor"
					/>
					<path
						d="M71.8908 3.20489C69.9656 1.13842 67.2407 0.000976562 64.2183 0.000976562C61.196 0.000976562 58.5431 1.08614 56.6618 3.13918C54.7104 5.26782 53.6797 8.33185 53.6797 11.9992C53.6797 15.6666 54.7112 18.7313 56.6618 20.8607C58.5431 22.9137 61.1564 23.9989 64.219 23.9989C67.2816 23.9989 69.9663 22.8607 71.8915 20.7949C73.9092 18.6296 74.976 15.5882 74.976 11.9992C74.976 8.41027 73.9092 5.37026 71.8915 3.20489H71.8908ZM70.9815 19.9472C70.138 20.8529 69.1284 21.5537 67.9818 22.032C66.8288 22.5124 65.5621 22.7562 64.2183 22.7562C61.5139 22.7562 59.2178 21.8102 57.5774 20.0206C55.8401 18.1251 54.9217 15.3508 54.9217 11.9992C54.9217 8.64765 55.8401 5.87399 57.5774 3.97849C59.2171 2.18896 61.5139 1.24298 64.2183 1.24298C65.5621 1.24298 66.8288 1.48671 67.9818 1.96712C69.1284 2.44471 70.138 3.14625 70.9815 4.05125C72.7809 5.98278 73.7326 8.73101 73.7326 11.9985C73.7326 15.266 72.7816 18.0149 70.9815 19.9465V19.9472Z"
						fill="currentColor"
					/>
					<path
						d="M64.2189 5.55078C62.8419 5.55078 61.7116 6.14494 60.95 7.26895C60.2004 8.3746 59.8203 9.96631 59.8203 11.9996C59.8203 14.0328 60.2004 15.6083 60.9493 16.7182C61.7137 17.8507 62.8441 18.4491 64.2189 18.4491C65.5937 18.4491 66.7658 17.857 67.5839 16.7373C68.414 15.6019 68.8344 14.0074 68.8344 11.9996C68.8344 9.99175 68.4133 8.38167 67.5832 7.24988C66.7672 6.13858 65.6043 5.55078 64.2189 5.55078ZM64.2189 17.2057C61.4735 17.2057 61.063 13.9438 61.063 11.9989C61.063 10.244 61.3795 8.84936 61.9786 7.96555C62.5057 7.18771 63.2595 6.79349 64.2189 6.79349C65.1783 6.79349 66.0006 7.19407 66.5814 7.98462C67.2426 8.88539 67.5916 10.2736 67.5916 11.9989C67.5916 15.2593 66.3306 17.2057 64.2189 17.2057Z"
						fill="currentColor"
					/>
					<path
						d="M14.8494 10.3835L18.8502 6.52395C20.1558 5.25157 20.584 3.62736 19.9955 2.17978C19.4571 0.855823 18.1593 0.000976562 16.6898 0.000976562C14.9971 0.000976562 14.1606 0.882668 13.2754 1.81664C13.1687 1.92897 13.0592 2.04484 12.9426 2.16494L9.0301 6.23217C8.768 6.49428 8.50306 6.76557 8.24661 7.04746V4.47656C8.24661 1.67464 6.78065 0.00168374 4.32562 0.00168374C1.87058 0.00168374 0.466797 1.67464 0.466797 4.47656V19.524C0.466797 22.3266 1.90944 24.0003 4.32562 24.0003C6.7418 24.0003 8.24661 22.3273 8.24661 19.524V16.7652L9.46035 15.5896L13.0373 21.7459C13.6343 22.7957 14.5894 23.9996 16.6905 23.9996C18.2095 23.9996 19.5136 23.2422 20.1784 21.9734C20.8976 20.6007 20.75 18.8881 19.7913 17.5041L14.8508 10.3835H14.8494ZM19.0763 21.3962C18.6235 22.2602 17.7538 22.7562 16.6898 22.7562C15.3206 22.7562 14.6707 22.1055 14.1154 21.1284L9.73588 13.5909L7.00249 16.2381V19.5233C7.00249 20.9984 6.53762 22.7562 4.32421 22.7562C2.11079 22.7562 1.70809 20.9977 1.70809 19.5233V4.47585C1.70809 3.00142 2.16165 1.24368 4.32421 1.24368C6.48676 1.24368 7.00249 3.00142 7.00249 4.47585V8.85465L8.15053 9.18387C8.6154 8.43994 9.27243 7.74546 9.91321 7.10468L13.8356 3.02827C13.9536 2.90675 14.0666 2.78735 14.1768 2.67149C15.0211 1.78132 15.5305 1.24368 16.6891 1.24368C17.6506 1.24368 18.4963 1.79474 18.8432 2.64818C19.2346 3.61111 18.9131 4.72736 17.9841 5.63237L13.2252 10.2238L18.7683 18.2127C19.4621 19.2145 19.58 20.4346 19.0756 21.3969L19.0763 21.3962Z"
						fill="currentColor"
					/>
				</svg>
				{description ? (
					<p className="m-[0] font-normal text-[14px] text-[var(--vscode-descriptionForeground)]">
						{description}
					</p>
				) : null}
			</h1>
		</header>
	);
}
