import { ReactElement } from "react";
import wordMarkLogoSrc from "./wordmark-logo.svg";
import ghost1DarkSrc from "./ghost1_dark.svg";
import ghost1LightSrc from "./ghost1_light.svg";
import ghost2DarkSrc from "./ghost2_dark.svg";
import ghost2LightSrc from "./ghost2_light.svg";
import { SignInStatus } from "../../types/sign-in-types";
import { ThemeType } from "../../types/shared-types";

interface KiroWordMarkLogoProps {
	signInStatus?: SignInStatus;
	themeType?: ThemeType;
}

/**
 * Kiro bubble font logo
 */
export function KiroWordmarkLogo({
	signInStatus,
	themeType,
}: KiroWordMarkLogoProps): ReactElement {
	return (
		<div className="relative">
			<img src={wordMarkLogoSrc} />

			{signInStatus && signInStatus !== "pending" && (
				<img
					className="absolute top-[-75px] right-[-75px]"
					alt="Kiro"
					src={
						themeType === "dark" || themeType === "hcDark"
							? ghost1DarkSrc
							: ghost1LightSrc
					}
				/>
			)}
			{signInStatus === "pending" && (
				<img
					className="absolute top-[20px] right-[-60px]"
					alt="Kiro"
					src={
						themeType === "dark" || themeType === "hcDark"
							? ghost2DarkSrc
							: ghost2LightSrc
					}
				/>
			)}
		</div>
	);
}
