import { useState, useEffect } from "react";

interface KiroGhostBlinkingProps {
	className?: string;
	withPurpleBackground?: boolean;
	size?: "sm" | "md" | "lg";
}

export const KiroGhostBlinking = ({
	className,
	withPurpleBackground = false,
	size = "md",
}: KiroGhostBlinkingProps) => {
	const [isBlinking, setIsBlinking] = useState(false);

	useEffect(() => {
		const blinkInterval = setInterval(() => {
			setIsBlinking(true);
			setTimeout(() => setIsBlinking(false), 150);
		}, 3000);
		return () => clearInterval(blinkInterval);
	}, []);

	// Size configurations
	const sizeConfig = {
		sm: { container: "w-12 h-12", ghost: "w-6 h-7" },
		md: { container: "w-14 h-14", ghost: "w-7 h-8" },
		lg: { container: "w-20 h-20", ghost: "w-10 h-12" },
	};

	const { container: containerSize, ghost: ghostSize } = sizeConfig[size];
	const containerClasses = className || containerSize;

	const containerStyle = withPurpleBackground
		? {
				background: "var(--gradient-kiro-purple)",
		  }
		: {};

	return (
		<div
			className={`${containerClasses} ${
				withPurpleBackground ? "rounded-full" : ""
			} flex items-center justify-center transition-all duration-300`}
			style={containerStyle}
		>
			<svg
				xmlns="http://www.w3.org/2000/svg"
				width="20"
				height="24"
				viewBox="0 0 20 24"
				fill="none"
				className={ghostSize}
			>
				<path
					d="M3.80081 18.5661C1.32306 24.0572 6.59904 25.434 10.4904 22.2205C11.6339 25.8242 15.926 23.1361 17.4652 20.3445C20.8578 14.1915 19.4877 7.91459 19.1361 6.61988C16.7244 -2.20972 4.67055 -2.21852 2.59581 6.6649C2.11136 8.21946 2.10284 9.98752 1.82846 11.8233C1.69011 12.749 1.59258 13.3398 1.23436 14.3135C1.02841 14.8733 0.745043 15.3704 0.299833 16.2082C-0.391594 17.5095 -0.0998802 20.021 3.46397 18.7186V18.7195L3.80081 18.5661Z"
					fill="white"
				/>
				<path
					d="M10.9614 10.4413C9.97202 10.4413 9.82422 9.25893 9.82422 8.55407C9.82422 7.91791 9.93824 7.4124 10.1542 7.09197C10.3441 6.81003 10.6158 6.66699 10.9614 6.66699C11.3071 6.66699 11.6036 6.81228 11.8128 7.09892C12.0511 7.42554 12.177 7.92861 12.177 8.55407C12.177 9.73591 11.7226 10.4413 10.9616 10.4413H10.9614Z"
					fill="black"
					style={{ opacity: isBlinking ? 0 : 1 }}
				/>
				<path
					d="M15.0318 10.4413C14.0423 10.4413 13.8945 9.25893 13.8945 8.55407C13.8945 7.91791 14.0086 7.4124 14.2245 7.09197C14.4144 6.81003 14.6861 6.66699 15.0318 6.66699C15.3774 6.66699 15.6739 6.81228 15.8831 7.09892C16.1214 7.42554 16.2474 7.92861 16.2474 8.55407C16.2474 9.73591 15.793 10.4413 15.0319 10.4413H15.0318Z"
					fill="black"
					style={{ opacity: isBlinking ? 0 : 1 }}
				/>
				{isBlinking ? (
					<>
						<rect
							x="9.2"
							y="8.3"
							width="3.2"
							height="1.2"
							rx="0.6"
							fill="black"
						/>
						<rect
							x="14"
							y="8.3"
							width="3.2"
							height="1.2"
							rx="0.6"
							fill="black"
						/>
					</>
				) : null}
			</svg>
		</div>
	);
};
