import { PropsWithChildren, ReactElement } from "react";

import { Spinner } from "../spinner";

interface KiroButtonProps {
	onClick?: () => void;
	disabled?: boolean;
	loading?: boolean;
	type?: "button" | "submit" | "reset";
	style?: "primary" | "secondary";
}

/**
 * Kiro gradient button
 */
export function KiroButton({
	onClick,
	disabled,
	loading,
	type,
	children,
	style,
}: PropsWithChildren<KiroButtonProps>): ReactElement {
	return (
		<button
			className={`rounded-lg ${
				style === "secondary" ? "secondary-button" : "primary-button"
			} ${
				!loading ? "disabled:opacity-50" : ""
			} p-2 w-full text-[14px]/6 font-medium cursor-pointer disabled:cursor-default`}
			onClick={onClick}
			disabled={disabled || loading}
			type={type || "button"}
		>
			{loading ? <Spinner /> : <span>{children}</span>}
		</button>
	);
}
