import { ReactElement, useContext } from "react";
import { AccountDashboardApiContext } from "../../context/account-dashboard-api-context";
import { KiroGhostBlinking } from "../kiro-ghost-blinking";

export function SignInPrompt(): ReactElement {
	const { signIn, close } = useContext(AccountDashboardApiContext);

	const handleSignIn = () => {
		signIn();
		close();
	};

	return (
		<div className="flex flex-col items-center justify-center min-h-[400px] p-8 text-center">
			<div className="mb-6">
				<KiroGhostBlinking withPurpleBackground={true} size="lg" />
			</div>

			<h2 className="text-2xl font-semibold mb-4">
				Sign in to view your account
			</h2>

			<p className="text-gray-400 mb-8 max-w-md">
				Access your usage summary, plan details, and account settings by signing
				in to your Kiro account.
			</p>

			<button
				onClick={handleSignIn}
				className="px-8 py-3 text-white bg-[var(--vscode-button-background)] hover:bg-[var(--vscode-button-hoverBackground)] rounded-lg font-medium transition-colors duration-200"
			>
				Sign In
			</button>
		</div>
	);
}
