import { ReactElement } from "react";
import { UsageBreakdown } from "../../../types/account-dashboard-types";
import {
	formatResourceType,
	hasActiveTrial,
} from "../../../utils/subscription-utils";

interface WelcomeBonusProps {
	trialBreakdowns: UsageBreakdown[];
}

export function WelcomeBonus({
	trialBreakdowns,
}: WelcomeBonusProps): ReactElement {
	const activeTrialBreakdowns = trialBreakdowns.filter(hasActiveTrial);

	return (
		<div className="kiro-welcome-bonus-container">
			<div className="kiro-welcome-bonus-table-wrapper">
				<table className="kiro-welcome-bonus-table">
					<thead>
						<tr>
							<th className="kiro-welcome-bonus-icon-cell">
								<i className="codicon codicon-gift kiro-welcome-bonus-icon"></i>
							</th>
							<th className="kiro-welcome-bonus-type-cell">Bonus Credits</th>
							<th className="kiro-welcome-bonus-expiry-cell">Expiry</th>
							<th className="kiro-welcome-bonus-usage-cell">Est. Usage</th>
						</tr>
					</thead>
					<tbody>
						{activeTrialBreakdowns.map((breakdown, index) => {
							return (
								<tr key={index}>
									<td className="kiro-welcome-bonus-empty-cell"></td>
									<td className="kiro-welcome-bonus-type-cell">
										{breakdown.type
											? breakdown.displayNamePlural || formatResourceType(breakdown.type)
											: "Usage"}
									</td>
									<td className="kiro-welcome-bonus-expiry-cell">
										{breakdown.freeTrialUsage?.daysRemaining ?? 0} days
									</td>
									<td className="kiro-welcome-bonus-usage-cell">
										{Math.min(
											breakdown.freeTrialUsage?.currentUsage ?? 0,
											breakdown.freeTrialUsage?.usageLimit ?? 0
										)}{" "}
										used / {breakdown.freeTrialUsage?.usageLimit ?? 0} total
									</td>
								</tr>
							);
						})}
					</tbody>
				</table>
			</div>
		</div>
	);
}
