import { ReactElement } from "react";
import { UsageBreakdown } from "../../../types/account-dashboard-types";
import { formatResourceType, getProgressColor } from "../../../utils/subscription-utils";

interface UsageItemProps {
	item: UsageBreakdown;
	index: number;
	isDisabled: boolean;
}

export function UsageBreakdownView({
	item,
	index,
	isDisabled,
}: UsageItemProps): ReactElement {
	const progressColor = getProgressColor(item.percentageUsed);

	return (
		<div key={`${item.type || "usage"}-${index}`}>
			<div className="kiro-usage-breakdown-header">
				<span
					className={`kiro-usage-breakdown-title ${
						isDisabled ? "kiro-usage-breakdown-title--disabled" : ""
					}`}
				>
					{item.displayNamePlural || formatResourceType(item?.type) || "Usage"}
				</span>
				<div className="kiro-usage-breakdown-stats">
					<div
						className={`kiro-usage-breakdown-stats-text ${
							isDisabled
								? "kiro-usage-breakdown-stats-text--disabled"
								: "kiro-usage-breakdown-stats-text--enabled"
						}`}
					>
						{isDisabled
							? "Upgrade plan to get spec requests"
							: `${Math.min(item.currentUsage, item.usageLimit).toLocaleString()} used / ${item.usageLimit.toLocaleString()} covered in plan`}
					</div>
				</div>
			</div>
			<div className="kiro-progress-bar-container">
				{isDisabled ? (
					<div className="kiro-progress-bar kiro-progress-bar--disabled"></div>
				) : (
					<div
						className={`kiro-progress-bar ${progressColor}`}
						style={{ width: `${Math.min(item.percentageUsed, 100)}%` }}
					></div>
				)}
			</div>
		</div>
	);
}
