import { ReactElement } from "react";
import { SectionSeparator } from "./section-separator";

interface SectionContainerProps {
	children: React.ReactNode;
	showSeparatorAfter?: boolean;
	showSeparatorBefore?: boolean;
}

export function SectionContainer({
	children,
	showSeparatorAfter = false,
	showSeparatorBefore = false,
}: SectionContainerProps): ReactElement {
	return (
		<>
			{showSeparatorBefore && <SectionSeparator />}
			<div className="kiro-section-container">
				<div className="kiro-section-content">{children}</div>
			</div>
			{showSeparatorAfter && <SectionSeparator />}
		</>
	);
}
