import { ReactElement } from "react";
import { UserInfo } from "../user-info";
import { SectionContainer } from "./index";
import type { UserInfo as UserInfoType } from "../../../types/account-dashboard-types";

interface PageWrapperProps {
	userInfo?: UserInfoType;
	children: React.ReactNode;
	showSeparator?: boolean;
}

export function PageWrapper({
	userInfo,
	children,
	showSeparator = true,
}: PageWrapperProps): ReactElement {
	return (
		<div
			className={`bg-[var(--vscode-welcomePage-tileBackground)] items-center relative overflow-y-auto bg-[var(--vscode-background)] max-h-screen`}
			style={{
				scrollbarWidth: "thin",
				scrollbarColor:
					"var(--vscode-scrollbarSlider-background) var(--vscode-background)",
			}}
		>
			{/* This section should ne present no matter what so keeping it here. */}
			<SectionContainer>
				<UserInfo userInfo={userInfo} />
			</SectionContainer>

			{children}
		</div>
	);
}
