import { ReactElement } from "react";
import { SectionSeparator, SectionContainer, PageWrapper } from ".";

export function LoadingSkeleton(): ReactElement {
	return (
		<div data-testid="loading-skeleton">
		<PageWrapper>
			<SectionContainer showSeparatorBefore>
				{/* Loading content for usage summary */}
				<div className="space-y-6">
					<div className="h-8 bg-[var(--vscode-widget-border)] rounded w-64 animate-pulse"></div>

					<div className="grid grid-cols-1 md:grid-cols-2 gap-6">
						{[1, 2].map((index) => (
							<div
								key={index}
								className="bg-[var(--vscode-welcomePage-tileBackground)] rounded-lg p-6 border border-[var(--vscode-widget-border)]"
							>
								<div className="h-5 bg-[var(--vscode-widget-border)] rounded mb-3 animate-pulse"></div>
								<div className="h-8 bg-[var(--vscode-widget-border)] rounded mb-2 animate-pulse"></div>
								<div className="h-4 bg-[var(--vscode-widget-border)] rounded w-24 animate-pulse"></div>
							</div>
						))}
					</div>
				</div>
			</SectionContainer>

			<SectionSeparator />

			{/* Loading indicator */}
			<div className="flex items-center justify-center my-8">
				<i
					className="codicon codicon-loading codicon-modifier-spin text-[var(--vscode-textLink-foreground)] mr-3"
					style={{ fontSize: "24px" }}
				></i>
				<p className="text-[var(--vscode-foreground)]">
					Loading account information...
				</p>
			</div>
		</PageWrapper>
		</div>
	);
}
