var N = Object.defineProperty;
var b = (n) => {
  throw TypeError(n);
};
var H = (n, e, t) => e in n ? N(n, e, { enumerable: !0, configurable: !0, writable: !0, value: t }) : n[e] = t;
var c = (n, e, t) => H(n, typeof e != "symbol" ? e + "" : e, t), P = (n, e, t) => e.has(n) || b("Cannot " + t);
var T = (n, e, t) => (P(n, e, "read from private field"), t ? t.call(n) : e.get(n)), E = (n, e, t) => e.has(n) ? b("Cannot add the same private member more than once") : e instanceof WeakSet ? e.add(n) : e.set(n, t), U = (n, e, t, r) => (P(n, e, "write to private field"), r ? r.call(n, t) : e.set(n, t), t);
import * as _ from "vscode";
import * as z from "os";
import * as w from "fs";
import * as D from "path";
import S from "crypto";
import { U as d, a as $, b as j, M as x, c as B, d as q, e as J, f as V, I as W, C as G, g as K, A as O, S as I, h as Y, F as m } from "./sso-oidc-client-C8abUy8I.js";
import { l as h, x as l, T as Q } from "./ignore-CEeUmp3m.js";
import "node-machine-id";
import { w as u } from "./span-BJ2ilrye.js";
import "@opentelemetry/api";
import X from "http";
var f;
const g = class g {
  constructor(e) {
    c(this, "baseUrl", "http://127.0.0.1");
    c(this, "oauthCallback", "/oauth/callback");
    c(this, "authenticationFlowTimeoutInMs", 6e5);
    c(this, "authenticationWarningTimeoutInMs", 6e4);
    c(this, "listenTimeoutMs", 1e4);
    c(this, "authenticationPromise");
    c(this, "deferred");
    c(this, "server");
    c(this, "connections");
    c(this, "_closed", !1);
    this.state = e, this.authenticationPromise = new Promise((t, r) => {
      this.deferred = { resolve: t, reject: r };
    }), this.connections = [], this.server = X.createServer((t, r) => {
      if (r.setHeader("Access-Control-Allow-Methods", "GET"), !t.url)
        return;
      const i = new URL(t.url, this.baseUrl);
      switch (i.pathname) {
        case this.oauthCallback: {
          this.handleAuthentication(i.searchParams, r);
          break;
        }
        default:
          h.info("Unexpected invocation of AuthSSOServer. Path: %s", i.pathname);
      }
    }), this.server.on("connection", (t) => {
      this.connections.push(t);
    });
  }
  /** Gets the last initialized instance */
  static get lastInstance() {
    return T(g, f);
  }
  /**
   * Initializes a new AuthSSOServer
   * @param state - The state parameter for validation
   */
  static init(e = "") {
    return u(l.Auth, "auth-server.init", async () => {
      const t = T(g, f);
      if (t !== void 0 && !t.closed)
        try {
          await t.close();
        } catch (i) {
          h.error("Failed to close already existing auth server in AuthSSOServer.init(): %s", i);
        }
      h.debug("AuthSSOServer: Initialized new auth server.");
      const r = new g(e);
      return U(g, f, r), r;
    });
  }
  /** Starts the server */
  start(e) {
    return u(l.Auth, "auth-server.start", async (t) => {
      let r = 0;
      if (this.server.listening)
        throw new d("AuthSSOServer: Server already started");
      return new Promise((i, a) => {
        this.server.on("close", () => {
          a(new d("AuthSSOServer: Server has closed"));
        }), this.server.on("error", (o) => {
          e && e.length > r + 1 ? this.listen(e[++r]) : a(new $(o.message, e));
        });
        const s = setTimeout(() => {
          this.server.listening || (this.close(), a(new j()));
        }, this.listenTimeoutMs);
        this.server.on("listening", () => {
          clearTimeout(s), this.server.address() || a(new x()), t.setAttribute("redirectUri", this.redirectUri), i();
        }), this.listen((e == null ? void 0 : e[0]) || 0);
      });
    });
  }
  listen(e) {
    this.server.listen(e, "127.0.0.1");
  }
  /**
   * Attempts to close the server and swallows exceptions
   */
  attemptClose() {
    (async () => {
      try {
        await this.close();
      } catch {
      }
    })();
  }
  /** Closes the server */
  close() {
    return u(l.Auth, "auth-server.close", async (e) => {
      try {
        e.setAttribute("redirectUri", this.redirectUri);
      } catch {
        e.setAttribute("redirectUri", "");
      }
      return new Promise((t, r) => {
        if (this._closed) {
          t();
          return;
        }
        this.server.listening || r(new d("AuthSSOServer: Server not started")), h.debug("AuthSSOServer: Attempting to close server.");
        for (const i of this.connections)
          i.destroy();
        this.server.close((i) => {
          i && r(i), this._closed = !0, h.debug("AuthSSOServer: Server closed successfully."), t();
        });
      });
    });
  }
  /** Gets the redirect URI */
  get redirectUri() {
    return `${this.baseLocation}${this.oauthCallback}`;
  }
  get baseLocation() {
    return `${this.baseUrl}:${this.getPort()}`;
  }
  /** Gets whether the server is closed */
  get closed() {
    return this._closed;
  }
  /** Gets the server address */
  getAddress() {
    return this.server.address();
  }
  getPort() {
    const e = this.getAddress();
    if (e instanceof Object)
      return e.port;
    if (typeof e == "string")
      return Number.parseInt(e);
    throw new x();
  }
  // TODO: Redirect to a nicer page later with proper UI feedback
  redirect(e) {
    e.writeHead(200, { "Content-Type": "text/html" }), e.write("You can close this window"), e.end();
  }
  handleAuthentication(e, t) {
    var s;
    const r = e.get("error"), i = e.get("error_description");
    if (r && i) {
      r === "access_denied" ? this.handleRequestRejection(t, new B()) : this.handleRequestRejection(t, new q(`${r}: ${i}`));
      return;
    }
    const a = e.get("code");
    if (!a) {
      this.handleRequestRejection(t, new J());
      return;
    }
    if (this.state) {
      const o = e.get("state");
      if (!o) {
        this.handleRequestRejection(t, new V());
        return;
      }
      if (o !== this.state) {
        this.handleRequestRejection(t, new W());
        return;
      }
    }
    (s = this.deferred) == null || s.resolve(a), this.redirect(t);
  }
  handleRequestRejection(e, t) {
    var r;
    this.redirect(e), (r = this.deferred) == null || r.reject(t);
  }
  /** Cancels the current authentication flow */
  cancelCurrentFlow() {
    var e;
    h.debug("AuthSSOServer: Canceling current login flow"), (e = this.deferred) == null || e.reject(new G("user cancellation"));
  }
  /** Waits for authorization to complete */
  async waitForAuthorization() {
    const e = setTimeout(() => {
      h.warn("AuthSSOServer: Authentication is taking a long time");
    }, this.authenticationWarningTimeoutInMs);
    try {
      return await Promise.race([
        this.authenticationPromise,
        new Promise((t, r) => {
          setTimeout(() => {
            r(new K());
          }, this.authenticationFlowTimeoutInMs);
        })
      ]);
    } finally {
      clearTimeout(e), this.attemptClose();
    }
  }
};
f = new WeakMap(), // Last initialized instance of the Auth Server
E(g, f);
let A = g;
const Z = 15 * 60, ee = "https://view.awsapps.com/start", te = "https://amzn.awsapps.com/start";
class re {
  constructor() {
    c(this, "cacheDirectory", D.join(z.homedir(), ".aws", "sso", "cache"));
  }
  getClientRegistrationPath(e) {
    return D.join(this.cacheDirectory, `${e}.json`);
  }
  ensureCacheDirectory() {
    try {
      w.existsSync(this.cacheDirectory) || w.mkdirSync(this.cacheDirectory, { recursive: !0 });
    } catch {
      throw new m(this.cacheDirectory);
    }
  }
  /**
   * Writes client registration to cache
   */
  writeClientRegistration(e, t) {
    this.ensureCacheDirectory();
    const r = this.getClientRegistrationPath(e);
    try {
      w.writeFileSync(r, JSON.stringify(t, void 0, 2));
    } catch {
      throw new m(r);
    }
  }
  /**
   * Reads the currently cached client registration
   */
  readClientRegistration(e) {
    const t = this.getClientRegistrationPath(e);
    if (w.existsSync(t))
      try {
        const r = w.readFileSync(t, "utf8");
        try {
          return JSON.parse(r);
        } catch {
          return;
        }
      } catch {
        throw new m(t);
      }
  }
  /**
   * Deletes the cached client registration file
   */
  deleteClientRegistration(e) {
    const t = this.getClientRegistrationPath(e);
    if (w.existsSync(t))
      try {
        w.unlinkSync(t);
      } catch {
        throw new m(t);
      }
  }
}
class de {
  constructor() {
    c(this, "storage");
    c(this, "authServiceClient");
    c(this, "scopes", [
      "codewhisperer:completions",
      "codewhisperer:analysis",
      "codewhisperer:conversations",
      "codewhisperer:transformations",
      "codewhisperer:taskassist"
    ]);
    c(this, "authServer");
    this.storage = new re(), this.authServiceClient = new O();
  }
  getClientIdHash(e) {
    return S.createHash("sha1").update(JSON.stringify({ startUrl: e })).digest("hex");
  }
  tokenResponseToToken(e, t, r, i) {
    const a = /* @__PURE__ */ new Date(), s = new Date(a.getTime() + Number(e.expiresIn) * 1e3);
    return {
      accessToken: e.accessToken,
      refreshToken: e.refreshToken,
      expiresAt: s.toISOString(),
      clientIdHash: t,
      authMethod: "IdC",
      provider: r,
      region: i
    };
  }
  isClientRegistrationExpired(e) {
    if (!e.expiresAt)
      return !0;
    const t = new Date(e.expiresAt), r = /* @__PURE__ */ new Date();
    return t.valueOf() < r.valueOf() + Z * 1e3;
  }
  async registerClient(e, t, r = !1) {
    return u(l.Auth, "idc-provider.register", async () => {
      const i = this.getClientIdHash(e), s = await new I(t).registerClient(
        {
          clientName: "Kiro IDE",
          clientType: "public",
          scopes: this.scopes,
          grantTypes: ["authorization_code", "refresh_token"],
          redirectUris: ["http://127.0.0.1/oauth/callback"],
          issuerUrl: e
        },
        r
      ), o = {
        clientId: s.clientId,
        clientSecret: s.clientSecret,
        expiresAt: new Date(s.clientSecretExpiresAt * 1e3).toISOString()
      };
      return this.storage.writeClientRegistration(i, o), o;
    });
  }
  getStartUrl(e) {
    return e.provider === "Enterprise" ? e.startUrl : e.provider === "BuilderId" ? ee : te;
  }
  /**
   * Authenticates via IDC method using browser-based OAuth flow using start url
   * @returns Promise that resolves to the token data when authentication is complete
   */
  async authenticate(e) {
    return u(l.Auth, "idc-provider.authenticate", async (t) => {
      if (t.setAttribute("authProvider", e.provider), e.authMethod !== "IdC")
        throw new d("IdC auth: invalid auth method");
      const r = this.getStartUrl(e), i = e.region || "us-east-1", a = new I(i), s = await this.registerClient(r, i, e.provider === "Enterprise"), o = S.randomUUID();
      this.authServer = await A.init(o);
      try {
        await this.authServer.start();
      } catch (y) {
        const k = new Q(
          `Failed to start authentication server. This is likely due to network or firewall restrictions preventing the local server from starting. ${y instanceof Error ? y.message : String(y)}`
        );
        throw h.error("AuthServer start failed:", k), k;
      }
      const v = S.randomBytes(32).toString("base64url"), C = S.createHash("sha256").update(v).digest().toString("base64url"), p = this.authServer.redirectUri, M = new URLSearchParams({
        response_type: "code",
        client_id: s.clientId,
        redirect_uri: p,
        scopes: this.scopes.join(","),
        state: o,
        code_challenge: C,
        code_challenge_method: "S256"
      }), F = `https://oidc.${i}.amazonaws.com/authorize?${M.toString()}`;
      await _.env.openExternal(_.Uri.parse(F));
      let R;
      try {
        R = await this.authServer.waitForAuthorization();
      } finally {
        this.authServer = void 0;
      }
      const L = await a.createToken({
        clientId: s.clientId,
        clientSecret: s.clientSecret,
        grantType: "authorization_code",
        redirectUri: p,
        code: R,
        codeVerifier: v
      });
      return this.tokenResponseToToken(L, this.getClientIdHash(r), e.provider, i);
    });
  }
  /**
   * Cancels a currently ongoing sign-in flow
   */
  cancelAuth() {
    this.authServer && this.authServer.cancelCurrentFlow();
  }
  /**
   * Refreshes token granted through IDC auth
   * @returns Promise that resolves to the refreshed token data
   */
  async refreshToken(e) {
    return u(l.Auth, "idc-provider.refreshToken", async (t) => {
      if (t.setAttribute("authProvider", e.provider), e.authMethod !== "IdC")
        throw new d("IdC auth: invalid auth method");
      const { refreshToken: r, clientIdHash: i, provider: a, region: s } = e;
      try {
        const o = this.storage.readClientRegistration(i), v = s || "us-east-1", C = new I(v);
        if (!o || this.isClientRegistrationExpired(o))
          throw new Y("IdC auth: No valid client registration found");
        const p = await C.createToken({
          clientId: o.clientId,
          clientSecret: o.clientSecret,
          refreshToken: r,
          grantType: "refresh_token"
        });
        return this.tokenResponseToToken(p, i, a, v);
      } catch (o) {
        throw h.error("Error refreshing token:", o), o;
      }
    });
  }
  /**
   * Logs the user out of a session generated through IDC auth
   * @returns Promise that resolves when logout was complete
   */
  logout(e) {
    try {
      if (e.authMethod !== "IdC")
        throw new d("IdC auth: invalid auth method");
      this.storage.deleteClientRegistration(e.clientIdHash);
    } catch (t) {
      h.error("Error deleting client registration during logout:", t);
    }
    return Promise.resolve();
  }
  /**
   * Deletes the user account for IDC auth provider.
   * Only supported for BuilderId accounts.
   * @param token - The token cache data
   * @throws {Error} Throws if account deletion is not supported for the provider type
   */
  async deleteAccount(e) {
    return u(l.Auth, "idc-provider.deleteAccount", async (t) => {
      if (t.setAttribute("authProvider", e.provider), e.authMethod !== "IdC")
        throw new d("IdC auth: invalid auth method");
      if (e.provider === "BuilderId")
        return this.authServiceClient.deleteAccount(e.accessToken);
      throw new Error("Account deletion not supported for enterprise auth");
    });
  }
}
const ie = [49153, 50153, 51153, 52153, 53153, 4649, 6588, 9091, 8008, 3128];
class ve {
  constructor() {
    c(this, "authServiceClient");
    c(this, "authServer");
    this.authServiceClient = new O();
  }
  tokenResponseToToken(e, t) {
    const r = /* @__PURE__ */ new Date(), i = new Date(r.getTime() + Number(e.expiresIn) * 1e3);
    return {
      accessToken: e.accessToken,
      refreshToken: e.refreshToken,
      profileArn: e.profileArn,
      expiresAt: i.toISOString(),
      authMethod: "social",
      provider: t
    };
  }
  /**
   * Authenticates via social auth.
   * @returns Promise that resolves to the token data when authentication is complete
   */
  async authenticate(e) {
    return u(l.Auth, "social-provider.authenticate", async (t) => {
      if (t.setAttribute("authProvider", e.provider), e.authMethod !== "social")
        throw new d("Social auth: invalid auth method");
      t.setAttribute("withInvitationCode", !!e.invitationCode);
      const r = S.randomUUID();
      this.authServer = await A.init(r), await this.authServer.start(ie);
      const i = S.randomBytes(32).toString("base64url"), a = S.createHash("sha256").update(i).digest().toString("base64url"), s = this.authServer.redirectUri.replace("127.0.0.1", "localhost");
      await this.authServiceClient.login({ provider: e.provider, redirectUri: s, codeChallenge: a, state: r });
      let o;
      try {
        o = await this.authServer.waitForAuthorization();
      } finally {
        this.authServer = void 0;
      }
      const v = await this.authServiceClient.createToken({
        code: o,
        codeVerifier: i,
        redirectUri: s,
        invitationCode: e.invitationCode
      });
      return this.tokenResponseToToken(v, e.provider);
    });
  }
  /**
   * Cancels a currently ongoing sign-in flow
   */
  cancelAuth() {
    this.authServer && this.authServer.cancelCurrentFlow();
  }
  /**
   * Refreshes token granted through social auth
   * @returns Promise that resolves to the refreshed token data
   */
  async refreshToken(e) {
    return u(l.Auth, "social-provider.refreshToken", async (t) => {
      if (t.setAttribute("authProvider", e.provider), e.authMethod !== "social")
        throw new d("Social auth: invalid auth method");
      const { refreshToken: r, profileArn: i, provider: a } = e;
      try {
        const s = await this.authServiceClient.refreshToken({ refreshToken: r });
        return s.profileArn = i, this.tokenResponseToToken(s, a);
      } catch (s) {
        throw h.error("Error refreshing token:", s), s;
      }
    });
  }
  /**
   * Logs the user out of a session generated through social auth
   * @returns Promise that resolves when logout was complete
   */
  async logout(e) {
    return u(l.Auth, "social-provider.logout", async (t) => {
      if (t.setAttribute("authProvider", e.provider), !!e.refreshToken)
        return this.authServiceClient.logout({ refreshToken: e.refreshToken });
    });
  }
  /**
   * Deletes the user account using the social auth provider.
   * @param token - The token cache data containing access token
   */
  async deleteAccount(e) {
    return u(l.Auth, "social-provider.deleteAccount", async (t) => (t.setAttribute("authProvider", e.provider), this.authServiceClient.deleteAccount(e.accessToken)));
  }
}
export {
  re as C,
  de as I,
  ve as S
};
