var F = Object.defineProperty;
var b = (s, e, r) => e in s ? F(s, e, { enumerable: !0, configurable: !0, writable: !0, value: r }) : s[e] = r;
var o = (s, e, r) => b(s, typeof e != "symbol" ? e + "" : e, r);
import { F as k, i as v, j as m, k as S, l as I, m as y, C as M, g as L, n as _, o as N, p as x, h as O, N as U, U as W, q as R, r as G, s as H } from "./sso-oidc-client-C8abUy8I.js";
import { t as ve, c as Ae, d as Se, x as Ce, w as De, v as Pe, I as ye, e as Me, M as Le, f as _e, u as Re, a as Fe, b as be, y as Ne } from "./sso-oidc-client-C8abUy8I.js";
import * as i from "vscode";
import { l as h, v as z, x as f, y as d, z as B } from "./ignore-CEeUmp3m.js";
import { A as Oe, o as Ue, C as We, g as Ge, c as He, D as ze, F as Be, M as qe, u as Ke, j as Ve, k as Je, T as $e, f as je, e as Ye, d as Xe, h as Qe, s as Ze, t as er, i as rr, a as tr, q as sr, b as or, m as ir, n as nr, p as ar, r as hr } from "./ignore-CEeUmp3m.js";
import * as C from "path";
import * as q from "os";
import * as c from "fs";
import "node-machine-id";
import { S as K, I as V } from "./social-auth-provider-NtT-6ewO.js";
import { w as E } from "./span-BJ2ilrye.js";
import { s as dr } from "./span-BJ2ilrye.js";
import "@opentelemetry/api";
import { exec as J } from "child_process";
import { promisify as $ } from "util";
import { c as lr, a as gr, b as fr, M as wr, g as pr, d as kr, e as mr, h as Ir, f as Er, l as Tr, s as vr } from "./config-Bro8qubS.js";
import { J as Sr, M as Cr, c as Dr, a as Pr, g as yr } from "./journey-tracker-D6wvW1vA.js";
import { b as Lr, g as _r, a as Rr } from "./paths-CA0scYz8.js";
import { b as br, a as Nr, u as xr } from "./ide-settings-D5qBPTr1.js";
import { g as Ur } from "./machine-id-C8hvgZVE.js";
const j = "kiro-auth-token.json", Y = ["Google", "Github"], X = ["Enterprise", "BuilderId", "Internal"];
class Q {
  constructor() {
    o(this, "tokenCache");
    o(this, "cacheDirectory", C.join(q.homedir(), ".aws", "sso", "cache"));
    o(this, "_onDidChange", new i.EventEmitter());
    o(this, "watchListener");
    this.watchListener = () => {
      this.clearCache(), this._onDidChange.fire();
    }, c.watchFile(this.getAuthTokenPath(), this.watchListener);
  }
  /**
   * Cleans up internal state
   */
  dispose() {
    c.unwatchFile(this.getAuthTokenPath(), this.watchListener);
  }
  /**
   * Event that triggers where there is a change in login status
   */
  get onDidChange() {
    return this._onDidChange.event;
  }
  readTokenFromLocalCache() {
    return this.tokenCache;
  }
  getAuthTokenPath() {
    return C.join(this.cacheDirectory, j);
  }
  ensureCacheDirectory() {
    try {
      c.existsSync(this.cacheDirectory) || c.mkdirSync(this.cacheDirectory, { recursive: !0 });
    } catch {
      throw new k(this.cacheDirectory);
    }
  }
  writeTokenToLocalCache(e) {
    this.tokenCache = e;
  }
  writeTokenToDisk(e) {
    this.ensureCacheDirectory();
    const r = this.getAuthTokenPath();
    try {
      c.writeFileSync(r, JSON.stringify(e, void 0, 2));
    } catch {
      throw new k(r);
    }
  }
  clearCache() {
    this.tokenCache = void 0;
  }
  readTokenFromDisk() {
    const e = this.getAuthTokenPath();
    if (c.existsSync(e))
      try {
        const r = c.readFileSync(e, "utf8");
        try {
          return JSON.parse(r);
        } catch (t) {
          h.error("Error trying to parse the token file.", t);
          return;
        }
      } catch {
        throw new k(e);
      }
  }
  /**
   * The method removed internal token inconsistencies enabled through redundant data stored in the token (authMethod vs. provider)
   * We treat the provider as the source of truth and, if provided, we determine authMethod based on that.
   */
  sanitizeToken(e) {
    return Y.includes(e.provider) ? { ...e, authMethod: "social" } : X.includes(e.provider) ? { ...e, authMethod: "IdC" } : e;
  }
  /**
   * Retrieves the currently cached auth token
   */
  readToken() {
    const e = this.readTokenFromLocalCache();
    if (e)
      return this.sanitizeToken(e);
    const r = this.readTokenFromDisk();
    if (r)
      return this.writeTokenToLocalCache(r), this.sanitizeToken(r);
  }
  /**
   * Writes an auth token to cache
   */
  writeToken(e) {
    this.writeTokenToDisk(e), this.clearCache(), this._onDidChange.fire();
  }
  /**
   * Deletes cached auth token
   */
  clearToken() {
    this.clearCache(), c.unlinkSync(this.getAuthTokenPath()), this._onDidChange.fire();
  }
}
const D = 3 * 60, Z = 10 * 60, ee = 60, l = new z(f.Auth, "auth-provider"), re = (s) => s instanceof y ? {
  blocked: 1
} : s instanceof M ? {
  abort: 1
} : s instanceof L ? {
  abandon: 1
} : s instanceof _ ? {
  badInput: 1
} : s instanceof G ? {
  environmentIssue: 1
} : v(s) ? {
  unauthorized: 1
} : {
  failure: 1
};
function T(s) {
  return s instanceof R ? s : new W("Auth provider: unexpected issue");
}
function te(s) {
  return (s == null ? void 0 : s.toString()) || "unknown";
}
function g(s, e) {
  return {
    traceName: `${te(e)}.${s}`,
    errorMapper: re,
    metricAliases: [s]
  };
}
class se {
  constructor() {
    o(this, "storage");
    o(this, "signInDeferred");
    o(this, "signInPromise");
    o(this, "providers");
    o(this, "authErrorMessagePromises", {
      AccessDenied: null,
      NetworkIssue: null,
      Unknown: null
    });
    o(this, "refreshSettled", Promise.resolve());
    o(this, "refreshLoopTimeout");
    o(this, "_onDidChangeLoginStatus", new i.EventEmitter());
    o(this, "_onDidPerformUserInitiatedLogout", new i.EventEmitter());
    o(this, "disposables", []);
    this.storage = new Q(), this.providers = {
      IdC: new V(),
      social: new K()
    }, i.window.state.focused && this.startRefreshLoop(), this.disposables.push(
      this.storage,
      {
        dispose: () => {
          this.stopRefreshLoop();
        }
      },
      this.storage.onDidChange(() => {
        this.handleTokenChanges();
      }),
      i.window.onDidChangeWindowState((e) => {
        e.focused ? this.startRefreshLoop() : this.stopRefreshLoop();
      })
    );
  }
  /**
   * Event that triggers where there is a change in login status
   */
  get onDidChangeLoginStatus() {
    return this._onDidChangeLoginStatus.event;
  }
  /**
   * Event that triggers when user initiates a logout
   * We treat this separately from other changes to the login status because a user initiated logout
   * will result in the sign-in page to be rendered again.
   */
  get onDidPerformUserInitiatedLogout() {
    return this._onDidPerformUserInitiatedLogout.event;
  }
  /**
   * Cleans up internal state
   */
  dispose() {
    this.disposables.forEach((e) => {
      e.dispose();
    });
  }
  stopRefreshLoop() {
    this.refreshLoopTimeout && clearInterval(this.refreshLoopTimeout);
  }
  startRefreshLoop() {
    this.stopRefreshLoop(), this.refreshSettled = this.attemptRefreshIfCloseToExpiry(), this.refreshLoopTimeout = setInterval(() => {
      this.refreshSettled = this.attemptRefreshIfCloseToExpiry();
    }, ee * 1e3);
  }
  /**
   * Handles changes of the token inside the storage
   * This ensures that changes made to the file system reflect correctly on the UI
   * More importantly, it ensures that an action performed in one IDE window reflect
   * correctly in all other open IDE windows.
   */
  handleTokenChanges() {
    if (this.isLoggedIn()) {
      const e = this.storage.readToken();
      this.signInDeferred && this.signInDeferred.resolve(e), this._onDidChangeLoginStatus.fire({
        isSignedIn: !0,
        token: e
      });
    } else
      this._onDidChangeLoginStatus.fire({
        isSignedIn: !1,
        token: void 0
      });
  }
  async attemptRefreshIfCloseToExpiry() {
    try {
      const e = this.storage.readToken();
      if (!e || !e.expiresAt || !e.accessToken)
        return;
      this.isAuthTokenExpiredWithinSeconds(e, Z) && await E(f.Auth, "auth-provider.scheduled-refresh", () => this.refreshToken());
    } catch (e) {
      const r = this.storage.readToken();
      v(e) && r && this.isAuthTokenExpiredWithinSeconds(r, D) && this.logoutAndForget();
    }
  }
  isAuthTokenExpiredWithinSeconds(e, r) {
    if (!e.expiresAt || !e.accessToken)
      return !0;
    const t = new Date(e.expiresAt), n = /* @__PURE__ */ new Date();
    return t.valueOf() < n.valueOf() + r * 1e3;
  }
  isAuthTokenExpired(e) {
    return this.isAuthTokenExpiredWithinSeconds(e, D);
  }
  /**
   * Returns the current auth token if authenticated
   * @returns Promise that resolves to the token (string)
   */
  async getToken() {
    return (await this.getTokenData()).accessToken;
  }
  /**
   * Returns the current auth token if authenticated
   * @returns The token read from cache / disk
   */
  readToken() {
    return this.storage.readToken();
  }
  /**
   * Returns the current profileArn if authenticated
   * @returns Promise that resolves to the profileArn (string)
   */
  async getProfileArn() {
    const e = await this.getTokenData();
    return "profileArn" in e ? e.profileArn : void 0;
  }
  /**
   * Returns the current auth token by trying various methods to read or re-generate it
   * (including attempting to refresh the token if expired)
   * @returns Promise that resolves to the token (LocalTokenCacheData)
   */
  async getTokenData({ attemptRefresh: e } = { attemptRefresh: !0 }) {
    await this.refreshSettled;
    try {
      const r = this.storage.readToken();
      if (!r)
        throw new m("No valid token found");
      if (!this.isAuthTokenExpired(r))
        return r;
      if (r.refreshToken && e)
        return await E(f.Auth, "auth-provider.getTokenData", async () => (await this.refreshToken(), await this.getTokenData({ attemptRefresh: !1 })));
      throw new S("No valid token found");
    } catch (r) {
      throw v(r) && this.logoutAndForget(), h.error("Failed to retrieve auth token:", r), T(r);
    }
  }
  /**
   * Whether the user is currently considered to be logged in
   */
  isLoggedIn() {
    const e = this.storage.readToken();
    return !!(e != null && e.refreshToken);
  }
  /**
   * Logs the user out of the session
   * @returns Promise that resolves when logout is complete
   */
  async logout() {
    if (!this.isLoggedIn())
      return;
    const e = this.storage.readToken();
    if (e)
      return l.withTrace(g("logout", e.provider), async (r) => {
        r.setAttribute("authProvider", e.provider), this.storage.clearToken();
        try {
          await this.providers[e.authMethod].logout(e);
        } catch (t) {
          throw h.error("Failed to logout:", t), T(t);
        }
      });
  }
  async logoutAndForget() {
    try {
      await this.logout();
    } catch {
    }
  }
  /**
   * Deletes the user account
   * @returns Promise that resolves when account deletion is complete
   */
  async deleteAccount() {
    if (!this.isLoggedIn())
      throw new I("Not logged in");
    const e = this.storage.readToken();
    if (!e)
      throw new m("No token available");
    return l.withTrace(g("deleteAccount", e.provider), async (r) => {
      r.setAttribute("authProvider", e.provider);
      const t = this.providers[e.authMethod];
      try {
        await t.deleteAccount(e), this.storage.clearToken(), this._onDidPerformUserInitiatedLogout.fire();
      } catch (n) {
        throw h.error("Failed to delete account:", n), T(n);
      }
    });
  }
  /**
   * Attempts to refresh the auth token
   * @returns Promise that resolves when token refresh is complete
   */
  async refreshToken() {
    const e = this.storage.readToken();
    if (!(e != null && e.refreshToken))
      throw new I("No valid refresh token found");
    return l.withTrace(g("refreshToken", e.provider), async (r) => {
      var t;
      r.setAttribute("authProvider", e.provider);
      try {
        const p = await this.providers[e.authMethod].refreshToken(e);
        ((t = this.storage.readToken()) == null ? void 0 : t.refreshToken) === e.refreshToken && this.storage.writeToken(p);
      } catch (n) {
        throw h.error("Failed to refresh token:", n), n;
      }
    });
  }
  async openInternalLink(e) {
    const r = await i.env.asExternalUri(
      i.Uri.parse(`${i.env.uriScheme}://kiro.kiroAgent${e}`)
    );
    await i.env.openExternal(r);
  }
  /**
   * Authenticates the user with any of the available login options: social (Google, Github),
   * builderId, enterprise or internal login
   */
  async authenticateWithOptions(e) {
    return d("started-login"), l.withTrace(g("authenticate", e.provider), async (r) => {
      r.setAttribute("authProvider", e.provider), this.isLoggedIn() && await this.logout();
      try {
        const n = await this.providers[e.authMethod].authenticate(e);
        this.storage.writeToken(n), await this.openInternalLink("/did-authenticate"), d("finished-login"), B(e);
      } catch (t) {
        throw t instanceof y ? h.info("Sign-in temporarily not allowed") : t instanceof M ? (h.info("Authentication canceled"), d("canceled-login")) : t instanceof L ? (h.info("Authentication timed out"), d("abandoned-login")) : t instanceof _ ? (h.error("Authentication failed due to bad user input:", t), d("bad-user-input")) : (h.error("Authentication failed:", t), d("failed-login"), i.window.showErrorMessage("Failed to authenticate with Kiro.")), await this.logout(), t;
      }
    });
  }
  /**
   * Cancels any current ongoing sign-in flow
   */
  cancelSignIn() {
    this.providers.IdC.cancelAuth(), this.providers.social.cancelAuth();
  }
  /**
   * Consumers of the auth provider should call this method when a token issued through this provider
   * was rejected by the invoked service.
   */
  async handleAuthError(e) {
    return e instanceof N || e instanceof m || e instanceof S || e instanceof I || e instanceof x || e instanceof O ? this.showInvalidSessionErrorMessage() : e instanceof U ? this.showNetworkIssueErrorMessage() : this.showUnknownIssueErrorMessage();
  }
  async showInvalidSessionErrorMessage() {
    return E(f.Auth, "auth-provider.manual-error-resolve", async () => {
      if (this.authErrorMessagePromises.AccessDenied)
        return this.authErrorMessagePromises.AccessDenied;
      const e = i.window.showErrorMessage(
        "Could not complete the request because your session is invalid or expired.",
        "Refresh session",
        "Login"
      );
      this.authErrorMessagePromises.AccessDenied = e;
      let r = await e;
      if (r === "Refresh session")
        try {
          await this.refreshToken(), i.window.showInformationMessage("Your session was successfully refreshed.");
        } catch {
          this.logoutAndForget(), r = await i.window.showErrorMessage("We are unable to refresh your session.", "Login");
        }
      r === "Login" && (await this.logout(), this._onDidPerformUserInitiatedLogout.fire()), this.authErrorMessagePromises.AccessDenied = null;
    });
  }
  async showNetworkIssueErrorMessage() {
    if (this.authErrorMessagePromises.NetworkIssue)
      return this.authErrorMessagePromises.NetworkIssue;
    const e = i.window.showErrorMessage(
      "Could not communicate with the service. Please check your network connection.",
      "Dismiss"
    );
    this.authErrorMessagePromises.NetworkIssue = e, await e, this.authErrorMessagePromises.NetworkIssue = null;
  }
  async showUnknownIssueErrorMessage() {
    if (this.authErrorMessagePromises.Unknown)
      return this.authErrorMessagePromises.Unknown;
    const e = i.window.showErrorMessage("An unexpected issue occurred.", "Dismiss");
    this.authErrorMessagePromises.Unknown = e, await e, this.authErrorMessagePromises.Unknown = null;
  }
  /**
   * Returns a promise that resolves once the user is logged in
   */
  async waitForSignIn() {
    return this.isLoggedIn() ? this.storage.readToken() : (this.signInPromise || (this.signInPromise = new Promise((e) => {
      this.signInDeferred = { resolve: e };
    }).then((e) => (this.signInPromise = void 0, this.signInDeferred = void 0, e))), this.signInPromise);
  }
}
const oe = $(J), ie = "mwinit", ne = process.platform == "win32" ? "where.exe" : "which";
async function ae() {
  try {
    return await oe(`${ne} ${ie}`), !0;
  } catch {
    return !1;
  }
}
const a = new se(), w = "kiro", P = "There was an error signing you in. Please try again.", he = {
  BuilderId: "BuilderId",
  Enterprise: "AWS IAM Identity Center",
  Internal: "Amazon internal (Midway)",
  Github: "GitHub",
  Google: "Google"
};
class u {
  constructor(e) {
    o(this, "account");
    o(this, "id", w);
    o(this, "scopes", []);
    o(this, "accessToken", "");
    this.account = { id: w, label: e ? he[e] : "" };
  }
}
class A {
  constructor(e) {
    o(this, "disposables", []);
    o(this, "_onDidChangeSessions", new i.EventEmitter());
    this.controller = e, this.disposables.push(
      a.onDidChangeLoginStatus(({ token: r, isSignedIn: t }) => {
        t ? this._onDidChangeSessions.fire({
          removed: [],
          added: [new u(r.provider)],
          changed: []
        }) : this._onDidChangeSessions.fire({
          removed: [new u()],
          added: [],
          changed: []
        });
      }),
      a.onDidPerformUserInitiatedLogout(() => {
        this.controller.showSignInPage();
      })
    );
  }
  get onDidChangeSessions() {
    return this._onDidChangeSessions.event;
  }
  dispose() {
    this.disposables.forEach((e) => {
      e.dispose();
    });
  }
  async getSessions(e, r) {
    if (a.isLoggedIn()) {
      const t = a.readToken();
      return Promise.resolve([new u(t.provider)]);
    }
    return Promise.resolve([]);
  }
  async createSession(e, r) {
    if (a.isLoggedIn()) {
      const n = a.readToken();
      return new u(n.provider);
    }
    this.controller.showSignInPage();
    const t = await a.waitForSignIn();
    return new u(t.provider);
  }
  async removeSession(e) {
    a.isLoggedIn() && (await a.logout(), this.controller.showSignInPage());
  }
}
o(A, "name", "Kiro");
class ce {
  constructor() {
    o(this, "_onDidReceiveSignInRequest", new i.EventEmitter());
  }
  get onDidReceiveSignInRequest() {
    return this._onDidReceiveSignInRequest.event;
  }
  showSignInPage() {
    this._onDidReceiveSignInRequest.fire();
  }
  async signIn(e) {
    try {
      return await a.authenticateWithOptions(e);
    } catch (r) {
      throw r instanceof R ? r.toUserFacingError(P) : new H(P);
    }
  }
  cancelSignIn() {
    a.cancelSignIn();
  }
}
async function Ie(s) {
  const e = new ce(), r = new A(e), t = i.authentication.registerAuthenticationProvider(
    w,
    A.name,
    r
  ), n = await ae(), p = i.authentication.registerSignInController(w, e, {
    isInternalUser: n
  });
  s.subscriptions.push(r, t, p, a);
}
export {
  Oe as APPLICATION_NAME,
  Ue as APPLICATION_VERSION,
  L as AbandonedError,
  N as AccessDeniedError,
  R as AuthError,
  ve as AuthErrorType,
  se as AuthProvider,
  Ae as AuthProviderDeniedAccess,
  Se as AuthProviderFailure,
  M as CanceledError,
  We as ContextPropagation,
  Ge as DEFAULT_IGNORE,
  He as DEFAULT_IGNORE_DIRS,
  ze as DEFAULT_IGNORE_FILETYPES,
  Ce as FailedToConnectError,
  Be as Feature,
  k as FileSystemAccessError,
  I as InvalidAuthError,
  O as InvalidIdCAuthError,
  De as InvalidInvitationCodeError,
  x as InvalidSSOAuthError,
  Pe as InvalidStartUrlError,
  ye as InvalidStateError,
  _ as InvalidUserInputError,
  Sr as JourneyTracker,
  lr as MCPConnection,
  gr as MCPJsonConfigSchema,
  fr as MCPManagerSingleton,
  wr as MCPOptionsSchema,
  S as MalformedTokenError,
  qe as MetricNamespace,
  z as MetricReporter,
  Cr as Metrics,
  Me as MissingCodeError,
  Le as MissingPortError,
  _e as MissingStateError,
  m as MissingTokenError,
  U as NetworkIssueError,
  Re as ServerIssueError,
  Fe as ServerListenError,
  be as ServerTimeoutError,
  y as SignInBlockedError,
  Ke as Telemetry,
  Ve as Tool,
  Je as ToolRecorder,
  $e as TrustedError,
  W as UnexpectedIssueError,
  G as UserEnvironmentError,
  H as UserFacingError,
  br as addAgentModeHeadersMiddleware,
  pr as addMCPToolToAutoApproveConfig,
  Nr as addPrivacyHeadersMiddleware,
  a as authProvider,
  Dr as createCounter,
  Pr as createHistogram,
  je as defaultIgnoreDir,
  Ye as defaultIgnoreFile,
  Xe as didMatchThroughWildCard,
  kr as disableMCPTools,
  mr as enableMCPTools,
  Ir as findConfigFileForServer,
  Er as formatToolName,
  Lr as getActiveMcpConfigLocation,
  _r as getHomeKiroPath,
  yr as getJourneyTracker,
  Ur as getMachineId,
  Ne as getUnknownErrorDetails,
  Rr as getWorkspaceKiroPath,
  Qe as gitIgnoreArrayFromFile,
  Ze as initializeBaggagePropagation,
  er as initializeTelemetry,
  rr as isAbortError,
  v as isBadAuthIssue,
  tr as isBlockedAccessError,
  sr as isInitialized,
  Tr as loadMcpConfig,
  h as logger,
  or as mapUnknownToErrorType,
  ir as mcpLogger,
  nr as normalizeCommand,
  ar as parseAndValidateCommand,
  hr as recordBashToolEvent,
  Ie as registerAuthProviderExtension,
  vr as setMCPServerDisabled,
  dr as startActiveSpan,
  xr as updateResolvedIDESetting,
  E as withSpan
};
