/*! For license information please see main.js.LICENSE.txt */
(()=>{var __webpack_modules__={62:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.GitCommitInputBoxCodeActionsProvider=t.GitCommitInputBoxDiagnosticsManager=t.DiagnosticCodes=void 0;const r=i(1398),o=i(7937);var n;!function(e){e.empty_message="empty_message",e.line_length="line_length"}(n||(t.DiagnosticCodes=n={})),t.GitCommitInputBoxDiagnosticsManager=class{constructor(e){this.model=e,this.severity=r.DiagnosticSeverity.Warning,this.disposables=[],this.diagnostics=r.languages.createDiagnosticCollection(),this.migrateInputValidationSettings().then(()=>{(0,o.mapEvent)((0,o.filterEvent)(r.workspace.onDidChangeTextDocument,e=>"vscode-scm"===e.document.uri.scheme),e=>e.document)(this.onDidChangeTextDocument,this,this.disposables),(0,o.filterEvent)(r.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git.inputValidation")||e.affectsConfiguration("git.inputValidationLength")||e.affectsConfiguration("git.inputValidationSubjectLength"))(this.onDidChangeConfiguration,this,this.disposables)})}getDiagnostics(e){return this.diagnostics.get(e)??[]}async migrateInputValidationSettings(){try{const e=r.workspace.getConfiguration("git"),t=e.inspect("inputValidation");if(void 0===t)return;"string"==typeof t.workspaceValue&&await e.update("inputValidation","off"!==t.workspaceValue,!1),"string"==typeof t.globalValue&&await e.update("inputValidation","off"!==t.workspaceValue,!0)}catch{}}onDidChangeConfiguration(){for(const e of this.model.repositories)this.onDidChangeTextDocument(e.inputBox.document)}onDidChangeTextDocument(e){const t=r.workspace.getConfiguration("git");if(!t.get("inputValidation",!1))return void this.diagnostics.set(e.uri,void 0);if(/^\s+$/.test(e.getText())){const t=new r.Range(e.lineAt(0).range.start,e.lineAt(e.lineCount-1).range.end),i=new r.Diagnostic(t,r.l10n.t("Current commit message only contains whitespace characters"),this.severity);return i.code=n.empty_message,void this.diagnostics.set(e.uri,[i])}const i=[],o=t.get("inputValidationLength",50),s=t.get("inputValidationSubjectLength",void 0);for(let t=0;t<e.lineCount;t++){const a=e.lineAt(t),l=0===t?s??o:o;if(a.text.length>l){const e=new r.Diagnostic(a.range,r.l10n.t("{0} characters over {1} in current line",a.text.length-l,l),this.severity);e.code=n.line_length,i.push(e)}}this.diagnostics.set(e.uri,i)}dispose(){(0,o.dispose)(this.disposables)}},t.GitCommitInputBoxCodeActionsProvider=class{constructor(e){this.diagnosticsManager=e,this.disposables=[],this.disposables.push(r.languages.registerCodeActionsProvider({scheme:"vscode-scm"},this))}provideCodeActions(e,t){const i=[],o=this.diagnosticsManager.getDiagnostics(e.uri),s=this.getWrapAllLinesCodeAction(e,o);for(const a of o)if(a.range.contains(t))switch(a.code){case n.empty_message:{const t=new r.WorkspaceEdit;t.delete(e.uri,a.range);const o=new r.CodeAction(r.l10n.t("Clear whitespace characters"),r.CodeActionKind.QuickFix);o.diagnostics=[a],o.edit=t,i.push(o);break}case n.line_length:{const t=this.getWrapLineWorkspaceEdit(e,a.range),o=new r.CodeAction(r.l10n.t("Hard wrap line"),r.CodeActionKind.QuickFix);o.diagnostics=[a],o.edit=t,i.push(o),s&&(s.diagnostics=[a],i.push(s));break}}return i}getWrapLineWorkspaceEdit(e,t){const i=this.wrapTextDocumentLine(e,t.start.line),o=new r.WorkspaceEdit;return o.replace(e.uri,t,i.join("\n")),o}getWrapAllLinesCodeAction(e,t){const i=t.filter(e=>e.code===n.line_length);if(i.length<2)return;const o=new r.CodeAction(r.l10n.t("Hard wrap all lines"),r.CodeActionKind.QuickFix);return o.edit=this.getWrapAllLinesWorkspaceEdit(e,i),o}getWrapAllLinesWorkspaceEdit(e,t){const i=new r.WorkspaceEdit;for(const r of t){const t=this.wrapTextDocumentLine(e,r.range.start.line);i.replace(e.uri,r.range,t.join("\n"))}return i}wrapTextDocumentLine(e,t){const i=r.workspace.getConfiguration("git"),o=i.get("inputValidationLength",50),n=i.get("inputValidationSubjectLength",void 0),s=0===t?n??o:o,a=[],l=e.lineAt(t).text.trim();let c=0;for(;l.length-c>s;){const e=l.lastIndexOf(" ",c+s);if(-1!==e&&e>c)a.push(l.substring(c,e)),c=e+1;else{const e=l.indexOf(" ",c+s);-1!==e?(a.push(l.substring(c,e)),c=e+1):(a.push(l.substring(c)),c=l.length)}}return c<l.length&&a.push(l.substring(c)),a}dispose(){(0,o.dispose)(this.disposables)}}},251:(e,t)=>{t.read=function(e,t,i,r,o){var n,s,a=8*o-r-1,l=(1<<a)-1,c=l>>1,h=-7,u=i?o-1:0,d=i?-1:1,p=e[t+u];for(u+=d,n=p&(1<<-h)-1,p>>=-h,h+=a;h>0;n=256*n+e[t+u],u+=d,h-=8);for(s=n&(1<<-h)-1,n>>=-h,h+=r;h>0;s=256*s+e[t+u],u+=d,h-=8);if(0===n)n=1-c;else{if(n===l)return s?NaN:1/0*(p?-1:1);s+=Math.pow(2,r),n-=c}return(p?-1:1)*s*Math.pow(2,n-r)},t.write=function(e,t,i,r,o,n){var s,a,l,c=8*n-o-1,h=(1<<c)-1,u=h>>1,d=23===o?Math.pow(2,-24)-Math.pow(2,-77):0,p=r?0:n-1,m=r?1:-1,g=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(a=isNaN(t)?1:0,s=h):(s=Math.floor(Math.log(t)/Math.LN2),t*(l=Math.pow(2,-s))<1&&(s--,l*=2),(t+=s+u>=1?d/l:d*Math.pow(2,1-u))*l>=2&&(s++,l/=2),s+u>=h?(a=0,s=h):s+u>=1?(a=(t*l-1)*Math.pow(2,o),s+=u):(a=t*Math.pow(2,u-1)*Math.pow(2,o),s=0));o>=8;e[i+p]=255&a,p+=m,a/=256,o-=8);for(s=s<<o|a,c+=o;c>0;e[i+p]=255&s,p+=m,s/=256,c-=8);e[i+p-m]|=128*g}},280:(e,t,i)=>{"use strict";const r=i(6928),o="win32"===process.platform,{REGEX_BACKSLASH:n,REGEX_REMOVE_BACKSLASH:s,REGEX_SPECIAL_CHARS:a,REGEX_SPECIAL_CHARS_GLOBAL:l}=i(3940);t.isObject=e=>null!==e&&"object"==typeof e&&!Array.isArray(e),t.hasRegexChars=e=>a.test(e),t.isRegexChar=e=>1===e.length&&t.hasRegexChars(e),t.escapeRegex=e=>e.replace(l,"\\$1"),t.toPosixSlashes=e=>e.replace(n,"/"),t.removeBackslashes=e=>e.replace(s,e=>"\\"===e?"":e),t.supportsLookbehinds=()=>{const e=process.version.slice(1).split(".").map(Number);return 3===e.length&&e[0]>=9||8===e[0]&&e[1]>=10},t.isWindows=e=>e&&"boolean"==typeof e.windows?e.windows:!0===o||"\\"===r.sep,t.escapeLast=(e,i,r)=>{const o=e.lastIndexOf(i,r);return-1===o?e:"\\"===e[o-1]?t.escapeLast(e,i,o-1):`${e.slice(0,o)}\\${e.slice(o)}`},t.removePrefix=(e,t={})=>{let i=e;return i.startsWith("./")&&(i=i.slice(2),t.prefix="./"),i},t.wrapOutput=(e,t={},i={})=>{let r=`${i.contains?"":"^"}(?:${e})${i.contains?"":"$"}`;return!0===t.negated&&(r=`(?:^(?!${r}).*$)`),r}},363:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.fromStream=t.fromBuffer=t.EndOfStreamError=t.fromFile=void 0;const r=i(1343),o=i(6452);var n=i(1456);Object.defineProperty(t,"fromFile",{enumerable:!0,get:function(){return n.fromFile}});var s=i(6452);Object.defineProperty(t,"EndOfStreamError",{enumerable:!0,get:function(){return s.EndOfStreamError}}),Object.defineProperty(t,"fromBuffer",{enumerable:!0,get:function(){return s.fromBuffer}}),t.fromStream=async function(e,t){if(t=t||{},e.path){const i=await r.stat(e.path);t.path=e.path,t.size=i.size}return o.fromStream(e,t)}},527:(e,t)=>{"use strict";var i;Object.defineProperty(t,"__esModule",{value:!0}),t.LRUCache=void 0;class r{constructor(){this[i]="LinkedMap",this._map=new Map,this._head=void 0,this._tail=void 0,this._size=0,this._state=0}clear(){this._map.clear(),this._head=void 0,this._tail=void 0,this._size=0,this._state++}isEmpty(){return!this._head&&!this._tail}get size(){return this._size}get first(){return this._head?.value}get last(){return this._tail?.value}has(e){return this._map.has(e)}get(e,t=0){const i=this._map.get(e);if(i)return 0!==t&&this.touch(i,t),i.value}set(e,t,i=0){let r=this._map.get(e);if(r)r.value=t,0!==i&&this.touch(r,i);else{switch(r={key:e,value:t,next:void 0,previous:void 0},i){case 0:case 2:default:this.addItemLast(r);break;case 1:this.addItemFirst(r)}this._map.set(e,r),this._size++}return this}delete(e){return!!this.remove(e)}remove(e){const t=this._map.get(e);if(t)return this._map.delete(e),this.removeItem(t),this._size--,t.value}shift(){if(!this._head&&!this._tail)return;if(!this._head||!this._tail)throw new Error("Invalid list");const e=this._head;return this._map.delete(e.key),this.removeItem(e),this._size--,e.value}forEach(e,t){const i=this._state;let r=this._head;for(;r;){if(t?e.bind(t)(r.value,r.key,this):e(r.value,r.key,this),this._state!==i)throw new Error("LinkedMap got modified during iteration.");r=r.next}}keys(){const e=this,t=this._state;let i=this._head;const r={[Symbol.iterator]:()=>r,next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:i.key,done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return r}values(){const e=this,t=this._state;let i=this._head;const r={[Symbol.iterator]:()=>r,next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:i.value,done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return r}entries(){const e=this,t=this._state;let i=this._head;const r={[Symbol.iterator]:()=>r,next(){if(e._state!==t)throw new Error("LinkedMap got modified during iteration.");if(i){const e={value:[i.key,i.value],done:!1};return i=i.next,e}return{value:void 0,done:!0}}};return r}[(i=Symbol.toStringTag,Symbol.iterator)](){return this.entries()}trimOld(e){if(e>=this.size)return;if(0===e)return void this.clear();let t=this._head,i=this.size;for(;t&&i>e;)this._map.delete(t.key),t=t.next,i--;this._head=t,this._size=i,t&&(t.previous=void 0),this._state++}trimNew(e){if(e>=this.size)return;if(0===e)return void this.clear();let t=this._tail,i=this.size;for(;t&&i>e;)this._map.delete(t.key),t=t.previous,i--;this._tail=t,this._size=i,t&&(t.next=void 0),this._state++}addItemFirst(e){if(this._head||this._tail){if(!this._head)throw new Error("Invalid list");e.next=this._head,this._head.previous=e}else this._tail=e;this._head=e,this._state++}addItemLast(e){if(this._head||this._tail){if(!this._tail)throw new Error("Invalid list");e.previous=this._tail,this._tail.next=e}else this._head=e;this._tail=e,this._state++}removeItem(e){if(e===this._head&&e===this._tail)this._head=void 0,this._tail=void 0;else if(e===this._head){if(!e.next)throw new Error("Invalid list");e.next.previous=void 0,this._head=e.next}else if(e===this._tail){if(!e.previous)throw new Error("Invalid list");e.previous.next=void 0,this._tail=e.previous}else{const t=e.next,i=e.previous;if(!t||!i)throw new Error("Invalid list");t.previous=i,i.next=t}e.next=void 0,e.previous=void 0,this._state++}touch(e,t){if(!this._head||!this._tail)throw new Error("Invalid list");if(1===t||2===t)if(1===t){if(e===this._head)return;const t=e.next,i=e.previous;e===this._tail?(i.next=void 0,this._tail=i):(t.previous=i,i.next=t),e.previous=void 0,e.next=this._head,this._head.previous=e,this._head=e,this._state++}else if(2===t){if(e===this._tail)return;const t=e.next,i=e.previous;e===this._head?(t.previous=void 0,this._head=t):(t.previous=i,i.next=t),e.next=void 0,e.previous=this._tail,this._tail.next=e,this._tail=e,this._state++}}toJSON(){const e=[];return this.forEach((t,i)=>{e.push([i,t])}),e}fromJSON(e){this.clear();for(const[t,i]of e)this.set(t,i)}}class o extends r{constructor(e,t=1){super(),this._limit=e,this._ratio=Math.min(Math.max(0,t),1)}get limit(){return this._limit}set limit(e){this._limit=e,this.checkTrim()}get ratio(){return this._ratio}set ratio(e){this._ratio=Math.min(Math.max(0,e),1),this.checkTrim()}get(e,t=2){return super.get(e,t)}peek(e){return super.get(e,0)}set(e,t){return super.set(e,t,2),this}checkTrim(){this.size>this._limit&&this.trim(Math.round(this._limit*this._ratio))}}t.LRUCache=class extends o{constructor(e,t=1){super(e,t)}trim(e){this.trimOld(e)}set(e,t){return super.set(e,t),this.checkTrim(),this}}},693:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t}),a=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.Repository=t.GitStatusParser=t.Git=t.GitError=void 0,t.findGit=async function(e,t,i){for(const r of e)try{return await k(r,t)}catch(e){i.info(`Unable to find git on the PATH: "${r}". Error: ${e.message}`)}try{switch(process.platform){case"darwin":return await function(e){return new Promise((t,i)=>{u.exec("which git",(r,o)=>{if(r)return i(new Error(`Executing "which git" failed: ${r.message}`));const n=o.toString().trim();function s(r){if(!e(r))return i(new Error(`Path "${r}" is invalid.`));u.exec("git --version",(e,o)=>e?i(new Error(`Executing "git --version" failed: ${e.message}`)):t({path:r,version:v(o.trim())}))}if("/usr/bin/git"!==n)return s(n);u.exec("xcode-select -p",e=>{if(e&&2===e.code)return i(new Error('Executing "xcode-select -p" failed with error code 2.'));s(n)})})})}(t);case"win32":return await function(e){return R(process.env.ProgramW6432,e).then(void 0,()=>R(process.env["ProgramFiles(x86)"],e)).then(void 0,()=>R(process.env.ProgramFiles,e)).then(void 0,()=>R(c.join(process.env.LocalAppData,"Programs"),e)).then(void 0,()=>async function(e){return k(await(0,p.default)("git.exe"),e)}(e))}(t);default:return await k("git",t)}}catch(e){i.warn(`Unable to find git. Error: ${e.message}`)}throw new Error("Git installation not found.")},t.parseGitmodules=I,t.parseGitRemotes=B,t.parseGitCommits=L,t.parseLsTree=$,t.parseLsFiles=N;const l=i(9896),c=s(i(6928)),h=s(i(857)),u=s(i(5317)),d=i(7016),p=a(i(7242)),m=i(4434),g=s(i(3846)),f=i(7937),y=i(1398),w=s(i(5607)),b=i(3193),C=3e4;function v(e){return e.replace(/^git version /,"")}function k(e,t){return new Promise((i,r)=>{if(!t(e))return r(new Error(`Path "${e}" is invalid.`));const o=[],n=u.spawn(e,["--version"]);n.stdout.on("data",e=>o.push(e)),n.on("error",E(r)),n.on("close",t=>t?r(new Error(`Not found. Code: ${t}`)):i({path:e,version:v(Buffer.concat(o).toString("utf8").trim())}))})}function R(e,t){return e?k(c.join(e,"Git","cmd","git.exe"),t):Promise.reject("Not found")}function E(e){return t=>{/ENOENT/.test(t.message)&&(t=new D({error:t,message:"Failed to execute git (ENOENT)",gitErrorCode:"NotAGitRepository"})),e(t)}}async function S(e,t){if(!e.stdout||!e.stderr)throw new D({message:"Failed to get stdout or stderr from git process."});if(t&&t.isCancellationRequested)throw new y.CancellationError;const i=[],r=(e,t,r)=>{e.once(t,r),i.push((0,f.toDisposable)(()=>e.removeListener(t,r)))},o=(e,t,r)=>{e.on(t,r),i.push((0,f.toDisposable)(()=>e.removeListener(t,r)))};let n=Promise.all([new Promise((t,i)=>{r(e,"error",E(i)),r(e,"exit",t)}),new Promise(t=>{const i=[];o(e.stdout,"data",e=>i.push(e)),r(e.stdout,"close",()=>t(Buffer.concat(i)))}),new Promise(t=>{const i=[];o(e.stderr,"data",e=>i.push(e)),r(e.stderr,"close",()=>t(Buffer.concat(i).toString("utf8")))})]);if(t){const i=new Promise((i,r)=>{(0,f.onceEvent)(t.onCancellationRequested)(()=>{try{e.kill()}catch(e){}r(new y.CancellationError)})});n=Promise.race([n,i])}try{const[e,t,i]=await n;return{exitCode:e,stdout:t,stderr:i}}finally{(0,f.dispose)(i)}}class D extends Error{constructor(e){super(e.error?.message||e.message||"Git error"),this.error=e.error,this.stdout=e.stdout,this.stderr=e.stderr,this.exitCode=e.exitCode,this.gitErrorCode=e.gitErrorCode,this.gitCommand=e.gitCommand,this.gitArgs=e.gitArgs}toString(){let e=this.message+" "+JSON.stringify({exitCode:this.exitCode,gitErrorCode:this.gitErrorCode,gitCommand:this.gitCommand,stdout:this.stdout,stderr:this.stderr},null,2);return this.error&&(e+=this.error.stack),e}}function A(e){return/Another git process seems to be running in this repository|If no other git process is currently running/.test(e)?"RepositoryIsLocked":/Authentication failed/i.test(e)?"AuthenticationFailed":/Not a git repository/i.test(e)?"NotAGitRepository":/bad config file/.test(e)?"BadConfigFile":/cannot make pipe for command substitution|cannot create standard input pipe/.test(e)?"CantCreatePipe":/Repository not found/.test(e)?"RepositoryNotFound":/unable to access/.test(e)?"CantAccessRemote":/branch '.+' is not fully merged/.test(e)?"BranchNotFullyMerged":/Couldn\'t find remote ref/.test(e)?"NoRemoteReference":/A branch named '.+' already exists/.test(e)?"BranchAlreadyExists":/'.+' is not a valid branch name/.test(e)?"InvalidBranchName":/Please,? commit your changes or stash them/.test(e)?"DirtyWorkTree":/detected dubious ownership in repository at/.test(e)?"NotASafeGitRepository":/contains modified or untracked files|use --force to delete it/.test(e)?"WorktreeContainsChanges":/fatal: '[^']+' already exists/.test(e)?"WorktreeAlreadyExists":/is already used by worktree at/.test(e)?"WorktreeBranchAlreadyUsed":void 0}function _(e){return e.replace(/^([a-z]):\\/i,(e,t)=>`${t.toUpperCase()}:\\`)}function P(e){return e.replace(/\\/g,"/")}t.GitError=D;const x="%H%n%aN%n%aE%n%at%n%ct%n%P%n%D%n%B";t.Git=class{get onOutput(){return this._onOutput}constructor(e){this.commandsToLog=[],this._onOutput=new m.EventEmitter,this.path=e.gitPath,this.version=e.version,this.userAgent=e.userAgent,this.env=e.env||{};const t=e=>{if(void 0!==e&&!e.affectsConfiguration("git.commandsToLog"))return;const t=y.workspace.getConfiguration("git");this.commandsToLog=t.get("commandsToLog",[])};y.workspace.onDidChangeConfiguration(t,this),t()}compareGitVersionTo(e){return f.Versions.compare(f.Versions.fromString(this.version),f.Versions.fromString(e))}open(e,t,i,r){return new K(this,e,t,i,r)}async init(e,t={}){const i=["init"];t.defaultBranch&&""!==t.defaultBranch&&-1!==this.compareGitVersionTo("2.28.0")&&i.push("-b",t.defaultBranch),await this.exec(e,i)}async clone(e,t,i){const r=decodeURI(e).replace(/[\/]+$/,"").replace(/^.*[\/\\]/,"").replace(/\.git$/,"")||"repository";let o=r,n=c.join(t.parentPath,o),s=1;for(;s<20&&await new Promise(e=>(0,l.exists)(n,e));)o=`${r}-${s++}`,n=c.join(t.parentPath,o);await(0,f.mkdirp)(t.parentPath);const a=e=>{const i=new b.StringDecoder("utf8"),r=new w.LineStream({encoding:"utf8"});e.stderr.on("data",e=>r.write(i.write(e)));let o=0,n=0;r.on("data",e=>{let i=null;(i=/Counting objects:\s*(\d+)%/i.exec(e))?o=Math.floor(.1*parseInt(i[1])):(i=/Compressing objects:\s*(\d+)%/i.exec(e))?o=10+Math.floor(.1*parseInt(i[1])):(i=/Receiving objects:\s*(\d+)%/i.exec(e))?o=20+Math.floor(.4*parseInt(i[1])):(i=/Resolving deltas:\s*(\d+)%/i.exec(e))&&(o=60+Math.floor(.4*parseInt(i[1]))),o!==n&&(t.progress.report({increment:o-n}),n=o)})};try{const r=["clone",e.includes(" ")?encodeURI(e):e,n,"--progress"];t.recursive&&r.push("--recursive"),t.ref&&r.push("--branch",t.ref),await this.exec(t.parentPath,r,{cancellationToken:i,env:{GIT_HTTP_USER_AGENT:this.userAgent},onSpawn:a})}catch(e){throw e.stderr&&(e.stderr=e.stderr.replace(/^Cloning.+$/m,"").trim(),e.stderr=e.stderr.replace(/^ERROR:\s+/,"").trim()),e}return n}async getRepositoryRoot(e){const t=await this.exec(e,["rev-parse","--show-toplevel"]),i=c.normalize(t.stdout.trimStart().replace(/[\r\n]+$/,""));if(!(0,f.pathEquals)(e,i)&&!(0,f.isDescendant)(i,e)&&!(0,f.isDescendant)(e,i)&&-1!==this.compareGitVersionTo("2.31.0")){const t=await this.exec(e,["rev-parse","--path-format=relative","--show-toplevel"]);return c.resolve(e,t.stdout.trimStart().replace(/[\r\n]+$/,""))}if(f.isWindows){const t=y.Uri.file(i),r=y.Uri.file(e);if(0!==t.authority.length&&0===r.authority.length){const e=/^[\/]?([a-zA-Z])[:\/]/.exec(r.path);if(null!==e){const[,i]=e;try{const e=await new Promise(e=>l.realpath.native(`${i}:\\`,{encoding:"utf8"},(t,i)=>e(null!==t?void 0:i)));if(void 0!==e){const r=(0,f.pathEquals)(t.fsPath,e);return c.normalize(t.fsPath.replace(e,`${i.toLowerCase()}:${r||e.endsWith("\\")?"\\":""}`))}}catch{}}return c.normalize(r.fsPath)}}return i}async getRepositoryDotGit(e){let t,i,r;const o=["rev-parse","--git-dir","--git-common-dir"];this.compareGitVersionTo("2.13.0")>=0&&o.push("--show-superproject-working-tree");const n=await this.exec(e,o);return[t,i,r]=n.stdout.split("\n").map(e=>e.trim()),c.isAbsolute(t)||(t=c.join(e,t)),t=c.normalize(t),i&&(c.isAbsolute(i)||(i=c.join(e,i)),i=c.normalize(i)),{path:t,commonPath:i!==t?i:void 0,superProjectPath:r?c.normalize(r):void 0}}async exec(e,t,i={}){return i=(0,f.assign)({cwd:e},i||{}),await this._exec(t,i)}async exec2(e,t={}){return await this._exec(e,t)}stream(e,t,i={}){i=(0,f.assign)({cwd:e},i||{});const r=this.spawn(t,i);if(!1!==i.log){const e=Date.now();r.on("exit",i=>{this.log(`> git ${t.join(" ")} [${Date.now()-e}ms]${r.killed?" (cancelled)":""}\n`)})}return r}async _exec(e,t={}){const i=this.spawn(e,t);t.onSpawn?.(i),t.input&&i.stdin.end(t.input,"utf8");const r=Date.now();let o;try{o=await S(i,t.cancellationToken)}catch(t){throw t instanceof y.CancellationError&&this.log(`> git ${e.join(" ")} [${Date.now()-r}ms] (cancelled)\n`),t}!1!==t.log&&(this.log(`> git ${e.join(" ")} [${Date.now()-r}ms]\n`),o.stdout.length>0&&e.find(e=>this.commandsToLog.includes(e))&&this.log(`${o.stdout}\n`),o.stderr.length>0&&this.log(`${o.stderr}\n`));const n={exitCode:o.exitCode,stdout:o.stdout.toString("utf8"),stderr:o.stderr};return o.exitCode?Promise.reject(new D({message:"Failed to execute git",stdout:n.stdout,stderr:n.stderr,exitCode:n.exitCode,gitErrorCode:A(n.stderr),gitCommand:e[0],gitArgs:e})):n}spawn(e,t={}){if(!this.path)throw new Error("git could not be found in the system.");t||(t={}),t.stdio||t.input||(t.stdio=["ignore",null,null]),t.env=(0,f.assign)({},process.env,this.env,t.env||{},{VSCODE_GIT_COMMAND:e[0],LC_ALL:"en_US.UTF-8",LANG:"en_US.UTF-8",GIT_PAGER:"cat"});const i=this.getCwd(t);return i&&(t.cwd=_(i)),u.spawn(this.path,e,t)}getCwd(e){const t=e.cwd;return void 0===t||"string"==typeof t?t:"file:"===t.protocol?(0,d.fileURLToPath)(t):void 0}log(e){this._onOutput.emit("log",e)}async mergeFile(e){const t=["merge-file","-p",e.input1Path,e.basePath,e.input2Path];e.diff3?t.push("--diff3"):t.push("--no-diff3");try{return(await this.exec(h.homedir(),t)).stdout}catch(e){if("string"==typeof e.stdout)return e.stdout;throw e}}async addSafeDirectory(e){await this.exec(h.homedir(),["config","--global","--add","safe.directory",e])}};class T{static parse(e){const t={sections:[]};let i={name:"DEFAULT",properties:{}};const r=e=>{e&&t.sections.push(e)};for(const t of e.split(T._lineSeparator)){const e=t.match(T._sectionRegex);if(3===e?.length){r(i),i={name:e[1],subSectionName:e[2]?.replaceAll('"',""),properties:{}};continue}const o=t.match(T._propertyRegex);3!==o?.length||Object.keys(i.properties).includes(o[1])||(i.properties[o[1]]=o[2])}return r(i),t.sections}}T._lineSeparator=/\r?\n/,T._propertyRegex=/^\s*(\w+)\s*=\s*"?([^"]+)"?$/,T._sectionRegex=/^\s*\[\s*([^\]]+?)\s*(\"[^"]+\")*\]\s*$/;class M{constructor(){this.lastRaw="",this.result=[]}get status(){return this.result}update(e){let t,i=0;for(e=this.lastRaw+e;void 0!==(t=this.parseEntry(e,i));)i=t;this.lastRaw=e.substr(i)}parseEntry(e,t){if(t+4>=e.length)return;let i;const r={x:e.charAt(t++),y:e.charAt(t++),rename:void 0,path:""};if(t++,"R"===r.x||"R"===r.y||"C"===r.x){if(i=e.indexOf("\0",t),-1===i)return;r.rename=e.substring(t,i),t=i+1}return i=e.indexOf("\0",t),-1!==i?(r.path=e.substring(t,i),"/"!==r.path[r.path.length-1]&&this.result.push(r),i+1):void 0}}function I(e){const t=[];for(const i of T.parse(e).filter(e=>"submodule"===e.name))i.subSectionName&&i.properties.path&&i.properties.url&&t.push({name:i.subSectionName,path:i.properties.path,url:i.properties.url});return t}function B(e){const t=[];for(const i of T.parse(e).filter(e=>"remote"===e.name))i.subSectionName&&t.push({name:i.subSectionName,fetchUrl:i.properties.url,pushUrl:i.properties.pushurl??i.properties.url,isReadOnly:!1});return t}t.GitStatusParser=M;const O=/([0-9a-f]{40})\n(.*)\n(.*)\n(.*)\n(.*)\n(.*)\n(.*)(?:\n([^]*?))?(?:\x00)(?:\n((?:.*)files? changed(?:.*))$)?/gm;function L(e){const t=[];let i,r,o,n,s,a,l,c,h,u;for(;u=O.exec(e),null!==u;)[,i,r,o,n,s,a,l,c,h]=u,"\n"===c[c.length-1]&&(c=c.substr(0,c.length-1)),t.push({hash:` ${i}`.substr(1),message:` ${c}`.substr(1),parents:a?a.split(" "):[],authorDate:new Date(1e3*Number(n)),authorName:` ${r}`.substr(1),authorEmail:` ${o}`.substr(1),commitDate:new Date(1e3*Number(s)),refNames:l.split(",").map(e=>e.trim()),shortStat:h?H(h):void 0});return t}const G=/(\d+) files? changed(?:, (\d+) insertions?\(\+\))?(?:, (\d+) deletions?\(-\))?/;function H(e){const t=e.trim().match(G);if(!t)return{files:0,insertions:0,deletions:0};const[,i,r,o]=t;return{files:parseInt(i),insertions:parseInt(r??"0"),deletions:parseInt(o??"0")}}function $(e){return e.split("\n").filter(e=>!!e).map(e=>/^(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(.*)$/.exec(e)).filter(e=>!!e).map(([,e,t,i,r,o])=>({mode:e,type:t,object:i,size:r,file:o}))}function N(e){return e.split("\n").filter(e=>!!e).map(e=>/^(\S+)\s+(\S+)\s+(\S+)\s+(.*)$/.exec(e)).filter(e=>!!e).map(([,e,t,i,r])=>({mode:e,object:t,stage:i,file:r}))}const U=/([0-9a-f]{40})\n(.*)\nstash@{(\d+)}\n(WIP\s)*on([^:]+):(.*)(?:\x00)/gim;function F(e,t){let i=0;const r=[],o=t.trim().split("\0").filter(e=>e);e:for(;i<o.length-1;){const t=o[i++],n=o[i++];if(!t||!n)break;const s=y.Uri.file(c.isAbsolute(n)?n:c.join(e,n));let a=s,l=s,h=7;switch(t[0]){case"A":h=1;break;case"M":h=5;break;case"D":h=6;break;case"R":{if(i>=o.length)break;const t=o[i++];if(!t)break;h=3,a=l=y.Uri.file(c.isAbsolute(t)?t:c.join(e,t));break}default:break e}r.push({status:h,uri:a,originalUri:s,renameUri:l})}return r}const W="%(refname)%00%(objectname)%00%(*objectname)",j=`${W}%00%(parent)%00%(*parent)%00%(authorname)%00%(*authorname)%00%(committerdate:unix)%00%(*committerdate:unix)%00%(subject)%00%(*subject)`;class K{constructor(e,t,i,r,o){this._git=e,this.repositoryRoot=t,this.repositoryRootRealPath=i,this.dotGit=r,this.logger=o,this._isUsingRefTable=!1,this._kind=this.dotGit.commonPath?"worktree":this.dotGit.superProjectPath?"submodule":"repository"}get kind(){return this._kind}get git(){return this._git}get root(){return this.repositoryRoot}get rootRealPath(){return this.repositoryRootRealPath}async exec(e,t={}){return await this.git.exec(this.repositoryRoot,e,t)}stream(e,t={}){return this.git.stream(this.repositoryRoot,e,t)}spawn(e,t={}){return this.git.spawn(e,t)}async config(e,t,i,r=null,o={}){const n=["config",`--${e}`];t&&n.push(`--${t}`),n.push(i),r&&n.push(r);try{return(await this.exec(n,o)).stdout.trim()}catch(e){return this.logger.warn(`[Git][config] git config failed: ${e.message}`),""}}async getConfigs(e){const t=["config"];return e&&t.push("--"+e),t.push("-l"),(await this.exec(t)).stdout.trim().split(/\r|\r\n|\n/).map(e=>{const t=e.indexOf("=");return{key:e.substr(0,t),value:e.substr(t+1)}})}async log(e,t){const i={cancellationToken:t},r=["log",`--format=${x}`,"-z"];e?.shortStats&&(r.push("--shortstat"),-1!==this._git.compareGitVersionTo("2.31")&&r.push("--diff-merges=first-parent")),e?.reverse&&r.push("--reverse","--ancestry-path"),e?.sortByAuthorDate&&r.push("--author-date-order"),e?.range?r.push(e.range):r.push(`-n${e?.maxEntries??32}`),e?.author&&r.push(`--author=${e.author}`),e?.grep&&(r.push(`--grep=${e.grep}`),r.push("--extended-regexp"),r.push("--regexp-ignore-case")),"number"==typeof e?.maxParents&&r.push(`--max-parents=${e.maxParents}`),"number"==typeof e?.skip&&r.push(`--skip=${e.skip}`),e?.refNames&&(r.push("--topo-order"),r.push("--decorate=full"),i.input=e.refNames.join("\n"),r.push("--stdin")),e?.path&&r.push("--",e.path);const o=await this.exec(r,i);return o.exitCode?[]:L(o.stdout)}async logFile(e,t,i){const r=["log",`--format=${x}`,"-z"];t?.maxEntries&&!t?.reverse&&r.push(`-n${t.maxEntries}`),t?.hash&&(t?.reverse?r.push("--reverse","--ancestry-path",`${t.hash}..HEAD`):r.push(t.hash)),t?.shortStats&&r.push("--shortstat"),t?.sortByAuthorDate&&r.push("--author-date-order"),t?.follow&&r.push("--follow"),r.push("--",e.fsPath);try{const e=await this.exec(r,{cancellationToken:i});return e.exitCode?[]:L(e.stdout)}catch(e){if(/does not have any commits yet/.test(e.stderr))return[];throw e}}async reflog(e,t){const i=["reflog",e,`--grep-reflog=${t}`],r=await this.exec(i);return r.exitCode?[]:r.stdout.split("\n").filter(e=>!!e)}async buffer(e,t){const i=this.sanitizeRelativePath(t),r=this.stream(["show","--textconv",`${e}:${i}`]);if(!r.stdout)return Promise.reject("Can't open file from git");const{exitCode:o,stdout:n,stderr:s}=await S(r);if(o){const e=new D({message:"Could not show object.",exitCode:o});return/exists on disk, but not in/.test(s)&&(e.gitErrorCode="WrongCase"),Promise.reject(e)}return n}async getObjectDetails(e,t){if(!e||":1"===e||":2"===e||":3"===e){const i=await this.lsfiles(t);if(0===i.length)throw new D({message:"Path not known by git",gitErrorCode:"UnknownPath"});const{mode:r,object:o}=""!==e?i.find(t=>t.stage===e.substring(1))??i[0]:i[0],n=await this.exec(["cat-file","-s",o]);return{mode:r,object:o,size:parseInt(n.stdout)}}const i=await this.lstree(e,t);if(0===i.length)throw new D({message:"Path not known by git",gitErrorCode:"UnknownPath"});const{mode:r,object:o,size:n}=i[0];return{mode:r,object:o,size:parseInt(n)||0}}async lstree(e,t,i){const r=["ls-tree","-l"];i?.recursive&&r.push("-r"),r.push(e),t&&r.push("--",this.sanitizeRelativePath(t));const{stdout:o}=await this.exec(r);return $(o)}async lsfiles(e){const t=["ls-files","--stage"],i=this.sanitizeRelativePath(e);i&&t.push("--",i);const{stdout:r}=await this.exec(t);return N(r)}async getGitFilePath(e,t){const i=e?await this.lstree(e,void 0,{recursive:!0}):await this.lsfiles(this.repositoryRoot),r=this.sanitizeRelativePath(t).toLowerCase(),o=i.find(e=>e.file.toLowerCase()===r);if(!o)throw new D({message:`Git relative path not found. Was looking for ${r} among ${JSON.stringify(i.map(({file:e})=>e),null,2)}`});return c.join(this.repositoryRoot,o.file)}async detectObjectType(e){const t=await this.stream(["show","--textconv",e]),i=await(0,f.readBytes)(t.stdout,4100);try{t.kill()}catch(e){}const r=(0,f.detectUnicodeEncoding)(i);let o=!0;if("utf16be"!==r&&"utf16le"!==r)for(let e=0;e<i.length;e++)if(0===i.readInt8(e)){o=!1;break}if(!o){const e=await g.fromBuffer(i);return e?{mimetype:e.mime}:{mimetype:"application/octet-stream"}}return r?{mimetype:"text/plain",encoding:r}:{mimetype:"text/plain"}}async apply(e,t){const i=["apply",e];t&&i.push("-R");try{await this.exec(i)}catch(e){throw/patch does not apply/.test(e.stderr)&&(e.gitErrorCode="PatchDoesNotApply"),e}}async diff(e=!1){const t=["diff"];return e&&t.push("--cached"),(await this.exec(t)).stdout}async diffWithHEAD(e){if(!e)return await this.diffFiles(!1);const t=["diff","--",this.sanitizeRelativePath(e)];return(await this.exec(t)).stdout}async diffWith(e,t){if(!t)return await this.diffFiles(!1,e);const i=["diff",e,"--",this.sanitizeRelativePath(t)];return(await this.exec(i)).stdout}async diffIndexWithHEAD(e){if(!e)return await this.diffFiles(!0);const t=["diff","--cached","--",this.sanitizeRelativePath(e)];return(await this.exec(t)).stdout}async diffIndexWith(e,t){if(!t)return await this.diffFiles(!0,e);const i=["diff","--cached",e,"--",this.sanitizeRelativePath(t)];return(await this.exec(i)).stdout}async diffBlobs(e,t){const i=["diff",e,t];return(await this.exec(i)).stdout}async diffBetween(e,t,i){const r=`${e}...${t}`;if(!i)return await this.diffFiles(!1,r);const o=["diff",r,"--",this.sanitizeRelativePath(i)];return(await this.exec(o)).stdout.trim()}async diffBetweenShortStat(e,t){const i=["diff","--shortstat",`${e}...${t}`],r=await this.exec(i);return r.exitCode?{files:0,insertions:0,deletions:0}:H(r.stdout.trim())}async diffFiles(e,t){const i=["diff","--name-status","-z","--diff-filter=ADMR"];e&&i.push("--cached"),t&&i.push(t);const r=await this.exec(i);return r.exitCode?[]:F(this.repositoryRoot,r.stdout)}async diffTrees(e,t,i){const r=["diff-tree","-r","--name-status","-z","--diff-filter=ADMR"];i?.similarityThreshold&&r.push(`--find-renames=${i.similarityThreshold}%`),r.push(e),t&&r.push(t);const o=await this.exec(r);return o.exitCode?[]:F(this.repositoryRoot,o.stdout)}async getMergeBase(e,t,...i){try{const r=["merge-base"];return 0!==i.length&&(r.push("--octopus"),r.push(...i)),r.push(e,t),(await this.exec(r)).stdout.trim()}catch(e){return}}async hashObject(e){return(await this.exec(["hash-object","-w","--stdin"],{input:e})).stdout.trim()}async add(e,t){const i=["add"];if(t&&t.update?i.push("-u"):i.push("-A"),e&&e.length)for(const t of(0,f.splitInChunks)(e.map(e=>this.sanitizeRelativePath(e)),C))await this.exec([...i,"--",...t]);else await this.exec([...i,"--","."])}async rm(e){const t=["rm","--"];e&&e.length&&(t.push(...e.map(e=>this.sanitizeRelativePath(e))),await this.exec(t))}async stage(e,t){const i=this.sanitizeRelativePath(e),r=this.stream(["hash-object","--stdin","-w","--path",i],{stdio:[null,null,null]});r.stdin.end(t);const{exitCode:o,stdout:n}=await S(r),s=n.toString("utf8");if(o)throw new D({message:"Could not hash object.",exitCode:o});const a=await this.getCommit("HEAD").then(()=>"HEAD",()=>"");let l,c="";try{l=(await this.getObjectDetails(a,e)).mode}catch(e){if("UnknownPath"!==e.gitErrorCode)throw e;l="100644",c="--add"}await this.exec(["update-index",c,"--cacheinfo",l,s,i])}async checkout(e,t,i=Object.create(null)){const r=["checkout","-q"];i.track&&r.push("--track"),i.detached&&r.push("--detach"),e&&r.push(e);try{if(t&&t.length>0)for(const e of(0,f.splitInChunks)(t.map(e=>this.sanitizeRelativePath(e)),C))await this.exec([...r,"--",...e]);else await this.exec(r)}catch(t){throw/Please,? commit your changes or stash them/.test(t.stderr||"")?(t.gitErrorCode="DirtyWorkTree",t.gitTreeish=e):/You are on a branch yet to be born/.test(t.stderr||"")&&(t.gitErrorCode="BranchNotYetBorn"),t}}async commit(e,t=Object.create(null)){const i=["commit","--quiet"],r={};e&&(r.input=e,i.push("--allow-empty-message","--file","-")),t.verbose&&i.push("--verbose"),t.all&&i.push("--all"),t.amend&&i.push("--amend"),t.useEditor||(e||(t.amend?i.push("--no-edit"):(r.input="",i.push("--file","-"))),i.push("--allow-empty-message")),t.signoff&&i.push("--signoff"),t.signCommit&&i.push("-S"),t.empty&&i.push("--allow-empty"),t.noVerify&&i.push("--no-verify"),(t.requireUserConfig??1)&&i.splice(0,0,"-c","user.useConfigOnly=true");try{await this.exec(i,r)}catch(e){await this.handleCommitError(e)}}async rebaseAbort(){await this.exec(["rebase","--abort"])}async rebaseContinue(){const e=["rebase","--continue"];try{await this.exec(e,{env:{GIT_EDITOR:"true"}})}catch(e){await this.handleCommitError(e)}}async handleCommitError(e){if(/not possible because you have unmerged files/.test(e.stderr||""))throw e.gitErrorCode="UnmergedChanges",e;if(/Aborting commit due to empty commit message/.test(e.stderr||""))throw e.gitErrorCode="EmptyCommitMessage",e;try{await this.exec(["config","--get-all","user.name"])}catch(e){throw e.gitErrorCode="NoUserNameConfigured",e}try{await this.exec(["config","--get-all","user.email"])}catch(e){throw e.gitErrorCode="NoUserEmailConfigured",e}throw e}async branch(e,t,i){const r=t?["checkout","-q","-b",e,"--no-track"]:["branch","-q",e];i&&r.push(i),await this.exec(r)}async deleteBranch(e,t){const i=["branch",t?"-D":"-d",e];await this.exec(i)}async renameBranch(e){const t=["branch","-m",e];await this.exec(t)}async move(e,t){const i=["mv",e,t];await this.exec(i)}async setBranchUpstream(e,t){const i=["branch","--set-upstream-to",t,e];await this.exec(i)}async deleteRef(e){const t=["update-ref","-d",e];await this.exec(t)}async merge(e){const t=["merge",e];try{await this.exec(t)}catch(e){throw/^CONFLICT /m.test(e.stdout||"")&&(e.gitErrorCode="Conflict"),e}}async mergeAbort(){await this.exec(["merge","--abort"])}async tag(e){let t=["tag"];t=e.message?[...t,"-a",e.name,"-m",e.message]:[...t,e.name],e.ref&&t.push(e.ref),await this.exec(t)}async deleteTag(e){const t=["tag","-d",e];await this.exec(t)}async addWorktree(e){const t=["worktree","add"];e.branch&&t.push("-b",e.branch),t.push(e.path,e.commitish),await this.exec(t)}async deleteWorktree(e,t){const i=["worktree","remove"];t?.force&&i.push("--force"),i.push(e),await this.exec(i)}async deleteRemoteRef(e,t,i){const r=["push",e,"--delete"];i?.force&&r.push("--force"),r.push(t),await this.exec(r)}async clean(e){const t=(0,f.groupBy)(e.map(_),e=>c.dirname(e)),i=Object.keys(t).map(e=>t[e]),r=new f.Limiter(5),o=[],n=["clean","-f","-q"];for(const e of i)for(const t of(0,f.splitInChunks)(e.map(e=>this.sanitizeRelativePath(e)),C))o.push(r.queue(()=>this.exec([...n,"--",...t])));await Promise.all(o)}async undo(){await this.exec(["clean","-fd"]);try{await this.exec(["checkout","--","."])}catch(e){if(/did not match any file\(s\) known to git\./.test(e.stderr||""))return;throw e}}async reset(e,t=!1){const i=["reset",t?"--hard":"--soft",e];await this.exec(i)}async revert(e,t){let i;i=(await this.exec(["branch"])).stdout?["reset","-q",e]:["rm","--cached","-r"];try{if(t&&t.length>0)for(const e of(0,f.splitInChunks)(t.map(e=>this.sanitizeRelativePath(e)),C))await this.exec([...i,"--",...e]);else await this.exec([...i,"--","."])}catch(e){if(/([^:]+: needs merge\n)+/m.test(e.stdout||""))return;throw e}}async addRemote(e,t){const i=["remote","add",e,t];await this.exec(i)}async removeRemote(e){const t=["remote","remove",e];await this.exec(t)}async renameRemote(e,t){const i=["remote","rename",e,t];await this.exec(i)}async fetch(e={}){const t=["fetch"],i={cancellationToken:e.cancellationToken,env:{GIT_HTTP_USER_AGENT:this.git.userAgent}};e.remote?(t.push(e.remote),e.ref&&t.push(e.ref)):e.all&&t.push("--all"),e.prune&&t.push("--prune"),"number"==typeof e.depth&&t.push(`--depth=${e.depth}`),e.silent&&(i.env.VSCODE_GIT_FETCH_SILENT="true");try{await this.exec(t,i)}catch(e){throw/No remote repository specified\./.test(e.stderr||"")?e.gitErrorCode="NoRemoteRepositorySpecified":/Could not read from remote repository/.test(e.stderr||"")?e.gitErrorCode="RemoteConnectionError":/! \[rejected\].*\(non-fast-forward\)/m.test(e.stderr||"")&&(e.gitErrorCode="BranchFastForwardRejected"),e}}async fetchTags(e){const t=["fetch"],i={env:{GIT_HTTP_USER_AGENT:this.git.userAgent}};t.push(e.remote);for(const i of e.tags)t.push(`refs/tags/${i}:refs/tags/${i}`);e.force&&t.push("--force"),await this.exec(t,i)}async pull(e,t,i,r={}){const o=["pull"];r.tags&&o.push("--tags"),r.unshallow&&o.push("--unshallow"),r.autoStash&&-1!==this._git.compareGitVersionTo("2.27.0")&&o.push("--autostash"),e&&o.push("-r"),t&&i&&(o.push(t),o.push(i));try{await this.exec(o,{cancellationToken:r.cancellationToken,env:{GIT_HTTP_USER_AGENT:this.git.userAgent}})}catch(e){throw/^CONFLICT \([^)]+\): \b/m.test(e.stdout||"")?e.gitErrorCode="Conflict":/Please tell me who you are\./.test(e.stderr||"")?e.gitErrorCode="NoUserNameConfigured":/Could not read from remote repository/.test(e.stderr||"")?e.gitErrorCode="RemoteConnectionError":/Pull(?:ing)? is not possible because you have unmerged files|Cannot pull with rebase: You have unstaged changes|Your local changes to the following files would be overwritten|Please, commit your changes before you can merge/i.test(e.stderr)?(e.stderr=e.stderr.replace(/Cannot pull with rebase: You have unstaged changes/i,"Cannot pull with rebase, you have unstaged changes"),e.gitErrorCode="DirtyWorkTree"):/cannot lock ref|unable to update local ref/i.test(e.stderr||"")?e.gitErrorCode="CantLockRef":/cannot rebase onto multiple branches/i.test(e.stderr||"")?e.gitErrorCode="CantRebaseMultipleBranches":/! \[rejected\].*\(would clobber existing tag\)/m.test(e.stderr||"")&&(e.gitErrorCode="TagConflict"),e}}async rebase(e,t={}){const i=["rebase"];i.push(e);try{await this.exec(i,t)}catch(e){throw/^CONFLICT \([^)]+\): \b/m.test(e.stdout||"")?e.gitErrorCode="Conflict":/cannot rebase onto multiple branches/i.test(e.stderr||"")&&(e.gitErrorCode="CantRebaseMultipleBranches"),e}}async push(e,t,i=!1,r=!1,o,n=!1){const s=["push"];1===o||2===o?(s.push("--force-with-lease"),2===o&&-1!==this._git.compareGitVersionTo("2.30")&&s.push("--force-if-includes")):0===o&&s.push("--force"),i&&s.push("-u"),r&&s.push("--follow-tags"),n&&s.push("--tags"),e&&s.push(e),t&&s.push(t);try{await this.exec(s,{env:{GIT_HTTP_USER_AGENT:this.git.userAgent}})}catch(e){throw/^error: failed to push some refs to\b/m.test(e.stderr||"")?1===o&&/! \[rejected\].*\(stale info\)/m.test(e.stderr||"")?e.gitErrorCode="ForcePushWithLeaseRejected":2===o&&/! \[rejected\].*\(remote ref updated since checkout\)/m.test(e.stderr||"")?e.gitErrorCode="ForcePushWithLeaseIfIncludesRejected":e.gitErrorCode="PushRejected":/Permission.*denied/.test(e.stderr||"")?e.gitErrorCode="PermissionDenied":/Could not read from remote repository/.test(e.stderr||"")?e.gitErrorCode="RemoteConnectionError":/^fatal: The current branch .* has no upstream branch/.test(e.stderr||"")&&(e.gitErrorCode="NoUpstreamBranch"),e}}async cherryPick(e){try{await this.exec(["cherry-pick",e])}catch(e){throw/The previous cherry-pick is now empty, possibly due to conflict resolution./.test(e.stderr??"")?(await this.cherryPickAbort(),e.gitErrorCode="CherryPickEmpty"):e.gitErrorCode="CherryPickConflict",e}}async cherryPickAbort(){await this.exec(["cherry-pick","--abort"])}async blame(e){try{const t=["blame","--",this.sanitizeRelativePath(e)];return(await this.exec(t)).stdout.trim()}catch(e){throw/^fatal: no such path/.test(e.stderr||"")&&(e.gitErrorCode="NoPathFound"),e}}async blame2(e,t){try{const i=["blame","--root","--incremental"];return t&&i.push(t),i.push("--",this.sanitizeRelativePath(e)),function(e){const t=/\r?\n/,i=/^([0-9a-f]{40})/gm,r=new Map;let o,n,s,a,l,c,h;for(const u of e.split(t)){const e=u.match(i);if(!o&&e){const t=u.split(" ");o=e[0],c=Number(t[2]),h=Number(t[2])+Number(t[3])-1}if(o&&u.startsWith("author ")&&(n=u.substring(7)),o&&u.startsWith("author-mail ")&&(s=u.substring(13,u.length-1)),o&&u.startsWith("author-time ")&&(a=1e3*Number(u.substring(12))),o&&u.startsWith("summary ")&&(l=u.substring(8)),o&&c&&h&&u.startsWith("filename ")){const e=r.get(o);e?(e.ranges.push({startLineNumber:c,endLineNumber:h}),r.set(o,e)):r.set(o,{hash:o,authorName:n,authorEmail:s,authorDate:a,subject:l,ranges:[{startLineNumber:c,endLineNumber:h}]}),o=n=s=a=l=c=h=void 0}}return Array.from(r.values())}((await this.exec(i)).stdout.trim())}catch(e){return}}async createStash(e,t,i){try{const r=["stash","push"];t&&r.push("-u"),i&&r.push("-S"),e&&r.push("-m",e),await this.exec(r)}catch(e){throw/No local changes to save/.test(e.stderr||"")&&(e.gitErrorCode="NoLocalChanges"),e}}async popStash(e){await this.popOrApplyStash(["stash","pop"],e)}async applyStash(e){await this.popOrApplyStash(["stash","apply"],e)}async popOrApplyStash(e,t){try{"number"==typeof t&&e.push(`stash@{${t}}`),await this.exec(e)}catch(e){throw/No stash found/.test(e.stderr||"")?e.gitErrorCode="NoStashFound":/error: Your local changes to the following files would be overwritten/.test(e.stderr||"")?e.gitErrorCode="LocalChangesOverwritten":/^CONFLICT/m.test(e.stdout||"")&&(e.gitErrorCode="StashConflict"),e}}async dropStash(e){const t=["stash"];"number"==typeof e?(t.push("drop"),t.push(`stash@{${e}}`)):t.push("clear");try{await this.exec(t)}catch(e){throw/No stash found/.test(e.stderr||"")&&(e.gitErrorCode="NoStashFound"),e}}async showStash(e){const t=["stash","show",`stash@{${e}}`,"--name-status","-z","-u"];try{const e=await this.exec(t);return e.exitCode?[]:F(this.repositoryRoot,e.stdout.trim())}catch(e){if(/No stash found/.test(e.stderr||""))return;throw e}}async getStatus(e){if(e?.cancellationToken&&e?.cancellationToken.isCancellationRequested)throw new y.CancellationError;const t=[],i=["status","-z"];"hidden"===e?.untrackedChanges?i.push("-uno"):i.push("-uall"),e?.ignoreSubmodules&&i.push("--ignore-submodules"),e?.similarityThreshold&&50!==e.similarityThreshold&&-1!==this._git.compareGitVersionTo("2.18.0")&&i.push(`--find-renames=${e.similarityThreshold}%`);const r=this.stream(i,{env:{GIT_OPTIONAL_LOCKS:"0"}});let o=new Promise((t,o)=>{const n=new M,s=e=>{if(0!==e){const t=c.join("");return o(new D({message:"Failed to execute git",stderr:t,exitCode:e,gitErrorCode:A(t),gitCommand:"status",gitArgs:i}))}t({status:n.status,statusLength:n.status.length,didHitLimit:!1})},a=e?.limit??1e4,l=e=>{n.update(e),0!==a&&n.status.length>a&&(r.removeListener("close",s),r.stdout.removeListener("data",l),r.kill(),t({status:n.status.slice(0,a),statusLength:n.status.length,didHitLimit:!0}))};r.stdout.setEncoding("utf8"),r.stdout.on("data",l);const c=[];r.stderr.setEncoding("utf8"),r.stderr.on("data",e=>c.push(e)),r.on("error",E(o)),r.on("close",s)});if(e?.cancellationToken){const i=new Promise((i,o)=>{t.push((0,f.onceEvent)(e.cancellationToken.onCancellationRequested)(()=>{try{r.kill()}catch(e){}o(new y.CancellationError)}))});o=Promise.race([o,i])}try{const{status:e,statusLength:t,didHitLimit:i}=await o;return{status:e,statusLength:t,didHitLimit:i}}finally{(0,f.dispose)(t)}}async getHEADRef(){let e;try{if(e=await this.getHEAD(),e.name){if(e=await this.getBranch(e.name),e&&e.upstream){const t="."!==e.upstream.remote?`refs/remotes/${e.upstream.remote}/${e.upstream.name}`:`refs/heads/${e.upstream.name}`,i=await this.revParse(t);e={...e,upstream:{...e.upstream,commit:i}}}}else if(e.commit){const t=(await this.getRefs({pattern:"refs/tags"})).find(t=>t.commit===e.commit);t&&(e={...e,name:t.name,type:2})}}catch(e){}return e}async getHEAD(){if(!this._isUsingRefTable)try{const e=await this.getHEADFS();if(".invalid"!==e.name)return e;this._isUsingRefTable=!0,this.logger.warn("[Git][getHEAD] Failed to parse HEAD file: Repository is using reftable format.")}catch(e){this.logger.warn(`[Git][getHEAD] Failed to parse HEAD file: ${e.message}`)}try{const e=await this.exec(["symbolic-ref","--short","HEAD"]);if(!e.stdout)throw new Error("Not in a branch");return{name:e.stdout.trim(),commit:void 0,type:0}}catch(e){}const e=await this.exec(["rev-parse","HEAD"]);if(!e.stdout)throw new Error("Error parsing HEAD");return{name:void 0,commit:e.stdout.trim(),type:0}}async getHEADFS(){const e=await l.promises.readFile(c.join(this.dotGit.path,"HEAD"),"utf8"),t=e.match(/^ref: refs\/heads\/(?<name>.*)$/m);if(t?.groups?.name)return{name:t.groups.name,commit:void 0,type:0};const i=e.match(/^(?<commit>[0-9a-f]{40})$/m);if(i?.groups?.commit)return{name:void 0,commit:i.groups.commit,type:0};throw new Error(`Unable to parse HEAD file. HEAD file contents: ${e}.`)}async findTrackingBranches(e){return(await this.exec(["for-each-ref","--format","%(refname:short)%00%(upstream:short)","refs/heads"])).stdout.trim().split("\n").map(e=>e.trim().split("\0")).filter(([t,i])=>i===e).map(([e])=>({name:e,type:0}))}async getRefs(e,t){if(t&&t.isCancellationRequested)throw new y.CancellationError;const i=["for-each-ref"];if(e.count&&i.push(`--count=${e.count}`),e.sort&&"alphabetically"!==e.sort&&i.push("--sort",`-${e.sort}`),e.includeCommitDetails){const e=-1!==this._git.compareGitVersionTo("1.9.0")?`${j}%00%(upstream:track)`:j;i.push("--format",e)}else i.push("--format",W);if(e.pattern){const t=Array.isArray(e.pattern)?e.pattern:[e.pattern];for(const e of t)i.push(e.startsWith("refs/")?e:`refs/${e}`)}return e.contains&&i.push("--contains",e.contains),function(e){const t=/^(refs\/[^\0]+)\0([0-9a-f]{40})\0([0-9a-f]{40})?(?:\0(.*))?$/gm,i=/^refs\/heads\/([^ ]+)$/,r=/^refs\/remotes\/([^/]+)\/([^ ]+)$/,o=/^refs\/tags\/([^ ]+)$/,n=/\[(?:ahead ([0-9]+))?[,\s]*(?:behind ([0-9]+))?]|\[gone]/;let s,a,l,c,h,u,d,p,m,g,f,y,w;const b=[];let C,v;for(;C=t.exec(e),null!==C;){[,s,a,l,c]=C,[h,u,m,g,f,y,d,p,w]=c?.split("\0")??[];const e=u||h,t=p||d,k=g||m,R=y||f,E=e&&t&&k&&R?{hash:a,message:t,parents:e.split(" "),authorName:k,commitDate:R?new Date(1e3*Number(R)):void 0}:void 0;if(v=i.exec(s)){const[,e,t]=n.exec(w)??[],i=w?e?Number(e):0:void 0,r=w?t?Number(t):0:void 0;b.push({name:v[1],commit:a,commitDetails:E,ahead:i,behind:r,type:0})}else if(v=r.exec(s)){const e=`${v[1]}/${v[2]}`;b.push({name:e,remote:v[1],commit:a,commitDetails:E,type:1})}else(v=o.exec(s))&&b.push({name:v[1],commit:l??a,commitDetails:E,type:2})}return b}((await this.exec(i,{cancellationToken:t})).stdout)}async getRemoteRefs(e,t){if(t?.cancellationToken&&t?.cancellationToken.isCancellationRequested)throw new y.CancellationError;const i=["ls-remote"];return t?.heads&&i.push("--heads"),t?.tags&&i.push("--tags"),i.push(e),(await this.exec(i,{cancellationToken:t?.cancellationToken})).stdout.split("\n").filter(e=>!!e).map(e=>{let t;return(t=/^([0-9a-f]{40})\trefs\/heads\/([^ ]+)$/.exec(e))?{name:t[1],commit:t[2],type:0}:(t=/^([0-9a-f]{40})\trefs\/tags\/([^ ]+)$/.exec(e))?{name:t[2],commit:t[1],type:2}:null}).filter(e=>!!e)}async getStashes(){return function(e){const t=[];let i,r,o,n,s,a,l;for(;i=U.exec(e),null!==i;)[,r,o,n,s,a,l]=i,t.push({hash:r,parents:o.split(" "),index:parseInt(n),branchName:a.trim(),description:s?`WIP (${l.trim()})`:l.trim()});return t}((await this.exec(["stash","list","--format=%H%n%P%n%gd%n%gs","-z"])).stdout.trim())}async getWorktrees(){return await this.getWorktreesFS()}async getWorktreesFS(){if(!0!==y.workspace.getConfiguration("git",y.Uri.file(this.repositoryRoot)).get("detectWorktrees"))return this.logger.info("[Git][getWorktreesFS] Worktree detection is disabled, skipping worktree detection"),[];try{const e=c.join(this.dotGit.commonPath??this.dotGit.path,"worktrees"),t=await l.promises.readdir(e,{withFileTypes:!0}),i=[];for(const r of t)if(r.isDirectory())try{const t=c.join(e,r.name,"HEAD"),o=(await l.promises.readFile(t,"utf8")).trim(),n=c.join(e,r.name,"gitdir"),s=(await l.promises.readFile(n,"utf8")).trim();i.push({name:r.name,path:s.replace(/\/.git.*$/,""),ref:o.replace(/^ref: /,"")})}catch(e){if(/ENOENT/.test(e.message))continue;throw e}return i}catch(e){if(/ENOENT/.test(e.message)||/ENOTDIR/.test(e.message))return[];throw e}}async getRemotes(){const e=[];try{e.push(...await this.getRemotesFS()),0===e.length&&this.logger.info("[Git][getRemotes] No remotes found in the git config file")}catch(t){this.logger.warn(`[Git][getRemotes] Error: ${t.message}`),e.push(...await this.getRemotesGit())}for(const t of e)t.isReadOnly=void 0===t.pushUrl||"no_push"===t.pushUrl;return e}async getRemotesFS(){return B(await l.promises.readFile(c.join(this.dotGit.commonPath??this.dotGit.path,"config"),"utf8"))}async getRemotesGit(){const e=[],t=(await this.exec(["remote","--verbose"])).stdout.trim().split("\n").filter(e=>!!e);for(const i of t){const t=i.split(/\s/),[r,o,n]=t;let s=e.find(e=>e.name===r);s||(s={name:r,isReadOnly:!1},e.push(s)),/fetch/i.test(n)?s.fetchUrl=o:(/push/i.test(n)||(s.fetchUrl=o),s.pushUrl=o)}return e}async getBranch(e){if("HEAD"===e)return this.getHEAD();const t=["for-each-ref"];let i=!0;-1===this._git.compareGitVersionTo("1.9.0")?(t.push("--format=%(refname)%00%(upstream:short)%00%(objectname)"),i=!1):-1===this._git.compareGitVersionTo("2.16.0")?t.push("--format=%(refname)%00%(upstream:short)%00%(objectname)%00%(upstream:track)"):t.push("--format=%(refname)%00%(upstream:short)%00%(objectname)%00%(upstream:track)%00%(upstream:remotename)%00%(upstream:remoteref)"),-1!==this.git.compareGitVersionTo("2.12")&&(f.isWindows||f.isMacintosh)&&t.push("--ignore-case"),/^refs\/(heads|remotes)\//i.test(e)?t.push(e):t.push(`refs/heads/${e}`,`refs/remotes/${e}`);const r=(await this.exec(t)).stdout.trim().split("\n").map(e=>{let[t,i,r,o,n,s]=e.trim().split("\0");if(t.startsWith("refs/heads/")){t=t.substring(11);const e=i.indexOf("/");let a,l;const c=/\[(?:ahead ([0-9]+))?[,\s]*(?:behind ([0-9]+))?]|\[gone]/.exec(o);return c&&([,a,l]=c),{type:0,name:t,upstream:""!==i&&"[gone]"!==o?{name:s?s.substring(11):i.substring(e+1),remote:n||i.substring(0,e)}:void 0,commit:r||void 0,ahead:Number(a)||0,behind:Number(l)||0}}if(t.startsWith("refs/remotes/")){t=t.substring(13);const e=t.indexOf("/");return{type:1,name:t.substring(e+1),remote:t.substring(0,e),commit:r}}}).filter(e=>!!e);if(r.length){const[e]=r;if(!i&&e.upstream)try{const t=await this.exec(["rev-list","--left-right","--count",`${e.name}...${e.upstream.remote}/${e.upstream.name}`]),[i,r]=t.stdout.trim().split("\t");e.ahead=Number(i)||0,e.behind=Number(r)||0}catch{}return e}return this.logger.warn(`[Git][getBranch] No such branch: ${e}`),Promise.reject(new Error(`No such branch: ${e}.`))}async getDefaultBranch(e){const t=await this.exec(["symbolic-ref","--short",`refs/remotes/${e}/HEAD`]);if(!t.stdout||t.stderr)throw new Error("No default branch");return this.getBranch(t.stdout.trim())}stripCommitMessageComments(e){return e.replace(/^\s*#.*$\n?/gm,"").trim()}async getSquashMessage(){const e=c.join(this.repositoryRoot,".git","SQUASH_MSG");try{const t=await l.promises.readFile(e,"utf8");return this.stripCommitMessageComments(t)}catch{return}}async getMergeMessage(){const e=c.join(this.repositoryRoot,".git","MERGE_MSG");try{const t=await l.promises.readFile(e,"utf8");return this.stripCommitMessageComments(t)}catch{return}}async getCommitTemplate(){try{const e=await this.exec(["config","--get","commit.template"]);if(!e.stdout)return"";const t=h.homedir();let i=e.stdout.trim().replace(/^~([^\/]*)\//,(e,i)=>`${i?c.join(c.dirname(t),i):t}/`);c.isAbsolute(i)||(i=c.join(this.repositoryRoot,i));const r=await l.promises.readFile(i,"utf8");return this.stripCommitMessageComments(r)}catch(e){return""}}async getCommit(e){const t=L((await this.exec(["show","-s","--decorate=full","--shortstat",`--format=${x}`,"-z",e,"--"])).stdout);return 0===t.length?Promise.reject("bad commit format"):t[0]}async showCommit(e){try{return(await this.exec(["show",e])).stdout.trim()}catch(e){throw/^fatal: bad revision '.+'/.test(e.stderr||"")&&(e.gitErrorCode="BadRevision"),e}}async revList(e,t){const i=await this.exec(["rev-list",`${e}..${t}`]);return i.stderr?[]:i.stdout.trim().split("\n")}async revParse(e){try{return(await l.promises.readFile(c.join(this.dotGit.path,e),"utf8")).trim()}catch(e){this.logger.warn(`[Git][revParse] Unable to read file: ${e.message}`)}try{const t=await this.exec(["rev-parse",e]);if(t.stderr)return;return t.stdout.trim()}catch(e){return}}async updateSubmodules(e){const t=["submodule","update"];for(const i of(0,f.splitInChunks)(e.map(e=>this.sanitizeRelativePath(e)),C))await this.exec([...t,"--",...i])}async getSubmodules(){const e=c.join(this.root,".gitmodules");try{return I(await l.promises.readFile(e,"utf8"))}catch(e){if(/ENOENT/.test(e.message))return[];throw e}}sanitizeRelativePath(e){if(this.logger.trace(`[Git][sanitizeRelativePath] filePath: ${e}`),!c.isAbsolute(e))return e=P(e),this.logger.trace(`[Git][sanitizeRelativePath] relativePath (noop): ${e}`),e;let t;return this.repositoryRootRealPath&&(t=(0,f.relativePathWithNoFallback)(this.repositoryRootRealPath,e),t)?(t=P(t),this.logger.trace(`[Git][sanitizeRelativePath] relativePath (real path): ${t}`),t):(t=(0,f.relativePathWithNoFallback)(this.repositoryRoot,e),t?(t=P(t),this.logger.trace(`[Git][sanitizeRelativePath] relativePath (path): ${t}`),t):(e=P(c.relative(this.repositoryRoot,e)),this.logger.trace(`[Git][sanitizeRelativePath] relativePath (fallback): ${e}`),e))}}t.Repository=K},842:(e,t,i)=>{"use strict";i.r(t),i.d(t,{isexe:()=>g,posix:()=>r,sync:()=>f,win32:()=>o});var r={};i.r(r),i.d(r,{isexe:()=>a,sync:()=>l});var o={};i.r(o),i.d(o,{isexe:()=>u,sync:()=>d});var n=i(9896);const s=require("fs/promises"),a=async(e,t={})=>{const{ignoreErrors:i=!1}=t;try{return c(await(0,s.stat)(e),t)}catch(e){const t=e;if(i||"EACCES"===t.code)return!1;throw t}},l=(e,t={})=>{const{ignoreErrors:i=!1}=t;try{return c((0,n.statSync)(e),t)}catch(e){const t=e;if(i||"EACCES"===t.code)return!1;throw t}},c=(e,t)=>e.isFile()&&h(e,t),h=(e,t)=>{const i=t.uid??process.getuid?.(),r=t.groups??process.getgroups?.()??[],o=t.gid??process.getgid?.()??r[0];if(void 0===i||void 0===o)throw new Error("cannot get uid or gid");const n=new Set([o,...r]),s=e.mode,a=e.uid,l=e.gid,c=parseInt("100",8),h=parseInt("010",8),u=c|h;return!!(s&parseInt("001",8)||s&h&&n.has(l)||s&c&&a===i||s&u&&0===i)},u=async(e,t={})=>{const{ignoreErrors:i=!1}=t;try{return p(await(0,s.stat)(e),e,t)}catch(e){const t=e;if(i||"EACCES"===t.code)return!1;throw t}},d=(e,t={})=>{const{ignoreErrors:i=!1}=t;try{return p((0,n.statSync)(e),e,t)}catch(e){const t=e;if(i||"EACCES"===t.code)return!1;throw t}},p=(e,t,i)=>e.isFile()&&((e,t)=>{const{pathExt:i=process.env.PATHEXT||""}=t,r=i.split(";");if(-1!==r.indexOf(""))return!0;for(let t=0;t<r.length;t++){const i=r[t].toLowerCase(),o=e.substring(e.length-i.length).toLowerCase();if(i&&o===i)return!0}return!1})(t,i),m="win32"===(process.env._ISEXE_TEST_PLATFORM_||process.platform)?o:r,g=m.isexe,f=m.sync},857:e=>{"use strict";e.exports=require("os")},1154:(e,t,i)=>{"use strict";const r=i(3940),o=i(280),{MAX_LENGTH:n,POSIX_REGEX_SOURCE:s,REGEX_NON_SPECIAL_CHARS:a,REGEX_SPECIAL_CHARS_BACKREF:l,REPLACEMENTS:c}=r,h=(e,t)=>{if("function"==typeof t.expandRange)return t.expandRange(...e,t);e.sort();const i=`[${e.join("-")}]`;try{new RegExp(i)}catch(t){return e.map(e=>o.escapeRegex(e)).join("..")}return i},u=(e,t)=>`Missing ${e}: "${t}" - use "\\\\${t}" to match literal characters`,d=(e,t)=>{if("string"!=typeof e)throw new TypeError("Expected a string");e=c[e]||e;const i={...t},p="number"==typeof i.maxLength?Math.min(n,i.maxLength):n;let m=e.length;if(m>p)throw new SyntaxError(`Input length: ${m}, exceeds maximum allowed length: ${p}`);const g={type:"bos",value:"",output:i.prepend||""},f=[g],y=i.capture?"":"?:",w=o.isWindows(t),b=r.globChars(w),C=r.extglobChars(b),{DOT_LITERAL:v,PLUS_LITERAL:k,SLASH_LITERAL:R,ONE_CHAR:E,DOTS_SLASH:S,NO_DOT:D,NO_DOT_SLASH:A,NO_DOTS_SLASH:_,QMARK:P,QMARK_NO_DOT:x,STAR:T,START_ANCHOR:M}=b,I=e=>`(${y}(?:(?!${M}${e.dot?S:v}).)*?)`,B=i.dot?"":D,O=i.dot?P:x;let L=!0===i.bash?I(i):T;i.capture&&(L=`(${L})`),"boolean"==typeof i.noext&&(i.noextglob=i.noext);const G={input:e,index:-1,start:0,dot:!0===i.dot,consumed:"",output:"",prefix:"",backtrack:!1,negated:!1,brackets:0,braces:0,parens:0,quotes:0,globstar:!1,tokens:f};e=o.removePrefix(e,G),m=e.length;const H=[],$=[],N=[];let U,F=g;const W=()=>G.index===m-1,j=G.peek=(t=1)=>e[G.index+t],K=G.advance=()=>e[++G.index]||"",J=()=>e.slice(G.index+1),z=(e="",t=0)=>{G.consumed+=e,G.index+=t},V=e=>{G.output+=null!=e.output?e.output:e.value,z(e.value)},q=()=>{let e=1;for(;"!"===j()&&("("!==j(2)||"?"===j(3));)K(),G.start++,e++;return e%2!=0&&(G.negated=!0,G.start++,!0)},Y=e=>{G[e]++,N.push(e)},Q=e=>{G[e]--,N.pop()},X=e=>{if("globstar"===F.type){const t=G.braces>0&&("comma"===e.type||"brace"===e.type),i=!0===e.extglob||H.length&&("pipe"===e.type||"paren"===e.type);"slash"===e.type||"paren"===e.type||t||i||(G.output=G.output.slice(0,-F.output.length),F.type="star",F.value="*",F.output=L,G.output+=F.output)}if(H.length&&"paren"!==e.type&&(H[H.length-1].inner+=e.value),(e.value||e.output)&&V(e),F&&"text"===F.type&&"text"===e.type)return F.value+=e.value,void(F.output=(F.output||"")+e.value);e.prev=F,f.push(e),F=e},Z=(e,t)=>{const r={...C[t],conditions:1,inner:""};r.prev=F,r.parens=G.parens,r.output=G.output;const o=(i.capture?"(":"")+r.open;Y("parens"),X({type:e,value:t,output:G.output?"":E}),X({type:"paren",extglob:!0,value:K(),output:o}),H.push(r)},ee=e=>{let r,o=e.close+(i.capture?")":"");if("negate"===e.type){let n=L;if(e.inner&&e.inner.length>1&&e.inner.includes("/")&&(n=I(i)),(n!==L||W()||/^\)+$/.test(J()))&&(o=e.close=`)$))${n}`),e.inner.includes("*")&&(r=J())&&/^\.[^\\/.]+$/.test(r)){const i=d(r,{...t,fastpaths:!1}).output;o=e.close=`)${i})${n})`}"bos"===e.prev.type&&(G.negatedExtglob=!0)}X({type:"paren",extglob:!0,value:U,output:o}),Q("parens")};if(!1!==i.fastpaths&&!/(^[*!]|[/()[\]{}"])/.test(e)){let r=!1,n=e.replace(l,(e,t,i,o,n,s)=>"\\"===o?(r=!0,e):"?"===o?t?t+o+(n?P.repeat(n.length):""):0===s?O+(n?P.repeat(n.length):""):P.repeat(i.length):"."===o?v.repeat(i.length):"*"===o?t?t+o+(n?L:""):L:t?e:`\\${e}`);return!0===r&&(n=!0===i.unescape?n.replace(/\\/g,""):n.replace(/\\+/g,e=>e.length%2==0?"\\\\":e?"\\":"")),n===e&&!0===i.contains?(G.output=e,G):(G.output=o.wrapOutput(n,G,t),G)}for(;!W();){if(U=K(),"\0"===U)continue;if("\\"===U){const e=j();if("/"===e&&!0!==i.bash)continue;if("."===e||";"===e)continue;if(!e){U+="\\",X({type:"text",value:U});continue}const t=/^\\+/.exec(J());let r=0;if(t&&t[0].length>2&&(r=t[0].length,G.index+=r,r%2!=0&&(U+="\\")),!0===i.unescape?U=K():U+=K(),0===G.brackets){X({type:"text",value:U});continue}}if(G.brackets>0&&("]"!==U||"["===F.value||"[^"===F.value)){if(!1!==i.posix&&":"===U){const e=F.value.slice(1);if(e.includes("[")&&(F.posix=!0,e.includes(":"))){const e=F.value.lastIndexOf("["),t=F.value.slice(0,e),i=F.value.slice(e+2),r=s[i];if(r){F.value=t+r,G.backtrack=!0,K(),g.output||1!==f.indexOf(F)||(g.output=E);continue}}}("["===U&&":"!==j()||"-"===U&&"]"===j())&&(U=`\\${U}`),"]"!==U||"["!==F.value&&"[^"!==F.value||(U=`\\${U}`),!0===i.posix&&"!"===U&&"["===F.value&&(U="^"),F.value+=U,V({value:U});continue}if(1===G.quotes&&'"'!==U){U=o.escapeRegex(U),F.value+=U,V({value:U});continue}if('"'===U){G.quotes=1===G.quotes?0:1,!0===i.keepQuotes&&X({type:"text",value:U});continue}if("("===U){Y("parens"),X({type:"paren",value:U});continue}if(")"===U){if(0===G.parens&&!0===i.strictBrackets)throw new SyntaxError(u("opening","("));const e=H[H.length-1];if(e&&G.parens===e.parens+1){ee(H.pop());continue}X({type:"paren",value:U,output:G.parens?")":"\\)"}),Q("parens");continue}if("["===U){if(!0!==i.nobracket&&J().includes("]"))Y("brackets");else{if(!0!==i.nobracket&&!0===i.strictBrackets)throw new SyntaxError(u("closing","]"));U=`\\${U}`}X({type:"bracket",value:U});continue}if("]"===U){if(!0===i.nobracket||F&&"bracket"===F.type&&1===F.value.length){X({type:"text",value:U,output:`\\${U}`});continue}if(0===G.brackets){if(!0===i.strictBrackets)throw new SyntaxError(u("opening","["));X({type:"text",value:U,output:`\\${U}`});continue}Q("brackets");const e=F.value.slice(1);if(!0===F.posix||"^"!==e[0]||e.includes("/")||(U=`/${U}`),F.value+=U,V({value:U}),!1===i.literalBrackets||o.hasRegexChars(e))continue;const t=o.escapeRegex(F.value);if(G.output=G.output.slice(0,-F.value.length),!0===i.literalBrackets){G.output+=t,F.value=t;continue}F.value=`(${y}${t}|${F.value})`,G.output+=F.value;continue}if("{"===U&&!0!==i.nobrace){Y("braces");const e={type:"brace",value:U,output:"(",outputIndex:G.output.length,tokensIndex:G.tokens.length};$.push(e),X(e);continue}if("}"===U){const e=$[$.length-1];if(!0===i.nobrace||!e){X({type:"text",value:U,output:U});continue}let t=")";if(!0===e.dots){const e=f.slice(),r=[];for(let t=e.length-1;t>=0&&(f.pop(),"brace"!==e[t].type);t--)"dots"!==e[t].type&&r.unshift(e[t].value);t=h(r,i),G.backtrack=!0}if(!0!==e.comma&&!0!==e.dots){const i=G.output.slice(0,e.outputIndex),r=G.tokens.slice(e.tokensIndex);e.value=e.output="\\{",U=t="\\}",G.output=i;for(const e of r)G.output+=e.output||e.value}X({type:"brace",value:U,output:t}),Q("braces"),$.pop();continue}if("|"===U){H.length>0&&H[H.length-1].conditions++,X({type:"text",value:U});continue}if(","===U){let e=U;const t=$[$.length-1];t&&"braces"===N[N.length-1]&&(t.comma=!0,e="|"),X({type:"comma",value:U,output:e});continue}if("/"===U){if("dot"===F.type&&G.index===G.start+1){G.start=G.index+1,G.consumed="",G.output="",f.pop(),F=g;continue}X({type:"slash",value:U,output:R});continue}if("."===U){if(G.braces>0&&"dot"===F.type){"."===F.value&&(F.output=v);const e=$[$.length-1];F.type="dots",F.output+=U,F.value+=U,e.dots=!0;continue}if(G.braces+G.parens===0&&"bos"!==F.type&&"slash"!==F.type){X({type:"text",value:U,output:v});continue}X({type:"dot",value:U,output:v});continue}if("?"===U){if((!F||"("!==F.value)&&!0!==i.noextglob&&"("===j()&&"?"!==j(2)){Z("qmark",U);continue}if(F&&"paren"===F.type){const e=j();let t=U;if("<"===e&&!o.supportsLookbehinds())throw new Error("Node.js v10 or higher is required for regex lookbehinds");("("===F.value&&!/[!=<:]/.test(e)||"<"===e&&!/<([!=]|\w+>)/.test(J()))&&(t=`\\${U}`),X({type:"text",value:U,output:t});continue}if(!0!==i.dot&&("slash"===F.type||"bos"===F.type)){X({type:"qmark",value:U,output:x});continue}X({type:"qmark",value:U,output:P});continue}if("!"===U){if(!0!==i.noextglob&&"("===j()&&("?"!==j(2)||!/[!=<:]/.test(j(3)))){Z("negate",U);continue}if(!0!==i.nonegate&&0===G.index){q();continue}}if("+"===U){if(!0!==i.noextglob&&"("===j()&&"?"!==j(2)){Z("plus",U);continue}if(F&&"("===F.value||!1===i.regex){X({type:"plus",value:U,output:k});continue}if(F&&("bracket"===F.type||"paren"===F.type||"brace"===F.type)||G.parens>0){X({type:"plus",value:U});continue}X({type:"plus",value:k});continue}if("@"===U){if(!0!==i.noextglob&&"("===j()&&"?"!==j(2)){X({type:"at",extglob:!0,value:U,output:""});continue}X({type:"text",value:U});continue}if("*"!==U){"$"!==U&&"^"!==U||(U=`\\${U}`);const e=a.exec(J());e&&(U+=e[0],G.index+=e[0].length),X({type:"text",value:U});continue}if(F&&("globstar"===F.type||!0===F.star)){F.type="star",F.star=!0,F.value+=U,F.output=L,G.backtrack=!0,G.globstar=!0,z(U);continue}let t=J();if(!0!==i.noextglob&&/^\([^?]/.test(t)){Z("star",U);continue}if("star"===F.type){if(!0===i.noglobstar){z(U);continue}const r=F.prev,o=r.prev,n="slash"===r.type||"bos"===r.type,s=o&&("star"===o.type||"globstar"===o.type);if(!0===i.bash&&(!n||t[0]&&"/"!==t[0])){X({type:"star",value:U,output:""});continue}const a=G.braces>0&&("comma"===r.type||"brace"===r.type),l=H.length&&("pipe"===r.type||"paren"===r.type);if(!n&&"paren"!==r.type&&!a&&!l){X({type:"star",value:U,output:""});continue}for(;"/**"===t.slice(0,3);){const i=e[G.index+4];if(i&&"/"!==i)break;t=t.slice(3),z("/**",3)}if("bos"===r.type&&W()){F.type="globstar",F.value+=U,F.output=I(i),G.output=F.output,G.globstar=!0,z(U);continue}if("slash"===r.type&&"bos"!==r.prev.type&&!s&&W()){G.output=G.output.slice(0,-(r.output+F.output).length),r.output=`(?:${r.output}`,F.type="globstar",F.output=I(i)+(i.strictSlashes?")":"|$)"),F.value+=U,G.globstar=!0,G.output+=r.output+F.output,z(U);continue}if("slash"===r.type&&"bos"!==r.prev.type&&"/"===t[0]){const e=void 0!==t[1]?"|$":"";G.output=G.output.slice(0,-(r.output+F.output).length),r.output=`(?:${r.output}`,F.type="globstar",F.output=`${I(i)}${R}|${R}${e})`,F.value+=U,G.output+=r.output+F.output,G.globstar=!0,z(U+K()),X({type:"slash",value:"/",output:""});continue}if("bos"===r.type&&"/"===t[0]){F.type="globstar",F.value+=U,F.output=`(?:^|${R}|${I(i)}${R})`,G.output=F.output,G.globstar=!0,z(U+K()),X({type:"slash",value:"/",output:""});continue}G.output=G.output.slice(0,-F.output.length),F.type="globstar",F.output=I(i),F.value+=U,G.output+=F.output,G.globstar=!0,z(U);continue}const r={type:"star",value:U,output:L};!0!==i.bash?!F||"bracket"!==F.type&&"paren"!==F.type||!0!==i.regex?(G.index!==G.start&&"slash"!==F.type&&"dot"!==F.type||("dot"===F.type?(G.output+=A,F.output+=A):!0===i.dot?(G.output+=_,F.output+=_):(G.output+=B,F.output+=B),"*"!==j()&&(G.output+=E,F.output+=E)),X(r)):(r.output=U,X(r)):(r.output=".*?","bos"!==F.type&&"slash"!==F.type||(r.output=B+r.output),X(r))}for(;G.brackets>0;){if(!0===i.strictBrackets)throw new SyntaxError(u("closing","]"));G.output=o.escapeLast(G.output,"["),Q("brackets")}for(;G.parens>0;){if(!0===i.strictBrackets)throw new SyntaxError(u("closing",")"));G.output=o.escapeLast(G.output,"("),Q("parens")}for(;G.braces>0;){if(!0===i.strictBrackets)throw new SyntaxError(u("closing","}"));G.output=o.escapeLast(G.output,"{"),Q("braces")}if(!0===i.strictSlashes||"star"!==F.type&&"bracket"!==F.type||X({type:"maybe_slash",value:"",output:`${R}?`}),!0===G.backtrack){G.output="";for(const e of G.tokens)G.output+=null!=e.output?e.output:e.value,e.suffix&&(G.output+=e.suffix)}return G};d.fastpaths=(e,t)=>{const i={...t},s="number"==typeof i.maxLength?Math.min(n,i.maxLength):n,a=e.length;if(a>s)throw new SyntaxError(`Input length: ${a}, exceeds maximum allowed length: ${s}`);e=c[e]||e;const l=o.isWindows(t),{DOT_LITERAL:h,SLASH_LITERAL:u,ONE_CHAR:d,DOTS_SLASH:p,NO_DOT:m,NO_DOTS:g,NO_DOTS_SLASH:f,STAR:y,START_ANCHOR:w}=r.globChars(l),b=i.dot?g:m,C=i.dot?f:m,v=i.capture?"":"?:";let k=!0===i.bash?".*?":y;i.capture&&(k=`(${k})`);const R=e=>!0===e.noglobstar?k:`(${v}(?:(?!${w}${e.dot?p:h}).)*?)`,E=e=>{switch(e){case"*":return`${b}${d}${k}`;case".*":return`${h}${d}${k}`;case"*.*":return`${b}${k}${h}${d}${k}`;case"*/*":return`${b}${k}${u}${d}${C}${k}`;case"**":return b+R(i);case"**/*":return`(?:${b}${R(i)}${u})?${C}${d}${k}`;case"**/*.*":return`(?:${b}${R(i)}${u})?${C}${k}${h}${d}${k}`;case"**/.*":return`(?:${b}${R(i)}${u})?${h}${d}${k}`;default:{const t=/^(.*?)\.(\w+)$/.exec(e);if(!t)return;const i=E(t[1]);if(!i)return;return i+h+t[2]}}},S=o.removePrefix(e,{negated:!1,prefix:""});let D=E(S);return D&&!0!==i.strictSlashes&&(D+=`${u}?`),D},e.exports=d},1184:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.deactivate=async function(){for(const e of P)await e()},t._activate=M,t.getExtensionContext=function(){return I},t.activate=async function(e){I=e;const t=await M(e);return e.subscriptions.push((0,v.registerAPICommands)(t)),t};const a=i(1398),l=i(693),c=i(2672),h=i(4459),u=i(2987),d=i(5518),p=i(2857),m=i(7937),g=i(5509),f=i(9815),y=s(i(6928)),w=s(i(9896)),b=s(i(857)),C=i(6103),v=i(6199),k=i(6333),R=i(3765),E=i(2228),S=i(8672),D=i(9522),A=i(62),_=i(5362),P=[];async function x(e,t,i){const r=a.workspace.getConfiguration("git").get("path");let o=Array.isArray(r)?r:r?[r]:[];const{isTrusted:n,workspaceFolders:s=[]}=a.workspace,g=n?[]:s.map(e=>y.normalize(e.uri.fsPath).replace(/[\r\n]+$/,""));n||0===o.length||(o=o.filter(e=>y.isAbsolute(e)));const f=await(0,l.findGit)(o,e=>{if(t.info(a.l10n.t('[main] Validating found git in: "{0}"',e)),0===g.length)return!0;const i=y.normalize(e).replace(/[\r\n]+$/,""),r=g.some(e=>i.startsWith(e));return r&&t.info(a.l10n.t('[main] Skipped found git in: "{0}"',e)),!r},t);let w;try{w=await(0,R.createIPCServer)(e.storagePath)}catch(e){t.error(`[main] Failed to create git IPC: ${e}`)}const v=new p.Askpass(w,t);i.push(v);const P=new E.GitEditor(w);i.push(P);const x={...v.getEnv(),...P.getEnv(),...w?.getEnv()},T=new k.TerminalEnvironmentManager(e,[v,P,w]);i.push(T),t.info(a.l10n.t('[main] Using git "{0}" from "{1}"',f.version,f.path));const M=new l.Git({gitPath:f.path,userAgent:`git/${f.version} (${b.version?.()??b.type()} ${b.release()}; ${b.platform()} ${b.arch()}) vscode/${a.version} (${a.env.appName})`,version:f.version,env:x}),I=new c.Model(M,v,e.globalState,e.workspaceState,t);i.push(I);const B=()=>a.commands.executeCommand("setContext","gitOpenRepositoryCount",`${I.repositories.length}`);I.onDidOpenRepository(B,null,i),I.onDidCloseRepository(B,null,i),B();const O=e=>{const i=e.split(/\r?\n/gm);for(;/^\s*$/.test(i[i.length-1]);)i.pop();t.appendLine(i.join("\n"))};M.onOutput.addListener("log",O),i.push((0,m.toDisposable)(()=>M.onOutput.removeListener("log",O)));const L=new h.CommandCenter(M,I,e.globalState,t);i.push(L,new u.GitFileSystemProvider(I,t),new d.GitDecorations(I),new _.GitBlameController(I),new C.GitTimelineProvider(I,L),new D.GitEditSessionIdentityProvider(I),new k.TerminalShellExecutionManager(I,t));const G=new S.GitPostCommitCommandsProvider(I);I.registerPostCommitCommandsProvider(G);const H=new A.GitCommitInputBoxDiagnosticsManager(I);i.push(H);const $=new A.GitCommitInputBoxCodeActionsProvider(H);i.push($);const N=a.languages.registerDocumentLinkProvider("git-commit",new E.GitEditorDocumentLinkProvider(I));return i.push(N),async function(e){await async function(e){const t=a.workspace.getConfiguration("git");if(!0===t.get("ignoreLegacyWarning"))return;if(!/^[01]/.test(e.version))return;const i=a.l10n.t("Update Git"),r=a.l10n.t("Don't Show Again"),o=await a.window.showWarningMessage(a.l10n.t('You seem to have git "{0}" installed. Code works best with git >= 2',e.version),i,r);o===i?a.commands.executeCommand("vscode.open",a.Uri.parse("https://aka.ms/vscode-download-git")):o===r&&await t.update("ignoreLegacyWarning",!0,!0)}(e),"win32"===process.platform&&await async function(e){if(!/^2\.(25|26)\./.test(e.version))return;const t=a.workspace.getConfiguration("git");if(!0===t.get("ignoreWindowsGit27Warning"))return;const i=a.l10n.t("Update Git"),r=a.l10n.t("Don't Show Again"),o=await a.window.showWarningMessage(a.l10n.t('There are known issues with the installed Git "{0}". Please update to Git >= 2.27 for the git features to work correctly.',e.version),i,r);o===i?a.commands.executeCommand("vscode.open",a.Uri.parse("https://aka.ms/vscode-download-git")):o===r&&await t.update("ignoreWindowsGit27Warning",!0,!0)}(e)}(f),a.commands.executeCommand("setContext","gitVersion2.35",M.compareGitVersionTo("2.35")>=0),I}async function T(e){if("file"!==e.uri.scheme)return!1;const t=y.join(e.uri.fsPath,".git");try{return(await new Promise((e,i)=>w.stat(t,(t,r)=>t?i(t):e(r)))).isDirectory()}catch(e){return!1}}async function M(e){const t=[];e.subscriptions.push(new a.Disposable(()=>a.Disposable.from(...t).dispose()));const i=a.window.createOutputChannel("Git",{log:!0});t.push(i);const r=e=>{i.appendLine(a.l10n.t("[main] Log level: {0}",a.LogLevel[e]))};if(t.push(i.onDidChangeLogLevel(r)),r(i.logLevel),!a.workspace.getConfiguration("git",null).get("enabled")){const r=(0,m.filterEvent)(a.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git")),o=(0,m.filterEvent)(r,()=>!0===a.workspace.getConfiguration("git",null).get("enabled")),n=new f.GitExtensionImpl;return(0,m.eventToPromise)(o).then(async()=>n.model=await x(e,i,t)),n}try{const r=await x(e,i,t);return new f.GitExtensionImpl(r)}catch(e){if(console.warn(e.message),i.warn(`[main] Failed to create model: ${e}`),!/Git installation not found/.test(e.message||""))throw e;return a.commands.executeCommand("setContext","git.missing",!0),async function(){const e=a.workspace.getConfiguration("git");if(!0===e.get("ignoreMissingGitWarning"))return;if(!a.workspace.workspaceFolders)return;if((await Promise.all(a.workspace.workspaceFolders.map(T))).every(e=>!e))return;const t=a.l10n.t("Download Git"),i=a.l10n.t("Don't Show Again"),r=await a.window.showWarningMessage(a.l10n.t('Git not found. Install it or configure it using the "git.path" setting.'),t,i);r===t?a.commands.executeCommand("vscode.open",a.Uri.parse("https://aka.ms/vscode-download-git")):r===i&&await e.update("ignoreMissingGitWarning",!0,!0)}(),new f.GitExtensionImpl}finally{t.push(new g.GitProtocolHandler(i))}}let I},1343:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.readFile=t.writeFileSync=t.writeFile=t.read=t.open=t.close=t.stat=t.createReadStream=t.pathExists=void 0;const r=i(9896);t.pathExists=r.existsSync,t.createReadStream=r.createReadStream,t.stat=async function(e){return new Promise((t,i)=>{r.stat(e,(e,r)=>{e?i(e):t(r)})})},t.close=async function(e){return new Promise((t,i)=>{r.close(e,e=>{e?i(e):t()})})},t.open=async function(e,t){return new Promise((i,o)=>{r.open(e,t,(e,t)=>{e?o(e):i(t)})})},t.read=async function(e,t,i,o,n){return new Promise((s,a)=>{r.read(e,t,i,o,n,(e,t,i)=>{e?a(e):s({bytesRead:t,buffer:i})})})},t.writeFile=async function(e,t){return new Promise((i,o)=>{r.writeFile(e,t,e=>{e?o(e):i()})})},t.writeFileSync=function(e,t){r.writeFileSync(e,t)},t.readFile=async function(e){return new Promise((t,i)=>{r.readFile(e,(e,r)=>{e?i(e):t(r)})})}},1398:e=>{"use strict";e.exports=require("vscode")},1456:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.fromFile=t.FileTokenizer=void 0;const r=i(8632),o=i(8705),n=i(1343);class s extends r.AbstractTokenizer{constructor(e,t){super(t),this.fd=e}async readBuffer(e,t){const i=this.normalizeOptions(e,t);this.position=i.position;const r=await n.read(this.fd,e,i.offset,i.length,i.position);if(this.position+=r.bytesRead,r.bytesRead<i.length&&(!t||!t.mayBeLess))throw new o.EndOfStreamError;return r.bytesRead}async peekBuffer(e,t){const i=this.normalizeOptions(e,t),r=await n.read(this.fd,e,i.offset,i.length,i.position);if(!i.mayBeLess&&r.bytesRead<i.length)throw new o.EndOfStreamError;return r.bytesRead}async close(){return n.close(this.fd)}}t.FileTokenizer=s,t.fromFile=async function(e){const t=await n.stat(e);if(!t.isFile)throw new Error(`File not a file: ${e}`);const i=await n.open(e,"r");return new s(i,{path:e,size:t.size})}},1510:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.StreamReader=t.EndOfStreamError=void 0;const r=i(5523),o=i(8122);var n=i(5523);Object.defineProperty(t,"EndOfStreamError",{enumerable:!0,get:function(){return n.EndOfStreamError}}),t.StreamReader=class{constructor(e){if(this.s=e,this.deferred=null,this.endOfStream=!1,this.peekQueue=[],!e.read||!e.once)throw new Error("Expected an instance of stream.Readable");this.s.once("end",()=>this.reject(new r.EndOfStreamError)),this.s.once("error",e=>this.reject(e)),this.s.once("close",()=>this.reject(new Error("Stream closed")))}async peek(e,t,i){const r=await this.read(e,t,i);return this.peekQueue.push(e.subarray(t,t+r)),r}async read(e,t,i){if(0===i)return 0;if(0===this.peekQueue.length&&this.endOfStream)throw new r.EndOfStreamError;let o=i,n=0;for(;this.peekQueue.length>0&&o>0;){const i=this.peekQueue.pop();if(!i)throw new Error("peekData should be defined");const r=Math.min(i.length,o);e.set(i.subarray(0,r),t+n),n+=r,o-=r,r<i.length&&this.peekQueue.push(i.subarray(r))}for(;o>0&&!this.endOfStream;){const i=Math.min(o,1048576),r=await this.readFromStream(e,t+n,i);if(n+=r,r<i)break;o-=r}return n}async readFromStream(e,t,i){const r=this.s.read(i);if(r)return e.set(r,t),r.length;{const r={buffer:e,offset:t,length:i,deferred:new o.Deferred};return this.deferred=r.deferred,this.s.once("readable",()=>{this.readDeferred(r)}),r.deferred.promise}}readDeferred(e){const t=this.s.read(e.length);t?(e.buffer.set(t,e.offset),e.deferred.resolve(t.length),this.deferred=null):this.s.once("readable",()=>{this.readDeferred(e)})}reject(e){this.endOfStream=!0,this.deferred&&(this.deferred.reject(e),this.deferred=null)}}},1558:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.GitBranchProtectionProvider=void 0;const r=i(1398),o=i(7937);t.GitBranchProtectionProvider=class{constructor(e){this.repositoryRoot=e,this._onDidChangeBranchProtection=new r.EventEmitter,this.onDidChangeBranchProtection=this._onDidChangeBranchProtection.event,this.disposables=[],(0,o.filterEvent)(r.workspace.onDidChangeConfiguration,t=>t.affectsConfiguration("git.branchProtection",e))(this.updateBranchProtection,this,this.disposables),this.updateBranchProtection()}provideBranchProtection(){return[this.branchProtection]}updateBranchProtection(){const e=r.workspace.getConfiguration("git",this.repositoryRoot).get("branchProtection")??[],t=(Array.isArray(e)?e:[e]).map(e=>"string"==typeof e?e.trim():"").filter(e=>""!==e);this.branchProtection={remote:"",rules:[{include:t}]},this._onDidChangeBranchProtection.fire(this.repositoryRoot)}dispose(){this.disposables=(0,o.dispose)(this.disposables)}}},1664:e=>{"use strict";e.exports={extensions:["jpg","png","apng","gif","webp","flif","xcf","cr2","cr3","orf","arw","dng","nef","rw2","raf","tif","bmp","icns","jxr","psd","indd","zip","tar","rar","gz","bz2","7z","dmg","mp4","mid","mkv","webm","mov","avi","mpg","mp2","mp3","m4a","oga","ogg","ogv","opus","flac","wav","spx","amr","pdf","epub","exe","swf","rtf","wasm","woff","woff2","eot","ttf","otf","ico","flv","ps","xz","sqlite","nes","crx","xpi","cab","deb","ar","rpm","Z","lz","cfb","mxf","mts","blend","bpg","docx","pptx","xlsx","3gp","3g2","jp2","jpm","jpx","mj2","aif","qcp","odt","ods","odp","xml","mobi","heic","cur","ktx","ape","wv","dcm","ics","glb","pcap","dsf","lnk","alias","voc","ac3","m4v","m4p","m4b","f4v","f4p","f4b","f4a","mie","asf","ogm","ogx","mpc","arrow","shp","aac","mp1","it","s3m","xm","ai","skp","avif","eps","lzh","pgp","asar","stl","chm","3mf","zst","jxl","vcf"],mimeTypes:["image/jpeg","image/png","image/gif","image/webp","image/flif","image/x-xcf","image/x-canon-cr2","image/x-canon-cr3","image/tiff","image/bmp","image/vnd.ms-photo","image/vnd.adobe.photoshop","application/x-indesign","application/epub+zip","application/x-xpinstall","application/vnd.oasis.opendocument.text","application/vnd.oasis.opendocument.spreadsheet","application/vnd.oasis.opendocument.presentation","application/vnd.openxmlformats-officedocument.wordprocessingml.document","application/vnd.openxmlformats-officedocument.presentationml.presentation","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet","application/zip","application/x-tar","application/x-rar-compressed","application/gzip","application/x-bzip2","application/x-7z-compressed","application/x-apple-diskimage","application/x-apache-arrow","video/mp4","audio/midi","video/x-matroska","video/webm","video/quicktime","video/vnd.avi","audio/vnd.wave","audio/qcelp","audio/x-ms-asf","video/x-ms-asf","application/vnd.ms-asf","video/mpeg","video/3gpp","audio/mpeg","audio/mp4","audio/opus","video/ogg","audio/ogg","application/ogg","audio/x-flac","audio/ape","audio/wavpack","audio/amr","application/pdf","application/x-msdownload","application/x-shockwave-flash","application/rtf","application/wasm","font/woff","font/woff2","application/vnd.ms-fontobject","font/ttf","font/otf","image/x-icon","video/x-flv","application/postscript","application/eps","application/x-xz","application/x-sqlite3","application/x-nintendo-nes-rom","application/x-google-chrome-extension","application/vnd.ms-cab-compressed","application/x-deb","application/x-unix-archive","application/x-rpm","application/x-compress","application/x-lzip","application/x-cfb","application/x-mie","application/mxf","video/mp2t","application/x-blender","image/bpg","image/jp2","image/jpx","image/jpm","image/mj2","audio/aiff","application/xml","application/x-mobipocket-ebook","image/heif","image/heif-sequence","image/heic","image/heic-sequence","image/icns","image/ktx","application/dicom","audio/x-musepack","text/calendar","text/vcard","model/gltf-binary","application/vnd.tcpdump.pcap","audio/x-dsf","application/x.ms.shortcut","application/x.apple.alias","audio/x-voc","audio/vnd.dolby.dd-raw","audio/x-m4a","image/apng","image/x-olympus-orf","image/x-sony-arw","image/x-adobe-dng","image/x-nikon-nef","image/x-panasonic-rw2","image/x-fujifilm-raf","video/x-m4v","video/3gpp2","application/x-esri-shape","audio/aac","audio/x-it","audio/x-s3m","audio/x-xm","video/MP1S","video/MP2P","application/vnd.sketchup.skp","image/avif","application/x-lzh-compressed","application/pgp-encrypted","application/x-asar","model/stl","application/vnd.ms-htmlhelp","model/3mf","image/jxl","application/zstd"]}},1750:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.StatusBarCommands=void 0;const r=i(1398),o=i(7937);class n{get onDidChange(){return this._onDidChange.event}get state(){return this._state}set state(e){this._state=e,this._onDidChange.fire()}constructor(e){this.repository=e,this._onDidChange=new r.EventEmitter,this.disposables=[],this._state={isCheckoutRunning:!1,isCommitRunning:!1,isSyncRunning:!1},e.onDidChangeOperations(this.onDidChangeOperations,this,this.disposables),e.onDidRunGitStatus(this._onDidChange.fire,this._onDidChange,this.disposables),e.onDidChangeBranchProtection(this._onDidChange.fire,this._onDidChange,this.disposables)}get command(){const e=[...this.repository.operations.getOperations("Checkout"),...this.repository.operations.getOperations("CheckoutTracking")],t=!!this.repository.rebaseCommit,i=e[0]?.refLabel??`${this.repository.headLabel}${t?` (${r.l10n.t("Rebasing")})`:""}`;return{command:this.state.isCheckoutRunning||this.state.isCommitRunning||this.state.isSyncRunning?"":"git.checkout",tooltip:`${i}, ${this.getTooltip()}`,title:`${this.getIcon()} ${i}`,arguments:[this.repository.sourceControl]}}getIcon(){return this.repository.HEAD?this.state.isCheckoutRunning?"$(loading~spin)":0===this.repository.HEAD.type&&this.repository.HEAD.name?this.repository.isBranchProtected()?"$(lock)":"$(git-branch)":2===this.repository.HEAD.type?"$(tag)":"$(git-commit)":""}getTooltip(){return this.state.isCheckoutRunning?r.l10n.t("Checking Out Branch/Tag..."):this.state.isCommitRunning?r.l10n.t("Committing Changes..."):this.state.isSyncRunning?r.l10n.t("Synchronizing Changes..."):r.l10n.t("Checkout Branch/Tag...")}onDidChangeOperations(){const e=this.repository.operations.isRunning("Commit"),t=this.repository.operations.isRunning("Checkout")||this.repository.operations.isRunning("CheckoutTracking"),i=this.repository.operations.isRunning("Sync")||this.repository.operations.isRunning("Push")||this.repository.operations.isRunning("Pull");this.state={...this.state,isCheckoutRunning:t,isCommitRunning:e,isSyncRunning:i}}dispose(){this.disposables.forEach(e=>e.dispose())}}class s{get onDidChange(){return this._onDidChange.event}get state(){return this._state}set state(e){this._state=e,this._onDidChange.fire()}constructor(e,t){this.repository=e,this.remoteSourcePublisherRegistry=t,this._onDidChange=new r.EventEmitter,this.disposables=[],this._state={enabled:!0,isCheckoutRunning:!1,isCommitRunning:!1,isSyncRunning:!1,hasRemotes:!1,HEAD:void 0,remoteSourcePublishers:t.getRemoteSourcePublishers()},e.onDidRunGitStatus(this.onDidRunGitStatus,this,this.disposables),e.onDidChangeOperations(this.onDidChangeOperations,this,this.disposables),(0,o.anyEvent)(t.onDidAddRemoteSourcePublisher,t.onDidRemoveRemoteSourcePublisher)(this.onDidChangeRemoteSourcePublishers,this,this.disposables),(0,o.filterEvent)(r.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git.enableStatusBarSync"))(this.updateEnablement,this,this.disposables),this.updateEnablement()}updateEnablement(){const e=r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)).get("enableStatusBarSync",!0);this.state={...this.state,enabled:e}}onDidChangeOperations(){const e=this.repository.operations.isRunning("Commit"),t=this.repository.operations.isRunning("Checkout")||this.repository.operations.isRunning("CheckoutTracking"),i=this.repository.operations.isRunning("Sync")||this.repository.operations.isRunning("Push")||this.repository.operations.isRunning("Pull");this.state={...this.state,isCheckoutRunning:t,isCommitRunning:e,isSyncRunning:i}}onDidRunGitStatus(){this.state={...this.state,hasRemotes:this.repository.remotes.length>0,HEAD:this.repository.HEAD}}onDidChangeRemoteSourcePublishers(){this.state={...this.state,remoteSourcePublishers:this.remoteSourcePublisherRegistry.getRemoteSourcePublishers()}}get command(){if(!this.state.enabled)return;if(!this.state.hasRemotes){if(0===this.state.remoteSourcePublishers.length)return;return{command:this.state.isCheckoutRunning||this.state.isCommitRunning?"":"git.publish",title:"$(cloud-upload)",tooltip:this.state.isCheckoutRunning?r.l10n.t("Checking Out Changes..."):this.state.isCommitRunning?r.l10n.t("Committing Changes..."):1===this.state.remoteSourcePublishers.length?r.l10n.t("Publish to {0}",this.state.remoteSourcePublishers[0].name):r.l10n.t("Publish to..."),arguments:[this.repository.sourceControl]}}const e=this.state.HEAD;let t="$(sync)",i="",o="",n="";return e&&e.name&&e.commit?e.upstream?((e.ahead||e.behind)&&(i+=this.repository.syncLabel),o="git.sync",n=this.repository.syncTooltip):(t="$(cloud-upload)",o="git.publish",n=r.l10n.t("Publish Branch")):(o="",n=""),this.state.isCheckoutRunning&&(o="",n=r.l10n.t("Checking Out Changes...")),this.state.isCommitRunning&&(o="",n=r.l10n.t("Committing Changes...")),this.state.isSyncRunning&&(t="$(sync~spin)",o="",n=r.l10n.t("Synchronizing Changes...")),{command:o,title:[t,i].join(" ").trim(),tooltip:n,arguments:[this.repository.sourceControl]}}dispose(){this.disposables.forEach(e=>e.dispose())}}t.StatusBarCommands=class{constructor(e,t){this.disposables=[],this.syncStatusBar=new s(e,t),this.checkoutStatusBar=new n(e),this.onDidChange=(0,o.anyEvent)(this.syncStatusBar.onDidChange,this.checkoutStatusBar.onDidChange)}get commands(){return[this.checkoutStatusBar.command,this.syncStatusBar.command].filter(e=>!!e)}dispose(){this.syncStatusBar.dispose(),this.checkoutStatusBar.dispose(),this.disposables=(0,o.dispose)(this.disposables)}}},1991:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ActionButton=void 0;const r=i(1398),o=i(7937);t.ActionButton=class{get onDidChange(){return this._onDidChange.event}get state(){return this._state}set state(e){var t,i;t=this._state,i=e,(t.HEAD?.name!==i.HEAD?.name||t.HEAD?.commit!==i.HEAD?.commit||t.HEAD?.remote!==i.HEAD?.remote||t.HEAD?.type!==i.HEAD?.type||t.HEAD?.ahead!==i.HEAD?.ahead||t.HEAD?.behind!==i.HEAD?.behind||t.HEAD?.upstream?.name!==i.HEAD?.upstream?.name||t.HEAD?.upstream?.remote!==i.HEAD?.upstream?.remote||t.HEAD?.upstream?.commit!==i.HEAD?.upstream?.commit||t.isCheckoutInProgress!==i.isCheckoutInProgress||t.isCommitInProgress!==i.isCommitInProgress||t.isMergeInProgress!==i.isMergeInProgress||t.isRebaseInProgress!==i.isRebaseInProgress||t.isSyncInProgress!==i.isSyncInProgress||t.repositoryHasChangesToCommit!==i.repositoryHasChangesToCommit||t.repositoryHasUnresolvedConflicts!==i.repositoryHasUnresolvedConflicts)&&(this.logger.trace(`[ActionButton][setState] ${JSON.stringify(e)}`),this._state=e,this._onDidChange.fire())}constructor(e,t,i){this.repository=e,this.postCommitCommandCenter=t,this.logger=i,this._onDidChange=new r.EventEmitter,this.disposables=[],this._state={HEAD:void 0,isCheckoutInProgress:!1,isCommitInProgress:!1,isMergeInProgress:!1,isRebaseInProgress:!1,isSyncInProgress:!1,repositoryHasChangesToCommit:!1,repositoryHasUnresolvedConflicts:!1},e.onDidRunGitStatus(this.onDidRunGitStatus,this,this.disposables),e.onDidChangeOperations(this.onDidChangeOperations,this,this.disposables),this.disposables.push(e.onDidChangeBranchProtection(()=>this._onDidChange.fire())),this.disposables.push(t.onDidChange(()=>this._onDidChange.fire()));const o=r.Uri.file(e.root);this.disposables.push(r.workspace.onDidChangeConfiguration(e=>{(e.affectsConfiguration("git.enableSmartCommit",o)||e.affectsConfiguration("git.smartCommitChanges",o)||e.affectsConfiguration("git.suggestSmartCommit",o))&&this.onDidChangeSmartCommitSettings(),(e.affectsConfiguration("git.branchProtectionPrompt",o)||e.affectsConfiguration("git.postCommitCommand",o)||e.affectsConfiguration("git.rememberPostCommitCommand",o)||e.affectsConfiguration("git.showActionButton",o))&&this._onDidChange.fire()}))}get button(){if(!this.state.HEAD)return;let e;return this.state.repositoryHasChangesToCommit&&(e=this.getCommitActionButton()),e=e??this.getPublishBranchActionButton()??this.getSyncChangesActionButton()??this.getCommitActionButton(),this.logger.trace(`[ActionButton][getButton] ${JSON.stringify({command:e?.command.command,title:e?.command.title,enabled:e?.enabled})}`),e}getCommitActionButton(){if(r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)).get("showActionButton",{commit:!0}).commit)return{command:this.getCommitActionButtonPrimaryCommand(),secondaryCommands:this.getCommitActionButtonSecondaryCommands(),enabled:(this.state.repositoryHasChangesToCommit||this.state.isRebaseInProgress&&!this.state.repositoryHasUnresolvedConflicts||this.state.isMergeInProgress&&!this.state.repositoryHasUnresolvedConflicts)&&!this.state.isCommitInProgress}}getCommitActionButtonPrimaryCommand(){return this.state.isRebaseInProgress?{command:"git.commit",title:r.l10n.t("{0} Continue","$(check)"),tooltip:this.state.isCommitInProgress?r.l10n.t("Continuing Rebase..."):r.l10n.t("Continue Rebase"),arguments:[this.repository.sourceControl,null]}:this.state.isMergeInProgress?{command:"git.commit",title:r.l10n.t("{0} Continue","$(check)"),tooltip:this.state.isCommitInProgress?r.l10n.t("Continuing Merge..."):r.l10n.t("Continue Merge"),arguments:[this.repository.sourceControl,null]}:2!==this.state.HEAD?.type&&this.state.HEAD?.name?this.postCommitCommandCenter.getPrimaryCommand():{command:"git.commit",title:r.l10n.t("{0} Commit","$(check)"),tooltip:this.state.isCommitInProgress?r.l10n.t("Committing Changes..."):r.l10n.t("Commit Changes"),arguments:[this.repository.sourceControl,null]}}getCommitActionButtonSecondaryCommands(){if(this.state.isRebaseInProgress)return[];if(this.state.isMergeInProgress)return[];if(2===this.state.HEAD?.type||!this.state.HEAD?.name)return[];const e=[];for(const t of this.postCommitCommandCenter.getSecondaryCommands())e.push(t.map(e=>({command:e.command,title:e.title,tooltip:e.tooltip,arguments:e.arguments})));return e}getPublishBranchActionButton(){const e=r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)).get("showActionButton",{publish:!0});if(2===this.state.HEAD?.type||!this.state.HEAD?.name||this.state.HEAD?.upstream||this.state.isCommitInProgress||this.state.isMergeInProgress||this.state.isRebaseInProgress||!e.publish)return;const t=this.state.isSyncInProgress?"$(sync~spin)":"$(cloud-upload)";return{command:{command:"git.publish",title:r.l10n.t({message:"{0} Publish Branch",args:[t],comment:['{Locked="Branch"}','Do not translate "Branch" as it is a git term']}),tooltip:this.state.isSyncInProgress?this.state.HEAD?.name?r.l10n.t({message:'Publishing Branch "{0}"...',args:[this.state.HEAD.name],comment:['{Locked="Branch"}','Do not translate "Branch" as it is a git term']}):r.l10n.t({message:"Publishing Branch...",comment:['{Locked="Branch"}','Do not translate "Branch" as it is a git term']}):this.repository.HEAD?.name?r.l10n.t({message:'Publish Branch "{0}"',args:[this.state.HEAD?.name],comment:['{Locked="Branch"}','Do not translate "Branch" as it is a git term']}):r.l10n.t({message:"Publish Branch",comment:['{Locked="Branch"}','Do not translate "Branch" as it is a git term']}),arguments:[this.repository.sourceControl]},enabled:!this.state.isCheckoutInProgress&&!this.state.isSyncInProgress}}getSyncChangesActionButton(){const e=r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)).get("showActionButton",{sync:!0}),t=(this.state.HEAD?.behind??0)>0||(this.state.HEAD?.ahead??0)>0;if(!this.state.HEAD?.upstream||!t||this.state.isCommitInProgress||this.state.isMergeInProgress||this.state.isRebaseInProgress||!e.sync)return;const i=this.state.HEAD.ahead?` ${this.state.HEAD.ahead}$(arrow-up)`:"",o=this.state.HEAD.behind?` ${this.state.HEAD.behind}$(arrow-down)`:"",n=this.state.isSyncInProgress?"$(sync~spin)":"$(sync)";return{command:{command:"git.sync",title:r.l10n.t("{0} Sync Changes{1}{2}",n,o,i),shortTitle:`${n}${o}${i}`,tooltip:this.state.isSyncInProgress?r.l10n.t("Synchronizing Changes..."):this.repository.syncTooltip,arguments:[this.repository.sourceControl]},enabled:!this.state.isCheckoutInProgress&&!this.state.isSyncInProgress}}onDidChangeOperations(){const e=this.repository.operations.isRunning("Checkout")||this.repository.operations.isRunning("CheckoutTracking"),t=this.repository.operations.isRunning("Commit")||this.repository.operations.isRunning("PostCommitCommand")||this.repository.operations.isRunning("RebaseContinue"),i=this.repository.operations.isRunning("Sync")||this.repository.operations.isRunning("Push")||this.repository.operations.isRunning("Pull");this.state={...this.state,isCheckoutInProgress:e,isCommitInProgress:t,isSyncInProgress:i}}onDidChangeSmartCommitSettings(){this.state={...this.state,repositoryHasChangesToCommit:this.repositoryHasChangesToCommit()}}onDidRunGitStatus(){this.state={...this.state,HEAD:this.repository.HEAD,isMergeInProgress:this.repository.mergeInProgress,isRebaseInProgress:!!this.repository.rebaseCommit,repositoryHasChangesToCommit:this.repositoryHasChangesToCommit(),repositoryHasUnresolvedConflicts:this.repository.mergeGroup.resourceStates.length>0}}repositoryHasChangesToCommit(){const e=r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)),t=!0===e.get("enableSmartCommit"),i=!0===e.get("suggestSmartCommit"),o=e.get("smartCommitChanges","all"),n=[...this.repository.indexGroup.resourceStates];return(t&&"all"===o||!t&&i)&&n.push(...this.repository.workingTreeGroup.resourceStates),t&&"tracked"===o&&n.push(...this.repository.workingTreeGroup.resourceStates.filter(e=>7!==e.type)),0!==n.length}dispose(){this.disposables=(0,o.dispose)(this.disposables)}}},2203:e=>{"use strict";e.exports=require("stream")},2228:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.GitEditorDocumentLinkProvider=t.GitEditor=void 0;const a=s(i(6928)),l=i(1398),c=i(7937);t.GitEditor=class{constructor(e){this.disposable=c.EmptyDisposable,this.featureDescription="git editor",e&&(this.disposable=e.registerHandler("git-editor",this)),this.env={GIT_EDITOR:`"${a.join(__dirname,e?"git-editor.sh":"git-editor-empty.sh")}"`,VSCODE_GIT_EDITOR_NODE:process.execPath,VSCODE_GIT_EDITOR_EXTRA_ARGS:"",VSCODE_GIT_EDITOR_MAIN:a.join(__dirname,"git-editor-main.js")}}async handle({commitMessagePath:e}){if(e){const t=l.Uri.file(e),i=await l.workspace.openTextDocument(t);return await l.window.showTextDocument(i,{preview:!1}),new Promise(e=>{const i=l.window.tabGroups.onDidChangeTabs(async r=>{if(r.closed.some(e=>e.input instanceof l.TabInputText&&e.input.uri.toString()===t.toString()))return i.dispose(),e(!0)})})}}getEnv(){return l.workspace.getConfiguration("git").get("useEditorAsCommitInput")?this.env:{}}getTerminalEnv(){const e=l.workspace.getConfiguration("git");return e.get("useEditorAsCommitInput")&&e.get("terminalGitEditor")?this.env:{}}dispose(){this.disposable.dispose()}},t.GitEditorDocumentLinkProvider=class{constructor(e){this._model=e,this._regex=/^#\s+(modified|new file|deleted|renamed|copied|type change):\s+(?<file1>.*?)(?:\s+->\s+(?<file2>.*))*$/gm}provideDocumentLinks(e,t){if(t.isCancellationRequested)return[];const i=this._model.getRepository(e.uri);if(!i)return[];const r=[];for(const t of e.getText().matchAll(this._regex)){if(!t.groups)continue;const{file1:o,file2:n}=t.groups;o&&r.push(this._createDocumentLink(i,e,t,o)),n&&r.push(this._createDocumentLink(i,e,t,n))}return r}_createDocumentLink(e,t,i,r){const o=i[0].indexOf(r),n=t.positionAt(i.index+o),s=t.positionAt(i.index+o+r.length),c=new l.DocumentLink(new l.Range(n,s),l.Uri.file(a.join(e.root,r)));return c.tooltip=l.l10n.t("Open File"),c}}},2608:(e,t,i)=>{"use strict";const r=i(280),{CHAR_ASTERISK:o,CHAR_AT:n,CHAR_BACKWARD_SLASH:s,CHAR_COMMA:a,CHAR_DOT:l,CHAR_EXCLAMATION_MARK:c,CHAR_FORWARD_SLASH:h,CHAR_LEFT_CURLY_BRACE:u,CHAR_LEFT_PARENTHESES:d,CHAR_LEFT_SQUARE_BRACKET:p,CHAR_PLUS:m,CHAR_QUESTION_MARK:g,CHAR_RIGHT_CURLY_BRACE:f,CHAR_RIGHT_PARENTHESES:y,CHAR_RIGHT_SQUARE_BRACKET:w}=i(3940),b=e=>e===h||e===s,C=e=>{!0!==e.isPrefix&&(e.depth=e.isGlobstar?1/0:1)};e.exports=(e,t)=>{const i=t||{},v=e.length-1,k=!0===i.parts||!0===i.scanToEnd,R=[],E=[],S=[];let D,A,_=e,P=-1,x=0,T=0,M=!1,I=!1,B=!1,O=!1,L=!1,G=!1,H=!1,$=!1,N=!1,U=!1,F=0,W={value:"",depth:0,isGlob:!1};const j=()=>P>=v,K=()=>_.charCodeAt(P+1),J=()=>(D=A,_.charCodeAt(++P));for(;P<v;){let e;if(A=J(),A!==s){if(!0===G||A===u){for(F++;!0!==j()&&(A=J());)if(A!==s)if(A!==u){if(!0!==G&&A===l&&(A=J())===l){if(M=W.isBrace=!0,B=W.isGlob=!0,U=!0,!0===k)continue;break}if(!0!==G&&A===a){if(M=W.isBrace=!0,B=W.isGlob=!0,U=!0,!0===k)continue;break}if(A===f&&(F--,0===F)){G=!1,M=W.isBrace=!0,U=!0;break}}else F++;else H=W.backslashes=!0,J();if(!0===k)continue;break}if(A!==h){if(!0!==i.noext&&!0==(A===m||A===n||A===o||A===g||A===c)&&K()===d){if(B=W.isGlob=!0,O=W.isExtglob=!0,U=!0,A===c&&P===x&&(N=!0),!0===k){for(;!0!==j()&&(A=J());)if(A!==s){if(A===y){B=W.isGlob=!0,U=!0;break}}else H=W.backslashes=!0,A=J();continue}break}if(A===o){if(D===o&&(L=W.isGlobstar=!0),B=W.isGlob=!0,U=!0,!0===k)continue;break}if(A===g){if(B=W.isGlob=!0,U=!0,!0===k)continue;break}if(A===p){for(;!0!==j()&&(e=J());)if(e!==s){if(e===w){I=W.isBracket=!0,B=W.isGlob=!0,U=!0;break}}else H=W.backslashes=!0,J();if(!0===k)continue;break}if(!0===i.nonegate||A!==c||P!==x){if(!0!==i.noparen&&A===d){if(B=W.isGlob=!0,!0===k){for(;!0!==j()&&(A=J());)if(A!==d){if(A===y){U=!0;break}}else H=W.backslashes=!0,A=J();continue}break}if(!0===B){if(U=!0,!0===k)continue;break}}else $=W.negated=!0,x++}else{if(R.push(P),E.push(W),W={value:"",depth:0,isGlob:!1},!0===U)continue;if(D===l&&P===x+1){x+=2;continue}T=P+1}}else H=W.backslashes=!0,A=J(),A===u&&(G=!0)}!0===i.noext&&(O=!1,B=!1);let z=_,V="",q="";x>0&&(V=_.slice(0,x),_=_.slice(x),T-=x),z&&!0===B&&T>0?(z=_.slice(0,T),q=_.slice(T)):!0===B?(z="",q=_):z=_,z&&""!==z&&"/"!==z&&z!==_&&b(z.charCodeAt(z.length-1))&&(z=z.slice(0,-1)),!0===i.unescape&&(q&&(q=r.removeBackslashes(q)),z&&!0===H&&(z=r.removeBackslashes(z)));const Y={prefix:V,input:e,start:x,base:z,glob:q,isBrace:M,isBracket:I,isGlob:B,isExtglob:O,isGlobstar:L,negated:$,negatedExtglob:N};if(!0===i.tokens&&(Y.maxDepth=0,b(A)||E.push(W),Y.tokens=E),!0===i.parts||!0===i.tokens){let t;for(let r=0;r<R.length;r++){const o=t?t+1:x,n=R[r],s=e.slice(o,n);i.tokens&&(0===r&&0!==x?(E[r].isPrefix=!0,E[r].value=V):E[r].value=s,C(E[r]),Y.maxDepth+=E[r].depth),0===r&&""===s||S.push(s),t=n}if(t&&t+1<e.length){const r=e.slice(t+1);S.push(r),i.tokens&&(E[E.length-1].value=r,C(E[E.length-1]),Y.maxDepth+=E[E.length-1].depth)}Y.slashes=R,Y.parts=S}return Y}},2672:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__decorate||function(e,t,i,r){var o,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,i):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,r);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(n<3?o(s):n>3?o(t,i,s):o(t,i))||s);return n>3&&s&&Object.defineProperty(t,i,s),s},a=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.Model=void 0;const l=i(1398),c=i(7681),h=i(4399),u=i(7937),d=a(i(6928)),p=a(i(9896)),m=i(4847),g=i(6199);class f{get label(){return d.basename(this.repository.root)}get description(){return[this.repository.headLabel,this.repository.syncLabel].filter(e=>!!e).join(" ")}get iconPath(){switch(this.repository.kind){case"submodule":return new l.ThemeIcon("archive");case"worktree":return new l.ThemeIcon("list-tree");default:return new l.ThemeIcon("repo")}}constructor(e,t){this.repository=e,this.index=t}}s([h.memoize],f.prototype,"label",null),s([h.memoize],f.prototype,"description",null),s([h.memoize],f.prototype,"iconPath",null);class y{get repositories(){return[...this._repositories.values()]}constructor(e){this.workspaceState=e,this._repositories=new Set(e.get("closedRepositories",[])),this.onDidChangeRepositories()}addRepository(e){this._repositories.add(e),this.onDidChangeRepositories()}deleteRepository(e){const t=this._repositories.delete(e);return t&&this.onDidChangeRepositories(),t}isRepositoryClosed(e){return this._repositories.has(e)}onDidChangeRepositories(){this.workspaceState.update("closedRepositories",[...this._repositories.values()]),l.commands.executeCommand("setContext","git.closedRepositoryCount",this._repositories.size)}}class w{get repositories(){return[...this._repositories.values()]}constructor(e){this.globalState=e,this._repositories=new Set,this.onDidChangeRepositories()}addRepository(e){this._repositories.add(e),this.onDidChangeRepositories()}deleteRepository(e){const t=this._repositories.delete(e);return t&&this.onDidChangeRepositories(),t}hasRepository(e){return this._repositories.has(e)}openRepository(e){this.globalState.update(`parentRepository:${e}`,!0),this.deleteRepository(e)}onDidChangeRepositories(){l.commands.executeCommand("setContext","git.parentRepositoryCount",this._repositories.size)}}class b{get repositories(){return[...this._repositories.keys()]}constructor(){this._repositories=new Map,this.onDidChangeRepositories()}addRepository(e,t){this._repositories.set(e,t),this.onDidChangeRepositories()}deleteRepository(e){const t=this._repositories.delete(e);return t&&this.onDidChangeRepositories(),t}getRepositoryPath(e){return this._repositories.get(e)}hasRepository(e){return this._repositories.has(e)}onDidChangeRepositories(){l.commands.executeCommand("setContext","git.unsafeRepositoryCount",this._repositories.size)}}class C{get repositories(){return this.openRepositories.map(e=>e.repository)}firePublishEvent(e,t){this._onDidPublish.fire({repository:new g.ApiRepository(e),branch:t})}get state(){return this._state}setState(e){this._state=e,this._onDidChangeState.fire(e),l.commands.executeCommand("setContext","git.state",e)}get isInitialized(){return"initialized"===this._state?Promise.resolve():(0,u.eventToPromise)((0,u.filterEvent)(this.onDidChangeState,e=>"initialized"===e))}get unsafeRepositories(){return this._unsafeRepositoriesManager.repositories}get parentRepositories(){return this._parentRepositoriesManager.repositories}get closedRepositories(){return[...this._closedRepositoriesManager.repositories]}constructor(e,t,i,r,o){this.git=e,this.askpass=t,this.globalState=i,this.workspaceState=r,this.logger=o,this._onDidOpenRepository=new l.EventEmitter,this.onDidOpenRepository=this._onDidOpenRepository.event,this._onDidCloseRepository=new l.EventEmitter,this.onDidCloseRepository=this._onDidCloseRepository.event,this._onDidChangeRepository=new l.EventEmitter,this.onDidChangeRepository=this._onDidChangeRepository.event,this._onDidChangeOriginalResource=new l.EventEmitter,this.onDidChangeOriginalResource=this._onDidChangeOriginalResource.event,this.openRepositories=[],this.possibleGitRepositoryPaths=new Set,this._onDidChangeState=new l.EventEmitter,this.onDidChangeState=this._onDidChangeState.event,this._onDidPublish=new l.EventEmitter,this.onDidPublish=this._onDidPublish.event,this._state="uninitialized",this.remoteSourcePublishers=new Set,this._onDidAddRemoteSourcePublisher=new l.EventEmitter,this.onDidAddRemoteSourcePublisher=this._onDidAddRemoteSourcePublisher.event,this._onDidRemoveRemoteSourcePublisher=new l.EventEmitter,this.onDidRemoveRemoteSourcePublisher=this._onDidRemoveRemoteSourcePublisher.event,this.postCommitCommandsProviders=new Set,this._onDidChangePostCommitCommandsProviders=new l.EventEmitter,this.onDidChangePostCommitCommandsProviders=this._onDidChangePostCommitCommandsProviders.event,this.branchProtectionProviders=new Map,this._onDidChangeBranchProtectionProviders=new l.EventEmitter,this.onDidChangeBranchProtectionProviders=this._onDidChangeBranchProtectionProviders.event,this.pushErrorHandlers=new Set,this.historyItemDetailsProviders=new Set,this._workspaceFolders=new Map,this.disposables=[],this._closedRepositoriesManager=new y(r),this._parentRepositoriesManager=new w(i),this._unsafeRepositoriesManager=new b,l.workspace.onDidChangeWorkspaceFolders(this.onDidChangeWorkspaceFolders,this,this.disposables),l.window.onDidChangeVisibleTextEditors(this.onDidChangeVisibleTextEditors,this,this.disposables),l.window.onDidChangeActiveTextEditor(this.onDidChangeActiveTextEditor,this,this.disposables),l.workspace.onDidChangeConfiguration(this.onDidChangeConfiguration,this,this.disposables);const n=l.workspace.createFileSystemWatcher("**");this.disposables.push(n);const s=(0,u.anyEvent)(n.onDidChange,n.onDidCreate,n.onDidDelete),a=(0,u.filterEvent)(s,e=>/\/\.git/.test(e.path));(0,u.filterEvent)(a,e=>!this.getRepository(e))(this.onPossibleGitRepositoryChange,this,this.disposables),this.setState("uninitialized"),this.doInitialScan().finally(()=>this.setState("initialized"))}async doInitialScan(){this.logger.info("[Model][doInitialScan] Initial repository scan started");const e=l.workspace.getConfiguration("git"),t=e.get("autoRepositoryDetection"),i=e.get("openRepositoryInParentFolders","prompt");this.logger.trace(`[Model][doInitialScan] Settings: autoRepositoryDetection=${t}, openRepositoryInParentFolders=${i}`);const r=()=>Promise.all([this.onDidChangeWorkspaceFolders({added:l.workspace.workspaceFolders||[],removed:[]}),this.onDidChangeVisibleTextEditors(l.window.visibleTextEditors),this.scanWorkspaceFolders()]);e.get("showProgress",!0)?await l.window.withProgress({location:l.ProgressLocation.SourceControl},r):await r(),0!==this.parentRepositories.length&&"prompt"===i?this.showParentRepositoryNotification():0!==this.unsafeRepositories.length&&this.showUnsafeRepositoryNotification(),this.logger.info(`[Model][doInitialScan] Initial repository scan completed - repositories (${this.repositories.length}), closed repositories (${this.closedRepositories.length}), parent repositories (${this.parentRepositories.length}), unsafe repositories (${this.unsafeRepositories.length})`)}async scanWorkspaceFolders(){try{const e=l.workspace.getConfiguration("git"),t=e.get("autoRepositoryDetection");if(!0!==t&&"subFolders"!==t)return;await Promise.all((l.workspace.workspaceFolders||[]).map(async t=>{const i=t.uri.fsPath;this.logger.trace(`[Model][scanWorkspaceFolders] Workspace folder: ${i}`);const r=(l.workspace.isTrusted?l.workspace.getConfiguration("git",t.uri):e).get("repositoryScanMaxDepth",1),o=(l.workspace.isTrusted?l.workspace.getConfiguration("git",t.uri):e).get("repositoryScanIgnoredFolders",[]),n=new Set(await this.traverseWorkspaceFolder(i,r,o)),s=(l.workspace.isTrusted?l.workspace.getConfiguration("git",t.uri):e).get("scanRepositories")||[];this.logger.trace(`[Model][scanWorkspaceFolders] Workspace scan settings: repositoryScanMaxDepth=${r}; repositoryScanIgnoredFolders=[${o.join(", ")}]; scanRepositories=[${s.join(", ")}]`);for(const e of s)if(".git"!==e){if(d.isAbsolute(e)){const e=l.l10n.t('Absolute paths not supported in "git.scanRepositories" setting.');this.logger.warn(`[Model][scanWorkspaceFolders] ${e}`),console.warn(e);continue}n.add(d.join(i,e))}else this.logger.trace("[Model][scanWorkspaceFolders] '.git' not supported in 'git.scanRepositories' setting.");this.logger.trace(`[Model][scanWorkspaceFolders] Workspace scan sub folders: [${[...n].join(", ")}]`),await Promise.all([...n].map(e=>this.openRepository(e)))}))}catch(e){this.logger.warn(`[Model][scanWorkspaceFolders] Error: ${e}`)}}async traverseWorkspaceFolder(e,t,i){const r=[],o=[{path:e,depth:0}];for(;o.length>0;){const e=o.shift(),n=[];try{n.push(...await p.promises.readdir(e.path,{withFileTypes:!0})),0!==e.depth&&r.push(e.path)}catch(t){this.logger.warn(`[Model][traverseWorkspaceFolder] Unable to read workspace folder '${e.path}': ${t}`);continue}if(e.depth<t||-1===t){const t=n.filter(e=>e.isDirectory()&&".git"!==e.name&&!i.find(t=>(0,u.pathEquals)(e.name,t))).map(t=>d.join(e.path,t.name));o.push(...t.map(t=>({path:t,depth:e.depth+1})))}}return r}onPossibleGitRepositoryChange(e){!1!==l.workspace.getConfiguration("git").get("autoRepositoryDetection")&&this.eventuallyScanPossibleGitRepository(e.fsPath.replace(/\.git.*$/,""))}eventuallyScanPossibleGitRepository(e){this.possibleGitRepositoryPaths.add(e),this.eventuallyScanPossibleGitRepositories()}eventuallyScanPossibleGitRepositories(){for(const e of this.possibleGitRepositoryPaths)this.openRepository(e,!1,!0);this.possibleGitRepositoryPaths.clear()}async onDidChangeWorkspaceFolders({added:e,removed:t}){try{const i=e.filter(e=>!this.getOpenRepository(e.uri)),r=l.window.visibleTextEditors.map(e=>this.getRepository(e.document.uri)).filter(e=>!!e),o=new Set(r);t.map(e=>this.getOpenRepository(e.uri)).filter(e=>!!e).filter(e=>!o.has(e.repository)).filter(e=>!(l.workspace.workspaceFolders||[]).some(t=>(0,u.isDescendant)(t.uri.fsPath,e.repository.root))).forEach(e=>e.dispose()),this.logger.trace(`[Model][onDidChangeWorkspaceFolders] Workspace folders: [${i.map(e=>e.uri.fsPath).join(", ")}]`),await Promise.all(i.map(e=>this.openRepository(e.uri.fsPath)))}catch(e){this.logger.warn(`[Model][onDidChangeWorkspaceFolders] Error: ${e}`)}}onDidChangeConfiguration(){const e=(l.workspace.workspaceFolders||[]).filter(e=>!0===l.workspace.getConfiguration("git",e.uri).get("enabled")).filter(e=>!this.getOpenRepository(e.uri)),t=this.openRepositories.map(e=>({repository:e,root:l.Uri.file(e.repository.root)})).filter(({root:e})=>!0!==l.workspace.getConfiguration("git",e).get("enabled")).map(({repository:e})=>e);this.logger.trace(`[Model][onDidChangeConfiguration] Workspace folders: [${e.map(e=>e.uri.fsPath).join(", ")}]`),e.forEach(e=>this.openRepository(e.uri.fsPath)),t.forEach(e=>e.dispose())}async onDidChangeVisibleTextEditors(e){try{if(!l.workspace.isTrusted)return void this.logger.trace("[Model][onDidChangeVisibleTextEditors] Workspace is not trusted.");const t=l.workspace.getConfiguration("git").get("autoRepositoryDetection");if(!0!==t&&"openEditors"!==t)return;await Promise.all(e.map(async e=>{const t=e.document.uri;if("file"!==t.scheme)return;const i=this.getRepository(t);i?this.logger.trace(`[Model][onDidChangeVisibleTextEditors] Repository for editor resource ${t.fsPath} already exists: ${i.root}`):(this.logger.trace(`[Model][onDidChangeVisibleTextEditors] Open repository for editor resource ${t.fsPath}`),await this.openRepository(d.dirname(t.fsPath)))}))}catch(e){this.logger.warn(`[Model][onDidChangeVisibleTextEditors] Error: ${e}`)}}onDidChangeActiveTextEditor(){const e=l.window.activeTextEditor;if(void 0===e)return l.commands.executeCommand("setContext","git.activeResourceHasUnstagedChanges",!1),void l.commands.executeCommand("setContext","git.activeResourceHasStagedChanges",!1);const t=this.getRepository(e.document.uri);if(!t)return l.commands.executeCommand("setContext","git.activeResourceHasUnstagedChanges",!1),void l.commands.executeCommand("setContext","git.activeResourceHasStagedChanges",!1);const i=t.indexGroup.resourceStates.find(t=>(0,u.pathEquals)(t.resourceUri.fsPath,e.document.uri.fsPath)),r=t.workingTreeGroup.resourceStates.find(t=>(0,u.pathEquals)(t.resourceUri.fsPath,e.document.uri.fsPath));l.commands.executeCommand("setContext","git.activeResourceHasStagedChanges",void 0!==i),l.commands.executeCommand("setContext","git.activeResourceHasUnstagedChanges",void 0!==r)}async openRepository(e,t=!1,i=!1){this.logger.trace(`[Model][openRepository] Repository: ${e}`);const r=await this.getRepositoryExact(e);if(r)return void this.logger.trace(`[Model][openRepository] Repository for path ${e} already exists: ${r.root}`);const o=l.workspace.getConfiguration("git",l.Uri.file(e));if(!0===o.get("enabled")){if(!l.workspace.isTrusted)try{p.accessSync(d.join(e,"HEAD"),p.constants.F_OK);const t=await this.git.exec(e,["-C",e,"rev-parse","--show-cdup"]);if(""===t.stderr.trim()&&""===t.stdout.trim())return void this.logger.trace(`[Model][openRepository] Bare repository: ${e}`)}catch{}try{const{repositoryRoot:r,unsafeRepositoryMatch:n}=await this.getRepositoryRoot(e);this.logger.trace(`[Model][openRepository] Repository root for path ${e} is: ${r}`);const s=await this.getRepositoryExact(r);if(s)return void this.logger.trace(`[Model][openRepository] Repository for path ${r} already exists: ${s.root}`);if(this.shouldRepositoryBeIgnored(r))return void this.logger.trace(`[Model][openRepository] Repository for path ${r} is ignored`);const a=o.get("openRepositoryInParentFolders","prompt");if("always"!==a&&!0!==this.globalState.get(`parentRepository:${r}`)){const e=await this.isRepositoryOutsideWorkspace(r);if(!i&&e)return this.logger.trace(`[Model][openRepository] Repository in parent folder: ${r}`),void(this._parentRepositoriesManager.hasRepository(r)||("initialized"===this.state&&"prompt"===a&&this.showParentRepositoryNotification(),this._parentRepositoriesManager.addRepository(r)))}if(n&&3===n.length)return this.logger.trace(`[Model][openRepository] Unsafe repository: ${r}`),"initialized"!==this._state||this._unsafeRepositoriesManager.hasRepository(r)||this.showUnsafeRepositoryNotification(),void this._unsafeRepositoriesManager.addRepository(r,n[2]);if(!t&&this._closedRepositoriesManager.isRepositoryClosed(r))return void this.logger.trace(`[Model][openRepository] Repository for path ${r} is closed`);const[l,h]=await Promise.all([this.git.getRepositoryDotGit(r),this.getRepositoryRootRealPath(r)]),u=this.git.open(r,h,l,this.logger),d=new c.Repository(u,this,this,this,this,this,this,this.globalState,this.logger);this.open(d),this._closedRepositoriesManager.deleteRepository(d.root),this.logger.info(`[Model][openRepository] Opened repository (path): ${d.root}`),this.logger.info(`[Model][openRepository] Opened repository (real path): ${d.rootRealPath??d.root}`),this.logger.info(`[Model][openRepository] Opened repository (kind): ${u.kind}`),d.status()}catch(t){this.logger.trace(`[Model][openRepository] Opening repository for path='${e}' failed. Error:${t}`)}}else this.logger.trace("[Model][openRepository] Git is not enabled")}async openParentRepository(e){this._parentRepositoriesManager.openRepository(e),await this.openRepository(e)}async getRepositoryRoot(e){try{const t=await this.git.getRepositoryRoot(e);return{repositoryRoot:l.Uri.file(t).fsPath,unsafeRepositoryMatch:null}}catch(e){const t=/^fatal: detected dubious ownership in repository at \'([^']+)\'[\s\S]*git config --global --add safe\.directory '?([^'\n]+)'?$/m.exec(e.stderr);if(t&&3===t.length)return{repositoryRoot:d.normalize(t[1]),unsafeRepositoryMatch:t};throw e}}async getRepositoryRootRealPath(e){try{const t=await p.promises.realpath(e);return(0,u.pathEquals)(e,t)?void 0:t}catch(t){return void this.logger.warn(`[Model][getRepositoryRootRealPath] Failed to get repository realpath for "${e}": ${t}`)}}shouldRepositoryBeIgnored(e){const t=l.workspace.getConfiguration("git").get("ignoredRepositories")||[];for(const i of t)if(d.isAbsolute(i)){if((0,u.pathEquals)(i,e))return!0}else for(const t of l.workspace.workspaceFolders||[])if((0,u.pathEquals)(d.join(t.uri.fsPath,i),e))return!0;return!1}open(e){this.logger.trace(`[Model][open] Repository: ${e.root}`);const t=(0,u.filterEvent)(e.onDidChangeState,e=>1===e)(()=>w()),i=e.sourceControl.onDidDisposeParent(()=>w()),r=e.onDidChangeRepository(t=>this._onDidChangeRepository.fire({repository:e,uri:t})),o=e.onDidChangeOriginalResource(t=>this._onDidChangeOriginalResource.fire({repository:e,uri:t})),n=l.workspace.getConfiguration("git",l.Uri.file(e.root)).get("detectSubmodules"),s=l.workspace.getConfiguration("git",l.Uri.file(e.root)).get("detectSubmodulesLimit"),a=l.workspace.getConfiguration("git",l.Uri.file(e.root)).get("detectWorktrees"),c=l.workspace.getConfiguration("git",l.Uri.file(e.root)).get("detectWorktreesLimit"),h=()=>{n?(e.submodules.length>s&&(l.window.showWarningMessage(l.l10n.t('The "{0}" repository has {1} submodules which won\'t be opened automatically. You can still open each one individually by opening a file within.',d.basename(e.root),e.submodules.length)),g.dispose()),e.submodules.slice(0,s).map(t=>d.join(e.root,t.path)).forEach(e=>{this.logger.trace(`[Model][open] Opening submodule: '${e}'`),this.eventuallyScanPossibleGitRepository(e)})):this.logger.trace("[Model][open] Automatic detection of git submodules is not enabled.")},p=()=>{a?"worktree"!==e.kind?(e.worktrees.length>c&&(l.window.showWarningMessage(l.l10n.t('The "{0}" repository has {1} worktrees which won\'t be opened automatically. You can still open each one individually by opening a file within.',d.basename(e.root),e.worktrees.length)),g.dispose()),e.worktrees.slice(0,c).forEach(e=>{this.logger.trace(`[Model][open] Opening worktree: '${e.path}'`),this.eventuallyScanPossibleGitRepository(e.path)})):this.logger.trace("[Model][open] Automatic detection of git worktrees is not skipped."):this.logger.trace("[Model][open] Automatic detection of git worktrees is not enabled.")},m=()=>{const e=[];for(const{repository:t}of this.openRepositories.values())for(const i of t.mergeGroup.resourceStates)e.push(i.resourceUri);l.commands.executeCommand("setContext","git.mergeChanges",e)},g=e.onDidRunGitStatus(()=>{h(),p(),m(),this.onDidChangeActiveTextEditor()});h(),p(),this.onDidChangeActiveTextEditor();const f=()=>{let e=!1;for(const{repository:t}of this.openRepositories.values())t.operations.shouldDisableCommands()&&(e=!0);l.commands.executeCommand("setContext","operationInProgress",e)},y=(0,u.anyEvent)(e.onDidRunOperation,e.onRunOperation)(()=>f());f();const w=()=>{t.dispose(),i.dispose(),r.dispose(),o.dispose(),g.dispose(),y.dispose(),e.dispose(),this.openRepositories=this.openRepositories.filter(e=>e!==b),this._onDidCloseRepository.fire(e)},b={repository:e,dispose:w};this.openRepositories.push(b),m(),this._onDidOpenRepository.fire(e)}close(e){const t=this.getOpenRepository(e);t&&(this.logger.info(`[Model][close] Repository: ${e.root}`),this._closedRepositoriesManager.addRepository(t.repository.root),t.dispose())}async pickRepository(e){if(0===this.openRepositories.length)throw new Error(l.l10n.t("There are no available repositories"));const t=this.openRepositories.filter(t=>!e||e.includes(t.repository.kind));if(0===t.length)throw new Error(l.l10n.t("There are no available repositories matching the filter"));if(1===t.length)return t[0].repository;const i=l.window.activeTextEditor,r=t.map((e,t)=>new f(e.repository,t)),o=i&&this.getRepository(i.document.fileName),n=r.findIndex(e=>e.repository===o);n>-1&&r.unshift(...r.splice(n,1));const s=l.l10n.t("Choose a repository"),a=await l.window.showQuickPick(r,{placeHolder:s});return a&&a.repository}getRepository(e){const t=this.getOpenRepository(e);return t&&t.repository}async getRepositoryExact(e){const t=this.openRepositories.find(t=>(0,u.pathEquals)(t.repository.root,e));if(t)return t.repository;try{const t=await p.promises.realpath(e,{encoding:"utf8"}),i=this.openRepositories.find(e=>(0,u.pathEquals)(e.repository.rootRealPath??e.repository.root,t));return i?.repository}catch(t){return void this.logger.warn(`[Model][getRepositoryExact] Failed to get repository realpath for: "${e}". Error:${t}`)}}getOpenRepository(e){if(e){if(e instanceof c.Repository)return this.openRepositories.filter(t=>t.repository===e)[0];if(e instanceof g.ApiRepository&&(e=e.rootUri),"string"==typeof e&&(e=l.Uri.file(e)),e instanceof l.Uri){let t;t="git"===e.scheme?(0,m.fromGitUri)(e).path:e.fsPath;e:for(const e of this.openRepositories.sort((e,t)=>t.repository.root.length-e.repository.root.length))if((0,u.isDescendant)(e.repository.root,t)){for(const i of e.repository.submodules){const r=d.join(e.repository.root,i.path);if((0,u.isDescendant)(r,t))continue e}return e}return}for(const t of this.openRepositories){const i=t.repository;if(e===i.sourceControl)return t;if(e===i.mergeGroup||e===i.indexGroup||e===i.workingTreeGroup||e===i.untrackedGroup)return t}}}getRepositoryForSubmodule(e){for(const t of this.repositories)for(const i of t.submodules)if(d.join(t.root,i.path)===e.fsPath)return t}registerRemoteSourcePublisher(e){return this.remoteSourcePublishers.add(e),this._onDidAddRemoteSourcePublisher.fire(e),(0,u.toDisposable)(()=>{this.remoteSourcePublishers.delete(e),this._onDidRemoveRemoteSourcePublisher.fire(e)})}getRemoteSourcePublishers(){return[...this.remoteSourcePublishers.values()]}registerBranchProtectionProvider(e,t){const i=[];return this.branchProtectionProviders.set(e.toString(),(this.branchProtectionProviders.get(e.toString())??new Set).add(t)),i.push(t.onDidChangeBranchProtection(e=>this._onDidChangeBranchProtectionProviders.fire(e))),this._onDidChangeBranchProtectionProviders.fire(e),(0,u.toDisposable)(()=>{const r=this.branchProtectionProviders.get(e.toString());r&&r.has(t)&&(r.delete(t),this.branchProtectionProviders.set(e.toString(),r),this._onDidChangeBranchProtectionProviders.fire(e)),(0,u.dispose)(i)})}getBranchProtectionProviders(e){return[...(this.branchProtectionProviders.get(e.toString())??new Set).values()]}registerPostCommitCommandsProvider(e){return this.postCommitCommandsProviders.add(e),this._onDidChangePostCommitCommandsProviders.fire(),(0,u.toDisposable)(()=>{this.postCommitCommandsProviders.delete(e),this._onDidChangePostCommitCommandsProviders.fire()})}getPostCommitCommandsProviders(){return[...this.postCommitCommandsProviders.values()]}registerCredentialsProvider(e){return this.askpass.registerCredentialsProvider(e)}registerPushErrorHandler(e){return this.pushErrorHandlers.add(e),(0,u.toDisposable)(()=>this.pushErrorHandlers.delete(e))}getPushErrorHandlers(){return[...this.pushErrorHandlers]}registerSourceControlHistoryItemDetailsProvider(e){return this.historyItemDetailsProviders.add(e),(0,u.toDisposable)(()=>this.historyItemDetailsProviders.delete(e))}getSourceControlHistoryItemDetailsProviders(){return[...this.historyItemDetailsProviders]}getUnsafeRepositoryPath(e){return this._unsafeRepositoriesManager.getRepositoryPath(e)}deleteUnsafeRepository(e){return this._unsafeRepositoriesManager.deleteRepository(e)}async isRepositoryOutsideWorkspace(e){const t=(l.workspace.workspaceFolders||[]).filter(e=>"file"===e.uri.scheme);if(0===t.length)return!0;const i=new Set([...t.map(e=>e.uri.fsPath),...await Promise.all(t.map(e=>this.getWorkspaceFolderRealPath(e)))]);return!Array.from(i).some(t=>t&&((0,u.pathEquals)(t,e)||(0,u.isDescendant)(t,e)))}async getWorkspaceFolderRealPath(e){let t=this._workspaceFolders.get(e.uri.fsPath);if(!t)try{t=await p.promises.realpath(e.uri.fsPath,{encoding:"utf8"}),this._workspaceFolders.set(e.uri.fsPath,t)}catch(t){this.logger.trace(`[Model][getWorkspaceFolderRealPath] Failed to resolve workspace folder "${e.uri.fsPath}". Error:${t}`)}return t}async showParentRepositoryNotification(){const e=1===this.parentRepositories.length?l.l10n.t("A git repository was found in the parent folders of the workspace or the open file(s). Would you like to open the repository?"):l.l10n.t("Git repositories were found in the parent folders of the workspace or the open file(s). Would you like to open the repositories?"),t=l.l10n.t("Yes"),i=l.l10n.t("Always"),r=l.l10n.t("Never"),o=await l.window.showInformationMessage(e,t,i,r);if(o===t)l.commands.executeCommand("git.openRepositoriesInParentFolders");else if(o===i||o===r){const e=l.workspace.getConfiguration("git");if(await e.update("openRepositoryInParentFolders",o===i?"always":"never",!0),o===i)for(const e of this.parentRepositories)await this.openParentRepository(e)}}async showUnsafeRepositoryNotification(){if(0===this.repositories.length)return;const e=1===this.unsafeRepositories.length?l.l10n.t("The git repository in the current folder is potentially unsafe as the folder is owned by someone other than the current user."):l.l10n.t("The git repositories in the current folder are potentially unsafe as the folders are owned by someone other than the current user."),t=l.l10n.t("Manage Unsafe Repositories"),i=l.l10n.t("Learn More"),r=await l.window.showErrorMessage(e,t,i);r===t?l.commands.executeCommand("git.manageUnsafeRepositories"):r===i&&l.commands.executeCommand("vscode.open",l.Uri.parse("https://aka.ms/vscode-git-unsafe-repository"))}disposeRepository(e){const t=this.getOpenRepository(e);t&&(this.logger.info(`[Model][disposeRepository] Repository: ${e.root}`),t.dispose())}dispose(){[...this.openRepositories].forEach(e=>e.dispose()),this.openRepositories=[],this.possibleGitRepositoryPaths.clear(),this.disposables=(0,u.dispose)(this.disposables)}}t.Model=C,s([h.memoize],C.prototype,"isInitialized",null),s([(0,h.debounce)(500)],C.prototype,"eventuallyScanPossibleGitRepositories",null),s([h.sequentialize],C.prototype,"openRepository",null)},2772:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.applyLineChanges=function(e,t,i){const o=[];let n=0;for(const s of i){const i=0===s.originalEndLineNumber,a=0===s.modifiedEndLineNumber;let l=i?s.originalStartLineNumber:s.originalStartLineNumber-1,c=0;if(a&&s.originalEndLineNumber===e.lineCount&&(l-=1,c=e.lineAt(l).range.end.character),o.push(e.getText(new r.Range(n,0,l,c))),!a){let n=s.modifiedStartLineNumber-1,a=0;i&&s.originalStartLineNumber===e.lineCount&&(n-=1,a=t.lineAt(n).range.end.character),o.push(t.getText(new r.Range(n,a,s.modifiedEndLineNumber,0)))}n=i?s.originalStartLineNumber:s.originalEndLineNumber}return o.push(e.getText(new r.Range(n,0,e.lineCount,0))),o.join("")},t.toLineRanges=function(e,t){const i=e.map(e=>{const i=t.lineAt(e.start.line),o=t.lineAt(e.end.line);return new r.Range(i.range.start,o.range.end)});i.sort((e,t)=>e.start.line-t.start.line);const o=i.reduce((e,t)=>{if(0===e.length)return e.push(t),e;const[i,...o]=e,n=t.intersection(i);return n?[n,...o]:t.start.line===i.end.line+1?[new r.Range(i.start,t.end),...o]:[t,...e]},[]);return o.reverse(),o},t.getModifiedRange=n,t.intersectDiffWithRange=function(e,t,i){const r=n(e,t),o=i.intersection(r);if(!o)return null;if(0===t.modifiedEndLineNumber)return t;{const e=o.start.line+1,i=o.end.line+1;if(t.originalEndLineNumber-t.originalStartLineNumber===t.modifiedEndLineNumber-t.modifiedStartLineNumber){const r=e-t.modifiedStartLineNumber,o=i-e;return{originalStartLineNumber:t.originalStartLineNumber+r,originalEndLineNumber:t.originalStartLineNumber+r+o,modifiedStartLineNumber:e,modifiedEndLineNumber:i}}return{originalStartLineNumber:t.originalStartLineNumber,originalEndLineNumber:t.originalEndLineNumber,modifiedStartLineNumber:e,modifiedEndLineNumber:i}}},t.invertLineChange=function(e){return{modifiedStartLineNumber:e.originalStartLineNumber,modifiedEndLineNumber:e.originalEndLineNumber,originalStartLineNumber:e.modifiedStartLineNumber,originalEndLineNumber:e.modifiedEndLineNumber}},t.toLineChanges=function(e){return e.changes.map(e=>{let t,i,r,o;return e.original.startLineNumber===e.original.endLineNumberExclusive?(t=e.original.startLineNumber-1,i=0):(t=e.original.startLineNumber,i=e.original.endLineNumberExclusive-1),e.modified.startLineNumber===e.modified.endLineNumberExclusive?(r=e.modified.startLineNumber-1,o=0):(r=e.modified.startLineNumber,o=e.modified.endLineNumberExclusive-1),{originalStartLineNumber:t,originalEndLineNumber:i,modifiedStartLineNumber:r,modifiedEndLineNumber:o}})},t.compareLineChanges=function(e,t){let i=e.modifiedStartLineNumber-t.modifiedStartLineNumber;return 0!==i?i:(i=e.modifiedEndLineNumber-t.modifiedEndLineNumber,0!==i?i:(i=e.originalStartLineNumber-t.originalStartLineNumber,0!==i?i:e.originalEndLineNumber-t.originalEndLineNumber))},t.getIndexDiffInformation=function(e){return e.diffInformation?.find(e=>e.original&&(0,o.isGitUri)(e.original)&&"HEAD"===(0,o.fromGitUri)(e.original).ref&&e.modified&&(0,o.isGitUri)(e.modified)&&""===(0,o.fromGitUri)(e.modified).ref)},t.getWorkingTreeDiffInformation=function(e){return s(e,"~")??s(e,"")},t.getWorkingTreeAndIndexDiffInformation=function(e){return s(e,"HEAD")};const r=i(1398),o=i(4847);function n(e,t){return 0===t.modifiedEndLineNumber?0===t.modifiedStartLineNumber?new r.Range(e.lineAt(t.modifiedStartLineNumber).range.end,e.lineAt(t.modifiedStartLineNumber).range.start):e.lineCount===t.modifiedStartLineNumber?new r.Range(e.lineAt(t.modifiedStartLineNumber-1).range.end,e.lineAt(t.modifiedStartLineNumber-1).range.end):new r.Range(e.lineAt(t.modifiedStartLineNumber-1).range.end,e.lineAt(t.modifiedStartLineNumber).range.start):new r.Range(e.lineAt(t.modifiedStartLineNumber-1).range.start,e.lineAt(t.modifiedEndLineNumber-1).range.end)}function s(e,t){return e.diffInformation?.find(e=>e.original&&(0,o.isGitUri)(e.original)&&(0,o.fromGitUri)(e.original).ref===t)}},2857:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.Askpass=void 0;const a=i(1398),l=i(7937),c=s(i(6928));t.Askpass=class{constructor(e,t){this.ipc=e,this.logger=t,this.disposable=l.EmptyDisposable,this.cache=new Map,this.credentialsProviders=new Set,this.featureDescription="git auth provider",e&&(this.disposable=e.registerHandler("askpass",this)),this.env={GIT_ASKPASS:c.join(__dirname,this.ipc?"askpass.sh":"askpass-empty.sh"),VSCODE_GIT_ASKPASS_NODE:process.execPath,VSCODE_GIT_ASKPASS_EXTRA_ARGS:"",VSCODE_GIT_ASKPASS_MAIN:c.join(__dirname,"askpass-main.js")},this.sshEnv={SSH_ASKPASS:c.join(__dirname,this.ipc?"ssh-askpass.sh":"ssh-askpass-empty.sh"),SSH_ASKPASS_REQUIRE:"force"}}async handle(e){return this.logger.trace(`[Askpass][handle] ${JSON.stringify(e)}`),a.workspace.getConfiguration("git",null).get("enabled")?"https"===e.askpassType?await this.handleAskpass(e.argv):await this.handleSSHAskpass(e.argv):(this.logger.trace("[Askpass][handle] Git is disabled"),"")}async handleAskpass(e){const t=e[2],i=e[4].replace(/^["']+|["':]+$/g,"");this.logger.trace(`[Askpass][handleAskpass] request: ${t}, host: ${i}`);const r=a.Uri.parse(i),o=r.authority.replace(/^.*@/,""),n=/password/i.test(t),s=this.cache.get(o);if(s&&n)return this.cache.delete(o),s.password;if(!n)for(const e of this.credentialsProviders)try{const t=await e.getCredentials(r);if(t)return this.cache.set(o,t),setTimeout(()=>this.cache.delete(o),6e4),t.username}catch{}const l={password:n,placeHolder:t,prompt:`Git: ${i}`,ignoreFocusOut:!0};return await a.window.showInputBox(l)||""}async handleSSHAskpass(e){const t=e[3];if(/passphrase/i.test(t)){const i=(0,l.extractFilePathFromArgs)(e,6);this.logger.trace(`[Askpass][handleSSHAskpass] request: ${t}, file: ${i}`);const r={password:!0,placeHolder:a.l10n.t("Passphrase"),prompt:i?`SSH Key: ${i}`:void 0,ignoreFocusOut:!0};return await a.window.showInputBox(r)||""}const i=e[6].replace(/^["']+|["':]+$/g,""),r=e[15];this.logger.trace(`[Askpass][handleSSHAskpass] request: ${t}, host: ${i}, fingerprint: ${r}`);const o={canPickMany:!1,ignoreFocusOut:!0,placeHolder:a.l10n.t("Are you sure you want to continue connecting?"),title:a.l10n.t('"{0}" has fingerprint "{1}"',i??"",r??"")},n=[a.l10n.t("yes"),a.l10n.t("no")];return await a.window.showQuickPick(n,o)??""}getEnv(){return a.workspace.getConfiguration("git").get("useIntegratedAskPass")?{...this.env,...this.sshEnv}:{}}getTerminalEnv(){const e=a.workspace.getConfiguration("git");return e.get("useIntegratedAskPass")&&e.get("terminalAuthentication")?this.env:{}}registerCredentialsProvider(e){return this.credentialsProviders.add(e),(0,l.toDisposable)(()=>this.credentialsProviders.delete(e))}dispose(){this.disposable.dispose()}}},2987:function(e,t,i){"use strict";var r=this&&this.__decorate||function(e,t,i,r){var o,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,i):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,r);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(n<3?o(s):n>3?o(t,i,s):o(t,i))||s);return n>3&&s&&Object.defineProperty(t,i,s),s};Object.defineProperty(t,"__esModule",{value:!0}),t.GitFileSystemProvider=void 0;const o=i(1398),n=i(4399),s=i(4847),a=i(7937);function l(e,t,i,r){if("~"===e){const e=o.Uri.file(t).toString(),[i]=r.indexGroup.resourceStates.filter(t=>t.resourceUri.toString()===e);return i?"":"HEAD"}return/^~\d$/.test(e)?`:${e[1]}`:!i||"index"!==e&&"wt"!==e?e:"HEAD"}class c{constructor(e,t){this.model=e,this.logger=t,this._onDidChangeFile=new o.EventEmitter,this.onDidChangeFile=this._onDidChangeFile.event,this.changedRepositoryRoots=new Set,this.cache=new Map,this.mtime=(new Date).getTime(),this.disposables=[],this.disposables.push(e.onDidChangeRepository(this.onDidChangeRepository,this),e.onDidChangeOriginalResource(this.onDidChangeOriginalResource,this),o.workspace.registerFileSystemProvider("git",this,{isReadonly:!0,isCaseSensitive:!0})),setInterval(()=>this.cleanup(),3e5)}onDidChangeRepository({repository:e}){this.changedRepositoryRoots.add(e.root),this.eventuallyFireChangeEvents()}onDidChangeOriginalResource({uri:e}){if("file"!==e.scheme)return;const t=(0,s.toGitUri)(e,"~"),i=(0,s.toGitUri)(e,"",{replaceFileExtension:!0});this.mtime=(new Date).getTime(),this._onDidChangeFile.fire([{type:o.FileChangeType.Changed,uri:t},{type:o.FileChangeType.Changed,uri:i}])}eventuallyFireChangeEvents(){this.fireChangeEvents()}async fireChangeEvents(){if(!o.window.state.focused){const e=(0,a.filterEvent)(o.window.onDidChangeWindowState,e=>e.focused);await(0,a.eventToPromise)(e)}const e=[];for(const{uri:t}of this.cache.values()){const i=t.fsPath;for(const r of this.changedRepositoryRoots)if((0,a.isDescendant)(r,i)){e.push({type:o.FileChangeType.Changed,uri:t});break}}e.length>0&&(this.mtime=(new Date).getTime(),this._onDidChangeFile.fire(e)),this.changedRepositoryRoots.clear()}cleanup(){const e=(new Date).getTime(),t=new Map;for(const i of this.cache.values()){const{path:r}=(0,s.fromGitUri)(i.uri);(o.workspace.textDocuments.filter(e=>"file"===e.uri.scheme).some(e=>(0,a.pathEquals)(e.uri.fsPath,r))||e-i.timestamp<18e4)&&t.set(i.uri.toString(),i)}this.cache=t}watch(){return a.EmptyDisposable}async stat(e){await this.model.isInitialized;const{submoduleOf:t,path:i,ref:r}=(0,s.fromGitUri)(e),n=t?this.model.getRepository(t):this.model.getRepository(e);if(!n)throw this.logger.warn(`[GitFileSystemProvider][stat] Repository not found - ${e.toString()}`),o.FileSystemError.FileNotFound();try{const e=await n.getObjectDetails(l(r,i,t,n),i);return{type:o.FileType.File,size:e.size,mtime:this.mtime,ctime:0}}catch{if(r===await n.getEmptyTree())return this.logger.warn(`[GitFileSystemProvider][stat] Empty tree - ${e.toString()}`),{type:o.FileType.File,size:0,mtime:this.mtime,ctime:0};throw this.logger.warn(`[GitFileSystemProvider][stat] File not found - ${e.toString()}`),o.FileSystemError.FileNotFound()}}readDirectory(){throw new Error("Method not implemented.")}createDirectory(){throw new Error("Method not implemented.")}async readFile(e){await this.model.isInitialized;const{path:t,ref:i,submoduleOf:r}=(0,s.fromGitUri)(e);if(r){const e=this.model.getRepository(r);if(!e)throw o.FileSystemError.FileNotFound();const n=new TextEncoder;return"index"===i?n.encode(await e.diffIndexWithHEAD(t)):n.encode(await e.diffWithHEAD(t))}const n=this.model.getRepository(e);if(!n)throw this.logger.warn(`[GitFileSystemProvider][readFile] Repository not found - ${e.toString()}`),o.FileSystemError.FileNotFound();const a={uri:e,timestamp:(new Date).getTime()};this.cache.set(e.toString(),a);try{return await n.buffer(l(i,t,r,n),t)}catch{if(i===await n.getEmptyTree())return this.logger.warn(`[GitFileSystemProvider][readFile] Empty tree - ${e.toString()}`),new Uint8Array(0);throw this.logger.warn(`[GitFileSystemProvider][readFile] File not found - ${e.toString()}`),o.FileSystemError.FileNotFound()}}writeFile(){throw new Error("Method not implemented.")}delete(){throw new Error("Method not implemented.")}rename(){throw new Error("Method not implemented.")}dispose(){this.disposables.forEach(e=>e.dispose())}}t.GitFileSystemProvider=c,r([(0,n.debounce)(1100)],c.prototype,"eventuallyFireChangeEvents",null),r([n.throttle],c.prototype,"fireChangeEvents",null)},3102:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.pickRemoteSource=async function(e={}){return r.GitBaseApi.getAPI().pickRemoteSource(e)},t.getRemoteSourceActions=async function(e){return r.GitBaseApi.getAPI().getRemoteSourceActions(e)};const r=i(8623)},3193:e=>{"use strict";e.exports=require("string_decoder")},3480:e=>{"use strict";e.exports=require("querystring")},3492:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.BufferTokenizer=void 0;const r=i(8705),o=i(8632);class n extends o.AbstractTokenizer{constructor(e,t){super(t),this.uint8Array=e,this.fileInfo.size=this.fileInfo.size?this.fileInfo.size:e.length}async readBuffer(e,t){if(t&&t.position){if(t.position<this.position)throw new Error("`options.position` must be equal or greater than `tokenizer.position`");this.position=t.position}const i=await this.peekBuffer(e,t);return this.position+=i,i}async peekBuffer(e,t){const i=this.normalizeOptions(e,t),o=Math.min(this.uint8Array.length-i.position,i.length);if(!i.mayBeLess&&o<i.length)throw new r.EndOfStreamError;return e.set(this.uint8Array.subarray(i.position,i.position+o),i.offset),o}async close(){}}t.BufferTokenizer=n},3557:e=>{"use strict";e.exports=require("timers")},3765:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.IPCServer=void 0,t.createIPCServer=async function(e){const t=c.createServer(),i=d.createHash("sha256");if(e)i.update(e);else{const e=await new Promise((e,t)=>d.randomBytes(20,(i,r)=>i?t(i):e(r)));i.update(e)}const r=(o=i.digest("hex").substring(0,10),"win32"===process.platform?`\\\\.\\pipe\\vscode-git-${o}-sock`:"darwin"!==process.platform&&process.env.XDG_RUNTIME_DIR?l.join(process.env.XDG_RUNTIME_DIR,`vscode-git-${o}.sock`):l.join(h.tmpdir(),`vscode-git-${o}.sock`));var o;if("win32"!==process.platform)try{await u.promises.unlink(r)}catch{}return new Promise((e,i)=>{try{t.on("error",e=>i(e)),t.listen(r),e(new p(t,r))}catch(e){i(e)}})};const a=i(7937),l=s(i(6928)),c=s(i(8611)),h=s(i(857)),u=s(i(9896)),d=s(i(6982));class p{get ipcHandlePath(){return this._ipcHandlePath}constructor(e,t){this.server=e,this._ipcHandlePath=t,this.handlers=new Map,this.server.on("request",this.onRequest.bind(this))}registerHandler(e,t){return this.handlers.set(`/${e}`,t),(0,a.toDisposable)(()=>this.handlers.delete(e))}onRequest(e,t){if(!e.url)return void console.warn("Request lacks url");const i=this.handlers.get(e.url);if(!i)return void console.warn(`IPC handler for ${e.url} not found`);const r=[];e.on("data",e=>r.push(e)),e.on("end",()=>{const e=JSON.parse(Buffer.concat(r).toString("utf8"));i.handle(e).then(e=>{t.writeHead(200),t.end(JSON.stringify(e))},()=>{t.writeHead(500),t.end()})})}getEnv(){return{VSCODE_GIT_IPC_HANDLE:this.ipcHandlePath}}getTerminalEnv(){return{VSCODE_GIT_IPC_HANDLE:this.ipcHandlePath}}dispose(){this.handlers.clear(),this.server.close(),this._ipcHandlePath&&"win32"!==process.platform&&u.unlinkSync(this._ipcHandlePath)}}t.IPCServer=p},3804:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.AutoFetcher=void 0;const r=i(1398),o=i(7937);class n{get enabled(){return this._enabled}set enabled(e){this._enabled=e,this._onDidChange.fire(e)}constructor(e,t){this.repository=e,this.globalState=t,this._onDidChange=new r.EventEmitter,this.onDidChange=this._onDidChange.event,this._enabled=!1,this._fetchAll=!1,this.disposables=[],r.workspace.onDidChangeConfiguration(this.onConfiguration,this,this.disposables),this.onConfiguration();const i=(0,o.filterEvent)(e.onDidRunOperation,({operation:e,error:t})=>!t&&e.remote);(0,o.onceEvent)(i)(this.onFirstGoodRemoteOperation,this,this.disposables)}async onFirstGoodRemoteOperation(){const e=!this.globalState.get(n.DidInformUser);if(this.enabled&&!e&&this.globalState.update(n.DidInformUser,!0),this.enabled||!e)return;const t={title:r.l10n.t("Yes")},i={isCloseAffordance:!0,title:r.l10n.t("No")},o={title:r.l10n.t("Ask Me Later")},s=await r.window.showInformationMessage(r.l10n.t('Would you like {0} to [periodically run "git fetch"]({1})?',r.env.appName,"https://go.microsoft.com/fwlink/?linkid=865294"),t,i,o);s!==o&&(s===t&&r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)).update("autofetch",!0,r.ConfigurationTarget.Global),this.globalState.update(n.DidInformUser,!0))}onConfiguration(e){if(void 0===e||e.affectsConfiguration("git.autofetch"))switch(r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)).get("autofetch")){case!0:this._fetchAll=!1,this.enable();break;case"all":this._fetchAll=!0,this.enable();break;default:this._fetchAll=!1,this.disable()}}enable(){this.enabled||(this.enabled=!0,this.run())}disable(){this.enabled=!1}async run(){for(;this.enabled;){if(await this.repository.whenIdleAndFocused(),!this.enabled)return;try{this._fetchAll?await this.repository.fetchAll({silent:!0}):await this.repository.fetchDefault({silent:!0})}catch(e){"AuthenticationFailed"===e.gitErrorCode&&this.disable()}if(!this.enabled)return;const e=1e3*r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)).get("autofetchPeriod",180),t=new Promise(t=>setTimeout(t,e)),i=(0,o.eventToPromise)((0,o.filterEvent)(this.onDidChange,e=>!e));await Promise.race([t,i])}}dispose(){this.disable(),this.disposables.forEach(e=>e.dispose())}}t.AutoFetcher=n,n.DidInformUser="autofetch.didInformUser"},3846:(e,t,i)=>{"use strict";const r=i(363),o=i(5707),n={fromFile:async function(e){const t=await r.fromFile(e);try{return await o.fromTokenizer(t)}finally{await t.close()}}};Object.assign(n,o),Object.defineProperty(n,"extensions",{get:()=>o.extensions}),Object.defineProperty(n,"mimeTypes",{get:()=>o.mimeTypes}),e.exports=n},3940:(e,t,i)=>{"use strict";const r=i(6928),o="\\\\/",n=`[^${o}]`,s="\\.",a="\\/",l="[^/]",c=`(?:${a}|$)`,h=`(?:^|${a})`,u=`${s}{1,2}${c}`,d={DOT_LITERAL:s,PLUS_LITERAL:"\\+",QMARK_LITERAL:"\\?",SLASH_LITERAL:a,ONE_CHAR:"(?=.)",QMARK:l,END_ANCHOR:c,DOTS_SLASH:u,NO_DOT:`(?!${s})`,NO_DOTS:`(?!${h}${u})`,NO_DOT_SLASH:`(?!${s}{0,1}${c})`,NO_DOTS_SLASH:`(?!${u})`,QMARK_NO_DOT:`[^.${a}]`,STAR:`${l}*?`,START_ANCHOR:h},p={...d,SLASH_LITERAL:`[${o}]`,QMARK:n,STAR:`${n}*?`,DOTS_SLASH:`${s}{1,2}(?:[${o}]|$)`,NO_DOT:`(?!${s})`,NO_DOTS:`(?!(?:^|[${o}])${s}{1,2}(?:[${o}]|$))`,NO_DOT_SLASH:`(?!${s}{0,1}(?:[${o}]|$))`,NO_DOTS_SLASH:`(?!${s}{1,2}(?:[${o}]|$))`,QMARK_NO_DOT:`[^.${o}]`,START_ANCHOR:`(?:^|[${o}])`,END_ANCHOR:`(?:[${o}]|$)`};e.exports={MAX_LENGTH:65536,POSIX_REGEX_SOURCE:{alnum:"a-zA-Z0-9",alpha:"a-zA-Z",ascii:"\\x00-\\x7F",blank:" \\t",cntrl:"\\x00-\\x1F\\x7F",digit:"0-9",graph:"\\x21-\\x7E",lower:"a-z",print:"\\x20-\\x7E ",punct:"\\-!\"#$%&'()\\*+,./:;<=>?@[\\]^_`{|}~",space:" \\t\\r\\n\\v\\f",upper:"A-Z",word:"A-Za-z0-9_",xdigit:"A-Fa-f0-9"},REGEX_BACKSLASH:/\\(?![*+?^${}(|)[\]])/g,REGEX_NON_SPECIAL_CHARS:/^[^@![\].,$*+?^{}()|\\/]+/,REGEX_SPECIAL_CHARS:/[-*+?.^${}(|)[\]]/,REGEX_SPECIAL_CHARS_BACKREF:/(\\?)((\W)(\3*))/g,REGEX_SPECIAL_CHARS_GLOBAL:/([-*+?.^${}(|)[\]])/g,REGEX_REMOVE_BACKSLASH:/(?:\[.*?[^\\]\]|\\(?=.))/g,REPLACEMENTS:{"***":"*","**/**":"**","**/**/**":"**"},CHAR_0:48,CHAR_9:57,CHAR_UPPERCASE_A:65,CHAR_LOWERCASE_A:97,CHAR_UPPERCASE_Z:90,CHAR_LOWERCASE_Z:122,CHAR_LEFT_PARENTHESES:40,CHAR_RIGHT_PARENTHESES:41,CHAR_ASTERISK:42,CHAR_AMPERSAND:38,CHAR_AT:64,CHAR_BACKWARD_SLASH:92,CHAR_CARRIAGE_RETURN:13,CHAR_CIRCUMFLEX_ACCENT:94,CHAR_COLON:58,CHAR_COMMA:44,CHAR_DOT:46,CHAR_DOUBLE_QUOTE:34,CHAR_EQUAL:61,CHAR_EXCLAMATION_MARK:33,CHAR_FORM_FEED:12,CHAR_FORWARD_SLASH:47,CHAR_GRAVE_ACCENT:96,CHAR_HASH:35,CHAR_HYPHEN_MINUS:45,CHAR_LEFT_ANGLE_BRACKET:60,CHAR_LEFT_CURLY_BRACE:123,CHAR_LEFT_SQUARE_BRACKET:91,CHAR_LINE_FEED:10,CHAR_NO_BREAK_SPACE:160,CHAR_PERCENT:37,CHAR_PLUS:43,CHAR_QUESTION_MARK:63,CHAR_RIGHT_ANGLE_BRACKET:62,CHAR_RIGHT_CURLY_BRACE:125,CHAR_RIGHT_SQUARE_BRACKET:93,CHAR_SEMICOLON:59,CHAR_SINGLE_QUOTE:39,CHAR_SPACE:32,CHAR_TAB:9,CHAR_UNDERSCORE:95,CHAR_VERTICAL_LINE:124,CHAR_ZERO_WIDTH_NOBREAK_SPACE:65279,SEP:r.sep,extglobChars:e=>({"!":{type:"negate",open:"(?:(?!(?:",close:`))${e.STAR})`},"?":{type:"qmark",open:"(?:",close:")?"},"+":{type:"plus",open:"(?:",close:")+"},"*":{type:"star",open:"(?:",close:")*"},"@":{type:"at",open:"(?:",close:")"}}),globChars:e=>!0===e?p:d}},4266:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.AnsiStringType=t.StringType=t.BufferType=t.Uint8ArrayType=t.IgnoreType=t.Float80_LE=t.Float80_BE=t.Float64_LE=t.Float64_BE=t.Float32_LE=t.Float32_BE=t.Float16_LE=t.Float16_BE=t.INT64_BE=t.UINT64_BE=t.INT64_LE=t.UINT64_LE=t.INT32_LE=t.INT32_BE=t.INT24_BE=t.INT24_LE=t.INT16_LE=t.INT16_BE=t.INT8=t.UINT32_BE=t.UINT32_LE=t.UINT24_BE=t.UINT24_LE=t.UINT16_BE=t.UINT16_LE=t.UINT8=void 0;const r=i(251);function o(e){return new DataView(e.buffer,e.byteOffset)}t.UINT8={len:1,get:(e,t)=>o(e).getUint8(t),put:(e,t,i)=>(o(e).setUint8(t,i),t+1)},t.UINT16_LE={len:2,get:(e,t)=>o(e).getUint16(t,!0),put:(e,t,i)=>(o(e).setUint16(t,i,!0),t+2)},t.UINT16_BE={len:2,get:(e,t)=>o(e).getUint16(t),put:(e,t,i)=>(o(e).setUint16(t,i),t+2)},t.UINT24_LE={len:3,get(e,t){const i=o(e);return i.getUint8(t)+(i.getUint16(t+1,!0)<<8)},put(e,t,i){const r=o(e);return r.setUint8(t,255&i),r.setUint16(t+1,i>>8,!0),t+3}},t.UINT24_BE={len:3,get(e,t){const i=o(e);return(i.getUint16(t)<<8)+i.getUint8(t+2)},put(e,t,i){const r=o(e);return r.setUint16(t,i>>8),r.setUint8(t+2,255&i),t+3}},t.UINT32_LE={len:4,get:(e,t)=>o(e).getUint32(t,!0),put:(e,t,i)=>(o(e).setUint32(t,i,!0),t+4)},t.UINT32_BE={len:4,get:(e,t)=>o(e).getUint32(t),put:(e,t,i)=>(o(e).setUint32(t,i),t+4)},t.INT8={len:1,get:(e,t)=>o(e).getInt8(t),put:(e,t,i)=>(o(e).setInt8(t,i),t+2)},t.INT16_BE={len:2,get:(e,t)=>o(e).getInt16(t),put:(e,t,i)=>(o(e).setInt16(t,i),t+2)},t.INT16_LE={len:2,get:(e,t)=>o(e).getInt16(t,!0),put:(e,t,i)=>(o(e).setInt16(t,i,!0),t+2)},t.INT24_LE={len:3,get(e,i){const r=t.UINT24_LE.get(e,i);return r>8388607?r-16777216:r},put(e,t,i){const r=o(e);return r.setUint8(t,255&i),r.setUint16(t+1,i>>8,!0),t+3}},t.INT24_BE={len:3,get(e,i){const r=t.UINT24_BE.get(e,i);return r>8388607?r-16777216:r},put(e,t,i){const r=o(e);return r.setUint16(t,i>>8),r.setUint8(t+2,255&i),t+3}},t.INT32_BE={len:4,get:(e,t)=>o(e).getInt32(t),put:(e,t,i)=>(o(e).setInt32(t,i),t+4)},t.INT32_LE={len:4,get:(e,t)=>o(e).getInt32(t,!0),put:(e,t,i)=>(o(e).setInt32(t,i,!0),t+4)},t.UINT64_LE={len:8,get:(e,t)=>o(e).getBigUint64(t,!0),put:(e,t,i)=>(o(e).setBigUint64(t,i,!0),t+8)},t.INT64_LE={len:8,get:(e,t)=>o(e).getBigInt64(t,!0),put:(e,t,i)=>(o(e).setBigInt64(t,i,!0),t+8)},t.UINT64_BE={len:8,get:(e,t)=>o(e).getBigUint64(t),put:(e,t,i)=>(o(e).setBigUint64(t,i),t+8)},t.INT64_BE={len:8,get:(e,t)=>o(e).getBigInt64(t),put:(e,t,i)=>(o(e).setBigInt64(t,i),t+8)},t.Float16_BE={len:2,get(e,t){return r.read(e,t,!1,10,this.len)},put(e,t,i){return r.write(e,i,t,!1,10,this.len),t+this.len}},t.Float16_LE={len:2,get(e,t){return r.read(e,t,!0,10,this.len)},put(e,t,i){return r.write(e,i,t,!0,10,this.len),t+this.len}},t.Float32_BE={len:4,get:(e,t)=>o(e).getFloat32(t),put:(e,t,i)=>(o(e).setFloat32(t,i),t+4)},t.Float32_LE={len:4,get:(e,t)=>o(e).getFloat32(t,!0),put:(e,t,i)=>(o(e).setFloat32(t,i,!0),t+4)},t.Float64_BE={len:8,get:(e,t)=>o(e).getFloat64(t),put:(e,t,i)=>(o(e).setFloat64(t,i),t+8)},t.Float64_LE={len:8,get:(e,t)=>o(e).getFloat64(t,!0),put:(e,t,i)=>(o(e).setFloat64(t,i,!0),t+8)},t.Float80_BE={len:10,get(e,t){return r.read(e,t,!1,63,this.len)},put(e,t,i){return r.write(e,i,t,!1,63,this.len),t+this.len}},t.Float80_LE={len:10,get(e,t){return r.read(e,t,!0,63,this.len)},put(e,t,i){return r.write(e,i,t,!0,63,this.len),t+this.len}},t.IgnoreType=class{constructor(e){this.len=e}get(e,t){}},t.Uint8ArrayType=class{constructor(e){this.len=e}get(e,t){return e.subarray(t,t+this.len)}},t.BufferType=class{constructor(e){this.len=e}get(e,t){return Buffer.from(e.subarray(t,t+this.len))}},t.StringType=class{constructor(e,t){this.len=e,this.encoding=t}get(e,t){return Buffer.from(e).toString(this.encoding,t,t+this.len)}};class n{constructor(e){this.len=e}static decode(e,t,i){let r="";for(let o=t;o<i;++o)r+=n.codePointToString(n.singleByteDecoder(e[o]));return r}static inRange(e,t,i){return t<=e&&e<=i}static codePointToString(e){return e<=65535?String.fromCharCode(e):(e-=65536,String.fromCharCode(55296+(e>>10),56320+(1023&e)))}static singleByteDecoder(e){if(n.inRange(e,0,127))return e;const t=n.windows1252[e-128];if(null===t)throw Error("invaliding encoding");return t}get(e,t=0){return n.decode(e,t,t+this.len)}}t.AnsiStringType=n,n.windows1252=[8364,129,8218,402,8222,8230,8224,8225,710,8240,352,8249,338,141,381,143,144,8216,8217,8220,8221,8226,8211,8212,732,8482,353,8250,339,157,382,376,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255]},4399:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.sequentialize=t.throttle=t.memoize=void 0,t.debounce=function(e){return o((t,i)=>{const r=`$debounce$${i}`;return function(...i){clearTimeout(this[r]),this[r]=setTimeout(()=>t.apply(this,i),e)}})};const r=i(7937);function o(e){return(t,i,r)=>{let o=null,n=null;if("function"==typeof r.value?(o="value",n=r.value):"function"==typeof r.get&&(o="get",n=r.get),!n||!o)throw new Error("not supported");r[o]=e(n,i)}}t.memoize=o(function(e,t){const i=`$memoize$${t}`;return function(...t){return this.hasOwnProperty(i)||Object.defineProperty(this,i,{configurable:!1,enumerable:!1,writable:!1,value:e.apply(this,t)}),this[i]}}),t.throttle=o(function(e,t){const i=`$throttle$current$${t}`,o=`$throttle$next$${t}`,n=function(...t){if(this[o])return this[o];if(this[i])return this[o]=(0,r.done)(this[i]).then(()=>(this[o]=void 0,n.apply(this,t))),this[o];this[i]=e.apply(this,t);const s=()=>this[i]=void 0;return(0,r.done)(this[i]).then(s,s),this[i]};return n}),t.sequentialize=o(function(e,t){const i=`__$sequence$${t}`;return function(...t){const r=this[i]||Promise.resolve(null),o=async()=>await e.apply(this,t);return this[i]=r.then(o,o),this[i]}})},4434:e=>{"use strict";e.exports=require("events")},4459:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__decorate||function(e,t,i,r){var o,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,i):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,r);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(n<3?o(s):n>3?o(t,i,s):o(t,i))||s);return n>3&&s&&Object.defineProperty(t,i,s),s},a=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.CommandCenter=void 0;const l=a(i(857)),c=a(i(6928)),h=i(1398),u=i(5495),d=i(7681),p=i(2772),m=i(4847),g=i(7937),f=i(6103),y=i(6199),w=i(3102);class b{get description(){return""}get alwaysShow(){return!0}}class C extends b{get label(){return h.l10n.t("{0} Create new branch...","$(plus)")}}class v extends b{get label(){return h.l10n.t("{0} Create new branch from...","$(plus)")}}class k extends b{get label(){return h.l10n.t("{0} Checkout detached...","$(debug-disconnect)")}}class R{get kind(){return h.QuickPickItemKind.Separator}get label(){switch(this.refType){case 0:return h.l10n.t("branches");case 1:return h.l10n.t("remote branches");case 2:return h.l10n.t("tags");default:return""}}constructor(e){this.refType=e}}class E{get label(){return`$(list-tree) ${this.worktree.name}`}get description(){return this.worktree.path}constructor(e){this.worktree=e}}class S{get label(){switch(this.ref.type){case 0:return`$(git-branch) ${this.ref.name??this.shortCommit}`;case 1:return`$(cloud) ${this.ref.name??this.shortCommit}`;case 2:return`$(tag) ${this.ref.name??this.shortCommit}`;default:return""}}get description(){if(this.ref.commitDetails?.commitDate)return(0,g.fromNow)(this.ref.commitDetails.commitDate,!0,!0);switch(this.ref.type){case 0:return this.shortCommit;case 1:return h.l10n.t("Remote branch at {0}",this.shortCommit);case 2:return h.l10n.t("Tag at {0}",this.shortCommit);default:return""}}get detail(){if(this.ref.commitDetails?.authorName&&this.ref.commitDetails?.message)return`${this.ref.commitDetails.authorName}$(circle-small-filled)${this.shortCommit}$(circle-small-filled)${this.ref.commitDetails.message}`}get refId(){switch(this.ref.type){case 0:return`refs/heads/${this.ref.name}`;case 1:return`refs/remotes/${this.ref.remote}/${this.ref.name}`;case 2:return`refs/tags/${this.ref.name}`}}get refName(){return this.ref.name}get refRemote(){return this.ref.remote}get shortCommit(){return(this.ref.commit||"").substring(0,this.shortCommitLength)}get buttons(){return this._buttons}set buttons(e){this._buttons=e}constructor(e,t){this.ref=e,this.shortCommitLength=t}}class D extends S{get description(){const e=[];return"number"==typeof this.ref.behind&&"number"==typeof this.ref.ahead&&e.push(`${this.ref.behind}↓ ${this.ref.ahead}↑`),this.ref.commitDetails?.commitDate&&e.push((0,g.fromNow)(this.ref.commitDetails.commitDate,!0,!0)),e.length>0?e.join("$(circle-small-filled)"):this.shortCommit}constructor(e,t){super(e,t),this.ref=e}}class A extends D{async run(e,t){if(!this.ref.name)return;const i=!0===h.workspace.getConfiguration("git",h.Uri.file(e.root)).get("pullBeforeCheckout",!1),r=t?.detached?this.ref.commit??this.ref.name:this.ref.name;await e.checkout(r,{...t,pullBeforeCheckout:i})}}class _ extends A{get label(){return`$(lock) ${this.ref.name??this.shortCommit}`}}class P extends S{async run(e,t){if(!this.ref.name)return;if(t?.detached)return void await e.checkout(this.ref.commit??this.ref.name,t);const i=await e.findTrackingBranches(this.ref.name);i.length>0?await e.checkout(i[0].name,t):await e.checkoutTracking(this.ref.name,t)}}class x extends S{async run(e,t){this.ref.name&&await e.checkout(this.ref.name,t)}}class T extends D{async run(e,t){if(0===this.ref.type&&this.refName)await e.deleteBranch(this.refName,t);else if(1===this.ref.type&&this.refRemote&&this.refName){const i=this.refName.substring(this.refRemote.length+1);await e.deleteRemoteRef(this.refRemote,i,{force:t})}}}class M extends S{async run(e){this.ref.name&&await e.deleteTag(this.ref.name)}}class I extends S{get description(){return h.l10n.t("Remote tag at {0}",this.shortCommit)}async run(e,t){this.ref.name&&await e.deleteRemoteRef(t,this.ref.name)}}class B extends E{async run(e){if(this.worktree.path)try{await e.deleteWorktree(this.worktree.path)}catch(t){if("WorktreeContainsChanges"===t.gitErrorCode){const t=h.l10n.t("Force Delete"),i=h.l10n.t("The worktree contains modified or untracked files. Do you want to force delete?");await h.window.showWarningMessage(i,{modal:!0},t)===t&&await e.deleteWorktree(this.worktree.path,{force:!0})}}}}class O extends D{async run(e){(this.ref.name||this.ref.commit)&&await e.merge(this.ref.name??this.ref.commit)}}class L extends D{async run(e){this.ref?.name&&await e.rebase(this.ref.name)}}class G extends L{get description(){return"(upstream)"}}class H{constructor(e,t){this.repository=e,this.shortCommitLength=t}get label(){return"HEAD"}get description(){return(this.repository.HEAD?.commit??"").substring(0,this.shortCommitLength)}get alwaysShow(){return!0}get refName(){return"HEAD"}}class ${constructor(e){this.cc=e}get label(){return"$(plus) "+h.l10n.t("Add a new remote...")}get description(){return""}get alwaysShow(){return!0}async run(e){await this.cc.addRemote(e)}}class N{get label(){return`$(cloud) ${this.remote.name}`}get description(){return this.remote.fetchUrl}get remoteName(){return this.remote.name}constructor(e,t){this.repository=e,this.remote=t}async run(){await this.repository.fetch({remote:this.remote.name})}}class U{get label(){return h.l10n.t("{0} Fetch all remotes","$(cloud-download)")}constructor(e){this.repository=e}async run(){await this.repository.fetch({all:!0})}}class F{get label(){return`$(repo) ${Q(this.path)}`}get description(){return this.path}constructor(e){this.path=e}}class W{get label(){return`#${this.stash.index}: ${this.stash.description}`}get description(){return this.stash.branchName}constructor(e){this.stash=e}}const j=[];function K(e,t={}){return(i,r,o)=>{if("function"!=typeof o.value)throw new Error("not supported");j.push({commandId:e,key:r,method:o.value,options:t})}}async function J(e){const t=e.filter(e=>e instanceof d.Resource).filter(e=>0===e.resourceGroupType),i=e=>18===e.type||16===e.type,r=e=>15===e.type||14===e.type,o=t.filter(i),n=o.map(e=>(0,g.grep)(e.resourceUri.fsPath,/^<{7}\s|^={7}$|^>{7}\s/)),s=await Promise.all(n),a=o.filter((e,t)=>!s[t]),l=t.filter(e=>r(e)),c=[...t.filter(e=>!i(e)&&!r(e)),...o.filter((e,t)=>s[t])];return{merge:t,resolved:a,unresolved:c,deletionConflicts:l}}class z{constructor(e,t=S){this.type=e,this.ctor=t,this.refs=[]}processRef(e){return!(!e.name&&!e.commit||e.type!==this.type||(this.refs.push(e),0))}getItems(e){const t=this.refs.map(t=>new this.ctor(t,e));return 0===t.length?t:[new R(this.type),...t]}}class V{constructor(e,t,i={}){this.repository=e,this.processors=t,this.options=i;const r=h.workspace.getConfiguration("git",h.Uri.file(e.root));this.shortCommitLength=r.get("commitShortHashLength",7)}processRefs(e){const t=this.getRefsToSkip();for(const i of e)if(!i.name||!t.includes(i.name))for(const e of this.processors)if(e.processRef(i))break;const i=[];for(const e of this.processors)i.push(...e.getItems(this.shortCommitLength));return i}getRefsToSkip(){const e=["origin/HEAD"];return this.options.skipCurrentBranch&&this.repository.HEAD?.name&&e.push(this.repository.HEAD.name),this.options.skipCurrentBranchRemote&&this.repository.HEAD?.upstream&&e.push(`${this.repository.HEAD.upstream.remote}/${this.repository.HEAD.upstream.name}`),e}}class q extends z{constructor(e){super(0),this.repository=e}getItems(e){const t=this.refs.map(t=>this.repository.isBranchProtected(t)?new _(t,e):new A(t,e));return 0===t.length?t:[new R(this.type),...t]}}class Y extends V{constructor(e,t,i,r=!1){super(e,t),this.buttons=i,this.detached=r;const o=e.remotes.find(t=>t.pushUrl===e.HEAD?.remote||t.fetchUrl===e.HEAD?.remote)??e.remotes[0],n=o?.pushUrl??o?.fetchUrl;n&&(this.defaultButtons=i.get(n))}processRefs(e){for(const t of e)if(this.detached||"origin/HEAD"!==t.name)for(const e of this.processors)if(e.processRef(t))break;const t=[];for(const e of this.processors)for(const i of e.getItems(this.shortCommitLength))if(i instanceof S){if(i.refRemote){const e=this.repository.remotes.find(e=>e.name===i.refRemote),t=[];e?.pushUrl&&t.push(...this.buttons.get(e.pushUrl)??[]),e?.fetchUrl&&e.fetchUrl!==e.pushUrl&&t.push(...this.buttons.get(e.fetchUrl)??[]),t.length&&(i.buttons=t)}else i.buttons=this.defaultButtons;t.push(i)}else t.push(i);return t}}function Q(e){const t=h.workspace.getWorkspaceFolder(h.Uri.file(e));return t?.uri.toString()===e?t.name:c.basename(e)}function X(e,t){return Q(e).localeCompare(Q(t))}function Z(e,t){return e?e.trim().replace(/^-+/,"").replace(/^\.|\/\.|\.\.|~|\^|:|\/$|\.lock$|\.lock\/|\\|\*|\s|^\s*$|\.$|\[|\]$/g,t):e}function ee(e){return(e=e.trim())&&e.replace(/^\.|\/\.|\.\.|~|\^|:|\/$|\.lock$|\.lock\/|\\|\*|\s|^\s*$|\.$|\[|\]$/g,"-")}var te;!function(e){e[e.Push=0]="Push",e[e.PushTo=1]="PushTo",e[e.PushFollowTags=2]="PushFollowTags",e[e.PushTags=3]="PushTags"}(te||(te={}));class ie{constructor(){this.items=new Map}set(e,t){this.items.set(e.path,t)}delete(e){this.items.delete(e.path)}provideTextDocumentContent(e){return this.items.get(e.path)}}class re{constructor(e,t,i,r){this.git=e,this.model=t,this.globalState=i,this.logger=r,this.commandErrors=new ie,this.disposables=j.map(({commandId:e,key:t,method:i,options:r})=>{const o=this.createCommand(e,t,i,r);return h.commands.registerCommand(e,o)}),this.disposables.push(h.workspace.registerTextDocumentContentProvider("git-output",this.commandErrors))}showOutput(){this.logger.show()}async refresh(e){await e.refresh()}async openResource(e){this.model.getRepository(e.resourceUri)&&await e.open()}async openChanges(e){for(const t of[...e.workingTreeGroup.resourceStates,...e.untrackedGroup.resourceStates])6!==t.type&&15!==t.type&&14!==t.type&&17!==t.type&&h.commands.executeCommand("vscode.open",t.resourceUri,{background:!0,preview:!1})}async openMergeEditor(e){if(void 0===e&&h.window.tabGroups.activeTabGroup.activeTab?.input instanceof h.TabInputText&&(e=h.window.tabGroups.activeTabGroup.activeTab.input.uri),!(e instanceof h.Uri))return;const t=this.model.getRepository(e);if(!t)return;const i=Boolean(t.rebaseCommit),r=(0,m.toMergeUris)(e);let o=!1;try{const t=function(e){const t="<<<<<<<";let i=!1,r="",o="",n=!1;for(let s=0;s<e.lineCount;s++){const a=e.lineAt(s).text;if(i){if(a.startsWith(">>>>>>>")){o=a.substring(7).trim(),i=!1;break}}else a.startsWith(t)&&(r=a.substring(7).trim(),i=!0,n=!0)}if(n)return{currentChangeLabel:r,incomingChangeLabel:o}}(await h.workspace.openTextDocument(e));o="Stashed changes"===t?.incomingChangeLabel}catch(e){console.error(e)}const n={uri:r.ours,title:h.l10n.t("Current")},s={uri:r.theirs,title:h.l10n.t("Incoming")};o&&(s.title=h.l10n.t("Stashed Changes"));try{const[r,o,a]=await Promise.all([t.getCommit("HEAD"),i?t.getCommit("REBASE_HEAD"):t.getCommit("MERGE_HEAD"),await t.diffBetween(i?"REBASE_HEAD":"MERGE_HEAD","HEAD")]),l=a?.find(t=>t.uri.fsPath===e.fsPath);n.detail=r.refNames.map(e=>e.replace(/^HEAD ->/,"")).join(", "),n.description="$(git-commit) "+r.hash.substring(0,7),n.uri=(0,m.toGitUri)(e,r.hash),s.detail=o.refNames.join(", "),s.description="$(git-commit) "+o.hash.substring(0,7),s.uri=l?(0,m.toGitUri)(l.originalUri,o.hash):(0,m.toGitUri)(e,o.hash)}catch(e){console.error("FAILED to read HEAD, MERGE_HEAD commits"),console.error(e)}const a={base:r.base,input1:i?n:s,input2:i?s:n,output:e};await h.commands.executeCommand("_open.mergeEditor",a)}async cloneRepository(e,t,i={}){if(e&&"string"==typeof e||(e=await(0,w.pickRemoteSource)({providerLabel:e=>h.l10n.t("Clone from {0}",e.name),urlLabel:h.l10n.t("Clone from URL")})),e){if(e=e.trim().replace(/^git\s+clone\s+/,""),!t){let i=h.workspace.getConfiguration("git").get("defaultCloneDirectory")||l.homedir();i=i.replace(/^~/,l.homedir());const r=await h.window.showOpenDialog({canSelectFiles:!1,canSelectFolders:!0,canSelectMany:!1,defaultUri:h.Uri.file(i),title:h.l10n.t("Choose a folder to clone {0} into",e),openLabel:h.l10n.t("Select as Repository Destination")});if(!r||0===r.length)return;const o=r[0];t=o.fsPath}try{const r={location:h.ProgressLocation.Notification,title:h.l10n.t('Cloning git repository "{0}"...',e),cancellable:!0},o=await h.window.withProgress(r,(r,o)=>this.git.clone(e,{parentPath:t,progress:r,recursive:i.recursive,ref:i.ref},o)),n=h.workspace.getConfiguration("git").get("openAfterClone");let s,a;if(function(e){e[e.Open=0]="Open",e[e.OpenNewWindow=1]="OpenNewWindow",e[e.AddToWorkspace=2]="AddToWorkspace"}(s||(s={})),"always"===n?a=s.Open:"alwaysNewWindow"===n?a=s.OpenNewWindow:"whenNoFolderOpen"!==n||h.workspace.workspaceFolders||(a=s.Open),void 0===a){let e=h.l10n.t("Would you like to open the cloned repository?");const t=h.l10n.t("Open"),i=h.l10n.t("Open in New Window"),r=[t,i],o=h.l10n.t("Add to Workspace");h.workspace.workspaceFolders&&(e=h.l10n.t("Would you like to open the cloned repository, or add it to the current workspace?"),r.push(o));const n=await h.window.showInformationMessage(e,{modal:!0},...r);a=n===t?s.Open:n===i?s.OpenNewWindow:n===o?s.AddToWorkspace:void 0}const l=h.Uri.file(o);a===s.Open?h.commands.executeCommand("vscode.openFolder",l,{forceReuseWindow:!0}):a===s.AddToWorkspace?h.workspace.updateWorkspaceFolders(h.workspace.workspaceFolders.length,0,{uri:l}):a===s.OpenNewWindow&&h.commands.executeCommand("vscode.openFolder",l,{forceNewWindow:!0})}catch(e){if(/already exists and is not an empty directory/.test(e&&e.stderr||""));else if(/Cancelled/i.test(e&&(e.message||e.stderr||"")))return;throw e}}}getRepositoriesWithRemote(e){return e.reduce((e,t)=>{const i=t.remotes.find(e=>e.name===t.HEAD?.upstream?.remote);return i?.pushUrl&&e.push({repository:t,label:i.pushUrl}),e},[])}async continueInLocalClone(){if(0===this.model.repositories.length)return;let e=this.getRepositoriesWithRemote(this.model.repositories);if(0===e.length){const t=1===this.model.repositories.length?{repository:this.model.repositories[0]}:await h.window.showQuickPick(this.model.repositories.map(e=>({repository:e,label:e.root})),{canPickMany:!1,placeHolder:h.l10n.t("Choose which repository to publish")});if(!t)return;if(await this.publish(t.repository),e=this.getRepositoriesWithRemote([t.repository]),0===e.length)return}let t=e[0];if(e.length>1){const i=await h.window.showQuickPick(e,{canPickMany:!1,placeHolder:h.l10n.t("Choose which repository to clone")});if(void 0===i)return;t=i}const i=t.label,r=t.repository.HEAD?.upstream?.name;if(void 0!==i){let e=`${h.env.uriScheme}://vscode.git/clone?url=${encodeURIComponent(i)}`;const t=h.env.uiKind===h.UIKind.Web,o=void 0!==h.env.remoteName;if(t||o){if(void 0!==r&&(e+=`&ref=${encodeURIComponent(r)}`),t)return h.Uri.parse(e);if(o)return e+="&windowId=_blank",h.Uri.parse(e)}this.clone(i,void 0,{ref:r})}}async clone(e,t,i){await this.cloneRepository(e,t,i)}async cloneRecursive(e,t){await this.cloneRepository(e,t,{recursive:!0})}async init(e=!1){let t,i=!0;if(h.workspace.workspaceFolders)if(e&&1===h.workspace.workspaceFolders.length)t=h.workspace.workspaceFolders[0].uri.fsPath,i=!1;else{const e=h.l10n.t("Pick workspace folder to initialize git repo in"),r={label:h.l10n.t("Choose Folder...")},o=[...h.workspace.workspaceFolders.map(e=>({label:e.name,description:e.uri.fsPath,folder:e})),r],n=await h.window.showQuickPick(o,{placeHolder:e,ignoreFocusOut:!0});if(!n)return;n.folder&&(t=n.folder.uri.fsPath,i=!1)}if(!t){const e=h.Uri.file(l.homedir()),r=h.workspace.workspaceFolders&&h.workspace.workspaceFolders.length>0?h.Uri.file(h.workspace.workspaceFolders[0].uri.fsPath):e,o=await h.window.showOpenDialog({canSelectFiles:!1,canSelectFolders:!0,canSelectMany:!1,defaultUri:r,openLabel:h.l10n.t("Initialize Repository")});if(!o||0===o.length)return;const n=o[0];if(e.toString().startsWith(n.toString())){const e=h.l10n.t("Initialize Repository");if(await h.window.showWarningMessage(h.l10n.t('This will create a Git repository in "{0}". Are you sure you want to continue?',n.fsPath),e)!==e)return}t=n.fsPath,h.workspace.workspaceFolders&&h.workspace.workspaceFolders.some(e=>e.uri.toString()===n.toString())&&(i=!1)}const r=h.workspace.getConfiguration("git"),o=r.get("defaultBranchName","main"),n=r.get("branchWhitespaceChar","-");await this.git.init(t,{defaultBranch:Z(o,n)});let s=h.l10n.t("Would you like to open the initialized repository?");const a=h.l10n.t("Open"),c=h.l10n.t("Open in New Window"),u=[a,c];if(!i)return void await this.model.openRepository(t);const d=h.l10n.t("Add to Workspace");h.workspace.workspaceFolders&&(s=h.l10n.t("Would you like to open the initialized repository, or add it to the current workspace?"),u.push(d));const p=await h.window.showInformationMessage(s,...u),m=h.Uri.file(t);p===a?h.commands.executeCommand("vscode.openFolder",m):p===d?h.workspace.updateWorkspaceFolders(h.workspace.workspaceFolders.length,0,{uri:m}):p===c?h.commands.executeCommand("vscode.openFolder",m,!0):await this.model.openRepository(t)}async openRepository(e){if(!e){const t=await h.window.showOpenDialog({canSelectFiles:!1,canSelectFolders:!0,canSelectMany:!1,defaultUri:h.Uri.file(l.homedir()),openLabel:h.l10n.t("Open Repository")});if(!t||0===t.length)return;e=t[0].fsPath}await this.model.openRepository(e,!0)}async reopenClosedRepositories(){if(0===this.model.closedRepositories.length)return;const e=[],t=h.l10n.t("Reopen Closed Repositories"),i=h.l10n.t("Pick a repository to reopen"),r={label:h.l10n.t("All Repositories")},o=this.model.closedRepositories.sort(X).map(e=>new F(e)),n=1===this.model.closedRepositories.length?[...o]:[...o,{label:"",kind:h.QuickPickItemKind.Separator},r],s=await h.window.showQuickPick(n,{title:t,placeHolder:i});if(s){s===r?e.push(...this.model.closedRepositories.values()):e.push(s.path);for(const t of e)await this.model.openRepository(t,!0)}}async close(e,...t){const i=t.map(e=>this.model.getRepository(e)).filter(g.isDefined);for(const t of[e,...i])this.model.close(t)}async closeOtherRepositories(e,...t){const i=[e,...t.map(e=>this.model.getRepository(e)).filter(g.isDefined)];for(const e of this.model.repositories)i.includes(e)||this.model.close(e)}async openFile(e,...t){const i=e instanceof d.Resource;let r;if(e instanceof h.Uri)(0,m.isGitUri)(e)?r=[h.Uri.file((0,m.fromGitUri)(e).path)]:"file"===e.scheme&&(r=[e]);else{let i=e;i instanceof d.Resource||(i=this.getSCMResource()),i?r=[i,...t].filter(e=>6!==e.type&&2!==e.type).map(e=>e.resourceUri):h.window.activeTextEditor&&(r=[h.window.activeTextEditor.document.uri])}if(!r)return;const o=h.window.activeTextEditor,n=o?.visibleRanges,s=o?.document.uri,a=o?.selection;for(const t of r){const r={preserveFocus:i,preview:!1,viewColumn:h.ViewColumn.Active};await h.commands.executeCommand("vscode.open",t,{...r,override:!(e instanceof d.Resource&&18===e.type)&&void 0});const l=h.window.activeTextEditor?.document;if(l?.uri.toString()===t.toString()&&o&&s&&a&&s.path===t.path&&l){r.selection=a;const e=await h.window.showTextDocument(l,r);if(n&&n.length>0){let t=n[0];a&&n.length>1&&(t=n.find(e=>e.intersection(a))??t),e.revealRange(t)}}}}async openFile2(e,...t){this.openFile(e,...t)}async openHEADFile(e){let t;const i=!(e instanceof d.Resource);if(t=e instanceof d.Resource?e:e instanceof h.Uri?this.getSCMResource(e):this.getSCMResource(),!t)return;const r=t.leftUri,o=`${c.basename(t.resourceUri.fsPath)} (HEAD)`;if(!r)return void h.window.showWarningMessage(h.l10n.t('HEAD version of "{0}" is not available.',c.basename(t.resourceUri.fsPath)));const n={preview:i};return await h.commands.executeCommand("vscode.open",r,n,o)}async openChange(e,...t){let i;if(e instanceof h.Uri){const t=this.getSCMResource(e);void 0!==t&&(i=[t])}else{let r;r=e instanceof d.Resource?e:this.getSCMResource(),r&&(i=[...t,r])}if(i)for(const e of i)await e.openChange()}async rename(e,t){if(!(t=t??h.window.activeTextEditor?.document.uri))return;const i=(0,g.relativePath)(e.root,t.fsPath);let r=await h.window.showInputBox({value:i,valueSelection:[i.length-c.basename(i).length,i.length]});r=r?.trim(),r&&(await e.move(i,r),await h.commands.executeCommand("workbench.action.closeActiveEditor"),await h.commands.executeCommand("vscode.open",h.Uri.file(c.join(e.root,r)),{viewColumn:h.ViewColumn.Active}))}async stage(...e){if(this.logger.debug(`[CommandCenter][stage] git.stage ${e.length} `),0===(e=e.filter(e=>!!e)).length||e[0]&&!(e[0].resourceUri instanceof h.Uri)){const t=this.getSCMResource();if(this.logger.debug(`[CommandCenter][stage] git.stage.getSCMResource ${t?t.resourceUri.toString():null} `),!t)return;e=[t]}const t=e.filter(e=>e instanceof d.Resource),{resolved:i,unresolved:r,deletionConflicts:o}=await J(t);if(r.length>0){const e=r.length>1?h.l10n.t("Are you sure you want to stage {0} files with merge conflicts?",r.length):h.l10n.t("Are you sure you want to stage {0} with merge conflicts?",c.basename(r[0].resourceUri.fsPath)),t=h.l10n.t("Yes");if(await h.window.showWarningMessage(e,{modal:!0},t)!==t)return}try{await this.runByRepository(o.map(e=>e.resourceUri),async(e,t)=>{for(const i of t)await this._stageDeletionConflict(e,i)})}catch(e){if(/Cancelled/.test(e.message))return;throw e}const n=[...t.filter(e=>2===e.resourceGroupType),...t.filter(e=>3===e.resourceGroupType),...i,...r];if(this.logger.debug(`[CommandCenter][stage] git.stage.scmResources ${n.length} `),!n.length)return;const s=n.map(e=>e.resourceUri);await this.runByRepository(s,async(e,t)=>e.add(t))}async stageAll(e){const t=[...e.workingTreeGroup.resourceStates,...e.untrackedGroup.resourceStates].map(e=>e.resourceUri);if(t.length>0){const i=h.workspace.getConfiguration("git",h.Uri.file(e.root)).get("untrackedChanges");await e.add(t,"mixed"===i?void 0:{update:!0})}}async _stageDeletionConflict(e,t){const i=t.toString(),r=e.mergeGroup.resourceStates.filter(e=>e.resourceUri.toString()===i)[0];if(r)if(15===r.type){const i=h.l10n.t("Keep Our Version"),r=h.l10n.t("Delete File"),o=await h.window.showInformationMessage(h.l10n.t('File "{0}" was deleted by them and modified by us.\n\nWhat would you like to do?',c.basename(t.fsPath)),{modal:!0},i,r);if(o===i)await e.add([t]);else{if(o!==r)throw new Error("Cancelled");await e.rm([t])}}else if(14===r.type){const i=h.l10n.t("Keep Their Version"),r=h.l10n.t("Delete File"),o=await h.window.showInformationMessage(h.l10n.t('File "{0}" was deleted by us and modified by them.\n\nWhat would you like to do?',c.basename(t.fsPath)),{modal:!0},i,r);if(o===i)await e.add([t]);else{if(o!==r)throw new Error("Cancelled");await e.rm([t])}}}async stageAllTracked(e){const t=e.workingTreeGroup.resourceStates.filter(e=>7!==e.type&&8!==e.type).map(e=>e.resourceUri);await e.add(t)}async stageAllUntracked(e){const t=[...e.workingTreeGroup.resourceStates,...e.untrackedGroup.resourceStates].filter(e=>7===e.type||8===e.type).map(e=>e.resourceUri);await e.add(t)}async stageAllMerge(e){const t=e.mergeGroup.resourceStates.filter(e=>e instanceof d.Resource),{merge:i,unresolved:r,deletionConflicts:o}=await J(t);try{for(const t of o)await this._stageDeletionConflict(e,t.resourceUri)}catch(e){if(/Cancelled/.test(e.message))return;throw e}if(r.length>0){const e=r.length>1?h.l10n.t("Are you sure you want to stage {0} files with merge conflicts?",i.length):h.l10n.t("Are you sure you want to stage {0} with merge conflicts?",c.basename(i[0].resourceUri.fsPath)),t=h.l10n.t("Yes");if(await h.window.showWarningMessage(e,{modal:!0},t)!==t)return}const n=t.map(e=>e.resourceUri);n.length>0&&await e.add(n)}async stageChange(e,t,i){if(!e)return;const r=h.window.visibleTextEditors.filter(t=>t.document.uri.toString()===e.toString())[0];if(!r)return;await this._stageChanges(r,[t[i]]);const o=t[i].modifiedStartLineNumber;r.selections=[new h.Selection(o,0,o,0)]}async diffStageHunk(e){e?this.diffStageHunkOrSelection(e):await this.stageHunkAtCursor()}async diffStageSelection(e){this.diffStageHunkOrSelection(e)}async diffStageHunkOrSelection(e){if(!e)return;let t,i=e.modifiedUri;if(!i){const e=h.window.activeTextEditor;if(!e)return;t=e.document,i=t.uri}if("file"!==i.scheme)return;t||(t=await h.workspace.openTextDocument(i));const r=e.originalWithModifiedChanges;await this.runByRepository(i,async(e,i)=>await e.stage(i,r,t.encoding))}async stageHunkAtCursor(){const e=h.window.activeTextEditor;if(!e)return;const t=(0,p.getWorkingTreeDiffInformation)(e);if(!t)return;const i=(0,p.toLineChanges)(t),r=e.document,o=e.selection.active,n=i.find(e=>(0,p.getModifiedRange)(r,e).contains(o));n?await this._stageChanges(e,[n]):h.window.showInformationMessage(h.l10n.t("No hunk found at cursor position."))}async stageSelectedChanges(){const e=h.window.activeTextEditor;if(!e)return;const t=(0,p.getWorkingTreeDiffInformation)(e);if(!t)return;const i=(0,p.toLineChanges)(t);this.logger.trace(`[CommandCenter][stageSelectedChanges] diffInformation: ${JSON.stringify(t)}`),this.logger.trace(`[CommandCenter][stageSelectedChanges] diffInformation changes: ${JSON.stringify(i)}`);const r=e.document,o=(0,p.toLineRanges)(e.selections,r),n=i.map(e=>o.reduce((t,i)=>t||(0,p.intersectDiffWithRange)(r,e,i),null)).filter(e=>!!e);this.logger.trace(`[CommandCenter][stageSelectedChanges] selectedChanges: ${JSON.stringify(n)}`),n.length?await this._stageChanges(e,n):h.window.showInformationMessage(h.l10n.t("The selection range does not contain any changes."))}async stageFile(e){if(!(e=e??h.window.activeTextEditor?.document.uri))return;const t=this.model.getRepository(e);if(!t)return;const i=[...t.workingTreeGroup.resourceStates,...t.untrackedGroup.resourceStates].filter(t=>t.multiFileDiffEditorModifiedUri?.toString()===e.toString()).map(e=>e.resourceUri);0!==i.length&&await t.add(i)}async acceptMerge(e){const{activeTab:t}=h.window.tabGroups.activeTabGroup;if(!t)return;if(!(t.input instanceof h.TabInputTextMerge))return;const i=t.input.result,r=this.model.getRepository(i);r?(await h.commands.executeCommand("mergeEditor.acceptMerge")).successful&&(await r.add([i]),await h.commands.executeCommand("workbench.view.scm")):console.log(`FAILED to complete merge because uri ${i.toString()} doesn't belong to any repository`)}async runGitMergeNoDiff3(){await this.runGitMerge(!1)}async runGitMergeDiff3(){await this.runGitMerge(!0)}async runGitMerge(e){const{activeTab:t}=h.window.tabGroups.activeTabGroup;if(!t)return;const i=t.input;if(!(i instanceof h.TabInputTextMerge))return;const r=await this.git.mergeFile({basePath:i.base.fsPath,input1Path:i.input1.fsPath,input2Path:i.input2.fsPath,diff3:e}),o=h.workspace.textDocuments.find(e=>e.uri.toString()===i.result.toString());if(!o)return;const n=new h.WorkspaceEdit;n.replace(i.result,new h.Range(new h.Position(0,0),new h.Position(o.lineCount,0)),r),await h.workspace.applyEdit(n)}async _stageChanges(e,t){const i=e.document,r=i.uri;if("file"!==r.scheme)return;const o=(0,m.toGitUri)(r,"~"),n=await h.workspace.openTextDocument(o),s=(0,p.applyLineChanges)(n,i,t);await this.runByRepository(r,async(e,t)=>await e.stage(t,s,i.encoding))}async revertChange(e,t,i){if(!e)return;const r=h.window.visibleTextEditors.filter(t=>t.document.uri.toString()===e.toString())[0];if(!r)return;await this._revertChanges(r,[...t.slice(0,i),...t.slice(i+1)]);const o=t[i].modifiedStartLineNumber;r.selections=[new h.Selection(o,0,o,0)]}async revertSelectedRanges(){const e=h.window.activeTextEditor;if(!e)return;const t=(0,p.getWorkingTreeDiffInformation)(e);if(!t)return;const i=(0,p.toLineChanges)(t);this.logger.trace(`[CommandCenter][revertSelectedRanges] diffInformation: ${JSON.stringify(t)}`),this.logger.trace(`[CommandCenter][revertSelectedRanges] diffInformation changes: ${JSON.stringify(i)}`);const r=e.document,o=e.selections,n=i.filter(e=>{const t=(0,p.getModifiedRange)(r,e);return o.every(e=>!e.intersection(t))});if(n.length===i.length)return void h.window.showInformationMessage(h.l10n.t("The selection range does not contain any changes."));this.logger.trace(`[CommandCenter][revertSelectedRanges] selectedChanges: ${JSON.stringify(n)}`);const s=e.selections;await this._revertChanges(e,n),e.selections=s}async _revertChanges(e,t){const i=e.document,r=i.uri;if("file"!==r.scheme)return;const o=(0,m.toGitUri)(r,"~"),n=await h.workspace.openTextDocument(o),s=e.visibleRanges,a=(0,p.applyLineChanges)(n,i,t),l=new h.WorkspaceEdit;l.replace(r,new h.Range(new h.Position(0,0),i.lineAt(i.lineCount-1).range.end),a),h.workspace.applyEdit(l),await i.save(),e.revealRange(s[0])}async unstage(...e){if(0===(e=e.filter(e=>!!e)).length||e[0]&&!(e[0].resourceUri instanceof h.Uri)){const t=this.getSCMResource();if(!t)return;e=[t]}const t=e.filter(e=>e instanceof d.Resource&&1===e.resourceGroupType);if(!t.length)return;const i=t.map(e=>e.resourceUri);await this.runByRepository(i,async(e,t)=>e.revert(t))}async unstageAll(e){await e.revert([])}async unstageSelectedRanges(){const e=h.window.activeTextEditor;if(!e)return;const t=e.document,i=t.uri,r=this.model.getRepository(i);if(!r)return;const o=r.indexGroup.resourceStates.find(e=>(0,g.pathEquals)(e.resourceUri.fsPath,i.fsPath));if(!o)return;const n=(0,p.getIndexDiffInformation)(e);if(!n)return;const s=(0,p.toLineChanges)(n);this.logger.trace(`[CommandCenter][unstageSelectedRanges] diffInformation: ${JSON.stringify(n)}`),this.logger.trace(`[CommandCenter][unstageSelectedRanges] diffInformation changes: ${JSON.stringify(s)}`);const a=(0,m.toGitUri)(o.original,"HEAD"),l=await h.workspace.openTextDocument(a),c=(0,p.toLineRanges)(e.selections,t),u=s.map(e=>c.reduce((i,r)=>i||(0,p.intersectDiffWithRange)(t,e,r),null)).filter(e=>!!e);if(!u.length)return void h.window.showInformationMessage(h.l10n.t("The selection range does not contain any changes."));this.logger.trace(`[CommandCenter][unstageSelectedRanges] selectedDiffs: ${JSON.stringify(u)}`);const d=u.map(p.invertLineChange);this.logger.trace(`[CommandCenter][unstageSelectedRanges] selectedDiffsInverted: ${JSON.stringify(d)}`);const f=(0,p.applyLineChanges)(t,l,d);await r.stage(t.uri,f,t.encoding)}async unstageFile(e){if(!(e=e??h.window.activeTextEditor?.document.uri))return;const t=this.model.getRepository(e);if(!t)return;const i=t.indexGroup.resourceStates.filter(t=>t.multiFileDiffEditorModifiedUri?.toString()===e.toString()).map(e=>e.resourceUri);0!==i.length&&await t.revert(i)}async unstageChange(e,t,i){if(!e)return;const r=h.window.visibleTextEditors.filter(t=>t.document.uri.toString()===e.toString())[0];r&&await this._unstageChanges(r,[t[i]])}async _unstageChanges(e,t){const i=e.document,r=i.uri;if("file"!==r.scheme)return;const o=(0,p.getWorkingTreeDiffInformation)(e);if(!o)return;const n=(0,p.toLineChanges)(o).map(p.invertLineChange),s=[...t.map(p.invertLineChange),...n].sort(p.compareLineChanges),a=(0,m.toGitUri)(r,"HEAD"),l=await h.workspace.openTextDocument(a),c=(0,p.applyLineChanges)(i,l,s);await this.runByRepository(r,async(e,t)=>await e.stage(t,c,i.encoding))}async clean(...e){const t=new Set;if(0===(e=e.filter(e=>void 0!==e&&!t.has(e.resourceUri.toString())&&(t.add(e.resourceUri.toString()),!0))).length||e[0]&&!(e[0].resourceUri instanceof h.Uri)){const t=this.getSCMResource();if(!t)return;e=[t]}const i=e.filter(e=>e instanceof d.Resource&&(2===e.resourceGroupType||3===e.resourceGroupType));i.length&&await this._cleanAll(i)}async cleanAll(e){await this._cleanAll(e.workingTreeGroup.resourceStates)}async cleanAllTracked(e){const t=e.workingTreeGroup.resourceStates.filter(e=>7!==e.type&&8!==e.type);0!==t.length&&await this._cleanTrackedChanges(t)}async cleanAllUntracked(e){const t=[...e.workingTreeGroup.resourceStates,...e.untrackedGroup.resourceStates].filter(e=>7===e.type||8===e.type);0!==t.length&&await this._cleanUntrackedChanges(t)}async _cleanAll(e){if(0===e.length)return;const t=e.filter(e=>7!==e.type&&8!==e.type),i=e.filter(e=>7===e.type||8===e.type);if(0===i.length)await this._cleanTrackedChanges(e);else if(0===t.length)await this._cleanUntrackedChanges(e);else{const[r,o]=this.getDiscardUntrackedChangesDialogDetails(i),n=1===t.length?h.l10n.t("\n\nAre you sure you want to discard changes in '{0}'?",c.basename(t[0].resourceUri.fsPath)):h.l10n.t("\n\nAre you sure you want to discard ALL changes in {0} files?",t.length),s=1===t.length?h.l10n.t("Discard 1 Tracked File"):h.l10n.t("Discard All {0} Tracked Files",t.length),a=h.l10n.t("Discard All {0} Files",e.length),l=await h.window.showWarningMessage(`${r} ${o}${n}\n\nThis is IRREVERSIBLE!\nYour current working set will be FOREVER LOST if you proceed.`,{modal:!0},s,a);if(l===s)e=t;else if(l!==a)return;const u=e.map(e=>e.resourceUri);await this.runByRepository(u,async(e,t)=>e.clean(t))}}async _cleanTrackedChanges(e){const t=e.every(e=>6===e.type),i=t?1===e.length?h.l10n.t("Are you sure you want to restore '{0}'?",c.basename(e[0].resourceUri.fsPath)):h.l10n.t("Are you sure you want to restore ALL {0} files?",e.length):1===e.length?h.l10n.t("Are you sure you want to discard changes in '{0}'?",c.basename(e[0].resourceUri.fsPath)):h.l10n.t("Are you sure you want to discard ALL changes in {0} files?\n\nThis is IRREVERSIBLE!\nYour current working set will be FOREVER LOST if you proceed.",e.length),r=t?1===e.length?h.l10n.t("Restore File"):h.l10n.t("Restore All {0} Files",e.length):1===e.length?h.l10n.t("Discard File"):h.l10n.t("Discard All {0} Files",e.length);if(await h.window.showWarningMessage(i,{modal:!0},r)!==r)return;const o=e.map(e=>e.resourceUri);await this.runByRepository(o,async(e,t)=>e.clean(t))}async _cleanUntrackedChanges(e){const[t,i,r]=this.getDiscardUntrackedChangesDialogDetails(e);if(await h.window.showWarningMessage(t,{detail:i,modal:!0},r)!==r)return;const o=e.map(e=>e.resourceUri);await this.runByRepository(o,async(e,t)=>e.clean(t))}getDiscardUntrackedChangesDialogDetails(e){const t=h.workspace.getConfiguration("git").get("discardUntrackedChangesToTrash",!0)&&!g.isRemote&&!g.isLinuxSnap,i=t?"":1===e.length?"\n\n"+h.l10n.t("This is IRREVERSIBLE!\nThis file will be FOREVER LOST if you proceed."):"\n\n"+h.l10n.t("This is IRREVERSIBLE!\nThese files will be FOREVER LOST if you proceed.");return[1===e.length?h.l10n.t("Are you sure you want to DELETE the following untracked file: '{0}'?{1}",c.basename(e[0].resourceUri.fsPath),i):h.l10n.t("Are you sure you want to DELETE the {0} untracked files?{1}",e.length,i),t?g.isWindows?1===e.length?h.l10n.t("You can restore this file from the Recycle Bin."):h.l10n.t("You can restore these files from the Recycle Bin."):1===e.length?h.l10n.t("You can restore this file from the Trash."):h.l10n.t("You can restore these files from the Trash."):"",t?g.isWindows?h.l10n.t("Move to Recycle Bin"):h.l10n.t("Move to Trash"):1===e.length?h.l10n.t("Delete File"):h.l10n.t("Delete All {0} Files",e.length)]}async smartCommit(e,t,i){const r=h.workspace.getConfiguration("git",h.Uri.file(e.root));let o=r.get("promptToSaveFilesBeforeCommit");!0===o?o="always":!1===o&&(o="never");let n=!0===r.get("enableSmartCommit");const s=!0===r.get("enableCommitSigning");let a=0===e.indexGroup.resourceStates.length,l=0===e.workingTreeGroup.resourceStates.length;if(!i.empty){if("never"!==o){let t=h.workspace.textDocuments.filter(t=>!t.isUntitled&&t.isDirty&&(0,g.isDescendant)(e.root,t.uri.fsPath));if(("staged"===o||e.indexGroup.resourceStates.length>0)&&(t=t.filter(t=>e.indexGroup.resourceStates.some(e=>(0,g.pathEquals)(e.resourceUri.fsPath,t.uri.fsPath)))),t.length>0){const i=1===t.length?h.l10n.t("The following file has unsaved changes which won't be included in the commit if you proceed: {0}.\n\nWould you like to save it before committing?",c.basename(t[0].uri.fsPath)):h.l10n.t("There are {0} unsaved files.\n\nWould you like to save them before committing?",t.length),r=h.l10n.t("Save All & Commit Changes"),o=h.l10n.t("Commit Changes"),n=await h.window.showWarningMessage(i,{modal:!0},r,o);if(n===r)await Promise.all(t.map(e=>e.save())),t=t.filter(t=>e.indexGroup.resourceStates.some(e=>(0,g.pathEquals)(e.resourceUri.fsPath,t.uri.fsPath))),await e.add(t.map(e=>e.uri)),a=0===e.indexGroup.resourceStates.length,l=0===e.workingTreeGroup.resourceStates.length;else if(n!==o)return}}if(!l&&a&&!n&&!i.all&&!i.amend){if(!0!==r.get("suggestSmartCommit"))return;const e=h.l10n.t("There are no staged changes to commit.\n\nWould you like to stage all your changes and commit them directly?"),t=h.l10n.t("Yes"),i=h.l10n.t("Always"),o=h.l10n.t("Never"),s=await h.window.showWarningMessage(e,{modal:!0},t,i,o);if(s===i)n=!0,r.update("enableSmartCommit",!0,!0);else{if(s===o)return void r.update("suggestSmartCommit",!1,!0);if(s!==t)return;n=!0}}n&&!i.all&&(i={...i,all:a})}i.signCommit=s,r.get("alwaysSignOff")&&(i.signoff=!0),r.get("useEditorAsCommitInput")&&(i.useEditor=!0,r.get("verboseCommit")&&(i.verbose=!0));const u=r.get("smartCommitChanges");if((a&&l||!i.all&&a||a&&"tracked"===u&&e.workingTreeGroup.resourceStates.every(e=>7===e.type))&&!i.amend&&!i.empty&&!e.mergeInProgress&&void 0===e.rebaseCommit){const e=h.l10n.t("Create Empty Commit");if(await h.window.showInformationMessage(h.l10n.t("There are no changes to commit."),e)!==e)return;i.empty=!0}if(i.noVerify){if(!r.get("allowNoVerifyCommit"))return void await h.window.showErrorMessage(h.l10n.t('Commits without verification are not allowed, please enable them with the "git.allowNoVerifyCommit" setting.'));if(r.get("confirmNoVerifyCommit")){const e=h.l10n.t("You are about to commit your changes without verification, this skips pre-commit hooks and can be undesirable.\n\nAre you sure to continue?"),t=h.l10n.t("OK"),i=h.l10n.t("OK, Don't Ask Again"),o=await h.window.showWarningMessage(e,{modal:!0},t,i);if(o===i)r.update("confirmNoVerifyCommit",!1,!0);else if(o!==t)return}}const d=await t();if(!d&&!i.amend&&!i.useEditor)return;i.all&&"tracked"===u&&(i.all="tracked"),i.all&&"mixed"!==r.get("untrackedChanges")&&(i.all="tracked");const p=await async function(e,t){const i=h.workspace.getConfiguration("git",h.Uri.file(e.root)),r=!0===i.get("diagnosticsCommitHook.enabled",!1),o=i.get("diagnosticsCommitHook.sources",{"*":"error"});if(!r)return!0;const n=[];e.indexGroup.resourceStates.length>0?n.push(...e.indexGroup.resourceStates.map(e=>e.resourceUri)):"tracked"===t.all?n.push(...e.workingTreeGroup.resourceStates.filter(e=>7!==e.type&&8!==e.type).map(e=>e.resourceUri)):(n.push(...e.workingTreeGroup.resourceStates.map(e=>e.resourceUri)),n.push(...e.untrackedGroup.resourceStates.map(e=>e.resourceUri)));const s=new Map;for(const e of n){const t=h.languages.getDiagnostics(e).filter(e=>!(!e.source||Object.keys(o).includes(e.source)&&"none"===o[e.source]||!(Object.keys(o).includes(e.source)&&e.severity<=(0,g.toDiagnosticSeverity)(o[e.source]))&&!(Object.keys(o).includes("*")&&e.severity<=(0,g.toDiagnosticSeverity)(o["*"]))));t.length>0&&s.set(e,t.length)}if(0===s.size)return!0;const a=h.l10n.t("Commit Anyway"),l=h.l10n.t("View Problems"),u=1===s.size?h.l10n.t("The following file has unresolved diagnostics: '{0}'.\n\nHow would you like to proceed?",c.basename(s.keys().next().value.fsPath)):h.l10n.t("There are {0} files that have unresolved diagnostics.\n\nHow would you like to proceed?",s.size),d=await h.window.showWarningMessage(u,{modal:!0},a,l);return d===a||(d===l&&h.commands.executeCommand("workbench.panel.markers.view.focus"),!1)}(e,i);if(!p)return;const m=r.get("branchProtectionPrompt");if(e.isBranchProtected()&&("alwaysPrompt"===m||"alwaysCommitToNewBranch"===m)){const t=h.l10n.t("Commit to a New Branch");let i=t;if("alwaysPrompt"===m){const e=h.l10n.t("You are trying to commit to a protected branch and you might not have permission to push your commits to the remote.\n\nHow would you like to proceed?"),r=h.l10n.t("Commit Anyway");i=await h.window.showWarningMessage(e,{modal:!0},t,r)}if(!i)return;if(i===t){const t=await this.promptForBranchName(e);if(!t)return;await e.branch(t,!0)}}await e.commit(d,i)}async commitWithAnyInput(e,t){const i=e.inputBox.value,r=h.Uri.file(e.root),o=h.workspace.getConfiguration("git",r);await this.smartCommit(e,async()=>{let r=i;if(!r&&!o.get("useEditorAsCommitInput")){const i=void 0;if(t&&t.amend&&e.HEAD&&e.HEAD.commit)return;const o=e.headShortName;let n;n=o?h.l10n.t('Message (commit on "{0}")',o):h.l10n.t("Commit message"),r=await h.window.showInputBox({value:i,placeHolder:n,prompt:h.l10n.t("Please provide a commit message"),ignoreFocusOut:!0})}return r},t)}async commit(e,t){await this.commitWithAnyInput(e,{postCommitCommand:t})}async commitAmend(e){await this.commitWithAnyInput(e,{amend:!0})}async commitSigned(e){await this.commitWithAnyInput(e,{signoff:!0})}async commitStaged(e){await this.commitWithAnyInput(e,{all:!1})}async commitStagedSigned(e){await this.commitWithAnyInput(e,{all:!1,signoff:!0})}async commitStagedAmend(e){await this.commitWithAnyInput(e,{all:!1,amend:!0})}async commitAll(e){await this.commitWithAnyInput(e,{all:!0})}async commitAllSigned(e){await this.commitWithAnyInput(e,{all:!0,signoff:!0})}async commitAllAmend(e){await this.commitWithAnyInput(e,{all:!0,amend:!0})}async commitMessageAccept(e){(e||h.window.activeTextEditor)&&(e??(e=h.window.activeTextEditor.document.uri),this._closeEditorTab(e))}async commitMessageDiscard(e){if(!e&&!h.window.activeTextEditor)return;e??(e=h.window.activeTextEditor.document.uri);const t=h.window.visibleTextEditors.filter(t=>"git-commit"===t.document.languageId&&t.document.uri.toString()===e.toString());if(1!==t.length)return;const i=t[0],r=i.document;await i.edit(e=>{const t=r.lineAt(0),i=r.lineAt(r.lineCount-1);e.delete(new h.Range(t.range.start,i.range.end))})&&await r.save()&&this._closeEditorTab(e)}_closeEditorTab(e){const t=h.window.tabGroups.all.map(e=>e.tabs).flat().filter(t=>t.input instanceof h.TabInputText&&t.input.uri.toString()===e.toString());h.window.tabGroups.close(t)}async _commitEmpty(e,t){const i=h.Uri.file(e.root),r=h.workspace.getConfiguration("git",i);if(!0===r.get("confirmEmptyCommits")){const e=h.l10n.t("Are you sure you want to create an empty commit?"),t=h.l10n.t("Yes"),i=h.l10n.t("Yes, Don't Show Again"),o=await h.window.showWarningMessage(e,{modal:!0},t,i);if(o===i)await r.update("confirmEmptyCommits",!1,!0);else if(o!==t)return}await this.commitWithAnyInput(e,{empty:!0,noVerify:t})}async commitEmpty(e){await this._commitEmpty(e)}async commitNoVerify(e){await this.commitWithAnyInput(e,{noVerify:!0})}async commitStagedNoVerify(e){await this.commitWithAnyInput(e,{all:!1,noVerify:!0})}async commitStagedSignedNoVerify(e){await this.commitWithAnyInput(e,{all:!1,signoff:!0,noVerify:!0})}async commitAmendNoVerify(e){await this.commitWithAnyInput(e,{amend:!0,noVerify:!0})}async commitSignedNoVerify(e){await this.commitWithAnyInput(e,{signoff:!0,noVerify:!0})}async commitStagedAmendNoVerify(e){await this.commitWithAnyInput(e,{all:!1,amend:!0,noVerify:!0})}async commitAllNoVerify(e){await this.commitWithAnyInput(e,{all:!0,noVerify:!0})}async commitAllSignedNoVerify(e){await this.commitWithAnyInput(e,{all:!0,signoff:!0,noVerify:!0})}async commitAllAmendNoVerify(e){await this.commitWithAnyInput(e,{all:!0,amend:!0,noVerify:!0})}async commitEmptyNoVerify(e){await this._commitEmpty(e,!0)}async restoreCommitTemplate(e){e.inputBox.value=await e.getCommitTemplate()}async undoCommit(e){const t=e.HEAD;if(!t||!t.commit)return void h.window.showWarningMessage(h.l10n.t("Can't undo because HEAD doesn't point to any commit."));const i=await e.getCommit("HEAD");if(i.parents.length>1){const e=h.l10n.t("Undo merge commit");if(await h.window.showWarningMessage(h.l10n.t("The last commit was a merge commit. Are you sure you want to undo it?"),{modal:!0},e)!==e)return}i.parents.length>0?await e.reset("HEAD~"):(await e.deleteRef("HEAD"),await this.unstageAll(e)),e.inputBox.value=i.message}async checkout(e,t){return this._checkout(e,{treeish:t})}async checkout2(e,t,i){const r=t?.references?.find(e=>e.id===i);if(!r)return;const o=!0===h.workspace.getConfiguration("git",h.Uri.file(e.root)).get("pullBeforeCheckout",!1);if(r.id.startsWith("refs/heads/")||r.id.startsWith("refs/tags/"))return void await e.checkout(r.name,{pullBeforeCheckout:o});const n=await e.findTrackingBranches(r.name);n.length>0?await e.checkout(n[0].name,{pullBeforeCheckout:o}):await e.checkoutTracking(r.name)}async checkoutDetached(e,t){return this._checkout(e,{detached:!0,treeish:t})}async checkoutDetached2(e,t){return!!t&&this._checkout(e,{detached:!0,treeish:t.id})}async _checkout(e,t){if("string"==typeof t?.treeish)return await e.checkout(t?.treeish,t),!0;const i=new C,r=new v,o=new k,n=[],s=[];t?.detached||s.push(i,r,o);const a=[],l=h.window.createQuickPick();l.busy=!0,l.sortByLabel=!1,l.matchOnDetail=!1,l.placeholder=t?.detached?h.l10n.t("Select a branch to checkout in detached mode"):h.l10n.t("Select a branch or tag to checkout"),l.show(),n.push(...await async function(e,t=!1){const i=h.workspace.getConfiguration("git"),r=i.get("checkoutType"),o=!0===i.get("showReferenceDetails");let n;n="all"!==r&&r&&0!==r.length?"string"==typeof r?[r]:r:["local","remote","tags"],t&&(n=n.filter(e=>"tags"!==e));const s=await e.getRefs({includeCommitDetails:o}),a=n.map(t=>function(e,t){switch(t){case"local":return new q(e);case"remote":return new z(1,P);case"tags":return new z(2,x);default:return}}(e,t)).filter(e=>!!e),l=await async function(e){const t=new Map,i=async e=>(await(0,w.getRemoteSourceActions)(e)).map(e=>({iconPath:new h.ThemeIcon(e.icon),tooltip:e.label,actual:e}));for(const r of e.remotes){if(r.fetchUrl){const e=t.get(r.fetchUrl)??[];e.push(...await i(r.fetchUrl)),t.set(r.fetchUrl,e)}if(r.pushUrl&&r.pushUrl!==r.fetchUrl){const e=t.get(r.pushUrl)??[];e.push(...await i(r.pushUrl)),t.set(r.pushUrl,e)}}return t}(e);return new Y(e,a,l,t).processRefs(s)}(e,t?.detached));const c=()=>{switch(!0){case""===l.value:l.items=[...s,...n];break;case 0===s.length:l.items=n;break;case 0===n.length:l.items=s;break;default:l.items=[...n,{label:"",kind:h.QuickPickItemKind.Separator},...s]}};c(),l.busy=!1;const u=await new Promise(e=>{a.push(l.onDidHide(()=>e(void 0))),a.push(l.onDidAccept(()=>e(l.activeItems[0]))),a.push(l.onDidTriggerItemButton(t=>{const i=t.button,r=t.item;i.actual&&r.refName&&i.actual.run(r.refRemote?r.refName.substring(r.refRemote.length+1):r.refName),e(void 0)})),a.push(l.onDidChangeValue(()=>c()))});if((0,g.dispose)(a),l.dispose(),!u)return!1;if(u===i)await this._branch(e,l.value);else if(u===r)await this._branch(e,l.value,!0);else{if(u===o)return this._checkout(e,{detached:!0});{const i=u;try{await i.run(e,t)}catch(r){if("DirtyWorkTree"!==r.gitErrorCode&&"WorktreeBranchAlreadyUsed"!==r.gitErrorCode)throw r;if("WorktreeBranchAlreadyUsed"===r.gitErrorCode)return this.handleWorktreeBranchAlreadyUsed(r),!1;const o=h.l10n.t("Stash & Checkout"),n=h.l10n.t("Migrate Changes"),s=h.l10n.t("Force Checkout"),a=await h.window.showWarningMessage(h.l10n.t("Your local changes would be overwritten by checkout."),{modal:!0},o,n,s);a===s?(await this.cleanAll(e),await i.run(e,t)):a!==o&&a!==n||await this._stash(e,!0)&&(await i.run(e,t),a===n&&await this.stashPopLatest(e))}}}return!0}async branch(e,t){await this._branch(e,void 0,!1,t?.id)}async branchFrom(e){await this._branch(e,void 0,!0)}async generateRandomBranchName(e,t){const i=h.workspace.getConfiguration("git").get("branchRandomName.dictionary"),r=[];for(const e of i)"adjectives"===e.toLowerCase()&&r.push(u.adjectives),"animals"===e.toLowerCase()&&r.push(u.animals),"colors"===e.toLowerCase()&&r.push(u.colors),"numbers"===e.toLowerCase()&&r.push(u.NumberDictionary.generate({length:3}));if(0===r.length)return"";for(let i=0;i<5;i++){const i=(0,u.uniqueNamesGenerator)({dictionaries:r,length:r.length,separator:t});if(0===(await e.getRefs({pattern:`refs/heads/${i}`})).length)return i}return""}async promptForBranchName(e,t,i){const r=h.workspace.getConfiguration("git"),o=r.get("branchPrefix"),n=r.get("branchWhitespaceChar"),s=r.get("branchValidationRegex"),a=r.get("branchRandomName.enable",!1),l=await e.getRefs({pattern:"refs/heads"});if(t)return Z(t,n);const c=async()=>{const t=a?await this.generateRandomBranchName(e,n):"";return`${o}${t}`},u=e=>e.startsWith(o)?[o.length,e.length]:void 0,d=e=>{const t=new RegExp(s),i=Z(e,n);return l.find(e=>e.name===i)?h.l10n.t('Branch "{0}" already exists',i):t.test(i)?e===i?void 0:{message:h.l10n.t('The new branch will be "{0}"',i),severity:h.InputBoxValidationSeverity.Info}:h.l10n.t("Branch name needs to match regex: {0}",s)},p=[],m=h.window.createInputBox();m.placeholder=h.l10n.t("Branch name"),m.prompt=h.l10n.t("Please provide a new branch name"),m.buttons=a?[{iconPath:new h.ThemeIcon("refresh"),tooltip:h.l10n.t("Regenerate Branch Name"),location:h.QuickInputButtonLocation.Inline}]:[],m.value=i??await c(),m.valueSelection=u(m.value),m.validationMessage=d(m.value),m.ignoreFocusOut=!0,m.show();const f=await new Promise(e=>{p.push(m.onDidHide(()=>e(void 0))),p.push(m.onDidAccept(()=>e(m.value))),p.push(m.onDidChangeValue(e=>{m.validationMessage=d(e)})),p.push(m.onDidTriggerButton(async()=>{m.value=await c(),m.valueSelection=u(m.value)}))});return(0,g.dispose)(p),m.dispose(),Z(f||"",n)}async _branch(e,t,i=!1,r){r=r??"HEAD";const o=h.workspace.getConfiguration("git"),n=!0===o.get("showReferenceDetails"),s=o.get("commitShortHashLength")??7;if(i){const t=async()=>{const t=await e.getRefs({includeCommitDetails:n}),i=new V(e,[new z(0),new z(1),new z(2)]);return[new H(e,s),...i.processRefs(t)]},i=h.l10n.t("Select a ref to create the branch from"),o=await h.window.showQuickPick(t(),{placeHolder:i});if(!o)return;o instanceof S&&o.refName&&(r=o.refName)}const a=await this.promptForBranchName(e,t);a&&await e.branch(a,!0,r)}async pickRef(e,t){const i=[],r=h.window.createQuickPick();r.placeholder=t,r.sortByLabel=!1,r.busy=!0,r.show(),r.items=await e,r.busy=!1;const o=await new Promise(e=>{i.push(r.onDidHide(()=>e(void 0))),i.push(r.onDidAccept(()=>e(r.activeItems[0])))});return(0,g.dispose)(i),r.dispose(),o}async deleteBranch(e,t,i){await this._deleteBranch(e,void 0,t,{remote:!1,force:i})}async deleteBranch2(e,t,i){const r=t?.references?.find(e=>e.id===i);if(!r)return;if(r.id.startsWith("refs/heads/"))return r.id===e.historyProvider.currentHistoryItemRef?.id?void h.window.showInformationMessage(h.l10n.t("The active branch cannot be deleted.")):void await this._deleteBranch(e,void 0,r.name,{remote:!1});if(r.id===e.historyProvider.currentHistoryItemRemoteRef?.id)return void h.window.showInformationMessage(h.l10n.t("The remote branch of the active branch cannot be deleted."));const o=r.name.indexOf("/");if(-1===o)return;const n=r.name.substring(0,o),s=r.name.substring(o+1);await this._deleteBranch(e,n,s,{remote:!0})}async deleteRemoteBranch(e){await this._deleteBranch(e,void 0,void 0,{remote:!0})}async _deleteBranch(e,t,i,r){let o;const n=!0===h.workspace.getConfiguration("git").get("showReferenceDetails");if(r.remote||"string"!=typeof i)if(r.remote&&"string"==typeof t&&"string"==typeof i)o=r=>e.deleteRemoteRef(t,i,{force:r});else{const t=async()=>{const t=r.remote?"refs/remotes":"refs/heads",i=await e.getRefs({pattern:t,includeCommitDetails:n}),o=r.remote?[new z(1,T)]:[new z(0,T)];return new V(e,o,{skipCurrentBranch:!0,skipCurrentBranchRemote:!0}).processRefs(i)},s=r.remote?h.l10n.t("Select a remote branch to delete"):h.l10n.t("Select a branch to delete"),a=await this.pickRef(t(),s);if(!(a instanceof T&&a.refName))return;i=a.refName,o=t=>a.run(e,t)}else o=t=>e.deleteBranch(i,t);try{await o(r.force)}catch(e){if("BranchNotFullyMerged"!==e.gitErrorCode)throw e;const t=h.l10n.t('The branch "{0}" is not fully merged. Delete anyway?',i),r=h.l10n.t("Delete Branch");await h.window.showWarningMessage(t,{modal:!0},r)===r&&await o(!0)}}async renameBranch(e){const t=e.HEAD&&e.HEAD.name,i=await this.promptForBranchName(e,void 0,t);if(i)try{await e.renameBranch(i)}catch(e){switch(e.gitErrorCode){case"InvalidBranchName":return void h.window.showErrorMessage(h.l10n.t("Invalid branch name"));case"BranchAlreadyExists":return void h.window.showErrorMessage(h.l10n.t('A branch named "{0}" already exists',i));default:throw e}}}async merge(e){const t=!0===h.workspace.getConfiguration("git").get("showReferenceDetails"),i=h.l10n.t("Select a branch or tag to merge from"),r=await this.pickRef((async()=>{const i=await e.getRefs({includeCommitDetails:t});return new V(e,[new z(0,O),new z(1,O),new z(2,O)],{skipCurrentBranch:!0,skipCurrentBranchRemote:!0}).processRefs(i)})(),i);r instanceof O&&await r.run(e)}async abortMerge(e){await e.mergeAbort()}async rebase(e){const t=h.workspace.getConfiguration("git"),i=!0===t.get("showReferenceDetails"),r=t.get("commitShortHashLength")??7,o=h.l10n.t("Select a branch to rebase onto"),n=await this.pickRef((async()=>{const t=await e.getRefs({includeCommitDetails:i}),o=new V(e,[new z(0,L),new z(1,L)],{skipCurrentBranch:!0,skipCurrentBranchRemote:!0}).processRefs(t);if(e.HEAD?.upstream){const i=t.find(t=>1===t.type&&t.name===`${e.HEAD.upstream.remote}/${e.HEAD.upstream.name}`);i&&o.splice(0,0,new G(i,r))}return o})(),o);n instanceof L&&await n.run(e)}async createTag(e,t){const i=await h.window.showInputBox({placeHolder:h.l10n.t("Tag name"),prompt:h.l10n.t("Please provide a tag name"),ignoreFocusOut:!0});if(!i)return;const r=await h.window.showInputBox({placeHolder:h.l10n.t("Message"),prompt:h.l10n.t("Please provide a message to annotate the tag"),ignoreFocusOut:!0}),o=i.replace(/^\.|\/\.|\.\.|~|\^|:|\/$|\.lock$|\.lock\/|\\|\*|\s|^\s*$|\.$/g,"-");await e.tag({name:o,message:r,ref:t?.id})}async deleteTag(e){const t=h.workspace.getConfiguration("git"),i=!0===t.get("showReferenceDetails"),r=t.get("commitShortHashLength")??7,o=h.l10n.t("Select a tag to delete"),n=await this.pickRef((async()=>{const t=await e.getRefs({pattern:"refs/tags",includeCommitDetails:i});return 0===t.length?[{label:h.l10n.t("$(info) This repository has no tags.")}]:t.map(e=>new M(e,r))})(),o);n instanceof M&&await n.run(e)}async createWorktree(e){if((e=this.model.getRepository(e))||1===this.model.repositories.length&&(e=this.model.repositories[0]),!e){const t=this.model.repositories.filter(e=>"repository"===e.kind||"submodule"===e.kind);1===t.length&&(e=t[0])}e||(e=await this.model.pickRepository(["repository","submodule"])),e&&await this._createWorktree(e)}async _createWorktree(e){const t=h.workspace.getConfiguration("git"),i=t.get("branchPrefix"),r=!0===t.get("showReferenceDetails"),o=new C,n=h.l10n.t("Select a branch to create the new worktree from"),s=await this.pickRef((async()=>{const t=await e.getRefs({includeCommitDetails:r}),i=new V(e,[new z(0),new z(1),new z(2)]).processRefs(t);return[o,{label:"",kind:h.QuickPickItemKind.Separator},...i]})(),n);if(!s)return;let a,l;if(s===o){if(a=await this.promptForBranchName(e),!a)return;l="HEAD"}else{if(!(s instanceof S&&s.refName))return;if(s.refName===e.HEAD?.name){const t=h.l10n.t('Branch "{0}" is already checked out in the current repository.',s.refName),i=h.l10n.t("Create New Branch");if(await h.window.showWarningMessage(t,{modal:!0},i)!==i)return;if(a=await this.promptForBranchName(e),!a)return;l="HEAD"}else{const t=e.worktrees.find(e=>e.ref===s.refId);if(t){const e=h.l10n.t('Branch "{0}" is already checked out in the worktree at "{1}".',s.refName,t.path);return void await this.handleWorktreeConflict(t.path,e)}l=s.refName}}const u=(a??l).startsWith(i)?(a??l).substring(i.length).replace(/\//g,"-"):(a??l).replace(/\//g,"-"),d=async()=>{const t=this.globalState.get(`${re.WORKTREE_ROOT_KEY}:${e.root}`),i=t?h.Uri.file(t):h.Uri.file(c.dirname(e.root)),r=await h.window.showOpenDialog({defaultUri:i,canSelectFiles:!1,canSelectFolders:!0,canSelectMany:!1,openLabel:h.l10n.t("Select as Worktree Destination")});if(r&&0!==r.length)return c.join(r[0].fsPath,u)},p=e=>{if(e&&u)return[e.length-u.length,e.length]},m=t=>e.worktrees.find(e=>(0,g.pathEquals)(c.normalize(e.path),c.normalize(t)))?{message:h.l10n.t('A worktree already exists at "{0}".',t),severity:h.InputBoxValidationSeverity.Warning}:void 0,f=this.globalState.get(`${re.WORKTREE_ROOT_KEY}:${e.root}`),y=f?c.join(f,u):c.join(c.dirname(e.root),`${c.basename(e.root)}.worktrees`,u),w=[],b=h.window.createInputBox();w.push(b),b.placeholder=h.l10n.t("Worktree path"),b.prompt=h.l10n.t("Please provide a worktree path"),b.value=y,b.valueSelection=p(b.value),b.validationMessage=m(b.value),b.ignoreFocusOut=!0,b.buttons=[{iconPath:new h.ThemeIcon("folder"),tooltip:h.l10n.t("Select Worktree Destination"),location:h.QuickInputButtonLocation.Inline}],b.show();const v=await new Promise(e=>{w.push(b.onDidHide(()=>e(void 0))),w.push(b.onDidAccept(()=>e(b.value))),w.push(b.onDidChangeValue(e=>{b.validationMessage=m(e)})),w.push(b.onDidTriggerButton(async()=>{b.value=await d()??"",b.valueSelection=p(b.value)}))});if((0,g.dispose)(w),v)try{await e.addWorktree({path:v,branch:a,commitish:l});const t=c.dirname(v);t!==f&&this.globalState.update(`${re.WORKTREE_ROOT_KEY}:${e.root}`,t)}catch(e){if("WorktreeAlreadyExists"===e.gitErrorCode)await this.handleWorktreeAlreadyExists(e);else{if("WorktreeBranchAlreadyUsed"!==e.gitErrorCode)throw e;await this.handleWorktreeBranchAlreadyUsed(e)}return}}async handleWorktreeBranchAlreadyUsed(e){const t=e.stderr.match(/fatal: '([^']+)' is already used by worktree at '([^']+)'/);if(!t)return;const[,i,r]=t,o=h.l10n.t('Branch "{0}" is already checked out in the worktree at "{1}".',i,r);await this.handleWorktreeConflict(r,o)}async handleWorktreeAlreadyExists(e){const t=e.stderr.match(/fatal: '([^']+)'/);if(!t)return;const[,i]=t,r=h.l10n.t('A worktree already exists at "{0}".',i);await this.handleWorktreeConflict(i,r)}async handleWorktreeConflict(e,t){await this.model.openRepository(e,!0);const i=this.model.getRepository(e);if(!i)return;const r=h.l10n.t("Open Worktree in Current Window"),o=h.l10n.t("Open Worktree in New Window"),n=await h.window.showWarningMessage(t,{modal:!0},r,o);n===r?await this.openWorktreeInCurrentWindow(i):n===o&&await this.openWorktreeInNewWindow(i)}async deleteWorktree(e){if(!e.dotGit.commonPath)return;const t=this.model.getRepository(c.dirname(e.dotGit.commonPath));if(t){this.model.disposeRepository(e);try{await t.deleteWorktree(e.root)}catch(i){if("WorktreeContainsChanges"===i.gitErrorCode){const i=h.l10n.t("Force Delete"),r=h.l10n.t("The worktree contains modified or untracked files. Do you want to force delete?");return void(await h.window.showWarningMessage(r,{modal:!0},i)===i?await t.deleteWorktree(e.root,{force:!0}):await this.model.openRepository(e.root))}throw i}}else await h.window.showErrorMessage(h.l10n.t("You cannot delete the worktree you are currently in. Please switch to the main repository first."),{modal:!0})}async deleteWorktreeFromPalette(e){const t=h.l10n.t("Select a worktree to delete"),i=await this.pickRef((async()=>{const t=await e.getWorktrees();return 0===t.length?[{label:h.l10n.t("$(info) This repository has no worktrees.")}]:t.map(e=>new B(e))})(),t);i instanceof B&&await i.run(e)}async openWorktreeInCurrentWindow(e){if(!e)return;const t=h.Uri.file(e.root);await h.commands.executeCommand("vscode.openFolder",t,{forceReuseWindow:!0})}async openWorktreeInNewWindow(e){if(!e)return;const t=h.Uri.file(e.root);await h.commands.executeCommand("vscode.openFolder",t,{forceNewWindow:!0})}async deleteTag2(e,t,i){const r=t?.references?.find(e=>e.id===i);r&&await e.deleteTag(r.name)}async deleteRemoteTag(e){const t=h.workspace.getConfiguration("git").get("commitShortHashLength")??7,i=e.remotes.filter(e=>void 0!==e.pushUrl).map(t=>new N(e,t));if(0===i.length)return void h.window.showErrorMessage(h.l10n.t("Your repository has no remotes configured to push to."));let r=i[0].remoteName;if(i.length>1){const e=h.l10n.t("Select a remote to delete a tag from"),t=await h.window.showQuickPick(i,{placeHolder:e});if(!t)return;r=t.remoteName}const o=h.l10n.t("Select a remote tag to delete"),n=await h.window.showQuickPick((async()=>{const i=await e.getRemoteRefs(r,{tags:!0}),o=new Set,n=[];for(const e of i){const t=(e.name??"").replace(/\^{}$/,"");o.has(t)||(n.push({...e,name:t}),o.add(t))}return 0===n.length?[{label:h.l10n.t('$(info) Remote "{0}" has no tags.',r)}]:n.map(e=>new I(e,t))})(),{placeHolder:o});n instanceof I&&await n.run(e,r)}async fetch(e){if(0===e.remotes.length)return void h.window.showWarningMessage(h.l10n.t("This repository has no remotes configured to fetch from."));if(1===e.remotes.length)return void await e.fetchDefault();const t=e.remotes.map(t=>new N(e,t));if(e.HEAD?.upstream?.remote){const i=t.findIndex(t=>t.remoteName===e.HEAD.upstream.remote);-1!==i&&t.splice(0,0,...t.splice(i,1))}const i=h.window.createQuickPick();i.placeholder=h.l10n.t("Select a remote to fetch"),i.canSelectMany=!1,i.items=[...t,{label:"",kind:h.QuickPickItemKind.Separator},new U(e)],i.show();const r=await new Promise(e=>{i.onDidAccept(()=>e(i.activeItems[0])),i.onDidHide(()=>e(void 0))});i.hide(),r&&await r.run()}async fetchPrune(e){0!==e.remotes.length?await e.fetchPrune():h.window.showWarningMessage(h.l10n.t("This repository has no remotes configured to fetch from."))}async fetchAll(e){0!==e.remotes.length?await e.fetchAll():h.window.showWarningMessage(h.l10n.t("This repository has no remotes configured to fetch from."))}async fetchRef(e,t){if(t=t??e?.historyProvider.currentHistoryItemRemoteRef?.id,!e||!t)return;const i=await e.getBranch(t);await e.fetch({remote:i.remote,ref:i.name})}async pullFrom(e){const t=h.workspace.getConfiguration("git").get("commitShortHashLength")??7,i=e.remotes;if(0===i.length)return void h.window.showWarningMessage(h.l10n.t("Your repository has no remotes configured to pull from."));let r=i[0].name;if(i.length>1){const e=i.filter(e=>void 0!==e.fetchUrl).map(e=>({label:e.name,description:e.fetchUrl})),t=h.l10n.t("Pick a remote to pull the branch from"),o=await h.window.showQuickPick(e,{placeHolder:t});if(!o)return;r=o.label}const o=h.l10n.t("Pick a branch to pull from"),n=await this.pickRef((async()=>(await e.getRefs({pattern:`refs/remotes/${r}/`})).map(e=>new S(e,t)))(),o);if(!n||!n.refName)return;const s=r.length;await e.pullFrom(!1,r,n.refName.slice(s+1))}async pull(e){0!==e.remotes.length?await e.pull(e.HEAD):h.window.showWarningMessage(h.l10n.t("Your repository has no remotes configured to pull from."))}async pullRebase(e){0!==e.remotes.length?await e.pullWithRebase(e.HEAD):h.window.showWarningMessage(h.l10n.t("Your repository has no remotes configured to pull from."))}async pullRef(e,t){if(t=t??e?.historyProvider.currentHistoryItemRemoteRef?.id,!e||!t)return;const i=await e.getBranch(t);await e.pullFrom(!1,i.remote,i.name)}async _push(e,t){const i=e.remotes;if(0===i.length){if(t.silent)return;const i=h.l10n.t("Add Remote");return void(await h.window.showWarningMessage(h.l10n.t("Your repository has no remotes configured to push to."),i)===i&&await this.addRemote(e))}const r=h.workspace.getConfiguration("git",h.Uri.file(e.root));let o;if(t.forcePush){if(!r.get("allowForcePush"))return void await h.window.showErrorMessage(h.l10n.t('Force push is not allowed, please enable it with the "git.allowForcePush" setting.'));const e=!0===r.get("useForcePushWithLease"),t=!0===r.get("useForcePushIfIncludes");if(o=e?t?2:1:0,r.get("confirmForcePush")){const e=h.l10n.t("You are about to force push your changes, this can be destructive and could inadvertently overwrite changes made by others.\n\nAre you sure to continue?"),t=h.l10n.t("OK"),i=h.l10n.t("OK, Don't Ask Again"),o=await h.window.showWarningMessage(e,{modal:!0},t,i);if(o===i)r.update("confirmForcePush",!1,!0);else if(o!==t)return}}if(t.pushType!==te.PushFollowTags)if(t.pushType===te.PushTags&&await e.pushTags(void 0,o),e.HEAD&&e.HEAD.name)if(t.pushType===te.Push)try{await e.push(e.HEAD,o)}catch(i){if("NoUpstreamBranch"!==i.gitErrorCode)throw i;if(t.silent)return;if(this.globalState.get("confirmBranchPublish",!0)){const t=e.HEAD.name,i=h.l10n.t('The branch "{0}" has no remote branch. Would you like to publish this branch?',t),r=h.l10n.t("OK"),o=h.l10n.t("OK, Don't Ask Again"),n=await h.window.showWarningMessage(i,{modal:!0},r,o);n!==r&&n!==o||(n===o&&this.globalState.update("confirmBranchPublish",!1),await this.publish(e))}else await this.publish(e)}else{const r=e.HEAD.name;if(t.pushTo?.remote)await e.pushTo(t.pushTo.remote,t.pushTo.refspec||r,t.pushTo.setUpstream,o);else{const t=new $(this),n=[...i.filter(e=>void 0!==e.pushUrl).map(e=>({label:e.name,description:e.pushUrl})),t],s=h.l10n.t('Pick a remote to publish the branch "{0}" to:',r),a=await h.window.showQuickPick(n,{placeHolder:s});if(!a)return;if(a===t){const t=await this.addRemote(e);t&&await e.pushTo(t,r,void 0,o)}else await e.pushTo(a.label,r,void 0,o)}}else t.silent||h.window.showWarningMessage(h.l10n.t("Please check out a branch to push to a remote."));else await e.pushFollowTags(void 0,o)}async push(e){await this._push(e,{pushType:te.Push})}async pushForce(e){await this._push(e,{pushType:te.Push,forcePush:!0})}async pushFollowTags(e){await this._push(e,{pushType:te.PushFollowTags})}async pushFollowTagsForce(e){await this._push(e,{pushType:te.PushFollowTags,forcePush:!0})}async pushRef(e){e&&await this._push(e,{pushType:te.Push})}async cherryPick(e){const t=await h.window.showInputBox({placeHolder:h.l10n.t("Commit Hash"),prompt:h.l10n.t("Please provide the commit hash"),ignoreFocusOut:!0});t&&await e.cherryPick(t)}async cherryPick2(e,t){t&&await e.cherryPick(t.id)}async cherryPickAbort(e){await e.cherryPickAbort()}async pushTo(e,t,i,r){await this._push(e,{pushType:te.PushTo,pushTo:{remote:t,refspec:i,setUpstream:r}})}async pushToForce(e,t,i,r){await this._push(e,{pushType:te.PushTo,pushTo:{remote:t,refspec:i,setUpstream:r},forcePush:!0})}async pushTags(e){await this._push(e,{pushType:te.PushTags})}async addRemote(e){const t=await(0,w.pickRemoteSource)({providerLabel:e=>h.l10n.t("Add remote from {0}",e.name),urlLabel:h.l10n.t("Add remote from URL")});if(!t)return;const i=await h.window.showInputBox({placeHolder:h.l10n.t("Remote name"),prompt:h.l10n.t("Please provide a remote name"),ignoreFocusOut:!0,validateInput:t=>ee(t)?e.remotes.find(e=>e.name===t)?h.l10n.t('Remote "{0}" already exists.',t):null:h.l10n.t("Remote name format invalid")}),r=ee(i||"");return r?(await e.addRemote(r,t.trim()),await e.fetch({remote:r}),r):void 0}async removeRemote(e){if(0===e.remotes.length)return void h.window.showErrorMessage(h.l10n.t("Your repository has no remotes."));const t=e.remotes.map(t=>new N(e,t)),i=h.l10n.t("Pick a remote to remove"),r=await h.window.showQuickPick(t,{placeHolder:i});r&&await e.removeRemote(r.remoteName)}async _sync(e,t){const i=e.HEAD;if(!i)return;if(!i.upstream)return void this._push(e,{pushType:te.Push});const r=i.remote||i.upstream.remote,o=e.remotes.find(e=>e.name===r),n=o&&o.isReadOnly,s=h.workspace.getConfiguration("git");if(!n&&!0===s.get("confirmSync")){const e=h.l10n.t('This action will pull and push commits from and to "{0}/{1}".',i.upstream.remote,i.upstream.name),t=h.l10n.t("OK"),r=h.l10n.t("OK, Don't Show Again"),o=await h.window.showWarningMessage(e,{modal:!0},t,r);if(o===r)await s.update("confirmSync",!1,!0);else if(o!==t)return}await e.sync(i,t)}async sync(e){const t=!0===h.workspace.getConfiguration("git",h.Uri.file(e.root)).get("rebaseWhenSync",!1);try{await this._sync(e,t)}catch(e){if(/Cancelled/i.test(e&&(e.message||e.stderr||"")))return;throw e}}async syncAll(){await Promise.all(this.model.repositories.map(async e=>{const t=!0===h.workspace.getConfiguration("git",h.Uri.file(e.root)).get("rebaseWhenSync",!1),i=e.HEAD;i&&i.upstream&&await e.sync(i,t)}))}async syncRebase(e){try{await this._sync(e,!0)}catch(e){if(/Cancelled/i.test(e&&(e.message||e.stderr||"")))return;throw e}}async publish(e){const t=e.HEAD&&e.HEAD.name||"",i=e.remotes;if(0===i.length){const i=this.model.getRemoteSourcePublishers();if(0===i.length)return void h.window.showWarningMessage(h.l10n.t("Your repository has no remotes configured to publish to."));let r;if(1===i.length)r=i[0];else{const e=i.map(e=>({label:(e.icon?`$(${e.icon}) `:"")+h.l10n.t("Publish to {0}",e.name),alwaysShow:!0,provider:e})),o=h.l10n.t('Pick a provider to publish the branch "{0}" to:',t),n=await h.window.showQuickPick(e,{placeHolder:o});if(!n)return;r=n.provider}return await r.publishRepository(new y.ApiRepository(e)),void this.model.firePublishEvent(e,t)}if(1===i.length)return await e.pushTo(i[0].name,t,!0),void this.model.firePublishEvent(e,t);const r=new $(this),o=[...e.remotes.map(e=>({label:e.name,description:e.pushUrl})),r],n=h.l10n.t('Pick a remote to publish the branch "{0}" to:',t),s=await h.window.showQuickPick(o,{placeHolder:n});if(s)if(s===r){const i=await this.addRemote(e);i&&(await e.pushTo(i,t,!0),this.model.firePublishEvent(e,t))}else await e.pushTo(s.label,t,!0),this.model.firePublishEvent(e,t)}async ignore(...e){if(0===(e=e.filter(e=>!!e)).length||e[0]&&!(e[0].resourceUri instanceof h.Uri)){const t=this.getSCMResource();if(!t)return;e=[t]}const t=e.filter(e=>e instanceof d.Resource).map(e=>e.resourceUri);t.length&&await this.runByRepository(t,async(e,t)=>e.ignore(t))}async revealInExplorer(e){e&&e.resourceUri instanceof h.Uri&&await h.commands.executeCommand("revealInExplorer",e.resourceUri)}async revealFileInOS(e){e&&e.resourceUri instanceof h.Uri&&await h.commands.executeCommand("revealFileInOS",e.resourceUri)}async _stash(e,t=!1,i=!1){const r=0===e.workingTreeGroup.resourceStates.length&&(!t||0===e.untrackedGroup.resourceStates.length),o=0===e.indexGroup.resourceStates.length;if(i){if(o)return h.window.showInformationMessage(h.l10n.t("There are no staged changes to stash.")),!1}else if(r&&o)return h.window.showInformationMessage(h.l10n.t("There are no changes to stash.")),!1;const n=h.workspace.getConfiguration("git",h.Uri.file(e.root)),s=n.get("promptToSaveFilesBeforeStash");if("never"!==s){let t=h.workspace.textDocuments.filter(t=>!t.isUntitled&&t.isDirty&&(0,g.isDescendant)(e.root,t.uri.fsPath));if(("staged"===s||e.indexGroup.resourceStates.length>0)&&(t=t.filter(t=>e.indexGroup.resourceStates.some(e=>(0,g.pathEquals)(e.resourceUri.fsPath,t.uri.fsPath)))),t.length>0){const e=1===t.length?h.l10n.t("The following file has unsaved changes which won't be included in the stash if you proceed: {0}.\n\nWould you like to save it before stashing?",c.basename(t[0].uri.fsPath)):h.l10n.t("There are {0} unsaved files.\n\nWould you like to save them before stashing?",t.length),i=h.l10n.t("Save All & Stash"),r=h.l10n.t("Stash Anyway"),o=await h.window.showWarningMessage(e,{modal:!0},i,r);if(o===i)await Promise.all(t.map(e=>e.save()));else if(o!==r)return!1}}let a;if(!n.get("useCommitInputAsStashMessage")||e.sourceControl.commitTemplate&&e.inputBox.value===e.sourceControl.commitTemplate||(a=e.inputBox.value),a=await h.window.showInputBox({value:a,prompt:h.l10n.t("Optionally provide a stash message"),placeHolder:h.l10n.t("Stash message")}),void 0===a)return!1;try{return await e.createStash(a,t,i),!0}catch(e){if(/You do not have the initial commit yet/.test(e.stderr||""))return h.window.showInformationMessage(h.l10n.t("The repository does not have any commits. Please make an initial commit before creating a stash.")),!1;throw e}}async stash(e){return await this._stash(e)}async stashStaged(e){return await this._stash(e,!1,!0)}async stashIncludeUntracked(e){return await this._stash(e,!0)}async stashPop(e){const t=h.l10n.t("Pick a stash to pop"),i=await this.pickStash(e,t);i&&await e.popStash(i.index)}async stashPopLatest(e){0!==(await e.getStashes()).length?await e.popStash():h.window.showInformationMessage(h.l10n.t("There are no stashes in the repository."))}async stashPopEditor(e){const t=await this.getStashFromUri(e);t&&(await h.commands.executeCommand("workbench.action.closeActiveEditor"),await t.repository.popStash(t.stash.index))}async stashApply(e){const t=h.l10n.t("Pick a stash to apply"),i=await this.pickStash(e,t);i&&await e.applyStash(i.index)}async stashApplyLatest(e){0!==(await e.getStashes()).length?await e.applyStash():h.window.showInformationMessage(h.l10n.t("There are no stashes in the repository."))}async stashApplyEditor(e){const t=await this.getStashFromUri(e);t&&(await h.commands.executeCommand("workbench.action.closeActiveEditor"),await t.repository.applyStash(t.stash.index))}async stashDrop(e){const t=h.l10n.t("Pick a stash to drop"),i=await this.pickStash(e,t);i&&await this._stashDrop(e,i)}async stashDropAll(e){const t=await e.getStashes();if(0===t.length)return void h.window.showInformationMessage(h.l10n.t("There are no stashes in the repository."));const i=h.l10n.t("Yes"),r=1===t.length?h.l10n.t("Are you sure you want to drop ALL stashes? There is 1 stash that will be subject to pruning, and MAY BE IMPOSSIBLE TO RECOVER."):h.l10n.t("Are you sure you want to drop ALL stashes? There are {0} stashes that will be subject to pruning, and MAY BE IMPOSSIBLE TO RECOVER.",t.length);await h.window.showWarningMessage(r,{modal:!0},i)===i&&await e.dropStash()}async stashDropEditor(e){const t=await this.getStashFromUri(e);t&&await this._stashDrop(t.repository,t.stash)&&await h.commands.executeCommand("workbench.action.closeActiveEditor")}async _stashDrop(e,t){const i=h.l10n.t("Yes");return await h.window.showWarningMessage(h.l10n.t("Are you sure you want to drop the stash: {0}?",t.description),{modal:!0},i)===i&&(await e.dropStash(t.index),!0)}async stashView(e){const t=h.l10n.t("Pick a stash to view"),i=await this.pickStash(e,t);if(!i)return;const r=await e.showStash(i.index);if(!r||0===r.length)return;const o=i.parents.length>0?i.parents[0]:`${i.hash}^`,n=3===i.parents.length?i.parents[2]:void 0,s=[];if(n){const t=await e.getObjectFiles(n);s.push(...t.map(t=>c.join(e.root,t.file)))}const a=`Git Stash #${i.index}: ${i.description}`,l=(0,m.toGitUri)(h.Uri.file(e.root),`stash@{${i.index}}`,{scheme:"git-stash"}),u=[];for(const e of r){const t=s.find(t=>(0,g.pathEquals)(t,e.uri.fsPath))?n??i.hash:i.hash;u.push((0,m.toMultiFileDiffEditorUris)(e,o,t))}h.commands.executeCommand("_workbench.openMultiDiffEditor",{multiDiffSourceUri:l,title:a,resources:u})}async pickStash(e,t){const i=await h.window.showQuickPick((async()=>{const t=await e.getStashes();return t.length>0?t.map(e=>new W(e)):[{label:h.l10n.t("$(info) This repository has no stashes.")}]})(),{placeHolder:t});return i instanceof W?i.stash:void 0}async getStashFromUri(e){if(!e||"git-stash"!==e.scheme)return;const t=(0,m.fromGitUri)(e),i=this.model.getRepository(t.path);if(!i)return;const r=/^stash@{(\d+)}$/.exec(t.ref);if(!r)return;const[,o]=r,n=(await i.getStashes()).find(e=>e.index===parseInt(o));return n?{repository:i,stash:n}:void 0}async timelineOpenDiff(e,t,i){const r=this.resolveTimelineOpenDiffCommand(e,t,{preserveFocus:!0,preview:!0,viewColumn:h.ViewColumn.Active});if(void 0!==r)return h.commands.executeCommand(r.command,...r.arguments??[])}resolveTimelineOpenDiffCommand(e,t,i){if(null==t||!f.GitTimelineItem.is(e))return;const r=c.basename(t.fsPath);let o;return o="HEAD"!==e.previousRef&&"~"!==e.previousRef||""!==e.ref?"HEAD"===e.previousRef&&"~"===e.ref?h.l10n.t("{0} (Index)",r):h.l10n.t("{0} ({1}) ↔ {0} ({2})",r,e.shortPreviousRef,e.shortRef):h.l10n.t("{0} (Working Tree)",r),{command:"vscode.diff",title:h.l10n.t("Open Comparison"),arguments:[(0,m.toGitUri)(t,e.previousRef),""===e.ref?t:(0,m.toGitUri)(t,e.ref),o,i]}}async timelineViewCommit(e,t,i){if(!f.GitTimelineItem.is(e))return;const r=await this._resolveTimelineOpenCommitCommand(e,t,{preserveFocus:!0,preview:!0,viewColumn:h.ViewColumn.Active});return void 0!==r?h.commands.executeCommand(r.command,...r.arguments??[]):void 0}async _resolveTimelineOpenCommitCommand(e,t,i){if(null==t||!f.GitTimelineItem.is(e))return;const r=await this.model.getRepository(t.fsPath);if(!r)return;const o=await r.getCommit(e.ref),n=o.parents.length>0?o.parents[0]:await r.getEmptyTree(),s=(await r.diffTrees(n,o.hash)).map(e=>(0,m.toMultiFileDiffEditorUris)(e,n,o.hash)),a=`${e.shortRef} - ${(0,g.truncate)(o.message)}`,l=h.Uri.from({scheme:"scm-history-item",path:`${r.root}/${n}..${o.hash}`});return{command:"_workbench.openMultiDiffEditor",title:h.l10n.t("Open Commit"),arguments:[{multiDiffSourceUri:l,title:a,resources:s},i]}}async timelineCopyCommitId(e,t,i){f.GitTimelineItem.is(e)&&h.env.clipboard.writeText(e.ref)}async timelineCopyCommitMessage(e,t,i){f.GitTimelineItem.is(e)&&h.env.clipboard.writeText(e.message)}async timelineSelectForCompare(e,t,i){f.GitTimelineItem.is(e)&&t&&(this._selectedForCompare={uri:t,item:e},await h.commands.executeCommand("setContext","git.timeline.selectedForCompare",!0))}async timelineCompareWithSelected(e,t,i){if(!f.GitTimelineItem.is(e)||!t||!this._selectedForCompare||t.toString()!==this._selectedForCompare.uri.toString())return;const{item:r}=this._selectedForCompare,o=c.basename(t.fsPath);let n,s;n="HEAD"!==r.previousRef&&"~"!==r.previousRef||""!==r.ref?"HEAD"===r.previousRef&&"~"===r.ref?h.l10n.t("{0} (Index)",o):h.l10n.t("{0} ({1})",o,r.shortRef):h.l10n.t("{0} (Working Tree)",o),s="HEAD"!==e.previousRef&&"~"!==e.previousRef||""!==e.ref?"HEAD"===e.previousRef&&"~"===e.ref?h.l10n.t("{0} (Index)",o):h.l10n.t("{0} ({1})",o,e.shortRef):h.l10n.t("{0} (Working Tree)",o);const a=h.l10n.t("{0} ↔ {1}",n,s);await h.commands.executeCommand("vscode.diff",""===r.ref?t:(0,m.toGitUri)(t,r.ref),""===e.ref?t:(0,m.toGitUri)(t,e.ref),a)}async rebaseAbort(e){e.rebaseCommit?await e.rebaseAbort():await h.window.showInformationMessage(h.l10n.t("No rebase in progress."))}closeDiffEditors(e){e.closeDiffEditors(void 0,void 0,!0)}closeUnmodifiedEditors(){const e=[],t=[];for(const e of this.model.repositories)t.push(...e.indexGroup.resourceStates.map(e=>e.resourceUri.fsPath)),t.push(...e.workingTreeGroup.resourceStates.map(e=>e.resourceUri.fsPath)),t.push(...e.untrackedGroup.resourceStates.map(e=>e.resourceUri.fsPath)),t.push(...e.mergeGroup.resourceStates.map(e=>e.resourceUri.fsPath));for(const i of h.window.tabGroups.all.map(e=>e.tabs).flat())if(!i.isDirty&&(i.input instanceof h.TabInputText||i.input instanceof h.TabInputNotebook)){const{uri:r}=i.input;t.find(e=>(0,g.pathEquals)(e,r.fsPath))||e.push(i)}h.window.tabGroups.close(e,!0)}async openRepositoriesInParentFolders(){const e=[],t=h.l10n.t("Open Repositories In Parent Folders"),i=h.l10n.t("Pick a repository to open"),r={label:h.l10n.t("All Repositories")},o=this.model.parentRepositories.sort(X).map(e=>new F(e)),n=1===this.model.parentRepositories.length?[...o]:[...o,{label:"",kind:h.QuickPickItemKind.Separator},r],s=await h.window.showQuickPick(n,{title:t,placeHolder:i});if(s){s===r?e.push(...this.model.parentRepositories):e.push(s.path);for(const t of e)await this.model.openParentRepository(t)}}async manageUnsafeRepositories(){const e=[],t=h.window.createQuickPick();t.title=h.l10n.t("Manage Unsafe Repositories"),t.placeholder=h.l10n.t("Pick a repository to mark as safe and open");const i=h.l10n.t("All Repositories"),r={label:i},o=this.model.unsafeRepositories.sort(X).map(e=>new F(e));t.items=1===this.model.unsafeRepositories.length?[...o]:[...o,{label:"",kind:h.QuickPickItemKind.Separator},r],t.show();const n=await new Promise(e=>{t.onDidAccept(()=>e(t.activeItems[0])),t.onDidHide(()=>e(void 0))});if(t.hide(),n){n.label===i?e.push(...this.model.unsafeRepositories):e.push(n.path);for(const t of e)await this.git.addSafeDirectory(this.model.getUnsafeRepositoryPath(t)),await this.model.openRepository(t),this.model.deleteUnsafeRepository(t)}}async viewChanges(e){await this._viewResourceGroupChanges(e,e.workingTreeGroup)}async viewStagedChanges(e){await this._viewResourceGroupChanges(e,e.indexGroup)}async viewUnstagedChanges(e){await this._viewResourceGroupChanges(e,e.untrackedGroup)}async _viewResourceGroupChanges(e,t){if(0!==t.resourceStates.length)await h.commands.executeCommand("_workbench.openScmMultiDiffEditor",{title:`${e.sourceControl.label}: ${t.label}`,repositoryUri:h.Uri.file(e.root),resourceGroupId:t.id});else switch(t.id){case"index":h.window.showInformationMessage(h.l10n.t("The repository does not have any staged changes."));break;case"workingTree":h.window.showInformationMessage(h.l10n.t("The repository does not have any changes."));break;case"untracked":h.window.showInformationMessage(h.l10n.t("The repository does not have any untracked changes."))}}async copyCommitId(e,t){e&&t&&h.env.clipboard.writeText(t.id)}async copyCommitMessage(e,t){e&&t&&h.env.clipboard.writeText(t.message)}async viewCommit(e,t){if(!e||!t)return;const i=h.Uri.file(e.root),r=h.workspace.getConfiguration("git",i).get("commitShortHashLength",7),o=await e.getCommit(t),n=`${(0,g.truncate)(t,r,!1)} - ${(0,g.truncate)(o.message)}`,s=o.parents.length>0?o.parents[0]:await e.getEmptyTree(),a=h.Uri.from({scheme:"scm-history-item",path:`${e.root}/${s}..${t}`}),l=(await e.diffTrees(s,t)).map(e=>(0,m.toMultiFileDiffEditorUris)(e,s,t));await h.commands.executeCommand("_workbench.openMultiDiffEditor",{multiDiffSourceUri:a,title:n,resources:l})}async copyContentToClipboard(e){"string"==typeof e&&h.env.clipboard.writeText(e)}toggleBlameEditorDecoration(){this._toggleBlameSetting("blame.editorDecoration.enabled")}toggleBlameStatusBarItem(){this._toggleBlameSetting("blame.statusBarItem.enabled")}_toggleBlameSetting(e){const t=h.workspace.getConfiguration("git"),i=!0===t.get(e);t.update(e,!i,!0)}createCommand(e,t,i,r){const o=(...e)=>{let t;if(r.repository){const o=this.model.getRepository(e[0]);let n;n=o?Promise.resolve(o):this.model.pickRepository(r.repositoryFilter),t=n.then(t=>t?Promise.resolve(i.apply(this,[t,...e.slice(1)])):Promise.resolve())}else t=Promise.resolve(i.apply(this,e));return t.catch(e=>{const t={modal:!0};let i,r="error";const o=new Map,n=h.l10n.t("Open Git Log"),s=this.logger;o.set(n,()=>s.show());const a=h.l10n.t("Show Command Output");switch(e.stderr&&o.set(a,async()=>{const t=(new Date).getTime(),i=h.Uri.parse(`git-output:/git-error-${t}`);let r="git";e.gitArgs?r=`${r} ${e.gitArgs.join(" ")}`:e.gitCommand&&(r=`${r} ${e.gitCommand}`),this.commandErrors.set(i,`> ${r}\n${e.stderr}`);try{const e=await h.workspace.openTextDocument(i);await h.window.showTextDocument(e)}finally{this.commandErrors.delete(i)}}),e.gitErrorCode){case"DirtyWorkTree":i=h.l10n.t("Please clean your repository working tree before checkout.");break;case"PushRejected":i=h.l10n.t('Can\'t push refs to remote. Try running "Pull" first to integrate your changes.');break;case"ForcePushWithLeaseRejected":case"ForcePushWithLeaseIfIncludesRejected":i=h.l10n.t('Can\'t force push refs to remote. The tip of the remote-tracking branch has been updated since the last checkout. Try running "Pull" first to pull the latest changes from the remote branch first.');break;case"Conflict":i=h.l10n.t("There are merge conflicts. Please resolve them before committing your changes."),r="warning",o.clear(),o.set(h.l10n.t("Show Changes"),()=>h.commands.executeCommand("workbench.view.scm")),t.modal=!1;break;case"StashConflict":i=h.l10n.t("There are merge conflicts while applying the stash. Please resolve them before committing your changes."),r="warning",o.clear(),o.set(h.l10n.t("Show Changes"),()=>h.commands.executeCommand("workbench.view.scm")),t.modal=!1;break;case"AuthenticationFailed":{const t=/Authentication failed for '(.*)'/i.exec(e.stderr||String(e));i=t?h.l10n.t("Failed to authenticate to git remote:\n\n{0}",t[1]):h.l10n.t("Failed to authenticate to git remote.");break}case"NoUserNameConfigured":case"NoUserEmailConfigured":i=h.l10n.t('Make sure you configure your "user.name" and "user.email" in git.'),o.set(h.l10n.t("Learn More"),()=>h.commands.executeCommand("vscode.open",h.Uri.parse("https://aka.ms/vscode-setup-git")));break;case"EmptyCommitMessage":i=h.l10n.t("Commit operation was cancelled due to empty commit message."),o.clear(),r="information",t.modal=!1;break;case"CherryPickEmpty":i=h.l10n.t("The changes are already present in the current branch."),o.clear(),r="information",t.modal=!1;break;case"CherryPickConflict":i=h.l10n.t("There were merge conflicts while cherry picking the changes. Resolve the conflicts before committing them."),r="warning",o.set(h.l10n.t("Show Changes"),()=>h.commands.executeCommand("workbench.view.scm")),t.modal=!1;break;default:{const t=(e.stderr||e.message||String(e)).replace(/^error: /im,"").replace(/^> husky.*$/im,"").split(/[\r\n]/).filter(e=>!!e)[0];i=t?h.l10n.t("Git: {0}",t):h.l10n.t("Git error");break}}i?this.showErrorNotification(r,i,t,o):console.error(e)})};return this[t]=o,o}async showErrorNotification(e,t,i,r){let o;const n=Array.from(r.keys());switch(e){case"error":o=await h.window.showErrorMessage(t,i,...n);break;case"warning":o=await h.window.showWarningMessage(t,i,...n);break;case"information":o=await h.window.showInformationMessage(t,i,...n)}if(o){const e=r.get(o);e?.()}}getSCMResource(e){e=e||h.window.activeTextEditor&&h.window.activeTextEditor.document.uri,this.logger.debug(`[CommandCenter][getSCMResource] git.getSCMResource.uri: ${e&&e.toString()}`);for(const e of this.model.repositories.map(e=>e.root))this.logger.debug(`[CommandCenter][getSCMResource] repo root: ${e}`);if(e){if((0,m.isGitUri)(e)){const{path:t}=(0,m.fromGitUri)(e);e=h.Uri.file(t)}if("file"===e.scheme){const t=e.toString(),i=this.model.getRepository(e);if(!i)return;return i.workingTreeGroup.resourceStates.filter(e=>e.resourceUri.toString()===t)[0]||i.indexGroup.resourceStates.filter(e=>e.resourceUri.toString()===t)[0]||i.mergeGroup.resourceStates.filter(e=>e.resourceUri.toString()===t)[0]}}}async runByRepository(e,t){const i=e instanceof h.Uri?[e]:e,r=e instanceof h.Uri,o=i.reduce((e,t)=>{let i=this.model.getRepository(t);if(!i)return console.warn("Could not find git repository for ",t),e;(0,g.pathEquals)(t.fsPath,i.root)&&(i=this.model.getRepositoryForSubmodule(t)||i);const r=e.filter(e=>e.repository===i)[0];return r?r.resources.push(t):e.push({repository:i,resources:[t]}),e},[]).map(({repository:e,resources:i})=>t(e,r?i[0]:i));return Promise.all(o)}dispose(){this.disposables.forEach(e=>e.dispose())}}t.CommandCenter=re,re.WORKTREE_ROOT_KEY="worktreeRoot",s([K("git.showOutput")],re.prototype,"showOutput",null),s([K("git.refresh",{repository:!0})],re.prototype,"refresh",null),s([K("git.openResource")],re.prototype,"openResource",null),s([K("git.openAllChanges",{repository:!0})],re.prototype,"openChanges",null),s([K("git.openMergeEditor")],re.prototype,"openMergeEditor",null),s([K("git.continueInLocalClone")],re.prototype,"continueInLocalClone",null),s([K("git.clone")],re.prototype,"clone",null),s([K("git.cloneRecursive")],re.prototype,"cloneRecursive",null),s([K("git.init")],re.prototype,"init",null),s([K("git.openRepository",{repository:!1})],re.prototype,"openRepository",null),s([K("git.reopenClosedRepositories",{repository:!1})],re.prototype,"reopenClosedRepositories",null),s([K("git.close",{repository:!0})],re.prototype,"close",null),s([K("git.closeOtherRepositories",{repository:!0})],re.prototype,"closeOtherRepositories",null),s([K("git.openFile")],re.prototype,"openFile",null),s([K("git.openFile2")],re.prototype,"openFile2",null),s([K("git.openHEADFile")],re.prototype,"openHEADFile",null),s([K("git.openChange")],re.prototype,"openChange",null),s([K("git.rename",{repository:!0})],re.prototype,"rename",null),s([K("git.stage")],re.prototype,"stage",null),s([K("git.stageAll",{repository:!0})],re.prototype,"stageAll",null),s([K("git.stageAllTracked",{repository:!0})],re.prototype,"stageAllTracked",null),s([K("git.stageAllUntracked",{repository:!0})],re.prototype,"stageAllUntracked",null),s([K("git.stageAllMerge",{repository:!0})],re.prototype,"stageAllMerge",null),s([K("git.stageChange")],re.prototype,"stageChange",null),s([K("git.diff.stageHunk")],re.prototype,"diffStageHunk",null),s([K("git.diff.stageSelection")],re.prototype,"diffStageSelection",null),s([K("git.stageSelectedRanges")],re.prototype,"stageSelectedChanges",null),s([K("git.stageFile")],re.prototype,"stageFile",null),s([K("git.acceptMerge")],re.prototype,"acceptMerge",null),s([K("git.runGitMerge")],re.prototype,"runGitMergeNoDiff3",null),s([K("git.runGitMergeDiff3")],re.prototype,"runGitMergeDiff3",null),s([K("git.revertChange")],re.prototype,"revertChange",null),s([K("git.revertSelectedRanges")],re.prototype,"revertSelectedRanges",null),s([K("git.unstage")],re.prototype,"unstage",null),s([K("git.unstageAll",{repository:!0})],re.prototype,"unstageAll",null),s([K("git.unstageSelectedRanges")],re.prototype,"unstageSelectedRanges",null),s([K("git.unstageFile")],re.prototype,"unstageFile",null),s([K("git.unstageChange")],re.prototype,"unstageChange",null),s([K("git.clean")],re.prototype,"clean",null),s([K("git.cleanAll",{repository:!0})],re.prototype,"cleanAll",null),s([K("git.cleanAllTracked",{repository:!0})],re.prototype,"cleanAllTracked",null),s([K("git.cleanAllUntracked",{repository:!0})],re.prototype,"cleanAllUntracked",null),s([K("git.commit",{repository:!0})],re.prototype,"commit",null),s([K("git.commitAmend",{repository:!0})],re.prototype,"commitAmend",null),s([K("git.commitSigned",{repository:!0})],re.prototype,"commitSigned",null),s([K("git.commitStaged",{repository:!0})],re.prototype,"commitStaged",null),s([K("git.commitStagedSigned",{repository:!0})],re.prototype,"commitStagedSigned",null),s([K("git.commitStagedAmend",{repository:!0})],re.prototype,"commitStagedAmend",null),s([K("git.commitAll",{repository:!0})],re.prototype,"commitAll",null),s([K("git.commitAllSigned",{repository:!0})],re.prototype,"commitAllSigned",null),s([K("git.commitAllAmend",{repository:!0})],re.prototype,"commitAllAmend",null),s([K("git.commitMessageAccept")],re.prototype,"commitMessageAccept",null),s([K("git.commitMessageDiscard")],re.prototype,"commitMessageDiscard",null),s([K("git.commitEmpty",{repository:!0})],re.prototype,"commitEmpty",null),s([K("git.commitNoVerify",{repository:!0})],re.prototype,"commitNoVerify",null),s([K("git.commitStagedNoVerify",{repository:!0})],re.prototype,"commitStagedNoVerify",null),s([K("git.commitStagedSignedNoVerify",{repository:!0})],re.prototype,"commitStagedSignedNoVerify",null),s([K("git.commitAmendNoVerify",{repository:!0})],re.prototype,"commitAmendNoVerify",null),s([K("git.commitSignedNoVerify",{repository:!0})],re.prototype,"commitSignedNoVerify",null),s([K("git.commitStagedAmendNoVerify",{repository:!0})],re.prototype,"commitStagedAmendNoVerify",null),s([K("git.commitAllNoVerify",{repository:!0})],re.prototype,"commitAllNoVerify",null),s([K("git.commitAllSignedNoVerify",{repository:!0})],re.prototype,"commitAllSignedNoVerify",null),s([K("git.commitAllAmendNoVerify",{repository:!0})],re.prototype,"commitAllAmendNoVerify",null),s([K("git.commitEmptyNoVerify",{repository:!0})],re.prototype,"commitEmptyNoVerify",null),s([K("git.restoreCommitTemplate",{repository:!0})],re.prototype,"restoreCommitTemplate",null),s([K("git.undoCommit",{repository:!0})],re.prototype,"undoCommit",null),s([K("git.checkout",{repository:!0})],re.prototype,"checkout",null),s([K("git.graph.checkout",{repository:!0})],re.prototype,"checkout2",null),s([K("git.checkoutDetached",{repository:!0})],re.prototype,"checkoutDetached",null),s([K("git.graph.checkoutDetached",{repository:!0})],re.prototype,"checkoutDetached2",null),s([K("git.branch",{repository:!0})],re.prototype,"branch",null),s([K("git.branchFrom",{repository:!0})],re.prototype,"branchFrom",null),s([K("git.deleteBranch",{repository:!0})],re.prototype,"deleteBranch",null),s([K("git.graph.deleteBranch",{repository:!0})],re.prototype,"deleteBranch2",null),s([K("git.deleteRemoteBranch",{repository:!0})],re.prototype,"deleteRemoteBranch",null),s([K("git.renameBranch",{repository:!0})],re.prototype,"renameBranch",null),s([K("git.merge",{repository:!0})],re.prototype,"merge",null),s([K("git.mergeAbort",{repository:!0})],re.prototype,"abortMerge",null),s([K("git.rebase",{repository:!0})],re.prototype,"rebase",null),s([K("git.createTag",{repository:!0})],re.prototype,"createTag",null),s([K("git.deleteTag",{repository:!0})],re.prototype,"deleteTag",null),s([K("git.createWorktree")],re.prototype,"createWorktree",null),s([K("git.deleteWorktree",{repository:!0,repositoryFilter:["worktree"]})],re.prototype,"deleteWorktree",null),s([K("git.deleteWorktreeFromPalette",{repository:!0,repositoryFilter:["repository","submodule"]})],re.prototype,"deleteWorktreeFromPalette",null),s([K("git.openWorktree",{repository:!0})],re.prototype,"openWorktreeInCurrentWindow",null),s([K("git.openWorktreeInNewWindow",{repository:!0})],re.prototype,"openWorktreeInNewWindow",null),s([K("git.graph.deleteTag",{repository:!0})],re.prototype,"deleteTag2",null),s([K("git.deleteRemoteTag",{repository:!0})],re.prototype,"deleteRemoteTag",null),s([K("git.fetch",{repository:!0})],re.prototype,"fetch",null),s([K("git.fetchPrune",{repository:!0})],re.prototype,"fetchPrune",null),s([K("git.fetchAll",{repository:!0})],re.prototype,"fetchAll",null),s([K("git.fetchRef",{repository:!0})],re.prototype,"fetchRef",null),s([K("git.pullFrom",{repository:!0})],re.prototype,"pullFrom",null),s([K("git.pull",{repository:!0})],re.prototype,"pull",null),s([K("git.pullRebase",{repository:!0})],re.prototype,"pullRebase",null),s([K("git.pullRef",{repository:!0})],re.prototype,"pullRef",null),s([K("git.push",{repository:!0})],re.prototype,"push",null),s([K("git.pushForce",{repository:!0})],re.prototype,"pushForce",null),s([K("git.pushWithTags",{repository:!0})],re.prototype,"pushFollowTags",null),s([K("git.pushWithTagsForce",{repository:!0})],re.prototype,"pushFollowTagsForce",null),s([K("git.pushRef",{repository:!0})],re.prototype,"pushRef",null),s([K("git.cherryPick",{repository:!0})],re.prototype,"cherryPick",null),s([K("git.graph.cherryPick",{repository:!0})],re.prototype,"cherryPick2",null),s([K("git.cherryPickAbort",{repository:!0})],re.prototype,"cherryPickAbort",null),s([K("git.pushTo",{repository:!0})],re.prototype,"pushTo",null),s([K("git.pushToForce",{repository:!0})],re.prototype,"pushToForce",null),s([K("git.pushTags",{repository:!0})],re.prototype,"pushTags",null),s([K("git.addRemote",{repository:!0})],re.prototype,"addRemote",null),s([K("git.removeRemote",{repository:!0})],re.prototype,"removeRemote",null),s([K("git.sync",{repository:!0})],re.prototype,"sync",null),s([K("git._syncAll")],re.prototype,"syncAll",null),s([K("git.syncRebase",{repository:!0})],re.prototype,"syncRebase",null),s([K("git.publish",{repository:!0})],re.prototype,"publish",null),s([K("git.ignore")],re.prototype,"ignore",null),s([K("git.revealInExplorer")],re.prototype,"revealInExplorer",null),s([K("git.revealFileInOS.linux"),K("git.revealFileInOS.mac"),K("git.revealFileInOS.windows")],re.prototype,"revealFileInOS",null),s([K("git.stash",{repository:!0})],re.prototype,"stash",null),s([K("git.stashStaged",{repository:!0})],re.prototype,"stashStaged",null),s([K("git.stashIncludeUntracked",{repository:!0})],re.prototype,"stashIncludeUntracked",null),s([K("git.stashPop",{repository:!0})],re.prototype,"stashPop",null),s([K("git.stashPopLatest",{repository:!0})],re.prototype,"stashPopLatest",null),s([K("git.stashPopEditor")],re.prototype,"stashPopEditor",null),s([K("git.stashApply",{repository:!0})],re.prototype,"stashApply",null),s([K("git.stashApplyLatest",{repository:!0})],re.prototype,"stashApplyLatest",null),s([K("git.stashApplyEditor")],re.prototype,"stashApplyEditor",null),s([K("git.stashDrop",{repository:!0})],re.prototype,"stashDrop",null),s([K("git.stashDropAll",{repository:!0})],re.prototype,"stashDropAll",null),s([K("git.stashDropEditor")],re.prototype,"stashDropEditor",null),s([K("git.stashView",{repository:!0})],re.prototype,"stashView",null),s([K("git.timeline.openDiff",{repository:!1})],re.prototype,"timelineOpenDiff",null),s([K("git.timeline.viewCommit",{repository:!1})],re.prototype,"timelineViewCommit",null),s([K("git.timeline.copyCommitId",{repository:!1})],re.prototype,"timelineCopyCommitId",null),s([K("git.timeline.copyCommitMessage",{repository:!1})],re.prototype,"timelineCopyCommitMessage",null),s([K("git.timeline.selectForCompare",{repository:!1})],re.prototype,"timelineSelectForCompare",null),s([K("git.timeline.compareWithSelected",{repository:!1})],re.prototype,"timelineCompareWithSelected",null),s([K("git.rebaseAbort",{repository:!0})],re.prototype,"rebaseAbort",null),s([K("git.closeAllDiffEditors",{repository:!0})],re.prototype,"closeDiffEditors",null),s([K("git.closeAllUnmodifiedEditors")],re.prototype,"closeUnmodifiedEditors",null),s([K("git.openRepositoriesInParentFolders")],re.prototype,"openRepositoriesInParentFolders",null),s([K("git.manageUnsafeRepositories")],re.prototype,"manageUnsafeRepositories",null),s([K("git.viewChanges",{repository:!0})],re.prototype,"viewChanges",null),s([K("git.viewStagedChanges",{repository:!0})],re.prototype,"viewStagedChanges",null),s([K("git.viewUntrackedChanges",{repository:!0})],re.prototype,"viewUnstagedChanges",null),s([K("git.copyCommitId",{repository:!0})],re.prototype,"copyCommitId",null),s([K("git.copyCommitMessage",{repository:!0})],re.prototype,"copyCommitMessage",null),s([K("git.viewCommit",{repository:!0})],re.prototype,"viewCommit",null),s([K("git.copyContentToClipboard")],re.prototype,"copyContentToClipboard",null),s([K("git.blame.toggleEditorDecoration")],re.prototype,"toggleBlameEditorDecoration",null),s([K("git.blame.toggleStatusBarItem")],re.prototype,"toggleBlameStatusBarItem",null)},4847:(e,t)=>{"use strict";function i(e,t,i={}){const r={path:e.fsPath,ref:t};i.submoduleOf&&(r.submoduleOf=i.submoduleOf);let o=e.path;return i.replaceFileExtension?o=`${o}.git`:i.submoduleOf&&(o=`${o}.diff`),e.with({scheme:i.scheme??"git",path:o,query:JSON.stringify(r)})}Object.defineProperty(t,"__esModule",{value:!0}),t.isGitUri=function(e){return/^git$/.test(e.scheme)},t.fromGitUri=function(e){return JSON.parse(e.query)},t.toGitUri=i,t.toMergeUris=function(e){return{base:i(e,":1"),ours:i(e,":2"),theirs:i(e,":3")}},t.toMultiFileDiffEditorUris=function(e,t,r){switch(e.status){case 1:return{originalUri:void 0,modifiedUri:i(e.uri,r)};case 6:return{originalUri:i(e.uri,t),modifiedUri:void 0};case 3:return{originalUri:i(e.originalUri,t),modifiedUri:i(e.uri,r)};default:return{originalUri:i(e.uri,t),modifiedUri:i(e.uri,r)}}}},5157:(e,t,i)=>{"use strict";e.exports=i(6675)},5317:e=>{"use strict";e.exports=require("child_process")},5362:function(e,t,i){"use strict";var r=this&&this.__decorate||function(e,t,i,r){var o,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,i):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,r);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(n<3?o(s):n>3?o(t,i,s):o(t,i))||s);return n>3&&s&&Object.defineProperty(t,i,s),s};Object.defineProperty(t,"__esModule",{value:!0}),t.GitBlameController=void 0;const o=i(1398),n=i(7937),s=i(4399),a=i(4847),l=i(6867),c=i(2772),h=i(8107),u=i(527);function d(e,t){return e.some(e=>e.modified.startLineNumber<=t&&t<e.modified.endLineNumberExclusive)}function p(e,t){return t-e}function m(e,t){if(0===t.length)return e;for(const i of t){if(e<i.modified.startLineNumber)break;if(i.kind===o.TextEditorChangeKind.Addition)e-=p(i.modified.startLineNumber,i.modified.endLineNumberExclusive);else if(i.kind===o.TextEditorChangeKind.Deletion)e+=p(i.original.startLineNumber,i.original.endLineNumberExclusive);else{if(i.kind!==o.TextEditorChangeKind.Modification)throw new Error("Unexpected change kind");{const t=p(i.original.startLineNumber,i.original.endLineNumberExclusive),r=p(i.modified.startLineNumber,i.modified.endLineNumberExclusive);t!==r&&(e-=r-t)}}}return e}function g(e){const t=new o.Position(e,Number.MAX_SAFE_INTEGER);return new o.Range(t,t)}function f(e){return"file"===e.scheme||(0,a.isGitUri)(e)}class y{constructor(){this._cache=new Map}delete(e){return this._cache.delete(e)}get(e,t,i){const r=this._getCacheKey(t,i);return this._cache.get(e)?.get(r)}set(e,t,i,r){this._cache.has(e)||this._cache.set(e,new u.LRUCache(100));const o=this._getCacheKey(t,i);this._cache.get(e).set(o,r)}_getCacheKey(e,t){return(0,a.toGitUri)(e,t).toString()}}class w{get textEditorBlameInformation(){return this._textEditorBlameInformation}set textEditorBlameInformation(e){(function(e,t){if(e===t)return!0;if(!e||!t||e.resource.toString()!==t.resource.toString()||e.blameInformation.length!==t.blameInformation.length)return!1;for(let i=0;i<e.blameInformation.length;i++){if(e.blameInformation[i].lineNumber!==t.blameInformation[i].lineNumber)return!1;const r=e.blameInformation[i].blameInformation,o=t.blameInformation[i].blameInformation;if("string"==typeof r&&"string"==typeof o){if(r!==o)return!1}else{if("string"==typeof r||"string"==typeof o)return!1;if(r.hash!==o.hash)return!1}}return!0})(this._textEditorBlameInformation,e)||(this._textEditorBlameInformation=e,this._onDidChangeBlameInformation.fire())}constructor(e){this._model=e,this._subjectMaxLength=50,this._onDidChangeBlameInformation=new o.EventEmitter,this.onDidChangeBlameInformation=this._onDidChangeBlameInformation.event,this._commitInformationCache=new u.LRUCache(100),this._repositoryBlameCache=new y,this._repositoryDisposables=new Map,this._enablementDisposables=[],this._disposables=[],o.workspace.onDidChangeConfiguration(this._onDidChangeConfiguration,this,this._disposables),this._onDidChangeConfiguration()}formatBlameInformationMessage(e,t,i){const r={hash:i.hash,hashShort:(0,n.getCommitShortHash)(e,i.hash),subject:(0,l.emojify)((0,n.truncate)(i.subject??"",this._subjectMaxLength)),authorName:i.authorName??"",authorEmail:i.authorEmail??"",authorDate:new Date(i.authorDate??new Date).toLocaleString(),authorDateAgo:(0,n.fromNow)(i.authorDate??new Date,!0,!0)};return t.replace(/\$\{(.+?)\}/g,(e,t)=>t in r?r[t]:`\${${t}}`)}async getBlameInformationHover(e,t){const i=[];let r,s,a;const c=this._model.getRepository(e);if(c){try{s=this._commitInformationCache.get(t.hash),s||(s=await c.getCommit(t.hash),this._commitInformationCache.set(t.hash,s));const e={commits:[{hash:t.hash,authorName:t.authorName,authorEmail:t.authorEmail}],size:20},i=await(0,h.provideSourceControlHistoryItemAvatar)(this._model,c,e);r=i?.get(t.hash)}catch{}(await c.getUnpublishedCommits()).has(t.hash)||i.push(...await(0,h.provideSourceControlHistoryItemHoverCommands)(this._model,c)??[]),a=await(0,h.provideSourceControlHistoryItemMessageLinks)(this._model,c,s?.message??t.subject??"")}const u=new o.MarkdownString;u.isTrusted=!0,u.supportThemeIcons=!0;const d=s?.hash??t.hash,p=s?.authorName??t.authorName,m=s?.authorEmail??t.authorEmail,g=s?.authorDate??t.authorDate,f=r?`![${p}](${r}|width=20,height=20)`:"$(account)";if(p){if(m){const e=o.l10n.t("Email");u.appendMarkdown(`${f} [**${p}**](mailto:${m} "${e} ${p}")`)}else u.appendMarkdown(`${f} **${p}**`);if(g){const e=new Date(g).toLocaleString(void 0,{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"numeric"});u.appendMarkdown(`, $(history) ${(0,n.fromNow)(g,!0,!0)} (${e})`)}u.appendMarkdown("\n\n")}const y=a??s?.message??t.subject??"";if(u.appendMarkdown(`${(0,l.emojify)(y.replace(/\r\n|\r|\n/g,"\n\n"))}\n\n`),u.appendMarkdown("---\n\n"),s?.shortStat&&(u.appendMarkdown(`<span>${1===s.shortStat.files?o.l10n.t("{0} file changed",s.shortStat.files):o.l10n.t("{0} files changed",s.shortStat.files)}</span>`),s.shortStat.insertions&&u.appendMarkdown(`,&nbsp;<span style="color:var(--vscode-scmGraph-historyItemHoverAdditionsForeground);">${1===s.shortStat.insertions?o.l10n.t("{0} insertion{1}",s.shortStat.insertions,"(+)"):o.l10n.t("{0} insertions{1}",s.shortStat.insertions,"(+)")}</span>`),s.shortStat.deletions&&u.appendMarkdown(`,&nbsp;<span style="color:var(--vscode-scmGraph-historyItemHoverDeletionsForeground);">${1===s.shortStat.deletions?o.l10n.t("{0} deletion{1}",s.shortStat.deletions,"(-)"):o.l10n.t("{0} deletions{1}",s.shortStat.deletions,"(-)")}</span>`),u.appendMarkdown("\n\n---\n\n")),u.appendMarkdown(`[\`$(git-commit) ${(0,n.getCommitShortHash)(e,d)} \`](command:git.viewCommit?${encodeURIComponent(JSON.stringify([e,d]))} "${o.l10n.t("Open Commit")}")`),u.appendMarkdown("&nbsp;"),u.appendMarkdown(`[$(copy)](command:git.copyContentToClipboard?${encodeURIComponent(JSON.stringify(d))} "${o.l10n.t("Copy Commit Hash")}")`),i.length>0){u.appendMarkdown("&nbsp;&nbsp;|&nbsp;&nbsp;");const e=i.map(e=>`[${e.title}](command:${e.command}?${encodeURIComponent(JSON.stringify([...e.arguments??[],d]))} "${e.tooltip}")`);u.appendMarkdown(e.join("&nbsp;"))}return u.appendMarkdown("&nbsp;&nbsp;|&nbsp;&nbsp;"),u.appendMarkdown(`[$(gear)](command:workbench.action.openSettings?%5B%22git.blame%22%5D "${o.l10n.t("Open Settings")}")`),u}_onDidChangeConfiguration(e){if(e&&!e.affectsConfiguration("git.blame.editorDecoration.enabled")&&!e.affectsConfiguration("git.blame.statusBarItem.enabled"))return;const t=o.workspace.getConfiguration("git"),i=!0===t.get("blame.editorDecoration.enabled"),r=!0===t.get("blame.statusBarItem.enabled");if(i?this._editorDecoration||(this._editorDecoration=new b(this)):(this._editorDecoration?.dispose(),this._editorDecoration=void 0),r?this._statusBarItem||(this._statusBarItem=new C(this)):(this._statusBarItem?.dispose(),this._statusBarItem=void 0),i||r){if(0===this._enablementDisposables.length){this._model.onDidOpenRepository(this._onDidOpenRepository,this,this._enablementDisposables),this._model.onDidCloseRepository(this._onDidCloseRepository,this,this._enablementDisposables);for(const e of this._model.repositories)this._onDidOpenRepository(e);o.window.onDidChangeActiveTextEditor(e=>this._updateTextEditorBlameInformation(e),this,this._enablementDisposables),o.window.onDidChangeTextEditorSelection(e=>this._updateTextEditorBlameInformation(e.textEditor,"selection"),this,this._enablementDisposables),o.window.onDidChangeTextEditorDiffInformation(e=>this._updateTextEditorBlameInformation(e.textEditor),this,this._enablementDisposables)}}else this._enablementDisposables=(0,n.dispose)(this._enablementDisposables);this._updateTextEditorBlameInformation(o.window.activeTextEditor)}_onDidOpenRepository(e){const t=[];e.onDidRunGitStatus(()=>this._onDidRunGitStatus(e),this,t),this._repositoryDisposables.set(e,t)}_onDidCloseRepository(e){const t=this._repositoryDisposables.get(e);t&&(0,n.dispose)(t),this._repositoryDisposables.delete(e),this._repositoryBlameCache.delete(e)}_onDidRunGitStatus(e){e.HEAD?.commit&&this._HEAD!==e.HEAD.commit&&(this._HEAD=e.HEAD.commit,this._updateTextEditorBlameInformation(o.window.activeTextEditor))}async _getBlameInformation(e,t){const i=this._model.getRepository(e);if(!i)return;const r=this._repositoryBlameCache.get(i,e,t);if(r)return r;await(0,l.ensureEmojis)();const o=await i.blame2(e.fsPath,t)??[];return this._repositoryBlameCache.set(i,e,t,o),o}async _updateTextEditorBlameInformation(e,t){if(!e)return void(this.textEditorBlameInformation=void 0);if(!e.diffInformation||e!==o.window.activeTextEditor)return;const i=this._model.getRepository(e.document.uri);if(!i||!i.HEAD?.commit)return;if(!f(e.document.uri))return void(this.textEditorBlameInformation=void 0);if("selection"!==t&&1===e.selections.length&&0===e.selections[0].start.line&&0===e.selections[0].start.character&&0===e.selections[0].end.line&&0===e.selections[0].end.character)return void(this.textEditorBlameInformation=void 0);let r,n,s,l;if((0,a.isGitUri)(e.document.uri)){const{ref:t}=(0,a.fromGitUri)(e.document.uri);if(/^[0-9a-f]{40}$/i.test(t)||"HEAD"===t||"~"===t)n=r=[],s=void 0;else{if(""!==t)throw new Error(`Unexpected ref: ${t}`);{const t=(0,c.getWorkingTreeAndIndexDiffInformation)(e);if(t&&t.isStale)return void(this.textEditorBlameInformation=void 0);n=[],s=r=t?.changes??[]}}}else{const t=(0,c.getWorkingTreeDiffInformation)(e);if(!t||t.isStale)return void(this.textEditorBlameInformation=void 0);const i=(0,c.getWorkingTreeAndIndexDiffInformation)(e);if(i&&i.isStale)return void(this.textEditorBlameInformation=void 0);n=t.changes,s=i?.changes,r=s??n}if((0,a.isGitUri)(e.document.uri)){const{ref:t}=(0,a.fromGitUri)(e.document.uri);l=/^[0-9a-f]{40}$/i.test(t)?t:i.HEAD.commit}else l=i.HEAD.commit;const h=await this._getBlameInformation(e.document.uri,l);if(!h)return;const u=[];for(const i of new Set(e.selections.map(e=>e.active.line))){if(d(n,i+1)){"selection"===t&&u.push({lineNumber:i,blameInformation:o.l10n.t("Not Committed Yet")});continue}if(d(s??[],i+1)){u.push({lineNumber:i,blameInformation:o.l10n.t("Not Committed Yet (Staged)")});continue}const e=m(i+1,r),a=h.find(t=>t.ranges.find(t=>e>=t.startLineNumber&&e<=t.endLineNumber));a&&u.push({lineNumber:i,blameInformation:a})}this.textEditorBlameInformation={resource:e.document.uri,blameInformation:u}}dispose(){for(const e of this._repositoryDisposables.values())(0,n.dispose)(e);this._repositoryDisposables.clear(),this._disposables=(0,n.dispose)(this._disposables)}}t.GitBlameController=w,r([s.throttle],w.prototype,"_updateTextEditorBlameInformation",null);class b{constructor(e){this._controller=e,this._template="",this._disposables=[],this._decoration=o.window.createTextEditorDecorationType({after:{color:new o.ThemeColor("git.blame.editorDecorationForeground")}}),this._disposables.push(this._decoration),o.workspace.onDidChangeConfiguration(this._onDidChangeConfiguration,this,this._disposables),o.window.onDidChangeActiveTextEditor(this._onDidChangeActiveTextEditor,this,this._disposables),this._controller.onDidChangeBlameInformation(()=>this._onDidChangeBlameInformation(),this,this._disposables),this._onDidChangeConfiguration()}async provideHover(e,t,i){if(i.isCancellationRequested)return;const r=o.window.activeTextEditor;if(!r)return;if(t.character!==e.lineAt(t.line).range.end.character)return;const n=this._controller.textEditorBlameInformation?.blameInformation,s=n?.find(e=>e.lineNumber===t.line);if(!s||"string"==typeof s.blameInformation)return;const a=await this._controller.getBlameInformationHover(r.document.uri,s.blameInformation);return a&&!i.isCancellationRequested?{range:g(t.line),contents:[a]}:void 0}_onDidChangeConfiguration(e){if(e&&!e.affectsConfiguration("git.commitShortHashLength")&&!e.affectsConfiguration("git.blame.editorDecoration.template"))return;const t=o.workspace.getConfiguration("git");this._template=t.get("blame.editorDecoration.template","${subject}, ${authorName} (${authorDateAgo})"),this._registerHoverProvider(),this._onDidChangeBlameInformation()}_onDidChangeActiveTextEditor(){for(const e of o.window.visibleTextEditors)e!==o.window.activeTextEditor&&e.setDecorations(this._decoration,[]);this._registerHoverProvider()}_onDidChangeBlameInformation(){const e=o.window.activeTextEditor;if(!e)return;const t=this._controller.textEditorBlameInformation?.blameInformation;if(!t||0===t.length)return void e.setDecorations(this._decoration,[]);const i=t.map(t=>{const i="string"!=typeof t.blameInformation?this._controller.formatBlameInformationMessage(e.document.uri,this._template,t.blameInformation):t.blameInformation;return this._createDecoration(t.lineNumber,i)});e.setDecorations(this._decoration,i)}_createDecoration(e,t){return{range:g(e),renderOptions:{after:{contentText:t,margin:"0 0 0 50px"}}}}_registerHoverProvider(){this._hoverDisposable?.dispose(),o.window.activeTextEditor&&f(o.window.activeTextEditor.document.uri)&&(this._hoverDisposable=o.languages.registerHoverProvider({pattern:o.window.activeTextEditor.document.uri.fsPath},this))}dispose(){this._hoverDisposable?.dispose(),this._hoverDisposable=void 0,this._disposables=(0,n.dispose)(this._disposables)}}class C{constructor(e){this._controller=e,this._template="",this._disposables=[],this._statusBarItem=o.window.createStatusBarItem("git.blame",o.StatusBarAlignment.Right,200),this._statusBarItem.name=o.l10n.t("Git Blame Information"),this._disposables.push(this._statusBarItem),o.workspace.onDidChangeConfiguration(this._onDidChangeConfiguration,this,this._disposables),this._controller.onDidChangeBlameInformation(()=>this._onDidChangeBlameInformation(),this,this._disposables),this._onDidChangeConfiguration()}_onDidChangeConfiguration(e){if(e&&!e.affectsConfiguration("git.commitShortHashLength")&&!e.affectsConfiguration("git.blame.statusBarItem.template"))return;const t=o.workspace.getConfiguration("git");this._template=t.get("blame.statusBarItem.template","${authorName} (${authorDateAgo})"),this._onDidChangeBlameInformation()}async _onDidChangeBlameInformation(){if(!o.window.activeTextEditor)return void this._statusBarItem.hide();const e=this._controller.textEditorBlameInformation?.blameInformation;e&&0!==e.length?("string"==typeof e[0].blameInformation?(this._statusBarItem.text=`$(git-commit) ${e[0].blameInformation}`,this._statusBarItem.tooltip=o.l10n.t("Git Blame Information"),this._statusBarItem.command=void 0):(this._statusBarItem.text=`$(git-commit) ${this._controller.formatBlameInformationMessage(o.window.activeTextEditor.document.uri,this._template,e[0].blameInformation)}`,this._statusBarItem.tooltip2=t=>this._provideTooltip(o.window.activeTextEditor.document.uri,e[0].blameInformation,t),this._statusBarItem.command={title:o.l10n.t("Open Commit"),command:"git.viewCommit",arguments:[o.window.activeTextEditor.document.uri,e[0].blameInformation.hash]}),this._statusBarItem.show()):this._statusBarItem.hide()}async _provideTooltip(e,t,i){if(i.isCancellationRequested)return;const r=await this._controller.getBlameInformationHover(e,t);return i.isCancellationRequested?void 0:r}dispose(){this._disposables=(0,n.dispose)(this._disposables)}}},5495:(e,t,i)=>{"use strict";i.r(t),i.d(t,{NumberDictionary:()=>p,adjectives:()=>a,animals:()=>l,colors:()=>c,languages:()=>h,names:()=>u,starWars:()=>d,uniqueNamesGenerator:()=>s});const r=e=>{e=1831565813+(e|=0)|0;let t=Math.imul(e^e>>>15,1|e);return t=t+Math.imul(t^t>>>7,61|t)^t,((t^t>>>14)>>>0)/4294967296};class o{constructor(e){this.dictionaries=void 0,this.length=void 0,this.separator=void 0,this.style=void 0,this.seed=void 0;const{length:t,separator:i,dictionaries:r,style:o,seed:n}=e;this.dictionaries=r,this.separator=i,this.length=t,this.style=o,this.seed=n}generate(){if(!this.dictionaries)throw new Error('Cannot find any dictionary. Please provide at least one, or leave the "dictionary" field empty in the config object');if(this.length<=0)throw new Error("Invalid length provided");if(this.length>this.dictionaries.length)throw new Error(`The length cannot be bigger than the number of dictionaries.\nLength provided: ${this.length}. Number of dictionaries provided: ${this.dictionaries.length}`);let e=this.seed;return this.dictionaries.slice(0,this.length).reduce((t,i)=>{let o;e?(o=(e=>{if("string"==typeof e){const t=e.split("").map(e=>e.charCodeAt(0)).reduce((e,t)=>e+t,1),i=Math.floor(Number(t));return r(i)}return r(e)})(e),e=4294967296*o):o=Math.random();let n=i[Math.floor(o*i.length)]||"";if("lowerCase"===this.style)n=n.toLowerCase();else if("capital"===this.style){const[e,...t]=n.split("");n=e.toUpperCase()+t.join("")}else"upperCase"===this.style&&(n=n.toUpperCase());return t?`${t}${this.separator}${n}`:`${n}`},"")}}const n={separator:"_",dictionaries:[]},s=e=>{const t=[...e&&e.dictionaries||n.dictionaries],i={...n,...e,length:e&&e.length||t.length,dictionaries:t};if(!e||!e.dictionaries||!e.dictionaries.length)throw new Error('A "dictionaries" array must be provided. This is a breaking change introduced starting from Unique Name Generator v4. Read more about the breaking change here: https://github.com/andreasonny83/unique-names-generator#migration-guide');return new o(i).generate()};var a=["able","above","absent","absolute","abstract","abundant","academic","acceptable","accepted","accessible","accurate","accused","active","actual","acute","added","additional","adequate","adjacent","administrative","adorable","advanced","adverse","advisory","aesthetic","afraid","aggregate","aggressive","agreeable","agreed","agricultural","alert","alive","alleged","allied","alone","alright","alternative","amateur","amazing","ambitious","amused","ancient","angry","annoyed","annual","anonymous","anxious","appalling","apparent","applicable","appropriate","arbitrary","architectural","armed","arrogant","artificial","artistic","ashamed","asleep","assistant","associated","atomic","attractive","automatic","autonomous","available","average","awake","aware","awful","awkward","back","bad","balanced","bare","basic","beautiful","beneficial","better","bewildered","big","binding","biological","bitter","bizarre","blank","blonde","blushing","boiling","bold","bored","boring","bottom","brainy","brave","breakable","breezy","brief","bright","brilliant","broad","broken","bumpy","burning","busy","calm","capable","careful","casual","causal","cautious","central","certain","changing","characteristic","charming","cheap","cheerful","chemical","chief","chilly","chosen","chronic","chubby","circular","civic","civil","classic","classical","clean","clear","clever","clinical","close","closed","cloudy","clumsy","coastal","cognitive","coherent","cold","collective","colorful","colossal","coloured","colourful","combined","comfortable","commercial","common","compact","comparable","comparative","compatible","competent","competitive","complete","complex","complicated","comprehensive","compulsory","conceptual","concerned","concrete","condemned","confident","confidential","confused","conscious","conservation","considerable","consistent","constant","constitutional","contemporary","content","continental","continued","continuing","continuous","controlled","controversial","convenient","conventional","convinced","convincing","cooing","cool","cooperative","corporate","correct","corresponding","costly","courageous","creative","creepy","criminal","critical","crooked","crowded","crucial","crude","cruel","cuddly","cultural","curious","curly","current","curved","cute","daily","damaged","damp","dangerous","dark","dead","deafening","dear","decent","decisive","deep","defeated","defensive","defiant","definite","deliberate","delicate","delicious","delighted","delightful","democratic","dependent","depressed","desirable","desperate","detailed","determined","developed","developing","devoted","different","difficult","digital","diplomatic","direct","dirty","disappointed","disastrous","disciplinary","disgusted","distant","distinct","distinctive","distinguished","disturbed","disturbing","diverse","divine","dizzy","domestic","dominant","double","doubtful","drab","dramatic","dreadful","driving","dry","dual","due","dull","dusty","dutch","dying","dynamic","eager","early","eastern","easy","economic","educational","eerie","effective","efficient","elaborate","elated","elderly","eldest","electoral","electric","electrical","electronic","elegant","eligible","embarrassed","embarrassing","emotional","empirical","empty","enchanting","encouraging","endless","energetic","enormous","enthusiastic","entire","entitled","envious","environmental","equal","equivalent","essential","established","estimated","ethical","eventual","everyday","evident","evil","evolutionary","exact","excellent","exceptional","excess","excessive","excited","exciting","exclusive","existing","exotic","expected","expensive","experienced","experimental","explicit","extended","extensive","external","extra","extraordinary","extreme","exuberant","faint","fair","faithful","familiar","famous","fancy","fantastic","far","fascinating","fashionable","fast","fatal","favourable","favourite","federal","fellow","few","fierce","final","financial","fine","firm","fiscal","fit","fixed","flaky","flat","flexible","fluffy","fluttering","flying","following","fond","foolish","foreign","formal","formidable","forthcoming","fortunate","forward","fragile","frail","frantic","free","frequent","fresh","friendly","frightened","front","frozen","full","fun","functional","fundamental","funny","furious","future","fuzzy","gastric","general","generous","genetic","gentle","genuine","geographical","giant","gigantic","given","glad","glamorous","gleaming","global","glorious","golden","good","gorgeous","gothic","governing","graceful","gradual","grand","grateful","greasy","great","grieving","grim","gross","grotesque","growing","grubby","grumpy","guilty","handsome","happy","hard","harsh","head","healthy","heavy","helpful","helpless","hidden","high","hilarious","hissing","historic","historical","hollow","holy","homely","hon","honest","horizontal","horrible","hostile","hot","huge","human","hungry","hurt","hushed","husky","icy","ideal","identical","ideological","ill","illegal","imaginative","immediate","immense","implicit","important","impossible","impressed","impressive","improved","inadequate","inc","inclined","increased","increasing","incredible","independent","indirect","individual","industrial","inevitable","influential","informal","inherent","initial","injured","inland","inner","innocent","innovative","inquisitive","instant","institutional","insufficient","intact","integral","integrated","intellectual","intelligent","intense","intensive","interested","interesting","interim","interior","intermediate","internal","international","invisible","involved","irrelevant","isolated","itchy","jealous","jittery","joint","jolly","joyous","judicial","juicy","junior","just","keen","key","kind","known","labour","large","late","latin","lazy","leading","left","legal","legislative","legitimate","lengthy","lesser","level","lexical","liable","light","like","likely","limited","linear","linguistic","liquid","literary","little","live","lively","living","local","logical","lonely","long","loose","lost","loud","lovely","low","loyal","ltd","lucky","mad","magic","magnetic","magnificent","main","major","mammoth","managerial","managing","manual","many","marginal","marine","marked","married","marvellous","mass","massive","mathematical","mature","maximum","mean","meaningful","mechanical","medical","medieval","melodic","melted","mental","mere","metropolitan","mid","middle","mighty","mild","military","miniature","minimal","minimum","ministerial","minor","miserable","misleading","missing","misty","mixed","moaning","mobile","moderate","modern","modest","molecular","monetary","monthly","moral","motionless","muddy","multiple","mushy","musical","mutual","mysterious","naked","narrow","nasty","national","natural","naughty","naval","near","nearby","neat","necessary","negative","neighbouring","nervous","net","neutral","new","nice","noble","noisy","normal","northern","nosy","notable","novel","nuclear","numerous","nursing","nutritious","nutty","obedient","objective","obliged","obnoxious","obvious","occasional","occupational","odd","official","ok","okay","old","only","open","operational","opposite","optimistic","ordinary","organic","organisational","original","orthodox","other","outdoor","outer","outrageous","outside","outstanding","overall","overseas","overwhelming","painful","pale","panicky","parallel","parental","parliamentary","partial","particular","passing","passive","past","patient","payable","peaceful","peculiar","perfect","permanent","persistent","personal","petite","philosophical","physical","plain","planned","plastic","pleasant","pleased","poised","polite","poor","popular","positive","possible","potential","powerful","practical","precious","precise","preferred","pregnant","preliminary","premier","prepared","present","presidential","pretty","previous","prickly","primary","prime","principal","printed","prior","private","probable","productive","professional","profitable","profound","progressive","prominent","promising","proper","proposed","prospective","protective","proud","provincial","psychiatric","psychological","public","puny","pure","purring","puzzled","quaint","qualified","quarrelsome","querulous","quick","quickest","quiet","quintessential","quixotic","racial","radical","rainy","random","rapid","rare","raspy","rational","ratty","raw","ready","real","realistic","rear","reasonable","recent","reduced","redundant","regional","registered","regular","regulatory","related","relative","relaxed","relevant","reliable","relieved","religious","reluctant","remaining","remarkable","remote","renewed","representative","repulsive","required","resident","residential","resonant","respectable","respective","responsible","resulting","retail","retired","revolutionary","rich","ridiculous","right","rigid","ripe","rising","rival","roasted","robust","rolling","romantic","rotten","rough","round","royal","rubber","rude","ruling","running","rural","sacred","sad","safe","salty","satisfactory","satisfied","scared","scary","scattered","scientific","scornful","scrawny","screeching","secondary","secret","secure","select","selected","selective","selfish","semantic","senior","sensible","sensitive","separate","serious","severe","shaggy","shaky","shallow","shared","sharp","sheer","shiny","shivering","shocked","short","shrill","shy","sick","significant","silent","silky","silly","similar","simple","single","skilled","skinny","sleepy","slight","slim","slimy","slippery","slow","small","smart","smiling","smoggy","smooth","social","soft","solar","sole","solid","sophisticated","sore","sorry","sound","sour","southern","spare","sparkling","spatial","special","specific","specified","spectacular","spicy","spiritual","splendid","spontaneous","sporting","spotless","spotty","square","squealing","stable","stale","standard","static","statistical","statutory","steady","steep","sticky","stiff","still","stingy","stormy","straight","straightforward","strange","strategic","strict","striking","striped","strong","structural","stuck","subjective","subsequent","substantial","subtle","successful","successive","sudden","sufficient","suitable","sunny","super","superb","superior","supporting","supposed","supreme","sure","surprised","surprising","surrounding","surviving","suspicious","sweet","swift","symbolic","sympathetic","systematic","tall","tame","tart","tasteless","tasty","technical","technological","teenage","temporary","tender","tense","terrible","territorial","testy","then","theoretical","thick","thin","thorough","thoughtful","thoughtless","thundering","tight","tiny","tired","top","total","tough","toxic","traditional","tragic","tremendous","tricky","tropical","troubled","typical","ugliest","ugly","ultimate","unable","unacceptable","unaware","uncertain","unchanged","uncomfortable","unconscious","underground","underlying","unemployed","uneven","unexpected","unfair","unfortunate","unhappy","uniform","uninterested","unique","united","universal","unknown","unlikely","unnecessary","unpleasant","unsightly","unusual","unwilling","upper","upset","uptight","urban","urgent","used","useful","useless","usual","vague","valid","valuable","variable","varied","various","varying","vast","verbal","vertical","very","vicarious","vicious","victorious","violent","visible","visiting","visual","vital","vitreous","vivacious","vivid","vocal","vocational","voiceless","voluminous","voluntary","vulnerable","wandering","warm","wasteful","watery","weak","wealthy","weary","wee","weekly","weird","welcome","well","western","wet","whispering","whole","wicked","wide","widespread","wild","wilful","willing","willowy","wily","wise","wispy","wittering","witty","wonderful","wooden","working","worldwide","worried","worrying","worthwhile","worthy","written","wrong","xenacious","xenial","xenogeneic","xeric","xerothermic","yabbering","yammering","yappiest","yappy","yawning","yearling","yearning","yeasty","yelling","yelping","yielding","yodelling","young","youngest","youthful","ytterbic","yucky","yummy","zany","zealous","zeroth","zestful","zesty","zippy","zonal","zoophagous","zygomorphic","zygotic"],l=["aardvark","aardwolf","albatross","alligator","alpaca","amphibian","anaconda","angelfish","anglerfish","ant","anteater","antelope","antlion","ape","aphid","armadillo","asp","baboon","badger","bandicoot","barnacle","barracuda","basilisk","bass","bat","bear","beaver","bedbug","bee","beetle","bird","bison","blackbird","boa","boar","bobcat","bobolink","bonobo","bovid","bug","butterfly","buzzard","camel","canid","canidae","capybara","cardinal","caribou","carp","cat","caterpillar","catfish","catshark","cattle","centipede","cephalopod","chameleon","cheetah","chickadee","chicken","chimpanzee","chinchilla","chipmunk","cicada","clam","clownfish","cobra","cockroach","cod","condor","constrictor","coral","cougar","cow","coyote","crab","crane","crawdad","crayfish","cricket","crocodile","crow","cuckoo","damselfly","deer","dingo","dinosaur","dog","dolphin","donkey","dormouse","dove","dragon","dragonfly","duck","eagle","earthworm","earwig","echidna","eel","egret","elephant","elk","emu","ermine","falcon","felidae","ferret","finch","firefly","fish","flamingo","flea","fly","flyingfish","fowl","fox","frog","galliform","gamefowl","gayal","gazelle","gecko","gerbil","gibbon","giraffe","goat","goldfish","goose","gopher","gorilla","grasshopper","grouse","guan","guanaco","guineafowl","gull","guppy","haddock","halibut","hamster","hare","harrier","hawk","hedgehog","heron","herring","hippopotamus","hookworm","hornet","horse","hoverfly","hummingbird","hyena","iguana","impala","jackal","jaguar","jay","jellyfish","junglefowl","kangaroo","kingfisher","kite","kiwi","koala","koi","krill","ladybug","lamprey","landfowl","lark","leech","lemming","lemur","leopard","leopon","limpet","lion","lizard","llama","lobster","locust","loon","louse","lungfish","lynx","macaw","mackerel","magpie","mammal","manatee","mandrill","marlin","marmoset","marmot","marsupial","marten","mastodon","meadowlark","meerkat","mink","minnow","mite","mockingbird","mole","mollusk","mongoose","monkey","moose","mosquito","moth","mouse","mule","muskox","narwhal","newt","nightingale","ocelot","octopus","opossum","orangutan","orca","ostrich","otter","owl","ox","panda","panther","parakeet","parrot","parrotfish","partridge","peacock","peafowl","pelican","penguin","perch","pheasant","pig","pigeon","pike","pinniped","piranha","planarian","platypus","pony","porcupine","porpoise","possum","prawn","primate","ptarmigan","puffin","puma","python","quail","quelea","quokka","rabbit","raccoon","rat","rattlesnake","raven","reindeer","reptile","rhinoceros","roadrunner","rodent","rook","rooster","roundworm","sailfish","salamander","salmon","sawfish","scallop","scorpion","seahorse","shark","sheep","shrew","shrimp","silkworm","silverfish","skink","skunk","sloth","slug","smelt","snail","snake","snipe","sole","sparrow","spider","spoonbill","squid","squirrel","starfish","stingray","stoat","stork","sturgeon","swallow","swan","swift","swordfish","swordtail","tahr","takin","tapir","tarantula","tarsier","termite","tern","thrush","tick","tiger","tiglon","toad","tortoise","toucan","trout","tuna","turkey","turtle","tyrannosaurus","unicorn","urial","vicuna","viper","vole","vulture","wallaby","walrus","warbler","wasp","weasel","whale","whippet","whitefish","wildcat","wildebeest","wildfowl","wolf","wolverine","wombat","woodpecker","worm","wren","xerinae","yak","zebra"],c=["amaranth","amber","amethyst","apricot","aqua","aquamarine","azure","beige","black","blue","blush","bronze","brown","chocolate","coffee","copper","coral","crimson","cyan","emerald","fuchsia","gold","gray","green","harlequin","indigo","ivory","jade","lavender","lime","magenta","maroon","moccasin","olive","orange","peach","pink","plum","purple","red","rose","salmon","sapphire","scarlet","silver","tan","teal","tomato","turquoise","violet","white","yellow"],h=["Akan","Amharic","Arabic","Assamese","Awadhi","Azerbaijani","Balochi","Belarusian","Bhojpuri","Burmese","Cebuano","Chewa","Chhattisgarhi","Chittagonian","Czech","Deccan","Dhundhari","Dutch","English","French","Fula","Gan","German","Greek","Gujarati","Hakka","Haryanvi","Hausa","Hiligaynon","Hindi","Hmong","Hungarian","Igbo","Ilocano","Italian","Japanese","Javanese","Jin","Kannada","Kazakh","Khmer","Kinyarwanda","Kirundi","Konkani","Korean","Kurdish","Madurese","Magahi","Maithili","Malagasy","Malay","Malayalam","Mandarin","Marathi","Marwari","Min","Mossi","Nepali","Odia","Oromo","Pashto","Persian","Polish","Portuguese","Punjabi","Quechua","Romanian","Russian","Saraiki","Shona","Sindhi","Sinhala","Somali","Spanish","Sundanese","Swedish","Sylheti","Tagalog","Tamil","Telugu","Thai","Turkish","Turkmen","Ukrainian","Urdu","Uyghur","Uzbek","Vietnamese","Wu","Xhosa","Xiang","Yoruba","Yue","Zhuang","Zulu"],u=["Aaren","Aarika","Abagael","Abagail","Abbe","Abbey","Abbi","Abbie","Abby","Abbye","Abigael","Abigail","Abigale","Abra","Ada","Adah","Adaline","Adan","Adara","Adda","Addi","Addia","Addie","Addy","Adel","Adela","Adelaida","Adelaide","Adele","Adelheid","Adelice","Adelina","Adelind","Adeline","Adella","Adelle","Adena","Adey","Adi","Adiana","Adina","Adora","Adore","Adoree","Adorne","Adrea","Adria","Adriaens","Adrian","Adriana","Adriane","Adrianna","Adrianne","Adriena","Adrienne","Aeriel","Aeriela","Aeriell","Afton","Ag","Agace","Agata","Agatha","Agathe","Aggi","Aggie","Aggy","Agna","Agnella","Agnes","Agnese","Agnesse","Agneta","Agnola","Agretha","Aida","Aidan","Aigneis","Aila","Aile","Ailee","Aileen","Ailene","Ailey","Aili","Ailina","Ailis","Ailsun","Ailyn","Aime","Aimee","Aimil","Aindrea","Ainslee","Ainsley","Ainslie","Ajay","Alaine","Alameda","Alana","Alanah","Alane","Alanna","Alayne","Alberta","Albertina","Albertine","Albina","Alecia","Aleda","Aleece","Aleen","Alejandra","Alejandrina","Alena","Alene","Alessandra","Aleta","Alethea","Alex","Alexa","Alexandra","Alexandrina","Alexi","Alexia","Alexina","Alexine","Alexis","Alfi","Alfie","Alfreda","Alfy","Ali","Alia","Alica","Alice","Alicea","Alicia","Alida","Alidia","Alie","Alika","Alikee","Alina","Aline","Alis","Alisa","Alisha","Alison","Alissa","Alisun","Alix","Aliza","Alla","Alleen","Allegra","Allene","Alli","Allianora","Allie","Allina","Allis","Allison","Allissa","Allix","Allsun","Allx","Ally","Allyce","Allyn","Allys","Allyson","Alma","Almeda","Almeria","Almeta","Almira","Almire","Aloise","Aloisia","Aloysia","Alta","Althea","Alvera","Alverta","Alvina","Alvinia","Alvira","Alyce","Alyda","Alys","Alysa","Alyse","Alysia","Alyson","Alyss","Alyssa","Amabel","Amabelle","Amalea","Amalee","Amaleta","Amalia","Amalie","Amalita","Amalle","Amanda","Amandi","Amandie","Amandy","Amara","Amargo","Amata","Amber","Amberly","Ambur","Ame","Amelia","Amelie","Amelina","Ameline","Amelita","Ami","Amie","Amii","Amil","Amitie","Amity","Ammamaria","Amy","Amye","Ana","Anabal","Anabel","Anabella","Anabelle","Analiese","Analise","Anallese","Anallise","Anastasia","Anastasie","Anastassia","Anatola","Andee","Andeee","Anderea","Andi","Andie","Andra","Andrea","Andreana","Andree","Andrei","Andria","Andriana","Andriette","Andromache","Andy","Anestassia","Anet","Anett","Anetta","Anette","Ange","Angel","Angela","Angele","Angelia","Angelica","Angelika","Angelina","Angeline","Angelique","Angelita","Angelle","Angie","Angil","Angy","Ania","Anica","Anissa","Anita","Anitra","Anjanette","Anjela","Ann","Ann-marie","Anna","Anna-diana","Anna-diane","Anna-maria","Annabal","Annabel","Annabela","Annabell","Annabella","Annabelle","Annadiana","Annadiane","Annalee","Annaliese","Annalise","Annamaria","Annamarie","Anne","Anne-corinne","Anne-marie","Annecorinne","Anneliese","Annelise","Annemarie","Annetta","Annette","Anni","Annice","Annie","Annis","Annissa","Annmaria","Annmarie","Annnora","Annora","Anny","Anselma","Ansley","Anstice","Anthe","Anthea","Anthia","Anthiathia","Antoinette","Antonella","Antonetta","Antonia","Antonie","Antonietta","Antonina","Anya","Appolonia","April","Aprilette","Ara","Arabel","Arabela","Arabele","Arabella","Arabelle","Arda","Ardath","Ardeen","Ardelia","Ardelis","Ardella","Ardelle","Arden","Ardene","Ardenia","Ardine","Ardis","Ardisj","Ardith","Ardra","Ardyce","Ardys","Ardyth","Aretha","Ariadne","Ariana","Aridatha","Ariel","Ariela","Ariella","Arielle","Arlana","Arlee","Arleen","Arlen","Arlena","Arlene","Arleta","Arlette","Arleyne","Arlie","Arliene","Arlina","Arlinda","Arline","Arluene","Arly","Arlyn","Arlyne","Aryn","Ashely","Ashia","Ashien","Ashil","Ashla","Ashlan","Ashlee","Ashleigh","Ashlen","Ashley","Ashli","Ashlie","Ashly","Asia","Astra","Astrid","Astrix","Atalanta","Athena","Athene","Atlanta","Atlante","Auberta","Aubine","Aubree","Aubrette","Aubrey","Aubrie","Aubry","Audi","Audie","Audra","Audre","Audrey","Audrie","Audry","Audrye","Audy","Augusta","Auguste","Augustina","Augustine","Aundrea","Aura","Aurea","Aurel","Aurelea","Aurelia","Aurelie","Auria","Aurie","Aurilia","Aurlie","Auroora","Aurora","Aurore","Austin","Austina","Austine","Ava","Aveline","Averil","Averyl","Avie","Avis","Aviva","Avivah","Avril","Avrit","Ayn","Bab","Babara","Babb","Babbette","Babbie","Babette","Babita","Babs","Bambi","Bambie","Bamby","Barb","Barbabra","Barbara","Barbara-anne","Barbaraanne","Barbe","Barbee","Barbette","Barbey","Barbi","Barbie","Barbra","Barby","Bari","Barrie","Barry","Basia","Bathsheba","Batsheva","Bea","Beatrice","Beatrisa","Beatrix","Beatriz","Bebe","Becca","Becka","Becki","Beckie","Becky","Bee","Beilul","Beitris","Bekki","Bel","Belia","Belicia","Belinda","Belita","Bell","Bella","Bellanca","Belle","Bellina","Belva","Belvia","Bendite","Benedetta","Benedicta","Benedikta","Benetta","Benita","Benni","Bennie","Benny","Benoite","Berenice","Beret","Berget","Berna","Bernadene","Bernadette","Bernadina","Bernadine","Bernardina","Bernardine","Bernelle","Bernete","Bernetta","Bernette","Berni","Bernice","Bernie","Bernita","Berny","Berri","Berrie","Berry","Bert","Berta","Berte","Bertha","Berthe","Berti","Bertie","Bertina","Bertine","Berty","Beryl","Beryle","Bess","Bessie","Bessy","Beth","Bethanne","Bethany","Bethena","Bethina","Betsey","Betsy","Betta","Bette","Bette-ann","Betteann","Betteanne","Betti","Bettina","Bettine","Betty","Bettye","Beulah","Bev","Beverie","Beverlee","Beverley","Beverlie","Beverly","Bevvy","Bianca","Bianka","Bibbie","Bibby","Bibbye","Bibi","Biddie","Biddy","Bidget","Bili","Bill","Billi","Billie","Billy","Billye","Binni","Binnie","Binny","Bird","Birdie","Birgit","Birgitta","Blair","Blaire","Blake","Blakelee","Blakeley","Blanca","Blanch","Blancha","Blanche","Blinni","Blinnie","Blinny","Bliss","Blisse","Blithe","Blondell","Blondelle","Blondie","Blondy","Blythe","Bobbe","Bobbee","Bobbette","Bobbi","Bobbie","Bobby","Bobbye","Bobette","Bobina","Bobine","Bobinette","Bonita","Bonnee","Bonni","Bonnibelle","Bonnie","Bonny","Brana","Brandais","Brande","Brandea","Brandi","Brandice","Brandie","Brandise","Brandy","Breanne","Brear","Bree","Breena","Bren","Brena","Brenda","Brenn","Brenna","Brett","Bria","Briana","Brianna","Brianne","Bride","Bridget","Bridgette","Bridie","Brier","Brietta","Brigid","Brigida","Brigit","Brigitta","Brigitte","Brina","Briney","Brinn","Brinna","Briny","Brit","Brita","Britney","Britni","Britt","Britta","Brittan","Brittaney","Brittani","Britte","Britteny","Brittne","Brittney","Brittni","Brook","Brooke","Brooks","Brunhilda","Brunhilde","Bryana","Bryn","Bryna","Brynn","Brynna","Brynne","Buffy","Bunni","Bunnie","Bunny","Cacilia","Cacilie","Cahra","Cairistiona","Caitlin","Caitrin","Cal","Calida","Calla","Calley","Calli","Callida","Callie","Cally","Calypso","Cam","Camala","Camel","Camella","Camellia","Cami","Camila","Camile","Camilla","Camille","Cammi","Cammie","Cammy","Candace","Candi","Candice","Candida","Candide","Candie","Candis","Candra","Candy","Caprice","Cara","Caralie","Caren","Carena","Caresa","Caressa","Caresse","Carey","Cari","Caria","Carie","Caril","Carilyn","Carin","Carina","Carine","Cariotta","Carissa","Carita","Caritta","Carla","Carlee","Carleen","Carlen","Carlene","Carley","Carlie","Carlin","Carlina","Carline","Carlita","Carlota","Carlotta","Carly","Carlye","Carlyn","Carlynn","Carlynne","Carma","Carmel","Carmela","Carmelia","Carmelina","Carmelita","Carmella","Carmelle","Carmen","Carmencita","Carmina","Carmine","Carmita","Carmon","Caro","Carol","Carol-jean","Carola","Carolan","Carolann","Carole","Carolee","Carolin","Carolina","Caroline","Caroljean","Carolyn","Carolyne","Carolynn","Caron","Carree","Carri","Carrie","Carrissa","Carroll","Carry","Cary","Caryl","Caryn","Casandra","Casey","Casi","Casie","Cass","Cassandra","Cassandre","Cassandry","Cassaundra","Cassey","Cassi","Cassie","Cassondra","Cassy","Catarina","Cate","Caterina","Catha","Catharina","Catharine","Cathe","Cathee","Catherin","Catherina","Catherine","Cathi","Cathie","Cathleen","Cathlene","Cathrin","Cathrine","Cathryn","Cathy","Cathyleen","Cati","Catie","Catina","Catlaina","Catlee","Catlin","Catrina","Catriona","Caty","Caye","Cayla","Cecelia","Cecil","Cecile","Ceciley","Cecilia","Cecilla","Cecily","Ceil","Cele","Celene","Celesta","Celeste","Celestia","Celestina","Celestine","Celestyn","Celestyna","Celia","Celie","Celina","Celinda","Celine","Celinka","Celisse","Celka","Celle","Cesya","Chad","Chanda","Chandal","Chandra","Channa","Chantal","Chantalle","Charil","Charin","Charis","Charissa","Charisse","Charita","Charity","Charla","Charlean","Charleen","Charlena","Charlene","Charline","Charlot","Charlotta","Charlotte","Charmain","Charmaine","Charmane","Charmian","Charmine","Charmion","Charo","Charyl","Chastity","Chelsae","Chelsea","Chelsey","Chelsie","Chelsy","Cher","Chere","Cherey","Cheri","Cherianne","Cherice","Cherida","Cherie","Cherilyn","Cherilynn","Cherin","Cherise","Cherish","Cherlyn","Cherri","Cherrita","Cherry","Chery","Cherye","Cheryl","Cheslie","Chiarra","Chickie","Chicky","Chiquia","Chiquita","Chlo","Chloe","Chloette","Chloris","Chris","Chrissie","Chrissy","Christa","Christabel","Christabella","Christal","Christalle","Christan","Christean","Christel","Christen","Christi","Christian","Christiana","Christiane","Christie","Christin","Christina","Christine","Christy","Christye","Christyna","Chrysa","Chrysler","Chrystal","Chryste","Chrystel","Cicely","Cicily","Ciel","Cilka","Cinda","Cindee","Cindelyn","Cinderella","Cindi","Cindie","Cindra","Cindy","Cinnamon","Cissiee","Cissy","Clair","Claire","Clara","Clarabelle","Clare","Claresta","Clareta","Claretta","Clarette","Clarey","Clari","Claribel","Clarice","Clarie","Clarinda","Clarine","Clarissa","Clarisse","Clarita","Clary","Claude","Claudelle","Claudetta","Claudette","Claudia","Claudie","Claudina","Claudine","Clea","Clem","Clemence","Clementia","Clementina","Clementine","Clemmie","Clemmy","Cleo","Cleopatra","Clerissa","Clio","Clo","Cloe","Cloris","Clotilda","Clovis","Codee","Codi","Codie","Cody","Coleen","Colene","Coletta","Colette","Colleen","Collen","Collete","Collette","Collie","Colline","Colly","Con","Concettina","Conchita","Concordia","Conni","Connie","Conny","Consolata","Constance","Constancia","Constancy","Constanta","Constantia","Constantina","Constantine","Consuela","Consuelo","Cookie","Cora","Corabel","Corabella","Corabelle","Coral","Coralie","Coraline","Coralyn","Cordelia","Cordelie","Cordey","Cordi","Cordie","Cordula","Cordy","Coreen","Corella","Corenda","Corene","Coretta","Corette","Corey","Cori","Corie","Corilla","Corina","Corine","Corinna","Corinne","Coriss","Corissa","Corliss","Corly","Cornela","Cornelia","Cornelle","Cornie","Corny","Correna","Correy","Corri","Corrianne","Corrie","Corrina","Corrine","Corrinne","Corry","Cortney","Cory","Cosetta","Cosette","Costanza","Courtenay","Courtnay","Courtney","Crin","Cris","Crissie","Crissy","Crista","Cristabel","Cristal","Cristen","Cristi","Cristie","Cristin","Cristina","Cristine","Cristionna","Cristy","Crysta","Crystal","Crystie","Cthrine","Cyb","Cybil","Cybill","Cymbre","Cynde","Cyndi","Cyndia","Cyndie","Cyndy","Cynthea","Cynthia","Cynthie","Cynthy","Dacey","Dacia","Dacie","Dacy","Dael","Daffi","Daffie","Daffy","Dagmar","Dahlia","Daile","Daisey","Daisi","Daisie","Daisy","Dale","Dalenna","Dalia","Dalila","Dallas","Daloris","Damara","Damaris","Damita","Dana","Danell","Danella","Danette","Dani","Dania","Danica","Danice","Daniela","Daniele","Daniella","Danielle","Danika","Danila","Danit","Danita","Danna","Danni","Dannie","Danny","Dannye","Danya","Danyelle","Danyette","Daphene","Daphna","Daphne","Dara","Darb","Darbie","Darby","Darcee","Darcey","Darci","Darcie","Darcy","Darda","Dareen","Darell","Darelle","Dari","Daria","Darice","Darla","Darleen","Darlene","Darline","Darlleen","Daron","Darrelle","Darryl","Darsey","Darsie","Darya","Daryl","Daryn","Dasha","Dasi","Dasie","Dasya","Datha","Daune","Daveen","Daveta","Davida","Davina","Davine","Davita","Dawn","Dawna","Dayle","Dayna","Ddene","De","Deana","Deane","Deanna","Deanne","Deb","Debbi","Debbie","Debby","Debee","Debera","Debi","Debor","Debora","Deborah","Debra","Dede","Dedie","Dedra","Dee","Deeann","Deeanne","Deedee","Deena","Deerdre","Deeyn","Dehlia","Deidre","Deina","Deirdre","Del","Dela","Delcina","Delcine","Delia","Delila","Delilah","Delinda","Dell","Della","Delly","Delora","Delores","Deloria","Deloris","Delphine","Delphinia","Demeter","Demetra","Demetria","Demetris","Dena","Deni","Denice","Denise","Denna","Denni","Dennie","Denny","Deny","Denys","Denyse","Deonne","Desdemona","Desirae","Desiree","Desiri","Deva","Devan","Devi","Devin","Devina","Devinne","Devon","Devondra","Devonna","Devonne","Devora","Di","Diahann","Dian","Diana","Diandra","Diane","Diane-marie","Dianemarie","Diann","Dianna","Dianne","Diannne","Didi","Dido","Diena","Dierdre","Dina","Dinah","Dinnie","Dinny","Dion","Dione","Dionis","Dionne","Dita","Dix","Dixie","Dniren","Dode","Dodi","Dodie","Dody","Doe","Doll","Dolley","Dolli","Dollie","Dolly","Dolores","Dolorita","Doloritas","Domeniga","Dominga","Domini","Dominica","Dominique","Dona","Donella","Donelle","Donetta","Donia","Donica","Donielle","Donna","Donnamarie","Donni","Donnie","Donny","Dora","Doralia","Doralin","Doralyn","Doralynn","Doralynne","Dore","Doreen","Dorelia","Dorella","Dorelle","Dorena","Dorene","Doretta","Dorette","Dorey","Dori","Doria","Dorian","Dorice","Dorie","Dorine","Doris","Dorisa","Dorise","Dorita","Doro","Dorolice","Dorolisa","Dorotea","Doroteya","Dorothea","Dorothee","Dorothy","Dorree","Dorri","Dorrie","Dorris","Dorry","Dorthea","Dorthy","Dory","Dosi","Dot","Doti","Dotti","Dottie","Dotty","Dre","Dreddy","Dredi","Drona","Dru","Druci","Drucie","Drucill","Drucy","Drusi","Drusie","Drusilla","Drusy","Dulce","Dulcea","Dulci","Dulcia","Dulciana","Dulcie","Dulcine","Dulcinea","Dulcy","Dulsea","Dusty","Dyan","Dyana","Dyane","Dyann","Dyanna","Dyanne","Dyna","Dynah","Eachelle","Eada","Eadie","Eadith","Ealasaid","Eartha","Easter","Eba","Ebba","Ebonee","Ebony","Eda","Eddi","Eddie","Eddy","Ede","Edee","Edeline","Eden","Edi","Edie","Edin","Edita","Edith","Editha","Edithe","Ediva","Edna","Edwina","Edy","Edyth","Edythe","Effie","Eileen","Eilis","Eimile","Eirena","Ekaterina","Elaina","Elaine","Elana","Elane","Elayne","Elberta","Elbertina","Elbertine","Eleanor","Eleanora","Eleanore","Electra","Eleen","Elena","Elene","Eleni","Elenore","Eleonora","Eleonore","Elfie","Elfreda","Elfrida","Elfrieda","Elga","Elianora","Elianore","Elicia","Elie","Elinor","Elinore","Elisa","Elisabet","Elisabeth","Elisabetta","Elise","Elisha","Elissa","Elita","Eliza","Elizabet","Elizabeth","Elka","Elke","Ella","Elladine","Elle","Ellen","Ellene","Ellette","Elli","Ellie","Ellissa","Elly","Ellyn","Ellynn","Elmira","Elna","Elnora","Elnore","Eloisa","Eloise","Elonore","Elora","Elsa","Elsbeth","Else","Elset","Elsey","Elsi","Elsie","Elsinore","Elspeth","Elsy","Elva","Elvera","Elvina","Elvira","Elwira","Elyn","Elyse","Elysee","Elysha","Elysia","Elyssa","Em","Ema","Emalee","Emalia","Emelda","Emelia","Emelina","Emeline","Emelita","Emelyne","Emera","Emilee","Emili","Emilia","Emilie","Emiline","Emily","Emlyn","Emlynn","Emlynne","Emma","Emmalee","Emmaline","Emmalyn","Emmalynn","Emmalynne","Emmeline","Emmey","Emmi","Emmie","Emmy","Emmye","Emogene","Emyle","Emylee","Engracia","Enid","Enrica","Enrichetta","Enrika","Enriqueta","Eolanda","Eolande","Eran","Erda","Erena","Erica","Ericha","Ericka","Erika","Erin","Erina","Erinn","Erinna","Erma","Ermengarde","Ermentrude","Ermina","Erminia","Erminie","Erna","Ernaline","Ernesta","Ernestine","Ertha","Eryn","Esma","Esmaria","Esme","Esmeralda","Essa","Essie","Essy","Esta","Estel","Estele","Estell","Estella","Estelle","Ester","Esther","Estrella","Estrellita","Ethel","Ethelda","Ethelin","Ethelind","Etheline","Ethelyn","Ethyl","Etta","Etti","Ettie","Etty","Eudora","Eugenia","Eugenie","Eugine","Eula","Eulalie","Eunice","Euphemia","Eustacia","Eva","Evaleen","Evangelia","Evangelin","Evangelina","Evangeline","Evania","Evanne","Eve","Eveleen","Evelina","Eveline","Evelyn","Evey","Evie","Evita","Evonne","Evvie","Evvy","Evy","Eyde","Eydie","Ezmeralda","Fae","Faina","Faith","Fallon","Fan","Fanchette","Fanchon","Fancie","Fancy","Fanechka","Fania","Fanni","Fannie","Fanya","Fara","Farah","Farand","Farica","Farra","Farrah","Farrand","Faun","Faunie","Faustina","Faustine","Fawn","Fawne","Fawnia","Fay","Faydra","Faye","Fayette","Fayina","Fayre","Fayth","Faythe","Federica","Fedora","Felecia","Felicdad","Felice","Felicia","Felicity","Felicle","Felipa","Felisha","Felita","Feliza","Fenelia","Feodora","Ferdinanda","Ferdinande","Fern","Fernanda","Fernande","Fernandina","Ferne","Fey","Fiann","Fianna","Fidela","Fidelia","Fidelity","Fifi","Fifine","Filia","Filide","Filippa","Fina","Fiona","Fionna","Fionnula","Fiorenze","Fleur","Fleurette","Flo","Flor","Flora","Florance","Flore","Florella","Florence","Florencia","Florentia","Florenza","Florette","Flori","Floria","Florida","Florie","Florina","Florinda","Floris","Florri","Florrie","Florry","Flory","Flossi","Flossie","Flossy","Flss","Fran","Francene","Frances","Francesca","Francine","Francisca","Franciska","Francoise","Francyne","Frank","Frankie","Franky","Franni","Frannie","Franny","Frayda","Fred","Freda","Freddi","Freddie","Freddy","Fredelia","Frederica","Fredericka","Frederique","Fredi","Fredia","Fredra","Fredrika","Freida","Frieda","Friederike","Fulvia","Gabbey","Gabbi","Gabbie","Gabey","Gabi","Gabie","Gabriel","Gabriela","Gabriell","Gabriella","Gabrielle","Gabriellia","Gabrila","Gaby","Gae","Gael","Gail","Gale","Galina","Garland","Garnet","Garnette","Gates","Gavra","Gavrielle","Gaye","Gayel","Gayla","Gayle","Gayleen","Gaylene","Gaynor","Gelya","Gena","Gene","Geneva","Genevieve","Genevra","Genia","Genna","Genni","Gennie","Gennifer","Genny","Genovera","Genvieve","George","Georgeanna","Georgeanne","Georgena","Georgeta","Georgetta","Georgette","Georgia","Georgiana","Georgianna","Georgianne","Georgie","Georgina","Georgine","Geralda","Geraldine","Gerda","Gerhardine","Geri","Gerianna","Gerianne","Gerladina","Germain","Germaine","Germana","Gerri","Gerrie","Gerrilee","Gerry","Gert","Gerta","Gerti","Gertie","Gertrud","Gertruda","Gertrude","Gertrudis","Gerty","Giacinta","Giana","Gianina","Gianna","Gigi","Gilberta","Gilberte","Gilbertina","Gilbertine","Gilda","Gilemette","Gill","Gillan","Gilli","Gillian","Gillie","Gilligan","Gilly","Gina","Ginelle","Ginevra","Ginger","Ginni","Ginnie","Ginnifer","Ginny","Giorgia","Giovanna","Gipsy","Giralda","Gisela","Gisele","Gisella","Giselle","Giuditta","Giulia","Giulietta","Giustina","Gizela","Glad","Gladi","Gladys","Gleda","Glen","Glenda","Glenine","Glenn","Glenna","Glennie","Glennis","Glori","Gloria","Gloriana","Gloriane","Glory","Glyn","Glynda","Glynis","Glynnis","Gnni","Godiva","Golda","Goldarina","Goldi","Goldia","Goldie","Goldina","Goldy","Grace","Gracia","Gracie","Grata","Gratia","Gratiana","Gray","Grayce","Grazia","Greer","Greta","Gretal","Gretchen","Grete","Gretel","Grethel","Gretna","Gretta","Grier","Griselda","Grissel","Guendolen","Guenevere","Guenna","Guglielma","Gui","Guillema","Guillemette","Guinevere","Guinna","Gunilla","Gus","Gusella","Gussi","Gussie","Gussy","Gusta","Gusti","Gustie","Gusty","Gwen","Gwendolen","Gwendolin","Gwendolyn","Gweneth","Gwenette","Gwenneth","Gwenni","Gwennie","Gwenny","Gwenora","Gwenore","Gwyn","Gwyneth","Gwynne","Hadria","Hailee","Haily","Haleigh","Halette","Haley","Hali","Halie","Halimeda","Halley","Halli","Hallie","Hally","Hana","Hanna","Hannah","Hanni","Hannie","Hannis","Hanny","Happy","Harlene","Harley","Harli","Harlie","Harmonia","Harmonie","Harmony","Harri","Harrie","Harriet","Harriett","Harrietta","Harriette","Harriot","Harriott","Hatti","Hattie","Hatty","Hayley","Hazel","Heath","Heather","Heda","Hedda","Heddi","Heddie","Hedi","Hedvig","Hedvige","Hedwig","Hedwiga","Hedy","Heida","Heidi","Heidie","Helaina","Helaine","Helen","Helen-elizabeth","Helena","Helene","Helenka","Helga","Helge","Helli","Heloise","Helsa","Helyn","Hendrika","Henka","Henrie","Henrieta","Henrietta","Henriette","Henryetta","Hephzibah","Hermia","Hermina","Hermine","Herminia","Hermione","Herta","Hertha","Hester","Hesther","Hestia","Hetti","Hettie","Hetty","Hilary","Hilda","Hildagard","Hildagarde","Hilde","Hildegaard","Hildegarde","Hildy","Hillary","Hilliary","Hinda","Holli","Hollie","Holly","Holly-anne","Hollyanne","Honey","Honor","Honoria","Hope","Horatia","Hortense","Hortensia","Hulda","Hyacinth","Hyacintha","Hyacinthe","Hyacinthia","Hyacinthie","Hynda","Ianthe","Ibbie","Ibby","Ida","Idalia","Idalina","Idaline","Idell","Idelle","Idette","Ileana","Ileane","Ilene","Ilise","Ilka","Illa","Ilsa","Ilse","Ilysa","Ilyse","Ilyssa","Imelda","Imogen","Imogene","Imojean","Ina","Indira","Ines","Inesita","Inessa","Inez","Inga","Ingaberg","Ingaborg","Inge","Ingeberg","Ingeborg","Inger","Ingrid","Ingunna","Inna","Iolande","Iolanthe","Iona","Iormina","Ira","Irena","Irene","Irina","Iris","Irita","Irma","Isa","Isabel","Isabelita","Isabella","Isabelle","Isadora","Isahella","Iseabal","Isidora","Isis","Isobel","Issi","Issie","Issy","Ivett","Ivette","Ivie","Ivonne","Ivory","Ivy","Izabel","Jacenta","Jacinda","Jacinta","Jacintha","Jacinthe","Jackelyn","Jacki","Jackie","Jacklin","Jacklyn","Jackquelin","Jackqueline","Jacky","Jaclin","Jaclyn","Jacquelin","Jacqueline","Jacquelyn","Jacquelynn","Jacquenetta","Jacquenette","Jacquetta","Jacquette","Jacqui","Jacquie","Jacynth","Jada","Jade","Jaime","Jaimie","Jaine","Jami","Jamie","Jamima","Jammie","Jan","Jana","Janaya","Janaye","Jandy","Jane","Janean","Janeczka","Janeen","Janel","Janela","Janella","Janelle","Janene","Janenna","Janessa","Janet","Janeta","Janetta","Janette","Janeva","Janey","Jania","Janice","Janie","Janifer","Janina","Janine","Janis","Janith","Janka","Janna","Jannel","Jannelle","Janot","Jany","Jaquelin","Jaquelyn","Jaquenetta","Jaquenette","Jaquith","Jasmin","Jasmina","Jasmine","Jayme","Jaymee","Jayne","Jaynell","Jazmin","Jean","Jeana","Jeane","Jeanelle","Jeanette","Jeanie","Jeanine","Jeanna","Jeanne","Jeannette","Jeannie","Jeannine","Jehanna","Jelene","Jemie","Jemima","Jemimah","Jemmie","Jemmy","Jen","Jena","Jenda","Jenelle","Jeni","Jenica","Jeniece","Jenifer","Jeniffer","Jenilee","Jenine","Jenn","Jenna","Jennee","Jennette","Jenni","Jennica","Jennie","Jennifer","Jennilee","Jennine","Jenny","Jeralee","Jere","Jeri","Jermaine","Jerrie","Jerrilee","Jerrilyn","Jerrine","Jerry","Jerrylee","Jess","Jessa","Jessalin","Jessalyn","Jessamine","Jessamyn","Jesse","Jesselyn","Jessi","Jessica","Jessie","Jessika","Jessy","Jewel","Jewell","Jewelle","Jill","Jillana","Jillane","Jillayne","Jilleen","Jillene","Jilli","Jillian","Jillie","Jilly","Jinny","Jo","Jo-ann","Jo-anne","Joan","Joana","Joane","Joanie","Joann","Joanna","Joanne","Joannes","Jobey","Jobi","Jobie","Jobina","Joby","Jobye","Jobyna","Jocelin","Joceline","Jocelyn","Jocelyne","Jodee","Jodi","Jodie","Jody","Joeann","Joela","Joelie","Joell","Joella","Joelle","Joellen","Joelly","Joellyn","Joelynn","Joete","Joey","Johanna","Johannah","Johna","Johnath","Johnette","Johnna","Joice","Jojo","Jolee","Joleen","Jolene","Joletta","Joli","Jolie","Joline","Joly","Jolyn","Jolynn","Jonell","Joni","Jonie","Jonis","Jordain","Jordan","Jordana","Jordanna","Jorey","Jori","Jorie","Jorrie","Jorry","Joscelin","Josee","Josefa","Josefina","Josepha","Josephina","Josephine","Josey","Josi","Josie","Josselyn","Josy","Jourdan","Joy","Joya","Joyan","Joyann","Joyce","Joycelin","Joye","Jsandye","Juana","Juanita","Judi","Judie","Judith","Juditha","Judy","Judye","Juieta","Julee","Juli","Julia","Juliana","Juliane","Juliann","Julianna","Julianne","Julie","Julienne","Juliet","Julieta","Julietta","Juliette","Julina","Juline","Julissa","Julita","June","Junette","Junia","Junie","Junina","Justina","Justine","Justinn","Jyoti","Kacey","Kacie","Kacy","Kaela","Kai","Kaia","Kaila","Kaile","Kailey","Kaitlin","Kaitlyn","Kaitlynn","Kaja","Kakalina","Kala","Kaleena","Kali","Kalie","Kalila","Kalina","Kalinda","Kalindi","Kalli","Kally","Kameko","Kamila","Kamilah","Kamillah","Kandace","Kandy","Kania","Kanya","Kara","Kara-lynn","Karalee","Karalynn","Kare","Karee","Karel","Karen","Karena","Kari","Karia","Karie","Karil","Karilynn","Karin","Karina","Karine","Kariotta","Karisa","Karissa","Karita","Karla","Karlee","Karleen","Karlen","Karlene","Karlie","Karlotta","Karlotte","Karly","Karlyn","Karmen","Karna","Karol","Karola","Karole","Karolina","Karoline","Karoly","Karon","Karrah","Karrie","Karry","Kary","Karyl","Karylin","Karyn","Kasey","Kass","Kassandra","Kassey","Kassi","Kassia","Kassie","Kat","Kata","Katalin","Kate","Katee","Katerina","Katerine","Katey","Kath","Katha","Katharina","Katharine","Katharyn","Kathe","Katherina","Katherine","Katheryn","Kathi","Kathie","Kathleen","Kathlin","Kathrine","Kathryn","Kathryne","Kathy","Kathye","Kati","Katie","Katina","Katine","Katinka","Katleen","Katlin","Katrina","Katrine","Katrinka","Katti","Kattie","Katuscha","Katusha","Katy","Katya","Kay","Kaycee","Kaye","Kayla","Kayle","Kaylee","Kayley","Kaylil","Kaylyn","Keeley","Keelia","Keely","Kelcey","Kelci","Kelcie","Kelcy","Kelila","Kellen","Kelley","Kelli","Kellia","Kellie","Kellina","Kellsie","Kelly","Kellyann","Kelsey","Kelsi","Kelsy","Kendra","Kendre","Kenna","Keri","Keriann","Kerianne","Kerri","Kerrie","Kerrill","Kerrin","Kerry","Kerstin","Kesley","Keslie","Kessia","Kessiah","Ketti","Kettie","Ketty","Kevina","Kevyn","Ki","Kiah","Kial","Kiele","Kiersten","Kikelia","Kiley","Kim","Kimberlee","Kimberley","Kimberli","Kimberly","Kimberlyn","Kimbra","Kimmi","Kimmie","Kimmy","Kinna","Kip","Kipp","Kippie","Kippy","Kira","Kirbee","Kirbie","Kirby","Kiri","Kirsten","Kirsteni","Kirsti","Kirstin","Kirstyn","Kissee","Kissiah","Kissie","Kit","Kitti","Kittie","Kitty","Kizzee","Kizzie","Klara","Klarika","Klarrisa","Konstance","Konstanze","Koo","Kora","Koral","Koralle","Kordula","Kore","Korella","Koren","Koressa","Kori","Korie","Korney","Korrie","Korry","Kris","Krissie","Krissy","Krista","Kristal","Kristan","Kriste","Kristel","Kristen","Kristi","Kristien","Kristin","Kristina","Kristine","Kristy","Kristyn","Krysta","Krystal","Krystalle","Krystle","Krystyna","Kyla","Kyle","Kylen","Kylie","Kylila","Kylynn","Kym","Kynthia","Kyrstin","Lacee","Lacey","Lacie","Lacy","Ladonna","Laetitia","Laina","Lainey","Lana","Lanae","Lane","Lanette","Laney","Lani","Lanie","Lanita","Lanna","Lanni","Lanny","Lara","Laraine","Lari","Larina","Larine","Larisa","Larissa","Lark","Laryssa","Latashia","Latia","Latisha","Latrena","Latrina","Laura","Lauraine","Laural","Lauralee","Laure","Lauree","Laureen","Laurel","Laurella","Lauren","Laurena","Laurene","Lauretta","Laurette","Lauri","Laurianne","Laurice","Laurie","Lauryn","Lavena","Laverna","Laverne","Lavina","Lavinia","Lavinie","Layla","Layne","Layney","Lea","Leah","Leandra","Leann","Leanna","Leanor","Leanora","Lebbie","Leda","Lee","Leeann","Leeanne","Leela","Leelah","Leena","Leesa","Leese","Legra","Leia","Leigh","Leigha","Leila","Leilah","Leisha","Lela","Lelah","Leland","Lelia","Lena","Lenee","Lenette","Lenka","Lenna","Lenora","Lenore","Leodora","Leoine","Leola","Leoline","Leona","Leonanie","Leone","Leonelle","Leonie","Leonora","Leonore","Leontine","Leontyne","Leora","Leshia","Lesley","Lesli","Leslie","Lesly","Lesya","Leta","Lethia","Leticia","Letisha","Letitia","Letizia","Letta","Letti","Lettie","Letty","Lexi","Lexie","Lexine","Lexis","Lexy","Leyla","Lezlie","Lia","Lian","Liana","Liane","Lianna","Lianne","Lib","Libbey","Libbi","Libbie","Libby","Licha","Lida","Lidia","Liesa","Lil","Lila","Lilah","Lilas","Lilia","Lilian","Liliane","Lilias","Lilith","Lilla","Lilli","Lillian","Lillis","Lilllie","Lilly","Lily","Lilyan","Lin","Lina","Lind","Linda","Lindi","Lindie","Lindsay","Lindsey","Lindsy","Lindy","Linea","Linell","Linet","Linette","Linn","Linnea","Linnell","Linnet","Linnie","Linzy","Lira","Lisa","Lisabeth","Lisbeth","Lise","Lisetta","Lisette","Lisha","Lishe","Lissa","Lissi","Lissie","Lissy","Lita","Liuka","Liv","Liva","Livia","Livvie","Livvy","Livvyy","Livy","Liz","Liza","Lizabeth","Lizbeth","Lizette","Lizzie","Lizzy","Loella","Lois","Loise","Lola","Loleta","Lolita","Lolly","Lona","Lonee","Loni","Lonna","Lonni","Lonnie","Lora","Lorain","Loraine","Loralee","Loralie","Loralyn","Loree","Loreen","Lorelei","Lorelle","Loren","Lorena","Lorene","Lorenza","Loretta","Lorette","Lori","Loria","Lorianna","Lorianne","Lorie","Lorilee","Lorilyn","Lorinda","Lorine","Lorita","Lorna","Lorne","Lorraine","Lorrayne","Lorri","Lorrie","Lorrin","Lorry","Lory","Lotta","Lotte","Lotti","Lottie","Lotty","Lou","Louella","Louisa","Louise","Louisette","Loutitia","Lu","Luce","Luci","Lucia","Luciana","Lucie","Lucienne","Lucila","Lucilia","Lucille","Lucina","Lucinda","Lucine","Lucita","Lucky","Lucretia","Lucy","Ludovika","Luella","Luelle","Luisa","Luise","Lula","Lulita","Lulu","Lura","Lurette","Lurleen","Lurlene","Lurline","Lusa","Luz","Lyda","Lydia","Lydie","Lyn","Lynda","Lynde","Lyndel","Lyndell","Lyndsay","Lyndsey","Lyndsie","Lyndy","Lynea","Lynelle","Lynett","Lynette","Lynn","Lynna","Lynne","Lynnea","Lynnell","Lynnelle","Lynnet","Lynnett","Lynnette","Lynsey","Lyssa","Mab","Mabel","Mabelle","Mable","Mada","Madalena","Madalyn","Maddalena","Maddi","Maddie","Maddy","Madel","Madelaine","Madeleine","Madelena","Madelene","Madelin","Madelina","Madeline","Madella","Madelle","Madelon","Madelyn","Madge","Madlen","Madlin","Madonna","Mady","Mae","Maegan","Mag","Magda","Magdaia","Magdalen","Magdalena","Magdalene","Maggee","Maggi","Maggie","Maggy","Mahala","Mahalia","Maia","Maible","Maiga","Maighdiln","Mair","Maire","Maisey","Maisie","Maitilde","Mala","Malanie","Malena","Malia","Malina","Malinda","Malinde","Malissa","Malissia","Mallissa","Mallorie","Mallory","Malorie","Malory","Malva","Malvina","Malynda","Mame","Mamie","Manda","Mandi","Mandie","Mandy","Manon","Manya","Mara","Marabel","Marcela","Marcelia","Marcella","Marcelle","Marcellina","Marcelline","Marchelle","Marci","Marcia","Marcie","Marcile","Marcille","Marcy","Mareah","Maren","Marena","Maressa","Marga","Margalit","Margalo","Margaret","Margareta","Margarete","Margaretha","Margarethe","Margaretta","Margarette","Margarita","Margaux","Marge","Margeaux","Margery","Marget","Margette","Margi","Margie","Margit","Margo","Margot","Margret","Marguerite","Margy","Mari","Maria","Mariam","Marian","Mariana","Mariann","Marianna","Marianne","Maribel","Maribelle","Maribeth","Marice","Maridel","Marie","Marie-ann","Marie-jeanne","Marieann","Mariejeanne","Mariel","Mariele","Marielle","Mariellen","Marietta","Mariette","Marigold","Marijo","Marika","Marilee","Marilin","Marillin","Marilyn","Marin","Marina","Marinna","Marion","Mariquilla","Maris","Marisa","Mariska","Marissa","Marita","Maritsa","Mariya","Marj","Marja","Marje","Marji","Marjie","Marjorie","Marjory","Marjy","Marketa","Marla","Marlane","Marleah","Marlee","Marleen","Marlena","Marlene","Marley","Marlie","Marline","Marlo","Marlyn","Marna","Marne","Marney","Marni","Marnia","Marnie","Marquita","Marrilee","Marris","Marrissa","Marsha","Marsiella","Marta","Martelle","Martguerita","Martha","Marthe","Marthena","Marti","Martica","Martie","Martina","Martita","Marty","Martynne","Mary","Marya","Maryann","Maryanna","Maryanne","Marybelle","Marybeth","Maryellen","Maryjane","Maryjo","Maryl","Marylee","Marylin","Marylinda","Marylou","Marylynne","Maryrose","Marys","Marysa","Masha","Matelda","Mathilda","Mathilde","Matilda","Matilde","Matti","Mattie","Matty","Maud","Maude","Maudie","Maura","Maure","Maureen","Maureene","Maurene","Maurine","Maurise","Maurita","Maurizia","Mavis","Mavra","Max","Maxi","Maxie","Maxine","Maxy","May","Maybelle","Maye","Mead","Meade","Meagan","Meaghan","Meara","Mechelle","Meg","Megan","Megen","Meggi","Meggie","Meggy","Meghan","Meghann","Mehetabel","Mei","Mel","Mela","Melamie","Melania","Melanie","Melantha","Melany","Melba","Melesa","Melessa","Melicent","Melina","Melinda","Melinde","Melisa","Melisande","Melisandra","Melisenda","Melisent","Melissa","Melisse","Melita","Melitta","Mella","Melli","Mellicent","Mellie","Mellisa","Mellisent","Melloney","Melly","Melodee","Melodie","Melody","Melonie","Melony","Melosa","Melva","Mercedes","Merci","Mercie","Mercy","Meredith","Meredithe","Meridel","Meridith","Meriel","Merilee","Merilyn","Meris","Merissa","Merl","Merla","Merle","Merlina","Merline","Merna","Merola","Merralee","Merridie","Merrie","Merrielle","Merrile","Merrilee","Merrili","Merrill","Merrily","Merry","Mersey","Meryl","Meta","Mia","Micaela","Michaela","Michaelina","Michaeline","Michaella","Michal","Michel","Michele","Michelina","Micheline","Michell","Michelle","Micki","Mickie","Micky","Midge","Mignon","Mignonne","Miguela","Miguelita","Mikaela","Mil","Mildred","Mildrid","Milena","Milicent","Milissent","Milka","Milli","Millicent","Millie","Millisent","Milly","Milzie","Mimi","Min","Mina","Minda","Mindy","Minerva","Minetta","Minette","Minna","Minnaminnie","Minne","Minni","Minnie","Minnnie","Minny","Minta","Miquela","Mira","Mirabel","Mirabella","Mirabelle","Miran","Miranda","Mireielle","Mireille","Mirella","Mirelle","Miriam","Mirilla","Mirna","Misha","Missie","Missy","Misti","Misty","Mitzi","Modesta","Modestia","Modestine","Modesty","Moina","Moira","Moll","Mollee","Molli","Mollie","Molly","Mommy","Mona","Monah","Monica","Monika","Monique","Mora","Moreen","Morena","Morgan","Morgana","Morganica","Morganne","Morgen","Moria","Morissa","Morna","Moselle","Moyna","Moyra","Mozelle","Muffin","Mufi","Mufinella","Muire","Mureil","Murial","Muriel","Murielle","Myra","Myrah","Myranda","Myriam","Myrilla","Myrle","Myrlene","Myrna","Myrta","Myrtia","Myrtice","Myrtie","Myrtle","Nada","Nadean","Nadeen","Nadia","Nadine","Nadiya","Nady","Nadya","Nalani","Nan","Nana","Nananne","Nance","Nancee","Nancey","Nanci","Nancie","Nancy","Nanete","Nanette","Nani","Nanice","Nanine","Nannette","Nanni","Nannie","Nanny","Nanon","Naoma","Naomi","Nara","Nari","Nariko","Nat","Nata","Natala","Natalee","Natalie","Natalina","Nataline","Natalya","Natasha","Natassia","Nathalia","Nathalie","Natividad","Natka","Natty","Neala","Neda","Nedda","Nedi","Neely","Neila","Neile","Neilla","Neille","Nelia","Nelie","Nell","Nelle","Nelli","Nellie","Nelly","Nerissa","Nerita","Nert","Nerta","Nerte","Nerti","Nertie","Nerty","Nessa","Nessi","Nessie","Nessy","Nesta","Netta","Netti","Nettie","Nettle","Netty","Nevsa","Neysa","Nichol","Nichole","Nicholle","Nicki","Nickie","Nicky","Nicol","Nicola","Nicole","Nicolea","Nicolette","Nicoli","Nicolina","Nicoline","Nicolle","Nikaniki","Nike","Niki","Nikki","Nikkie","Nikoletta","Nikolia","Nina","Ninetta","Ninette","Ninnetta","Ninnette","Ninon","Nissa","Nisse","Nissie","Nissy","Nita","Nixie","Noami","Noel","Noelani","Noell","Noella","Noelle","Noellyn","Noelyn","Noemi","Nola","Nolana","Nolie","Nollie","Nomi","Nona","Nonah","Noni","Nonie","Nonna","Nonnah","Nora","Norah","Norean","Noreen","Norene","Norina","Norine","Norma","Norri","Norrie","Norry","Novelia","Nydia","Nyssa","Octavia","Odele","Odelia","Odelinda","Odella","Odelle","Odessa","Odetta","Odette","Odilia","Odille","Ofelia","Ofella","Ofilia","Ola","Olenka","Olga","Olia","Olimpia","Olive","Olivette","Olivia","Olivie","Oliy","Ollie","Olly","Olva","Olwen","Olympe","Olympia","Olympie","Ondrea","Oneida","Onida","Oona","Opal","Opalina","Opaline","Ophelia","Ophelie","Ora","Oralee","Oralia","Oralie","Oralla","Oralle","Orel","Orelee","Orelia","Orelie","Orella","Orelle","Oriana","Orly","Orsa","Orsola","Ortensia","Otha","Othelia","Othella","Othilia","Othilie","Ottilie","Page","Paige","Paloma","Pam","Pamela","Pamelina","Pamella","Pammi","Pammie","Pammy","Pandora","Pansie","Pansy","Paola","Paolina","Papagena","Pat","Patience","Patrica","Patrice","Patricia","Patrizia","Patsy","Patti","Pattie","Patty","Paula","Paule","Pauletta","Paulette","Pauli","Paulie","Paulina","Pauline","Paulita","Pauly","Pavia","Pavla","Pearl","Pearla","Pearle","Pearline","Peg","Pegeen","Peggi","Peggie","Peggy","Pen","Penelopa","Penelope","Penni","Pennie","Penny","Pepi","Pepita","Peri","Peria","Perl","Perla","Perle","Perri","Perrine","Perry","Persis","Pet","Peta","Petra","Petrina","Petronella","Petronia","Petronilla","Petronille","Petunia","Phaedra","Phaidra","Phebe","Phedra","Phelia","Phil","Philipa","Philippa","Philippe","Philippine","Philis","Phillida","Phillie","Phillis","Philly","Philomena","Phoebe","Phylis","Phyllida","Phyllis","Phyllys","Phylys","Pia","Pier","Pierette","Pierrette","Pietra","Piper","Pippa","Pippy","Polly","Pollyanna","Pooh","Poppy","Portia","Pris","Prisca","Priscella","Priscilla","Prissie","Pru","Prudence","Prudi","Prudy","Prue","Queenie","Quentin","Querida","Quinn","Quinta","Quintana","Quintilla","Quintina","Rachael","Rachel","Rachele","Rachelle","Rae","Raeann","Raf","Rafa","Rafaela","Rafaelia","Rafaelita","Rahal","Rahel","Raina","Raine","Rakel","Ralina","Ramona","Ramonda","Rana","Randa","Randee","Randene","Randi","Randie","Randy","Ranee","Rani","Rania","Ranice","Ranique","Ranna","Raphaela","Raquel","Raquela","Rasia","Rasla","Raven","Ray","Raychel","Raye","Rayna","Raynell","Rayshell","Rea","Reba","Rebbecca","Rebe","Rebeca","Rebecca","Rebecka","Rebeka","Rebekah","Rebekkah","Ree","Reeba","Reena","Reeta","Reeva","Regan","Reggi","Reggie","Regina","Regine","Reiko","Reina","Reine","Remy","Rena","Renae","Renata","Renate","Rene","Renee","Renell","Renelle","Renie","Rennie","Reta","Retha","Revkah","Rey","Reyna","Rhea","Rheba","Rheta","Rhetta","Rhiamon","Rhianna","Rhianon","Rhoda","Rhodia","Rhodie","Rhody","Rhona","Rhonda","Riane","Riannon","Rianon","Rica","Ricca","Rici","Ricki","Rickie","Ricky","Riki","Rikki","Rina","Risa","Rita","Riva","Rivalee","Rivi","Rivkah","Rivy","Roana","Roanna","Roanne","Robbi","Robbie","Robbin","Robby","Robbyn","Robena","Robenia","Roberta","Robin","Robina","Robinet","Robinett","Robinetta","Robinette","Robinia","Roby","Robyn","Roch","Rochell","Rochella","Rochelle","Rochette","Roda","Rodi","Rodie","Rodina","Rois","Romola","Romona","Romonda","Romy","Rona","Ronalda","Ronda","Ronica","Ronna","Ronni","Ronnica","Ronnie","Ronny","Roobbie","Rora","Rori","Rorie","Rory","Ros","Rosa","Rosabel","Rosabella","Rosabelle","Rosaleen","Rosalia","Rosalie","Rosalind","Rosalinda","Rosalinde","Rosaline","Rosalyn","Rosalynd","Rosamond","Rosamund","Rosana","Rosanna","Rosanne","Rose","Roseann","Roseanna","Roseanne","Roselia","Roselin","Roseline","Rosella","Roselle","Rosemaria","Rosemarie","Rosemary","Rosemonde","Rosene","Rosetta","Rosette","Roshelle","Rosie","Rosina","Rosita","Roslyn","Rosmunda","Rosy","Row","Rowe","Rowena","Roxana","Roxane","Roxanna","Roxanne","Roxi","Roxie","Roxine","Roxy","Roz","Rozalie","Rozalin","Rozamond","Rozanna","Rozanne","Roze","Rozele","Rozella","Rozelle","Rozina","Rubetta","Rubi","Rubia","Rubie","Rubina","Ruby","Ruperta","Ruth","Ruthann","Ruthanne","Ruthe","Ruthi","Ruthie","Ruthy","Ryann","Rycca","Saba","Sabina","Sabine","Sabra","Sabrina","Sacha","Sada","Sadella","Sadie","Sadye","Saidee","Sal","Salaidh","Sallee","Salli","Sallie","Sally","Sallyann","Sallyanne","Saloma","Salome","Salomi","Sam","Samantha","Samara","Samaria","Sammy","Sande","Sandi","Sandie","Sandra","Sandy","Sandye","Sapphira","Sapphire","Sara","Sara-ann","Saraann","Sarah","Sarajane","Saree","Sarena","Sarene","Sarette","Sari","Sarina","Sarine","Sarita","Sascha","Sasha","Sashenka","Saudra","Saundra","Savina","Sayre","Scarlet","Scarlett","Sean","Seana","Seka","Sela","Selena","Selene","Selestina","Selia","Selie","Selina","Selinda","Seline","Sella","Selle","Selma","Sena","Sephira","Serena","Serene","Shae","Shaina","Shaine","Shalna","Shalne","Shana","Shanda","Shandee","Shandeigh","Shandie","Shandra","Shandy","Shane","Shani","Shanie","Shanna","Shannah","Shannen","Shannon","Shanon","Shanta","Shantee","Shara","Sharai","Shari","Sharia","Sharity","Sharl","Sharla","Sharleen","Sharlene","Sharline","Sharon","Sharona","Sharron","Sharyl","Shaun","Shauna","Shawn","Shawna","Shawnee","Shay","Shayla","Shaylah","Shaylyn","Shaylynn","Shayna","Shayne","Shea","Sheba","Sheela","Sheelagh","Sheelah","Sheena","Sheeree","Sheila","Sheila-kathryn","Sheilah","Shel","Shela","Shelagh","Shelba","Shelbi","Shelby","Shelia","Shell","Shelley","Shelli","Shellie","Shelly","Shena","Sher","Sheree","Sheri","Sherie","Sherill","Sherilyn","Sherline","Sherri","Sherrie","Sherry","Sherye","Sheryl","Shina","Shir","Shirl","Shirlee","Shirleen","Shirlene","Shirley","Shirline","Shoshana","Shoshanna","Siana","Sianna","Sib","Sibbie","Sibby","Sibeal","Sibel","Sibella","Sibelle","Sibilla","Sibley","Sibyl","Sibylla","Sibylle","Sidoney","Sidonia","Sidonnie","Sigrid","Sile","Sileas","Silva","Silvana","Silvia","Silvie","Simona","Simone","Simonette","Simonne","Sindee","Siobhan","Sioux","Siouxie","Sisely","Sisile","Sissie","Sissy","Siusan","Sofia","Sofie","Sondra","Sonia","Sonja","Sonni","Sonnie","Sonnnie","Sonny","Sonya","Sophey","Sophi","Sophia","Sophie","Sophronia","Sorcha","Sosanna","Stace","Stacee","Stacey","Staci","Stacia","Stacie","Stacy","Stafani","Star","Starla","Starlene","Starlin","Starr","Stefa","Stefania","Stefanie","Steffane","Steffi","Steffie","Stella","Stepha","Stephana","Stephani","Stephanie","Stephannie","Stephenie","Stephi","Stephie","Stephine","Stesha","Stevana","Stevena","Stoddard","Storm","Stormi","Stormie","Stormy","Sue","Suellen","Sukey","Suki","Sula","Sunny","Sunshine","Susan","Susana","Susanetta","Susann","Susanna","Susannah","Susanne","Susette","Susi","Susie","Susy","Suzann","Suzanna","Suzanne","Suzette","Suzi","Suzie","Suzy","Sybil","Sybila","Sybilla","Sybille","Sybyl","Sydel","Sydelle","Sydney","Sylvia","Tabatha","Tabbatha","Tabbi","Tabbie","Tabbitha","Tabby","Tabina","Tabitha","Talia","Tallia","Tallie","Tallou","Tallulah","Tally","Talya","Talyah","Tamar","Tamara","Tamarah","Tamarra","Tamera","Tami","Tamiko","Tamma","Tammara","Tammi","Tammie","Tammy","Tamqrah","Tamra","Tana","Tandi","Tandie","Tandy","Tanhya","Tani","Tania","Tanitansy","Tansy","Tanya","Tara","Tarah","Tarra","Tarrah","Taryn","Tasha","Tasia","Tate","Tatiana","Tatiania","Tatum","Tawnya","Tawsha","Ted","Tedda","Teddi","Teddie","Teddy","Tedi","Tedra","Teena","Teirtza","Teodora","Tera","Teresa","Terese","Teresina","Teresita","Teressa","Teri","Teriann","Terra","Terri","Terrie","Terrijo","Terry","Terrye","Tersina","Terza","Tess","Tessa","Tessi","Tessie","Tessy","Thalia","Thea","Theadora","Theda","Thekla","Thelma","Theo","Theodora","Theodosia","Theresa","Therese","Theresina","Theresita","Theressa","Therine","Thia","Thomasa","Thomasin","Thomasina","Thomasine","Tiena","Tierney","Tiertza","Tiff","Tiffani","Tiffanie","Tiffany","Tiffi","Tiffie","Tiffy","Tilda","Tildi","Tildie","Tildy","Tillie","Tilly","Tim","Timi","Timmi","Timmie","Timmy","Timothea","Tina","Tine","Tiphani","Tiphanie","Tiphany","Tish","Tisha","Tobe","Tobey","Tobi","Toby","Tobye","Toinette","Toma","Tomasina","Tomasine","Tomi","Tommi","Tommie","Tommy","Toni","Tonia","Tonie","Tony","Tonya","Tonye","Tootsie","Torey","Tori","Torie","Torrie","Tory","Tova","Tove","Tracee","Tracey","Traci","Tracie","Tracy","Trenna","Tresa","Trescha","Tressa","Tricia","Trina","Trish","Trisha","Trista","Trix","Trixi","Trixie","Trixy","Truda","Trude","Trudey","Trudi","Trudie","Trudy","Trula","Tuesday","Twila","Twyla","Tybi","Tybie","Tyne","Ula","Ulla","Ulrica","Ulrika","Ulrikaumeko","Ulrike","Umeko","Una","Ursa","Ursala","Ursola","Ursula","Ursulina","Ursuline","Uta","Val","Valaree","Valaria","Vale","Valeda","Valencia","Valene","Valenka","Valentia","Valentina","Valentine","Valera","Valeria","Valerie","Valery","Valerye","Valida","Valina","Valli","Vallie","Vally","Valma","Valry","Van","Vanda","Vanessa","Vania","Vanna","Vanni","Vannie","Vanny","Vanya","Veda","Velma","Velvet","Venita","Venus","Vera","Veradis","Vere","Verena","Verene","Veriee","Verile","Verina","Verine","Verla","Verna","Vernice","Veronica","Veronika","Veronike","Veronique","Vevay","Vi","Vicki","Vickie","Vicky","Victoria","Vida","Viki","Vikki","Vikky","Vilhelmina","Vilma","Vin","Vina","Vinita","Vinni","Vinnie","Vinny","Viola","Violante","Viole","Violet","Violetta","Violette","Virgie","Virgina","Virginia","Virginie","Vita","Vitia","Vitoria","Vittoria","Viv","Viva","Vivi","Vivia","Vivian","Viviana","Vivianna","Vivianne","Vivie","Vivien","Viviene","Vivienne","Viviyan","Vivyan","Vivyanne","Vonni","Vonnie","Vonny","Vyky","Wallie","Wallis","Walliw","Wally","Waly","Wanda","Wandie","Wandis","Waneta","Wanids","Wenda","Wendeline","Wendi","Wendie","Wendy","Wendye","Wenona","Wenonah","Whitney","Wileen","Wilhelmina","Wilhelmine","Wilie","Willa","Willabella","Willamina","Willetta","Willette","Willi","Willie","Willow","Willy","Willyt","Wilma","Wilmette","Wilona","Wilone","Wilow","Windy","Wini","Winifred","Winna","Winnah","Winne","Winni","Winnie","Winnifred","Winny","Winona","Winonah","Wren","Wrennie","Wylma","Wynn","Wynne","Wynnie","Wynny","Xaviera","Xena","Xenia","Xylia","Xylina","Yalonda","Yasmeen","Yasmin","Yelena","Yetta","Yettie","Yetty","Yevette","Ynes","Ynez","Yoko","Yolanda","Yolande","Yolane","Yolanthe","Yoshi","Yoshiko","Yovonnda","Ysabel","Yvette","Yvonne","Zabrina","Zahara","Zandra","Zaneta","Zara","Zarah","Zaria","Zarla","Zea","Zelda","Zelma","Zena","Zenia","Zia","Zilvia","Zita","Zitella","Zoe","Zola","Zonda","Zondra","Zonnya","Zora","Zorah","Zorana","Zorina","Zorine","Zsazsa","Zulema","Zuzana"],d=["Ackbar","Adi Gallia","Anakin Skywalker","Arvel Crynyd","Ayla Secura","Bail Prestor Organa","Barriss Offee","Ben Quadinaros","Beru Whitesun lars","Bib Fortuna","Biggs Darklighter","Boba Fett","Bossk","C-3PO","Chewbacca","Cliegg Lars","Cordé","Darth Maul","Darth Vader","Dexter Jettster","Dooku","Dormé","Dud Bolt","Eeth Koth","Finis Valorum","Gasgano","Greedo","Gregar Typho","Grievous","Han Solo","IG-88","Jabba Desilijic Tiure","Jango Fett","Jar Jar Binks","Jek Tono Porkins","Jocasta Nu","Ki-Adi-Mundi","Kit Fisto","Lama Su","Lando Calrissian","Leia Organa","Lobot","Luke Skywalker","Luminara Unduli","Mace Windu","Mas Amedda","Mon Mothma","Nien Nunb","Nute Gunray","Obi-Wan Kenobi","Owen Lars","Padmé Amidala","Palpatine","Plo Koon","Poggle the Lesser","Quarsh Panaka","Qui-Gon Jinn","R2-D2","R4-P17","R5-D4","Ratts Tyerel","Raymus Antilles","Ric Olié","Roos Tarpals","Rugor Nass","Saesee Tiin","San Hill","Sebulba","Shaak Ti","Shmi Skywalker","Sly Moore","Tarfful","Taun We","Tion Medon","Wat Tambor","Watto","Wedge Antilles","Wicket Systri Warrick","Wilhuff Tarkin","Yoda","Zam Wesell"];class p{static generate(e={}){let t=e.min||1,i=e.max||999;if(e.length){const r=Math.pow(10,e.length);return t=r/10,i=r-1,[`${Math.floor(Math.random()*(i-t))+t}`]}return[`${Math.floor(Math.random()*(i-t))+t}`]}}},5509:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.GitProtocolHandler=void 0;const a=i(1398),l=i(7937),c=s(i(3480)),h=l.isWindows?new Set(["git","http","https","ssh"]):new Set(["file","git","http","https","ssh"]),u=/^$|[~\^:\\\*\s\[\]]|^-|^\.|\/\.|\.\.|\.lock\/|\.lock$|\/$|\.$/;t.GitProtocolHandler=class{constructor(e){this.logger=e,this.disposables=[],this.disposables.push(a.window.registerUriHandler(this))}handleUri(e){this.logger.info(`[GitProtocolHandler][handleUri] URI:(${e.toString()})`),"/clone"===e.path&&this.clone(e)}async clone(e){const t=c.parse(e.query),i=t.ref;if(!t.url)return void this.logger.warn("[GitProtocolHandler][clone] Failed to open URI:"+e.toString());if(Array.isArray(t.url)&&0===t.url.length)return void this.logger.warn("[GitProtocolHandler][clone] Failed to open URI:"+e.toString());if(void 0!==i&&"string"!=typeof i)return void this.logger.warn("[GitProtocolHandler][clone] Failed to open URI due to multiple references:"+e.toString());let r;try{let e=Array.isArray(t.url)?t.url[0]:t.url;if(e=e.replace(/^(git@[^\/:]+)(:)/i,"ssh://$1/"),r=a.Uri.parse(e,!0),!h.has(r.scheme.toLowerCase()))throw new Error("Unsupported scheme.");if("string"==typeof i&&u.test(i))throw new Error("Invalid reference.")}catch(t){return void this.logger.warn("[GitProtocolHandler][clone] Invalid URI:"+e.toString())}if(!(await a.commands.getCommands(!0)).includes("git.clone")){this.logger.error("[GitProtocolHandler][clone] Could not complete git clone operation as git installation was not found.");const e=a.l10n.t("Could not clone your repository as Git is not installed."),t=a.l10n.t("Download Git");return void(await a.window.showErrorMessage(e,{modal:!0},t)===t&&a.commands.executeCommand("vscode.open",a.Uri.parse("https://aka.ms/vscode-download-git")))}{const e=r.toString(!0);this.logger.info(`[GitProtocolHandler][clone] Executing git.clone for ${e}`),a.commands.executeCommand("git.clone",e,void 0,{ref:i})}}dispose(){this.disposables=(0,l.dispose)(this.disposables)}}},5518:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__decorate||function(e,t,i,r){var o,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,i):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,r);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(n<3?o(s):n>3?o(t,i,s):o(t,i))||s);return n>3&&s&&Object.defineProperty(t,i,s),s},a=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.GitDecorations=void 0;const l=i(1398),c=a(i(6928)),h=i(4399),u=i(7937);function d(e,t){return e===t||e?.id===t?.id&&e?.name===t?.name&&e?.revision===t?.revision}class p{constructor(e){this.model=e,this.queue=new Map,this.disposables=[],this.onDidChangeFileDecorations=(0,u.fireEvent)((0,u.anyEvent)((0,u.filterEvent)(l.workspace.onDidSaveTextDocument,e=>/\.gitignore$|\.git\/info\/exclude$/.test(e.uri.path)),e.onDidOpenRepository,e.onDidCloseRepository)),this.disposables.push(l.window.registerFileDecorationProvider(this))}async provideFileDecoration(e){const t=this.model.getRepository(e);if(!t)return;let i=this.queue.get(t.root);i||(i={repository:t,queue:new Map},this.queue.set(t.root,i));let r=i.queue.get(e.fsPath);return r||(r=new u.PromiseSource,i.queue.set(e.fsPath,r),this.checkIgnoreSoon()),await r.promise}checkIgnoreSoon(){const e=new Map(this.queue.entries());this.queue.clear();for(const[,t]of e){const e=[...t.queue.keys()];t.repository.checkIgnore(e).then(e=>{for(const[i,r]of t.queue.entries())r.resolve(e.has(i)?p.Decoration:void 0)},e=>{"IsInSubmodule"!==e.gitErrorCode&&console.error(e);for(const[,i]of t.queue.entries())i.reject(e)})}}dispose(){this.disposables.forEach(e=>e.dispose()),this.queue.clear()}}p.Decoration={color:new l.ThemeColor("gitDecoration.ignoredResourceForeground")},s([(0,h.debounce)(500)],p.prototype,"checkIgnoreSoon",null);class m{constructor(e){this.repository=e,this._onDidChangeDecorations=new l.EventEmitter,this.onDidChangeFileDecorations=this._onDidChangeDecorations.event,this.disposables=[],this.decorations=new Map,this.disposables.push(l.window.registerFileDecorationProvider(this),(0,u.runAndSubscribeEvent)(e.onDidRunGitStatus,()=>this.onDidRunGitStatus()))}onDidRunGitStatus(){const e=new Map;this.collectDecorationData(this.repository.indexGroup,e),this.collectDecorationData(this.repository.untrackedGroup,e),this.collectDecorationData(this.repository.workingTreeGroup,e),this.collectDecorationData(this.repository.mergeGroup,e),this.collectSubmoduleDecorationData(e);const t=new Set([...this.decorations.keys()].concat([...e.keys()]));this.decorations=e,this._onDidChangeDecorations.fire([...t.values()].map(e=>l.Uri.parse(e,!0)))}collectDecorationData(e,t){for(const i of e.resourceStates){const e=i.resourceDecoration;e&&(t.set(i.original.toString(),e),6===i.type&&i.rightUri&&t.set(i.rightUri.toString(),e),3!==i.type&&10!==i.type||t.set(i.resourceUri.toString(),e))}}collectSubmoduleDecorationData(e){for(const t of this.repository.submodules)e.set(l.Uri.file(c.join(this.repository.root,t.path)).toString(),m.SubmoduleDecorationData)}provideFileDecoration(e){return this.decorations.get(e.toString())}dispose(){this.disposables.forEach(e=>e.dispose())}}m.SubmoduleDecorationData={tooltip:"Submodule",badge:"S",color:new l.ThemeColor("gitDecoration.submoduleResourceForeground")};class g{constructor(e){this.repository=e,this._onDidChangeDecorations=new l.EventEmitter,this.onDidChangeFileDecorations=this._onDidChangeDecorations.event,this._decorations=new Map,this.disposables=[],this.disposables.push(l.window.registerFileDecorationProvider(this),(0,u.runAndSubscribeEvent)(e.historyProvider.onDidChangeCurrentHistoryItemRefs,()=>this.onDidChangeCurrentHistoryItemRefs()))}async onDidChangeCurrentHistoryItemRefs(){const e=this.repository.historyProvider,t=e.currentHistoryItemRef,i=e.currentHistoryItemRemoteRef;if(d(this._currentHistoryItemRef,t)&&d(this._currentHistoryItemRemoteRef,i))return;const r=new Map;await this.collectIncomingChangesFileDecorations(r);const o=new Set([...this._decorations.keys()].concat([...r.keys()]));this._decorations=r,this._currentHistoryItemRef=t,this._currentHistoryItemRemoteRef=i,this._onDidChangeDecorations.fire([...o.values()].map(e=>l.Uri.parse(e,!0)))}async collectIncomingChangesFileDecorations(e){for(const t of await this.getIncomingChanges())switch(t.status){case 1:e.set(t.uri.toString(),{badge:"↓A",tooltip:l.l10n.t("Incoming Changes (added)")});break;case 6:e.set(t.uri.toString(),{badge:"↓D",tooltip:l.l10n.t("Incoming Changes (deleted)")});break;case 3:e.set(t.originalUri.toString(),{badge:"↓R",tooltip:l.l10n.t("Incoming Changes (renamed)")});break;case 5:e.set(t.uri.toString(),{badge:"↓M",tooltip:l.l10n.t("Incoming Changes (modified)")});break;default:e.set(t.uri.toString(),{badge:"↓~",tooltip:l.l10n.t("Incoming Changes")})}}async getIncomingChanges(){try{const e=this.repository.historyProvider,t=e.currentHistoryItemRef,i=e.currentHistoryItemRemoteRef;if(!t||!i)return[];const r=await e.resolveHistoryItemRefsCommonAncestor([t.id,i.id]);return r?await this.repository.diffBetween(r,i.id):[]}catch(e){return[]}}provideFileDecoration(e){return this._decorations.get(e.toString())}dispose(){(0,u.dispose)(this.disposables)}}t.GitDecorations=class{constructor(e){this.model=e,this.enabled=!1,this.disposables=[],this.modelDisposables=[],this.providers=new Map,this.disposables.push(new p(e)),(0,u.filterEvent)(l.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git.decorations.enabled"))(this.update,this,this.disposables),this.update()}update(){const e=!0===l.workspace.getConfiguration("git").get("decorations.enabled");this.enabled!==e&&(e?this.enable():this.disable(),this.enabled=e)}enable(){this.model.onDidOpenRepository(this.onDidOpenRepository,this,this.modelDisposables),this.model.onDidCloseRepository(this.onDidCloseRepository,this,this.modelDisposables),this.model.repositories.forEach(this.onDidOpenRepository,this)}disable(){this.modelDisposables=(0,u.dispose)(this.modelDisposables),this.providers.forEach(e=>e.dispose()),this.providers.clear()}onDidOpenRepository(e){const t=(0,u.combinedDisposable)([new m(e),new g(e)]);this.providers.set(e,t)}onDidCloseRepository(e){const t=this.providers.get(e);t&&(t.dispose(),this.providers.delete(e))}dispose(){this.disable(),this.disposables=(0,u.dispose)(this.disposables)}}},5523:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.EndOfStreamError=t.defaultMessages=void 0,t.defaultMessages="End-Of-Stream";class i extends Error{constructor(){super(t.defaultMessages)}}t.EndOfStreamError=i},5607:(e,t,i)=>{var r=i(2203),o=i(9023),n=i(3557);function s(e,t){if(!e)throw new Error("expected readStream");if(!e.readable)throw new Error("readStream must be readable");var i=new a(t);return e.pipe(i),i}function a(e){r.Transform.call(this,e),e=e||{},this._readableState.objectMode=!0,this._lineBuffer=[],this._keepEmptyLines=e.keepEmptyLines||!1,this._lastChunkEndedWithCR=!1;var t=this;this.on("pipe",function(e){t.encoding||e instanceof r.Readable&&(t.encoding=e._readableState.encoding)})}e.exports=function(t,i){return e.exports.createStream(t,i)},e.exports.createStream=function(e,t){return e?s(e,t):new a(t)},e.exports.createLineStream=function(e){return console.log("WARNING: byline#createLineStream is deprecated and will be removed soon"),s(e)},e.exports.LineStream=a,o.inherits(a,r.Transform),a.prototype._transform=function(e,t,i){t=t||"utf8",Buffer.isBuffer(e)&&("buffer"==t?(e=e.toString(),t="utf8"):e=e.toString(t)),this._chunkEncoding=t;var r=e.split(/\r\n|[\n\v\f\r\x85\u2028\u2029]/g);this._lastChunkEndedWithCR&&"\n"==e[0]&&r.shift(),this._lineBuffer.length>0&&(this._lineBuffer[this._lineBuffer.length-1]+=r[0],r.shift()),this._lastChunkEndedWithCR="\r"==e[e.length-1],this._lineBuffer=this._lineBuffer.concat(r),this._pushBuffer(t,1,i)},a.prototype._pushBuffer=function(e,t,i){for(;this._lineBuffer.length>t;){var r=this._lineBuffer.shift();if((this._keepEmptyLines||r.length>0)&&!this.push(this._reencode(r,e))){var o=this;return void n.setImmediate(function(){o._pushBuffer(e,t,i)})}}i()},a.prototype._flush=function(e){this._pushBuffer(this._chunkEncoding,0,e)},a.prototype._reencode=function(e,t){return this.encoding&&this.encoding!=t?new Buffer(e,t).toString(this.encoding):this.encoding?e:new Buffer(e,t)}},5707:(module,__unused_webpack_exports,__webpack_require__)=>{"use strict";const Token=__webpack_require__(4266),strtok3=__webpack_require__(6452),{stringToBytes,tarHeaderChecksumMatches,uint32SyncSafeToken}=__webpack_require__(6760),supported=__webpack_require__(1664),minimumBytes=4100;async function fromStream(e){const t=await strtok3.fromStream(e);try{return await fromTokenizer(t)}finally{await t.close()}}async function fromBuffer(e){if(!(e instanceof Uint8Array||e instanceof ArrayBuffer||Buffer.isBuffer(e)))throw new TypeError(`Expected the \`input\` argument to be of type \`Uint8Array\` or \`Buffer\` or \`ArrayBuffer\`, got \`${typeof e}\``);const t=e instanceof Buffer?e:Buffer.from(e);if(t&&t.length>1)return fromTokenizer(strtok3.fromBuffer(t))}function _check(e,t,i){i={offset:0,...i};for(const[r,o]of t.entries())if(i.mask){if(o!==(i.mask[r]&e[r+i.offset]))return!1}else if(o!==e[r+i.offset])return!1;return!0}async function fromTokenizer(e){try{return _fromTokenizer(e)}catch(e){if(!(e instanceof strtok3.EndOfStreamError))throw e}}async function _fromTokenizer(e){let t=Buffer.alloc(minimumBytes);const i=(e,i)=>_check(t,e,i),r=(e,t)=>i(stringToBytes(e),t);if(e.fileInfo.size||(e.fileInfo.size=Number.MAX_SAFE_INTEGER),await e.peekBuffer(t,{length:12,mayBeLess:!0}),i([66,77]))return{ext:"bmp",mime:"image/bmp"};if(i([11,119]))return{ext:"ac3",mime:"audio/vnd.dolby.dd-raw"};if(i([120,1]))return{ext:"dmg",mime:"application/x-apple-diskimage"};if(i([77,90]))return{ext:"exe",mime:"application/x-msdownload"};if(i([37,33]))return await e.peekBuffer(t,{length:24,mayBeLess:!0}),r("PS-Adobe-",{offset:2})&&r(" EPSF-",{offset:14})?{ext:"eps",mime:"application/eps"}:{ext:"ps",mime:"application/postscript"};if(i([31,160])||i([31,157]))return{ext:"Z",mime:"application/x-compress"};if(i([255,216,255]))return{ext:"jpg",mime:"image/jpeg"};if(i([73,73,188]))return{ext:"jxr",mime:"image/vnd.ms-photo"};if(i([31,139,8]))return{ext:"gz",mime:"application/gzip"};if(i([66,90,104]))return{ext:"bz2",mime:"application/x-bzip2"};if(r("ID3")){await e.ignore(6);const o=await e.readToken(uint32SyncSafeToken);return e.position+o>e.fileInfo.size?{ext:"mp3",mime:"audio/mpeg"}:(await e.ignore(o),fromTokenizer(e))}if(r("MP+"))return{ext:"mpc",mime:"audio/x-musepack"};if((67===t[0]||70===t[0])&&i([87,83],{offset:1}))return{ext:"swf",mime:"application/x-shockwave-flash"};if(i([71,73,70]))return{ext:"gif",mime:"image/gif"};if(r("FLIF"))return{ext:"flif",mime:"image/flif"};if(r("8BPS"))return{ext:"psd",mime:"image/vnd.adobe.photoshop"};if(r("WEBP",{offset:8}))return{ext:"webp",mime:"image/webp"};if(r("MPCK"))return{ext:"mpc",mime:"audio/x-musepack"};if(r("FORM"))return{ext:"aif",mime:"audio/aiff"};if(r("icns",{offset:0}))return{ext:"icns",mime:"image/icns"};if(i([80,75,3,4])){try{for(;e.position+30<e.fileInfo.size;){await e.readBuffer(t,{length:30});const n={compressedSize:t.readUInt32LE(18),uncompressedSize:t.readUInt32LE(22),filenameLength:t.readUInt16LE(26),extraFieldLength:t.readUInt16LE(28)};if(n.filename=await e.readToken(new Token.StringType(n.filenameLength,"utf-8")),await e.ignore(n.extraFieldLength),"META-INF/mozilla.rsa"===n.filename)return{ext:"xpi",mime:"application/x-xpinstall"};if(n.filename.endsWith(".rels")||n.filename.endsWith(".xml"))switch(n.filename.split("/")[0]){case"_rels":default:break;case"word":return{ext:"docx",mime:"application/vnd.openxmlformats-officedocument.wordprocessingml.document"};case"ppt":return{ext:"pptx",mime:"application/vnd.openxmlformats-officedocument.presentationml.presentation"};case"xl":return{ext:"xlsx",mime:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"}}if(n.filename.startsWith("xl/"))return{ext:"xlsx",mime:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"};if(n.filename.startsWith("3D/")&&n.filename.endsWith(".model"))return{ext:"3mf",mime:"model/3mf"};if("mimetype"===n.filename&&n.compressedSize===n.uncompressedSize)switch(await e.readToken(new Token.StringType(n.compressedSize,"utf-8"))){case"application/epub+zip":return{ext:"epub",mime:"application/epub+zip"};case"application/vnd.oasis.opendocument.text":return{ext:"odt",mime:"application/vnd.oasis.opendocument.text"};case"application/vnd.oasis.opendocument.spreadsheet":return{ext:"ods",mime:"application/vnd.oasis.opendocument.spreadsheet"};case"application/vnd.oasis.opendocument.presentation":return{ext:"odp",mime:"application/vnd.oasis.opendocument.presentation"}}if(0===n.compressedSize){let s=-1;for(;s<0&&e.position<e.fileInfo.size;)await e.peekBuffer(t,{mayBeLess:!0}),s=t.indexOf("504B0304",0,"hex"),await e.ignore(s>=0?s:t.length)}else await e.ignore(n.compressedSize)}}catch(a){if(!(a instanceof strtok3.EndOfStreamError))throw a}return{ext:"zip",mime:"application/zip"}}if(r("OggS")){await e.ignore(28);const l=Buffer.alloc(8);return await e.readBuffer(l),_check(l,[79,112,117,115,72,101,97,100])?{ext:"opus",mime:"audio/opus"}:_check(l,[128,116,104,101,111,114,97])?{ext:"ogv",mime:"video/ogg"}:_check(l,[1,118,105,100,101,111,0])?{ext:"ogm",mime:"video/ogg"}:_check(l,[127,70,76,65,67])?{ext:"oga",mime:"audio/ogg"}:_check(l,[83,112,101,101,120,32,32])?{ext:"spx",mime:"audio/ogg"}:_check(l,[1,118,111,114,98,105,115])?{ext:"ogg",mime:"audio/ogg"}:{ext:"ogx",mime:"application/ogg"}}if(i([80,75])&&(3===t[2]||5===t[2]||7===t[2])&&(4===t[3]||6===t[3]||8===t[3]))return{ext:"zip",mime:"application/zip"};if(r("ftyp",{offset:4})&&96&t[8]){const c=t.toString("binary",8,12).replace("\0"," ").trim();switch(c){case"avif":return{ext:"avif",mime:"image/avif"};case"mif1":return{ext:"heic",mime:"image/heif"};case"msf1":return{ext:"heic",mime:"image/heif-sequence"};case"heic":case"heix":return{ext:"heic",mime:"image/heic"};case"hevc":case"hevx":return{ext:"heic",mime:"image/heic-sequence"};case"qt":return{ext:"mov",mime:"video/quicktime"};case"M4V":case"M4VH":case"M4VP":return{ext:"m4v",mime:"video/x-m4v"};case"M4P":return{ext:"m4p",mime:"video/mp4"};case"M4B":return{ext:"m4b",mime:"audio/mp4"};case"M4A":return{ext:"m4a",mime:"audio/x-m4a"};case"F4V":return{ext:"f4v",mime:"video/mp4"};case"F4P":return{ext:"f4p",mime:"video/mp4"};case"F4A":return{ext:"f4a",mime:"audio/mp4"};case"F4B":return{ext:"f4b",mime:"audio/mp4"};case"crx":return{ext:"cr3",mime:"image/x-canon-cr3"};default:return c.startsWith("3g")?c.startsWith("3g2")?{ext:"3g2",mime:"video/3gpp2"}:{ext:"3gp",mime:"video/3gpp"}:{ext:"mp4",mime:"video/mp4"}}}if(r("MThd"))return{ext:"mid",mime:"audio/midi"};if(r("wOFF")&&(i([0,1,0,0],{offset:4})||r("OTTO",{offset:4})))return{ext:"woff",mime:"font/woff"};if(r("wOF2")&&(i([0,1,0,0],{offset:4})||r("OTTO",{offset:4})))return{ext:"woff2",mime:"font/woff2"};if(i([212,195,178,161])||i([161,178,195,212]))return{ext:"pcap",mime:"application/vnd.tcpdump.pcap"};if(r("DSD "))return{ext:"dsf",mime:"audio/x-dsf"};if(r("LZIP"))return{ext:"lz",mime:"application/x-lzip"};if(r("fLaC"))return{ext:"flac",mime:"audio/x-flac"};if(i([66,80,71,251]))return{ext:"bpg",mime:"image/bpg"};if(r("wvpk"))return{ext:"wv",mime:"audio/wavpack"};if(r("%PDF")){await e.ignore(1350);const h=10485760,u=Buffer.alloc(Math.min(h,e.fileInfo.size));return await e.readBuffer(u,{mayBeLess:!0}),u.includes(Buffer.from("AIPrivateData"))?{ext:"ai",mime:"application/postscript"}:{ext:"pdf",mime:"application/pdf"}}if(i([0,97,115,109]))return{ext:"wasm",mime:"application/wasm"};if(i([73,73,42,0]))return r("CR",{offset:8})?{ext:"cr2",mime:"image/x-canon-cr2"}:i([28,0,254,0],{offset:8})||i([31,0,11,0],{offset:8})?{ext:"nef",mime:"image/x-nikon-nef"}:i([8,0,0,0],{offset:4})&&(i([45,0,254,0],{offset:8})||i([39,0,254,0],{offset:8}))?{ext:"dng",mime:"image/x-adobe-dng"}:(t=Buffer.alloc(24),await e.peekBuffer(t),(i([16,251,134,1],{offset:4})||i([8,0,0,0],{offset:4}))&&i([0,254,0,4,0,1,0,0,0,1,0,0,0,3,1],{offset:9})?{ext:"arw",mime:"image/x-sony-arw"}:{ext:"tif",mime:"image/tiff"});if(i([77,77,0,42]))return{ext:"tif",mime:"image/tiff"};if(r("MAC "))return{ext:"ape",mime:"audio/ape"};if(i([26,69,223,163])){async function d(){const t=await e.peekNumber(Token.UINT8);let i=128,r=0;for(;0===(t&i)&&0!==i;)++r,i>>=1;const o=Buffer.alloc(r+1);return await e.readBuffer(o),o}async function p(){const e=await d(),t=await d();t[0]^=128>>t.length-1;const i=Math.min(6,t.length);return{id:e.readUIntBE(0,e.length),len:t.readUIntBE(t.length-i,i)}}async function m(t,i){for(;i>0;){const t=await p();if(17026===t.id)return e.readToken(new Token.StringType(t.len,"utf-8"));await e.ignore(t.len),--i}}const g=await p();switch(await m(0,g.len)){case"webm":return{ext:"webm",mime:"video/webm"};case"matroska":return{ext:"mkv",mime:"video/x-matroska"};default:return}}if(i([82,73,70,70])){if(i([65,86,73],{offset:8}))return{ext:"avi",mime:"video/vnd.avi"};if(i([87,65,86,69],{offset:8}))return{ext:"wav",mime:"audio/vnd.wave"};if(i([81,76,67,77],{offset:8}))return{ext:"qcp",mime:"audio/qcelp"}}if(r("SQLi"))return{ext:"sqlite",mime:"application/x-sqlite3"};if(i([78,69,83,26]))return{ext:"nes",mime:"application/x-nintendo-nes-rom"};if(r("Cr24"))return{ext:"crx",mime:"application/x-google-chrome-extension"};if(r("MSCF")||r("ISc("))return{ext:"cab",mime:"application/vnd.ms-cab-compressed"};if(i([237,171,238,219]))return{ext:"rpm",mime:"application/x-rpm"};if(i([197,208,211,198]))return{ext:"eps",mime:"application/eps"};if(i([40,181,47,253]))return{ext:"zst",mime:"application/zstd"};if(i([79,84,84,79,0]))return{ext:"otf",mime:"font/otf"};if(r("#!AMR"))return{ext:"amr",mime:"audio/amr"};if(r("{\\rtf"))return{ext:"rtf",mime:"application/rtf"};if(i([70,76,86,1]))return{ext:"flv",mime:"video/x-flv"};if(r("IMPM"))return{ext:"it",mime:"audio/x-it"};if(r("-lh0-",{offset:2})||r("-lh1-",{offset:2})||r("-lh2-",{offset:2})||r("-lh3-",{offset:2})||r("-lh4-",{offset:2})||r("-lh5-",{offset:2})||r("-lh6-",{offset:2})||r("-lh7-",{offset:2})||r("-lzs-",{offset:2})||r("-lz4-",{offset:2})||r("-lz5-",{offset:2})||r("-lhd-",{offset:2}))return{ext:"lzh",mime:"application/x-lzh-compressed"};if(i([0,0,1,186])){if(i([33],{offset:4,mask:[241]}))return{ext:"mpg",mime:"video/MP1S"};if(i([68],{offset:4,mask:[196]}))return{ext:"mpg",mime:"video/MP2P"}}if(r("ITSF"))return{ext:"chm",mime:"application/vnd.ms-htmlhelp"};if(i([253,55,122,88,90,0]))return{ext:"xz",mime:"application/x-xz"};if(r("<?xml "))return{ext:"xml",mime:"application/xml"};if(i([55,122,188,175,39,28]))return{ext:"7z",mime:"application/x-7z-compressed"};if(i([82,97,114,33,26,7])&&(0===t[6]||1===t[6]))return{ext:"rar",mime:"application/x-rar-compressed"};if(r("solid "))return{ext:"stl",mime:"model/stl"};if(r("BLENDER"))return{ext:"blend",mime:"application/x-blender"};if(r("!<arch>"))return await e.ignore(8),"debian-binary"===await e.readToken(new Token.StringType(13,"ascii"))?{ext:"deb",mime:"application/x-deb"}:{ext:"ar",mime:"application/x-unix-archive"};if(i([137,80,78,71,13,10,26,10])){async function f(){return{length:await e.readToken(Token.INT32_BE),type:await e.readToken(new Token.StringType(4,"binary"))}}await e.ignore(8);do{const y=await f();if(y.length<0)return;switch(y.type){case"IDAT":return{ext:"png",mime:"image/png"};case"acTL":return{ext:"apng",mime:"image/apng"};default:await e.ignore(y.length+4)}}while(e.position+8<e.fileInfo.size);return{ext:"png",mime:"image/png"}}if(i([65,82,82,79,87,49,0,0]))return{ext:"arrow",mime:"application/x-apache-arrow"};if(i([103,108,84,70,2,0,0,0]))return{ext:"glb",mime:"model/gltf-binary"};if(i([102,114,101,101],{offset:4})||i([109,100,97,116],{offset:4})||i([109,111,111,118],{offset:4})||i([119,105,100,101],{offset:4}))return{ext:"mov",mime:"video/quicktime"};if(i([73,73,82,79,8,0,0,0,24]))return{ext:"orf",mime:"image/x-olympus-orf"};if(r("gimp xcf "))return{ext:"xcf",mime:"image/x-xcf"};if(i([73,73,85,0,24,0,0,0,136,231,116,216]))return{ext:"rw2",mime:"image/x-panasonic-rw2"};if(i([48,38,178,117,142,102,207,17,166,217])){async function w(){const t=Buffer.alloc(16);return await e.readBuffer(t),{id:t,size:Number(await e.readToken(Token.UINT64_LE))}}for(await e.ignore(30);e.position+24<e.fileInfo.size;){const b=await w();let C=b.size-24;if(_check(b.id,[145,7,220,183,183,169,207,17,142,230,0,192,12,32,83,101])){const v=Buffer.alloc(16);if(C-=await e.readBuffer(v),_check(v,[64,158,105,248,77,91,207,17,168,253,0,128,95,92,68,43]))return{ext:"asf",mime:"audio/x-ms-asf"};if(_check(v,[192,239,25,188,77,91,207,17,168,253,0,128,95,92,68,43]))return{ext:"asf",mime:"video/x-ms-asf"};break}await e.ignore(C)}return{ext:"asf",mime:"application/vnd.ms-asf"}}if(i([171,75,84,88,32,49,49,187,13,10,26,10]))return{ext:"ktx",mime:"image/ktx"};if((i([126,16,4])||i([126,24,4]))&&i([48,77,73,69],{offset:4}))return{ext:"mie",mime:"application/x-mie"};if(i([39,10,0,0,0,0,0,0,0,0,0,0],{offset:2}))return{ext:"shp",mime:"application/x-esri-shape"};if(i([0,0,0,12,106,80,32,32,13,10,135,10]))switch(await e.ignore(20),await e.readToken(new Token.StringType(4,"ascii"))){case"jp2 ":return{ext:"jp2",mime:"image/jp2"};case"jpx ":return{ext:"jpx",mime:"image/jpx"};case"jpm ":return{ext:"jpm",mime:"image/jpm"};case"mjp2":return{ext:"mj2",mime:"image/mj2"};default:return}if(i([255,10])||i([0,0,0,12,74,88,76,32,13,10,135,10]))return{ext:"jxl",mime:"image/jxl"};if(i([0,0,1,186])||i([0,0,1,179]))return{ext:"mpg",mime:"video/mpeg"};if(i([0,1,0,0,0]))return{ext:"ttf",mime:"font/ttf"};if(i([0,0,1,0]))return{ext:"ico",mime:"image/x-icon"};if(i([0,0,2,0]))return{ext:"cur",mime:"image/x-icon"};if(i([208,207,17,224,161,177,26,225]))return{ext:"cfb",mime:"application/x-cfb"};if(await e.peekBuffer(t,{length:Math.min(256,e.fileInfo.size),mayBeLess:!0}),r("BEGIN:")){if(r("VCARD",{offset:6}))return{ext:"vcf",mime:"text/vcard"};if(r("VCALENDAR",{offset:6}))return{ext:"ics",mime:"text/calendar"}}if(r("FUJIFILMCCD-RAW"))return{ext:"raf",mime:"image/x-fujifilm-raf"};if(r("Extended Module:"))return{ext:"xm",mime:"audio/x-xm"};if(r("Creative Voice File"))return{ext:"voc",mime:"audio/x-voc"};if(i([4,0,0,0])&&t.length>=16){const k=t.readUInt32LE(12);if(k>12&&t.length>=k+16)try{const R=t.slice(16,k+16).toString();if(JSON.parse(R).files)return{ext:"asar",mime:"application/x-asar"}}catch(E){}}if(i([6,14,43,52,2,5,1,1,13,1,2,1,1,2]))return{ext:"mxf",mime:"application/mxf"};if(r("SCRM",{offset:44}))return{ext:"s3m",mime:"audio/x-s3m"};if(i([71],{offset:4})&&(i([71],{offset:192})||i([71],{offset:196})))return{ext:"mts",mime:"video/mp2t"};if(i([66,79,79,75,77,79,66,73],{offset:60}))return{ext:"mobi",mime:"application/x-mobipocket-ebook"};if(i([68,73,67,77],{offset:128}))return{ext:"dcm",mime:"application/dicom"};if(i([76,0,0,0,1,20,2,0,0,0,0,0,192,0,0,0,0,0,0,70]))return{ext:"lnk",mime:"application/x.ms.shortcut"};if(i([98,111,111,107,0,0,0,0,109,97,114,107,0,0,0,0]))return{ext:"alias",mime:"application/x.apple.alias"};if(i([76,80],{offset:34})&&(i([0,0,1],{offset:8})||i([1,0,2],{offset:8})||i([2,0,2],{offset:8})))return{ext:"eot",mime:"application/vnd.ms-fontobject"};if(i([6,6,237,245,216,29,70,229,189,49,239,231,254,116,183,29]))return{ext:"indd",mime:"application/x-indesign"};if(await e.peekBuffer(t,{length:Math.min(512,e.fileInfo.size),mayBeLess:!0}),tarHeaderChecksumMatches(t))return{ext:"tar",mime:"application/x-tar"};if(i([255,254,255,14,83,0,107,0,101,0,116,0,99,0,104,0,85,0,112,0,32,0,77,0,111,0,100,0,101,0,108,0]))return{ext:"skp",mime:"application/vnd.sketchup.skp"};if(r("-----BEGIN PGP MESSAGE-----"))return{ext:"pgp",mime:"application/pgp-encrypted"};if(t.length>=2&&i([255,224],{offset:0,mask:[255,224]})){if(i([16],{offset:1,mask:[22]}))return i([8],{offset:1,mask:[8]}),{ext:"aac",mime:"audio/aac"};if(i([2],{offset:1,mask:[6]}))return{ext:"mp3",mime:"audio/mpeg"};if(i([4],{offset:1,mask:[6]}))return{ext:"mp2",mime:"audio/mpeg"};if(i([6],{offset:1,mask:[6]}))return{ext:"mp1",mime:"audio/mpeg"}}}const stream=readableStream=>new Promise((resolve,reject)=>{const stream=eval("require")("stream");readableStream.on("error",reject),readableStream.once("readable",async()=>{const e=new stream.PassThrough;let t;t=stream.pipeline?stream.pipeline(readableStream,e,()=>{}):readableStream.pipe(e);const i=readableStream.read(minimumBytes)||readableStream.read()||Buffer.alloc(0);try{const t=await fromBuffer(i);e.fileType=t}catch(e){reject(e)}resolve(t)})}),fileType={fromStream,fromTokenizer,fromBuffer,stream};Object.defineProperty(fileType,"extensions",{get:()=>new Set(supported.extensions)}),Object.defineProperty(fileType,"mimeTypes",{get:()=>new Set(supported.mimeTypes)}),module.exports=fileType},6066:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ReadStreamTokenizer=void 0;const r=i(8632),o=i(8705);class n extends r.AbstractTokenizer{constructor(e,t){super(t),this.streamReader=new o.StreamReader(e)}async getFileInfo(){return this.fileInfo}async readBuffer(e,t){const i=this.normalizeOptions(e,t),r=i.position-this.position;if(r>0)return await this.ignore(r),this.readBuffer(e,t);if(r<0)throw new Error("`options.position` must be equal or greater than `tokenizer.position`");if(0===i.length)return 0;const n=await this.streamReader.read(e,i.offset,i.length);if(this.position+=n,(!t||!t.mayBeLess)&&n<i.length)throw new o.EndOfStreamError;return n}async peekBuffer(e,t){const i=this.normalizeOptions(e,t);let r=0;if(i.position){const t=i.position-this.position;if(t>0){const o=new Uint8Array(i.length+t);return r=await this.peekBuffer(o,{mayBeLess:i.mayBeLess}),e.set(o.subarray(t),i.offset),r-t}if(t<0)throw new Error("Cannot peek from a negative offset in a stream")}if(i.length>0){try{r=await this.streamReader.peek(e,i.offset,i.length)}catch(e){if(t&&t.mayBeLess&&e instanceof o.EndOfStreamError)return 0;throw e}if(!i.mayBeLess&&r<i.length)throw new o.EndOfStreamError}return r}async ignore(e){const t=Math.min(256e3,e),i=new Uint8Array(t);let r=0;for(;r<e;){const o=e-r,n=await this.readBuffer(i,{length:Math.min(t,o)});if(n<0)return n;r+=n}return r}}t.ReadStreamTokenizer=n},6103:function(e,t,i){"use strict";var r=this&&this.__decorate||function(e,t,i,r){var o,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,i):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,r);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(n<3?o(s):n>3?o(t,i,s):o(t,i))||s);return n>3&&s&&Object.defineProperty(t,i,s),s};Object.defineProperty(t,"__esModule",{value:!0}),t.GitTimelineProvider=t.GitTimelineItem=void 0;const o=i(1398),n=i(7681),s=i(4399),a=i(6867),l=i(7937),c=i(8107);class h extends o.TimelineItem{static is(e){return e instanceof h}constructor(e,t,i,r,o,n){const s=i.indexOf("\n");super(-1!==s?`${(0,l.truncate)(i,s,!1)}`:i,r),this.ref=e,this.previousRef=t,this.message=i,this.id=o,this.contextValue=n}get shortRef(){return this.shortenRef(this.ref)}get shortPreviousRef(){return this.shortenRef(this.previousRef)}setItemDetails(e,t,i,r,n,s,a,l,c,h=[]){this.tooltip=new o.MarkdownString("",!0),this.tooltip.isTrusted=!0;const u=r?`![${n}](${r}|width=20,height=20)`:"$(account)";if(s){const e=o.l10n.t("Email");this.tooltip.appendMarkdown(`${u} [**${n}**](mailto:${s} "${e} ${n}")`)}else this.tooltip.appendMarkdown(`${u} **${n}**`);if(this.tooltip.appendMarkdown(`, $(history) ${a}\n\n`),this.tooltip.appendMarkdown(`${l}\n\n`),c){this.tooltip.appendMarkdown("---\n\n");const e=[];c.insertions&&e.push(`<span style="color:var(--vscode-scmGraph-historyItemHoverAdditionsForeground);">${1===c.insertions?o.l10n.t("{0} insertion{1}",c.insertions,"(+)"):o.l10n.t("{0} insertions{1}",c.insertions,"(+)")}</span>`),c.deletions&&e.push(`<span style="color:var(--vscode-scmGraph-historyItemHoverDeletionsForeground);">${1===c.deletions?o.l10n.t("{0} deletion{1}",c.deletions,"(-)"):o.l10n.t("{0} deletions{1}",c.deletions,"(-)")}</span>`),this.tooltip.appendMarkdown(`${e.join(", ")}\n\n`)}if(t&&i&&(this.tooltip.appendMarkdown("---\n\n"),this.tooltip.appendMarkdown(`[\`$(git-commit) ${i} \`](command:git.viewCommit?${encodeURIComponent(JSON.stringify([e,t]))} "${o.l10n.t("Open Commit")}")`),this.tooltip.appendMarkdown("&nbsp;"),this.tooltip.appendMarkdown(`[$(copy)](command:git.copyContentToClipboard?${encodeURIComponent(JSON.stringify(t))} "${o.l10n.t("Copy Commit Hash")}")`),h.length>0)){this.tooltip.appendMarkdown("&nbsp;&nbsp;|&nbsp;&nbsp;");const e=h.map(e=>`[${e.title}](command:${e.command}?${encodeURIComponent(JSON.stringify([...e.arguments??[],t]))} "${e.tooltip}")`);this.tooltip.appendMarkdown(e.join("&nbsp;"))}}shortenRef(e){return""===e||"~"===e||"HEAD"===e?e:e.endsWith("^")?`${e.substr(0,8)}^`:e.substr(0,8)}}t.GitTimelineItem=h;class u{get onDidChange(){return this._onDidChange.event}constructor(e,t){this.model=e,this.commands=t,this._onDidChange=new o.EventEmitter,this.id="git-history",this.label=o.l10n.t("Git History"),this.disposable=o.Disposable.from(e.onDidOpenRepository(this.onRepositoriesChanged,this),o.workspace.onDidChangeConfiguration(this.onConfigurationChanged,this)),e.repositories.length&&this.ensureProviderRegistration()}dispose(){this.providerDisposable?.dispose(),this.disposable.dispose()}async provideTimeline(e,t,i){const r=this.model.getRepository(e);if(!r)return this.repoDisposable?.dispose(),this.repoOperationDate=void 0,this.repo=void 0,{items:[]};let s;if(this.repo?.root!==r.root&&(this.repoDisposable?.dispose(),this.repo=r,this.repoOperationDate=new Date,this.repoDisposable=o.Disposable.from(r.onDidChangeRepository(e=>this.onRepositoryChanged(r,e)),r.onDidRunGitStatus(()=>this.onRepositoryStatusChanged(r)),r.onDidRunOperation(e=>this.onRepositoryOperationRun(r,e)))),void 0!==t.limit&&"number"!=typeof t.limit)try{const i=await this.model.git.exec(r.root,["rev-list","--count",`${t.limit.id}..`,"--",e.fsPath]);i.exitCode||(s=Number(i.stdout)+2)}catch{s=void 0}else s=void 0===t.limit?void 0:t.limit+1;await(0,a.ensureEmojis)();const u=await r.logFile(e,{maxEntries:s,hash:t.cursor,follow:!0,shortStats:!0},i),d=u.length?{cursor:void 0===s?void 0:u.length>=s?u[u.length-1]?.hash:void 0}:void 0;void 0!==s&&u.length>=s&&u.splice(u.length-1,1);const p=new Intl.DateTimeFormat(o.env.language,{year:"numeric",month:"long",day:"numeric",hour:"numeric",minute:"numeric"}),m=o.workspace.getConfiguration("git",o.Uri.file(r.root)),g=m.get("timeline.date"),f=m.get("timeline.showAuthor"),y=m.get("timeline.showUncommitted"),w=m.get("commitShortHashLength")??7,b=o.l10n.t("Open Comparison"),C=await r.getEmptyTree(),v=await r.getUnpublishedCommits(),k=await(0,c.provideSourceControlHistoryItemHoverCommands)(this.model,r),R={commits:u.map(e=>({hash:e.hash,authorName:e.authorName,authorEmail:e.authorEmail})),size:20},E=await(0,c.provideSourceControlHistoryItemAvatar)(this.model,r,R),S=[];for(let t=0;t<u.length;t++){const i=u[t],n="authored"===g?i.authorDate:i.commitDate,s=(0,a.emojify)(i.message),d=u[t+1]?.hash??C,m=new h(i.hash,d,s,n?.getTime()??0,i.hash,"git:file:commit");m.iconPath=new o.ThemeIcon("git-commit"),f&&(m.description=i.authorName);const y=v.has(i.hash)?[]:k,R=await(0,c.provideSourceControlHistoryItemMessageLinks)(this.model,r,s)??s;m.setItemDetails(e,i.hash,(0,l.truncate)(i.hash,w,!1),E?.get(i.hash),i.authorName,i.authorEmail,p.format(n),R,i.shortStat,y);const D=this.commands.resolveTimelineOpenDiffCommand(m,e);D&&(m.command={title:b,command:D.command,arguments:D.arguments}),S.push(m)}if(void 0===t.cursor){const t=o.l10n.t("You"),i=r.indexGroup.resourceStates.find(t=>t.resourceUri.fsPath===e.fsPath);if(i){const r=this.repoOperationDate??new Date,s=new h("~","HEAD",o.l10n.t("Staged Changes"),r.getTime(),"index","git:file:index");s.iconPath=new o.ThemeIcon("git-commit"),s.description="",s.setItemDetails(e,void 0,void 0,void 0,t,void 0,p.format(r),n.Resource.getStatusText(i.type));const a=this.commands.resolveTimelineOpenDiffCommand(s,e);a&&(s.command={title:b,command:a.command,arguments:a.arguments}),S.splice(0,0,s)}if(y){const s=r.workingTreeGroup.resourceStates.find(t=>t.resourceUri.fsPath===e.fsPath);if(s){const r=new Date,a=new h("",i?"~":"HEAD",o.l10n.t("Uncommitted Changes"),r.getTime(),"working","git:file:working");a.iconPath=new o.ThemeIcon("circle-outline"),a.description="",a.setItemDetails(e,void 0,void 0,void 0,t,void 0,p.format(r),n.Resource.getStatusText(s.type));const l=this.commands.resolveTimelineOpenDiffCommand(a,e);l&&(a.command={title:b,command:l.command,arguments:l.arguments}),S.splice(0,0,a)}}}return{items:S,paging:d}}ensureProviderRegistration(){void 0===this.providerDisposable&&(this.providerDisposable=o.workspace.registerTimelineProvider(["file","git","vscode-remote","vscode-local-history"],this))}onConfigurationChanged(e){(e.affectsConfiguration("git.timeline.date")||e.affectsConfiguration("git.timeline.showAuthor")||e.affectsConfiguration("git.timeline.showUncommitted"))&&this.fireChanged()}onRepositoriesChanged(e){this.ensureProviderRegistration(),this.fireChanged()}onRepositoryChanged(e,t){this.fireChanged()}onRepositoryStatusChanged(e){!0===o.workspace.getConfiguration("git.timeline").get("showUncommitted")&&this.fireChanged()}onRepositoryOperationRun(e,t){t.error||t.operation.readOnly||"Status"===t.operation.kind||(this.repoOperationDate=new Date,this.fireChanged())}fireChanged(){this._onDidChange.fire(void 0)}}t.GitTimelineProvider=u,r([(0,s.debounce)(500)],u.prototype,"fireChanged",null)},6199:function(e,t,i){"use strict";var r,o,n,s,a,l,c,h=this&&this.__classPrivateFieldSet||function(e,t,i,r,o){if("m"===r)throw new TypeError("Private method is not writable");if("a"===r&&!o)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof t?e!==t||!o:!t.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===r?o.call(e,i):o?o.value=i:t.set(e,i),i},u=this&&this.__classPrivateFieldGet||function(e,t,i,r){if("a"===i&&!r)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof t?e!==t||!r:!t.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===i?r:"a"===i?r.call(e):r?r.value:t.get(e)};Object.defineProperty(t,"__esModule",{value:!0}),t.ApiImpl=t.ApiGit=t.ApiRepository=t.ApiRepositoryUIState=t.ApiRepositoryState=t.ApiChange=void 0,t.registerAPICommands=function(e){const t=[];return t.push(d.commands.registerCommand("git.api.getRepositories",()=>e.getAPI(1).repositories.map(e=>e.rootUri.toString()))),t.push(d.commands.registerCommand("git.api.getRepositoryState",t=>{const i=e.getAPI(1).getRepository(d.Uri.parse(t));if(!i)return null;const r=i.state,o=e=>e&&{...e,type:k(e.type)},n=e=>({uri:e.uri.toString(),originalUri:e.originalUri.toString(),renameUri:e.renameUri?.toString(),status:R(e.status)});return{HEAD:o(r.HEAD),refs:r.refs.map(o),remotes:r.remotes,submodules:r.submodules,rebaseCommit:r.rebaseCommit,mergeChanges:r.mergeChanges.map(n),indexChanges:r.indexChanges.map(n),workingTreeChanges:r.workingTreeChanges.map(n)}})),t.push(d.commands.registerCommand("git.api.getRemoteSources",e=>d.commands.executeCommand("git-base.api.getRemoteSources",e))),d.Disposable.from(...t)};const d=i(1398),p=i(7937),m=i(4847),g=i(8623);class f{constructor(e){r.set(this,void 0),h(this,r,e,"f")}set value(e){u(this,r,"f").value=e}get value(){return u(this,r,"f").value}}r=new WeakMap;class y{constructor(e){o.set(this,void 0),h(this,o,e,"f")}get uri(){return u(this,o,"f").resourceUri}get originalUri(){return u(this,o,"f").original}get renameUri(){return u(this,o,"f").renameResourceUri}get status(){return u(this,o,"f").type}}t.ApiChange=y,o=new WeakMap;class w{constructor(e){n.set(this,void 0),h(this,n,e,"f"),this.onDidChange=u(this,n,"f").onDidRunGitStatus}get HEAD(){return u(this,n,"f").HEAD}get refs(){return console.warn("Deprecated. Use ApiRepository.getRefs() instead."),[]}get remotes(){return[...u(this,n,"f").remotes]}get submodules(){return[...u(this,n,"f").submodules]}get rebaseCommit(){return u(this,n,"f").rebaseCommit}get mergeChanges(){return u(this,n,"f").mergeGroup.resourceStates.map(e=>new y(e))}get indexChanges(){return u(this,n,"f").indexGroup.resourceStates.map(e=>new y(e))}get workingTreeChanges(){return u(this,n,"f").workingTreeGroup.resourceStates.map(e=>new y(e))}get untrackedChanges(){return u(this,n,"f").untrackedGroup.resourceStates.map(e=>new y(e))}}t.ApiRepositoryState=w,n=new WeakMap;class b{constructor(e){s.set(this,void 0),h(this,s,e,"f"),this.onDidChange=(0,p.mapEvent)(u(this,s,"f").onDidChangeSelection,()=>null)}get selected(){return u(this,s,"f").selected}}t.ApiRepositoryUIState=b,s=new WeakMap;class C{constructor(e){a.set(this,void 0),h(this,a,e,"f"),this.rootUri=d.Uri.file(u(this,a,"f").root),this.inputBox=new f(u(this,a,"f").inputBox),this.state=new w(u(this,a,"f")),this.ui=new b(u(this,a,"f").sourceControl),this.onDidCommit=(0,p.mapEvent)((0,p.filterEvent)(u(this,a,"f").onDidRunOperation,e=>"Commit"===e.operation.kind),()=>null),this.onDidCheckout=(0,p.mapEvent)((0,p.filterEvent)(u(this,a,"f").onDidRunOperation,e=>"Checkout"===e.operation.kind||"CheckoutTracking"===e.operation.kind),()=>null)}apply(e,t){return u(this,a,"f").apply(e,t)}getConfigs(){return u(this,a,"f").getConfigs()}getConfig(e){return u(this,a,"f").getConfig(e)}setConfig(e,t){return u(this,a,"f").setConfig(e,t)}unsetConfig(e){return u(this,a,"f").unsetConfig(e)}getGlobalConfig(e){return u(this,a,"f").getGlobalConfig(e)}getObjectDetails(e,t){return u(this,a,"f").getObjectDetails(e,t)}detectObjectType(e){return u(this,a,"f").detectObjectType(e)}buffer(e,t){return u(this,a,"f").buffer(e,t)}show(e,t){return u(this,a,"f").show(e,t)}getCommit(e){return u(this,a,"f").getCommit(e)}add(e){return u(this,a,"f").add(e.map(e=>d.Uri.file(e)))}revert(e){return u(this,a,"f").revert(e.map(e=>d.Uri.file(e)))}clean(e){return u(this,a,"f").clean(e.map(e=>d.Uri.file(e)))}diff(e){return u(this,a,"f").diff(e)}diffWithHEAD(e){return u(this,a,"f").diffWithHEAD(e)}diffWith(e,t){return u(this,a,"f").diffWith(e,t)}diffIndexWithHEAD(e){return u(this,a,"f").diffIndexWithHEAD(e)}diffIndexWith(e,t){return u(this,a,"f").diffIndexWith(e,t)}diffBlobs(e,t){return u(this,a,"f").diffBlobs(e,t)}diffBetween(e,t,i){return u(this,a,"f").diffBetween(e,t,i)}hashObject(e){return u(this,a,"f").hashObject(e)}createBranch(e,t,i){return u(this,a,"f").branch(e,t,i)}deleteBranch(e,t){return u(this,a,"f").deleteBranch(e,t)}getBranch(e){return u(this,a,"f").getBranch(e)}getBranches(e,t){return u(this,a,"f").getBranches(e,t)}getBranchBase(e){return u(this,a,"f").getBranchBase(e)}setBranchUpstream(e,t){return u(this,a,"f").setBranchUpstream(e,t)}getRefs(e,t){return u(this,a,"f").getRefs(e,t)}checkIgnore(e){return u(this,a,"f").checkIgnore(e)}getMergeBase(e,t){return u(this,a,"f").getMergeBase(e,t)}tag(e,t,i){return u(this,a,"f").tag({name:e,message:t,ref:i})}deleteTag(e){return u(this,a,"f").deleteTag(e)}status(){return u(this,a,"f").status()}checkout(e){return u(this,a,"f").checkout(e)}addRemote(e,t){return u(this,a,"f").addRemote(e,t)}removeRemote(e){return u(this,a,"f").removeRemote(e)}renameRemote(e,t){return u(this,a,"f").renameRemote(e,t)}fetch(e,t,i,r){return void 0!==e&&"string"!=typeof e?u(this,a,"f").fetch(e):u(this,a,"f").fetch({remote:e,ref:t,depth:i,prune:r})}pull(e){return u(this,a,"f").pull(void 0,e)}push(e,t,i=!1,r){return u(this,a,"f").pushTo(e,t,i,r)}blame(e){return u(this,a,"f").blame(e)}log(e){return u(this,a,"f").log(e)}commit(e,t){return u(this,a,"f").commit(e,{...t,postCommitCommand:null})}merge(e){return u(this,a,"f").merge(e)}mergeAbort(){return u(this,a,"f").mergeAbort()}applyStash(e){return u(this,a,"f").applyStash(e)}popStash(e){return u(this,a,"f").popStash(e)}dropStash(e){return u(this,a,"f").dropStash(e)}}t.ApiRepository=C,a=new WeakMap;class v{constructor(e){l.set(this,void 0),h(this,l,e,"f")}get path(){return u(this,l,"f").git.path}get env(){return void 0===this._env&&(this._env=Object.freeze(u(this,l,"f").git.env)),this._env}}function k(e){switch(e){case 0:return"Head";case 1:return"RemoteHead";case 2:return"Tag"}return"unknown"}function R(e){switch(e){case 0:return"INDEX_MODIFIED";case 1:return"INDEX_ADDED";case 2:return"INDEX_DELETED";case 3:return"INDEX_RENAMED";case 4:return"INDEX_COPIED";case 5:return"MODIFIED";case 6:return"DELETED";case 7:return"UNTRACKED";case 8:return"IGNORED";case 9:return"INTENT_TO_ADD";case 10:return"INTENT_TO_RENAME";case 11:return"TYPE_CHANGED";case 12:return"ADDED_BY_US";case 13:return"ADDED_BY_THEM";case 14:return"DELETED_BY_US";case 15:return"DELETED_BY_THEM";case 16:return"BOTH_ADDED";case 17:return"BOTH_DELETED";case 18:return"BOTH_MODIFIED"}return"UNKNOWN"}t.ApiGit=v,l=new WeakMap,t.ApiImpl=class{constructor(e){c.set(this,void 0),h(this,c,e,"f"),this.git=new v(u(this,c,"f"))}get state(){return u(this,c,"f").state}get onDidChangeState(){return u(this,c,"f").onDidChangeState}get onDidPublish(){return u(this,c,"f").onDidPublish}get onDidOpenRepository(){return(0,p.mapEvent)(u(this,c,"f").onDidOpenRepository,e=>new C(e))}get onDidCloseRepository(){return(0,p.mapEvent)(u(this,c,"f").onDidCloseRepository,e=>new C(e))}get repositories(){return u(this,c,"f").repositories.map(e=>new C(e))}toGitUri(e,t){return(0,m.toGitUri)(e,t)}getRepository(e){const t=u(this,c,"f").getRepository(e);return t?new C(t):null}async getRepositoryRoot(e){const t=this.getRepository(e);if(t)return t.rootUri;try{const t=await u(this,c,"f").git.getRepositoryRoot(e.fsPath);return d.Uri.file(t)}catch(e){if("NotAGitRepository"===e.gitErrorCode||"NotASafeGitRepository"===e.gitErrorCode)return null;throw e}}async init(e,t){const i=e.fsPath;return await u(this,c,"f").git.init(i,t),await u(this,c,"f").openRepository(i),this.getRepository(e)||null}async openRepository(e){return"file"!==e.scheme?null:(await u(this,c,"f").openRepository(e.fsPath),this.getRepository(e)||null)}registerRemoteSourceProvider(e){const t=[];return e.publishRepository&&t.push(u(this,c,"f").registerRemoteSourcePublisher(e)),t.push(g.GitBaseApi.getAPI().registerRemoteSourceProvider(e)),(0,p.combinedDisposable)(t)}registerRemoteSourcePublisher(e){return u(this,c,"f").registerRemoteSourcePublisher(e)}registerCredentialsProvider(e){return u(this,c,"f").registerCredentialsProvider(e)}registerPostCommitCommandsProvider(e){return u(this,c,"f").registerPostCommitCommandsProvider(e)}registerPushErrorHandler(e){return u(this,c,"f").registerPushErrorHandler(e)}registerSourceControlHistoryItemDetailsProvider(e){return u(this,c,"f").registerSourceControlHistoryItemDetailsProvider(e)}registerBranchProtectionProvider(e,t){return u(this,c,"f").registerBranchProtectionProvider(e,t)}},c=new WeakMap},6326:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.watch=function(e){const t=r.workspace.createFileSystemWatcher(new r.RelativePattern(e,"*"));return new class{constructor(){this.event=(0,o.anyEvent)(t.onDidCreate,t.onDidChange,t.onDidDelete)}dispose(){t.dispose()}}};const r=i(1398),o=i(7937)},6333:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.TerminalShellExecutionManager=t.TerminalEnvironmentManager=void 0;const r=i(1398),o=i(7937);t.TerminalEnvironmentManager=class{constructor(e,t){this.context=e,this.envProviders=t,this.disposable=(0,o.filterEvent)(r.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git"))(this.refresh,this),this.refresh()}refresh(){const e=r.workspace.getConfiguration("git",null);if(this.context.environmentVariableCollection.clear(),!e.get("enabled",!0))return;const t=[];for(const e of this.envProviders){const i=e?.getTerminalEnv()??{};for(const e of Object.keys(i))this.context.environmentVariableCollection.replace(e,i[e]);e?.featureDescription&&Object.keys(i).length>0&&t.push(e.featureDescription)}t.length&&(this.context.environmentVariableCollection.description=r.l10n.t("Enables the following features: {0}",t.join(", ")))}dispose(){this.disposable.dispose()}},t.TerminalShellExecutionManager=class{constructor(e,t){this.model=e,this.logger=t,this.subcommands=new Set(["add","branch","checkout","cherry-pick","clean","commit","fetch","merge","mv","rebase","reset","restore","revert","rm","pull","push","stash","switch"]),this.disposables=[],r.window.onDidEndTerminalShellExecution(this.onDidEndTerminalShellExecution,this,this.disposables)}onDidEndTerminalShellExecution(e){const{execution:t,exitCode:i,shellIntegration:r}=e,[o,n]=t.commandLine.value.split(/\s+/),s=t.cwd??r.cwd;if("git"!==o.toLowerCase()||!this.subcommands.has(n?.toLowerCase())||!s||0!==i)return;this.logger.trace(`[TerminalShellExecutionManager][onDidEndTerminalShellExecution] Matched git subcommand: ${n}`);const a=this.model.getRepository(s);a?a.status():this.logger.trace(`[TerminalShellExecutionManager][onDidEndTerminalShellExecution] Unable to find repository for current working directory: ${s.toString()}`)}dispose(){(0,o.dispose)(this.disposables)}}},6452:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.fromBuffer=t.fromStream=t.EndOfStreamError=void 0;const r=i(6066),o=i(3492);var n=i(8705);Object.defineProperty(t,"EndOfStreamError",{enumerable:!0,get:function(){return n.EndOfStreamError}}),t.fromStream=function(e,t){return t=t||{},new r.ReadStreamTokenizer(e,t)},t.fromBuffer=function(e,t){return new o.BufferTokenizer(e,t)}},6675:(e,t,i)=>{"use strict";const r=i(6928),o=i(2608),n=i(1154),s=i(280),a=i(3940),l=(e,t,i=!1)=>{if(Array.isArray(e)){const r=e.map(e=>l(e,t,i)),o=e=>{for(const t of r){const i=t(e);if(i)return i}return!1};return o}const r=(o=e)&&"object"==typeof o&&!Array.isArray(o)&&e.tokens&&e.input;var o;if(""===e||"string"!=typeof e&&!r)throw new TypeError("Expected pattern to be a non-empty string");const n=t||{},a=s.isWindows(t),c=r?l.compileRe(e,t):l.makeRe(e,t,!1,!0),h=c.state;delete c.state;let u=()=>!1;if(n.ignore){const e={...t,ignore:null,onMatch:null,onResult:null};u=l(n.ignore,e,i)}const d=(i,r=!1)=>{const{isMatch:o,match:s,output:d}=l.test(i,c,t,{glob:e,posix:a}),p={glob:e,state:h,regex:c,posix:a,input:i,output:d,match:s,isMatch:o};return"function"==typeof n.onResult&&n.onResult(p),!1===o?(p.isMatch=!1,!!r&&p):u(i)?("function"==typeof n.onIgnore&&n.onIgnore(p),p.isMatch=!1,!!r&&p):("function"==typeof n.onMatch&&n.onMatch(p),!r||p)};return i&&(d.state=h),d};l.test=(e,t,i,{glob:r,posix:o}={})=>{if("string"!=typeof e)throw new TypeError("Expected input to be a string");if(""===e)return{isMatch:!1,output:""};const n=i||{},a=n.format||(o?s.toPosixSlashes:null);let c=e===r,h=c&&a?a(e):e;return!1===c&&(h=a?a(e):e,c=h===r),!1!==c&&!0!==n.capture||(c=!0===n.matchBase||!0===n.basename?l.matchBase(e,t,i,o):t.exec(h)),{isMatch:Boolean(c),match:c,output:h}},l.matchBase=(e,t,i,o=s.isWindows(i))=>(t instanceof RegExp?t:l.makeRe(t,i)).test(r.basename(e)),l.isMatch=(e,t,i)=>l(t,i)(e),l.parse=(e,t)=>Array.isArray(e)?e.map(e=>l.parse(e,t)):n(e,{...t,fastpaths:!1}),l.scan=(e,t)=>o(e,t),l.compileRe=(e,t,i=!1,r=!1)=>{if(!0===i)return e.output;const o=t||{},n=o.contains?"":"^",s=o.contains?"":"$";let a=`${n}(?:${e.output})${s}`;e&&!0===e.negated&&(a=`^(?!${a}).*$`);const c=l.toRegex(a,t);return!0===r&&(c.state=e),c},l.makeRe=(e,t={},i=!1,r=!1)=>{if(!e||"string"!=typeof e)throw new TypeError("Expected a non-empty string");let o={negated:!1,fastpaths:!0};return!1===t.fastpaths||"."!==e[0]&&"*"!==e[0]||(o.output=n.fastpaths(e,t)),o.output||(o=n(e,t)),l.compileRe(o,t,i,r)},l.toRegex=(e,t)=>{try{const i=t||{};return new RegExp(e,i.flags||(i.nocase?"i":""))}catch(e){if(t&&!0===t.debug)throw e;return/$^/}},l.constants=a,e.exports=l},6760:(e,t)=>{"use strict";t.stringToBytes=e=>[...e].map(e=>e.charCodeAt(0)),t.tarHeaderChecksumMatches=(e,t=0)=>{const i=parseInt(e.toString("utf8",148,154).replace(/\0.*$/,"").trim(),8);if(isNaN(i))return!1;let r=256;for(let i=t;i<t+148;i++)r+=e[i];for(let i=t+156;i<t+512;i++)r+=e[i];return i===r},t.uint32SyncSafeToken={get:(e,t)=>127&e[t+3]|e[t+2]<<7|e[t+1]<<14|e[t]<<21,len:4}},6867:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.ensureEmojis=async function(){void 0===a&&(void 0===l&&(l=async function(){const e=(0,o.getExtensionContext)(),t=r.Uri.joinPath(e.extensionUri,"resources","emojis.json");a=JSON.parse(new n.TextDecoder("utf8").decode(await r.workspace.fs.readFile(t)))}()),await l)},t.emojify=function(e){return void 0===a?e:e.replace(s,(e,t)=>a?.[t]||e)};const r=i(1398),o=i(1184),n=i(9023),s=/:([-+_a-z0-9]+):/g;let a,l},6928:e=>{"use strict";e.exports=require("path")},6982:e=>{"use strict";e.exports=require("crypto")},7016:e=>{"use strict";e.exports=require("url")},7242:(e,t,i)=>{const{isexe:r,sync:o}=i(842),{join:n,delimiter:s,sep:a,posix:l}=i(6928),c="win32"===process.platform,h=new RegExp(`[${l.sep}${a===l.sep?"":a}]`.replace(/(\\)/g,"\\$1")),u=new RegExp(`^\\.${h.source}`),d=e=>Object.assign(new Error(`not found: ${e}`),{code:"ENOENT"}),p=(e,{path:t=process.env.PATH,pathExt:i=process.env.PATHEXT,delimiter:r=s})=>{const o=e.match(h)?[""]:[...c?[process.cwd()]:[],...(t||"").split(r)];if(c){const t=i||[".EXE",".CMD",".BAT",".COM"].join(r),n=t.split(r).flatMap(e=>[e,e.toLowerCase()]);return e.includes(".")&&""!==n[0]&&n.unshift(""),{pathEnv:o,pathExt:n,pathExtExe:t}}return{pathEnv:o,pathExt:[""]}},m=(e,t)=>{const i=/^".*"$/.test(e)?e.slice(1,-1):e;return(!i&&u.test(t)?t.slice(0,2):"")+n(i,t)},g=async(e,t={})=>{const{pathEnv:i,pathExt:o,pathExtExe:n}=p(e,t),s=[];for(const a of i){const i=m(a,e);for(const e of o){const o=i+e;if(await r(o,{pathExt:n,ignoreErrors:!0})){if(!t.all)return o;s.push(o)}}}if(t.all&&s.length)return s;if(t.nothrow)return null;throw d(e)};e.exports=g,g.sync=(e,t={})=>{const{pathEnv:i,pathExt:r,pathExtExe:n}=p(e,t),s=[];for(const a of i){const i=m(a,e);for(const e of r){const r=i+e;if(o(r,{pathExt:n,ignoreErrors:!0})){if(!t.all)return r;s.push(r)}}}if(t.all&&s.length)return s;if(t.nothrow)return null;throw d(e)}},7681:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__decorate||function(e,t,i,r){var o,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,i):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,r);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(n<3?o(s):n>3?o(t,i,s):o(t,i))||s);return n>3&&s&&Object.defineProperty(t,i,s),s},a=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t}),l=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.StagedResourceQuickDiffProvider=t.Repository=t.Resource=void 0;const c=a(i(9896)),h=a(i(6928)),u=l(i(5157)),d=i(1398),p=i(1991),m=i(6199),g=i(3804),f=i(1558),y=i(4399),w=i(693),b=i(8e3),C=i(9212),v=i(8672),k=i(1750),R=i(4847),E=i(7937),S=i(6326),D=e=>new Promise(t=>setTimeout(t,e)),A=h.join(h.dirname(__dirname),"resources","icons");function _(e,t){return d.Uri.file(h.join(A,t,`${e}.svg`))}class P{static getStatusLetter(e){switch(e){case 0:case 5:return"M";case 1:case 9:return"A";case 2:case 6:return"D";case 3:case 10:return"R";case 11:return"T";case 7:return"U";case 8:return"I";case 4:return"C";case 17:case 12:case 15:case 13:case 14:case 16:case 18:return"!";default:throw new Error("Unknown git status: "+e)}}static getStatusText(e){switch(e){case 0:return d.l10n.t("Index Modified");case 5:return d.l10n.t("Modified");case 1:return d.l10n.t("Index Added");case 2:return d.l10n.t("Index Deleted");case 6:return d.l10n.t("Deleted");case 3:return d.l10n.t("Index Renamed");case 4:return d.l10n.t("Index Copied");case 7:return d.l10n.t("Untracked");case 8:return d.l10n.t("Ignored");case 9:return d.l10n.t("Intent to Add");case 10:return d.l10n.t("Intent to Rename");case 11:return d.l10n.t("Type Changed");case 17:return d.l10n.t("Conflict: Both Deleted");case 12:return d.l10n.t("Conflict: Added By Us");case 15:return d.l10n.t("Conflict: Deleted By Them");case 13:return d.l10n.t("Conflict: Added By Them");case 14:return d.l10n.t("Conflict: Deleted By Us");case 16:return d.l10n.t("Conflict: Both Added");case 18:return d.l10n.t("Conflict: Both Modified");default:return""}}static getStatusColor(e){switch(e){case 0:return new d.ThemeColor("gitDecoration.stageModifiedResourceForeground");case 5:case 11:return new d.ThemeColor("gitDecoration.modifiedResourceForeground");case 2:return new d.ThemeColor("gitDecoration.stageDeletedResourceForeground");case 6:return new d.ThemeColor("gitDecoration.deletedResourceForeground");case 1:case 9:return new d.ThemeColor("gitDecoration.addedResourceForeground");case 4:case 3:case 10:return new d.ThemeColor("gitDecoration.renamedResourceForeground");case 7:return new d.ThemeColor("gitDecoration.untrackedResourceForeground");case 8:return new d.ThemeColor("gitDecoration.ignoredResourceForeground");case 17:case 12:case 15:case 13:case 14:case 16:case 18:return new d.ThemeColor("gitDecoration.conflictingResourceForeground");default:throw new Error("Unknown git status: "+e)}}get resourceUri(){return!this.renameResourceUri||5!==this._type&&6!==this._type&&3!==this._type&&4!==this._type&&10!==this._type?this._resourceUri:this.renameResourceUri}get leftUri(){return this.resources.left}get rightUri(){return this.resources.right}get multiDiffEditorOriginalUri(){return this.resources.original}get multiFileDiffEditorModifiedUri(){return this.resources.modified}get command(){return this._commandResolver.resolveDefaultCommand(this)}get resources(){return this._commandResolver.getResources(this)}get resourceGroupType(){return this._resourceGroupType}get type(){return this._type}get original(){return this._resourceUri}get renameResourceUri(){return this._renameResourceUri}getIconPath(e){switch(this.type){case 0:case 5:return P.Icons[e].Modified;case 1:case 9:return P.Icons[e].Added;case 2:case 6:return P.Icons[e].Deleted;case 3:case 10:return P.Icons[e].Renamed;case 4:return P.Icons[e].Copied;case 7:return P.Icons[e].Untracked;case 8:return P.Icons[e].Ignored;case 11:return P.Icons[e].TypeChanged;case 17:case 12:case 15:case 13:case 14:case 16:case 18:return P.Icons[e].Conflict;default:throw new Error("Unknown git status: "+this.type)}}get tooltip(){return P.getStatusText(this.type)}get strikeThrough(){switch(this.type){case 6:case 17:case 15:case 14:case 2:return!0;default:return!1}}get faded(){return!1}get decorations(){const e=this._useIcons?{iconPath:this.getIconPath("light")}:void 0,t=this._useIcons?{iconPath:this.getIconPath("dark")}:void 0,i=this.tooltip;return{strikeThrough:this.strikeThrough,faded:this.faded,tooltip:i,light:e,dark:t}}get letter(){return P.getStatusLetter(this.type)}get color(){return P.getStatusColor(this.type)}get priority(){switch(this.type){case 0:case 5:case 4:case 11:return 2;case 8:return 3;case 17:case 12:case 15:case 13:case 14:case 16:case 18:return 4;default:return 1}}get resourceDecoration(){const e=new d.FileDecoration(this.letter,this.tooltip,this.color);return e.propagate=6!==this.type&&2!==this.type,e}constructor(e,t,i,r,o,n){this._commandResolver=e,this._resourceGroupType=t,this._resourceUri=i,this._type=r,this._useIcons=o,this._renameResourceUri=n}async open(){const e=this.command;await d.commands.executeCommand(e.command,...e.arguments||[])}async openFile(){const e=this._commandResolver.resolveFileCommand(this);await d.commands.executeCommand(e.command,...e.arguments||[])}async openChange(){const e=this._commandResolver.resolveChangeCommand(this);await d.commands.executeCommand(e.command,...e.arguments||[])}clone(e){return new P(this._commandResolver,e??this._resourceGroupType,this._resourceUri,this._type,this._useIcons,this._renameResourceUri)}}t.Resource=P,P.Icons={light:{Modified:_("status-modified","light"),Added:_("status-added","light"),Deleted:_("status-deleted","light"),Renamed:_("status-renamed","light"),Copied:_("status-copied","light"),Untracked:_("status-untracked","light"),Ignored:_("status-ignored","light"),Conflict:_("status-conflict","light"),TypeChanged:_("status-type-changed","light")},dark:{Modified:_("status-modified","dark"),Added:_("status-added","dark"),Deleted:_("status-deleted","dark"),Renamed:_("status-renamed","dark"),Copied:_("status-copied","dark"),Untracked:_("status-untracked","dark"),Ignored:_("status-ignored","dark"),Conflict:_("status-conflict","dark"),TypeChanged:_("status-type-changed","dark")}},s([y.memoize],P.prototype,"resourceUri",null),s([y.memoize],P.prototype,"command",null),s([y.memoize],P.prototype,"resources",null),s([y.memoize],P.prototype,"faded",null);class x{constructor(e){this.repository=e,this.enabled=!1,this.disposable=E.EmptyDisposable,(0,E.filterEvent)(d.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git",d.Uri.file(this.repository.root)))(e=>this.updateEnablement()),this.updateEnablement(),this.repository.onDidChangeOperations(()=>{this.repository.sourceControl.inputBox.enabled=!this.repository.operations.isRunning("Commit")})}updateEnablement(){d.workspace.getConfiguration("git",d.Uri.file(this.repository.root)).get("showProgress")?this.enable():this.disable()}enable(){if(this.enabled)return;const e=(0,E.onceEvent)((0,E.filterEvent)(this.repository.onDidChangeOperations,()=>this.repository.operations.shouldShowProgress())),t=(0,E.onceEvent)((0,E.filterEvent)((0,E.debounceEvent)(this.repository.onDidChangeOperations,300),()=>!this.repository.operations.shouldShowProgress())),i=()=>{this.disposable=e(()=>{const e=(0,E.eventToPromise)(t).then(()=>i());d.window.withProgress({location:d.ProgressLocation.SourceControl},()=>e)})};i(),this.enabled=!0}disable(){this.enabled&&(this.disposable.dispose(),this.disposable=E.EmptyDisposable,this.enabled=!1)}dispose(){this.disable()}}class T{constructor(e,t,i){this.onWorkspaceWorkingTreeFileChange=e,this.onDotGitFileChange=t,this.logger=i,this.eventDisposable=E.EmptyDisposable,this.logLevelDisposable=E.EmptyDisposable,this.logLevelDisposable=i.onDidChangeLogLevel(this.onDidChangeLogLevel,this),this.onDidChangeLogLevel(i.logLevel)}onDidChangeLogLevel(e){this.eventDisposable.dispose(),e>d.LogLevel.Debug||(this.eventDisposable=(0,E.combinedDisposable)([this.onWorkspaceWorkingTreeFileChange(e=>this.logger.debug(`[FileEventLogger][onWorkspaceWorkingTreeFileChange] ${e.fsPath}`)),this.onDotGitFileChange(e=>this.logger.debug(`[FileEventLogger][onDotGitFileChange] ${e.fsPath}`))]))}dispose(){this.eventDisposable.dispose(),this.logLevelDisposable.dispose()}}class M{constructor(e,t){this.repository=e,this.logger=t,this.emitter=new d.EventEmitter,this.transientDisposables=[],this.disposables=[];const i=(0,S.watch)(e.dotGit.path);this.disposables.push(i);const r=(0,E.filterEvent)(i.event,e=>"file"===e.scheme&&!/\/\.git(\/index\.lock)?$|\/\.watchman-cookie-/.test(e.path));this.event=(0,E.anyEvent)(r,this.emitter.event),e.onDidRunGitStatus(this.updateTransientWatchers,this,this.disposables),this.updateTransientWatchers()}updateTransientWatchers(){if(this.transientDisposables=(0,E.dispose)(this.transientDisposables),!this.repository.HEAD||!this.repository.HEAD.upstream)return;this.transientDisposables=(0,E.dispose)(this.transientDisposables);const{name:e,remote:t}=this.repository.HEAD.upstream,i=h.join(this.repository.dotGit.commonPath??this.repository.dotGit.path,"refs","remotes",t,e);try{const e=(0,S.watch)(i);this.transientDisposables.push(e),e.event(this.emitter.fire,this.emitter,this.transientDisposables)}catch(e){this.logger.warn(`[DotGitWatcher][updateTransientWatchers] Failed to watch ref '${i}', is most likely packed.`)}}dispose(){this.emitter.dispose(),this.transientDisposables=(0,E.dispose)(this.transientDisposables),this.disposables=(0,E.dispose)(this.disposables)}}class I{constructor(e){this.repository=e}resolveDefaultCommand(e){return d.workspace.getConfiguration("git",d.Uri.file(this.repository.root)).get("openDiffOnClick",!0)?this.resolveChangeCommand(e):this.resolveFileCommand(e)}resolveFileCommand(e){return{command:"vscode.open",title:d.l10n.t("Open"),arguments:[e.resourceUri]}}resolveChangeCommand(e){const t=this.getTitle(e);if(e.leftUri)return{command:"vscode.diff",title:d.l10n.t("Open"),arguments:[e.leftUri,e.rightUri,t]};{const i=18===e.type;return e.rightUri&&d.workspace.getConfiguration("git").get("mergeEditor",!1)&&(i||16===e.type)?{command:"git.openMergeEditor",title:d.l10n.t("Open Merge"),arguments:[e.rightUri]}:{command:"vscode.open",title:d.l10n.t("Open"),arguments:[e.rightUri,{override:!i&&void 0},t]}}}getResources(e){for(const t of this.repository.submodules)if(h.join(this.repository.root,t.path)===e.resourceUri.fsPath){const t=void 0,i=(0,R.toGitUri)(e.resourceUri,1===e.resourceGroupType?"index":"wt",{submoduleOf:this.repository.root});return{left:t,right:i,original:t,modified:i}}const t=this.getLeftResource(e),i=this.getRightResource(e);return{left:t.original??t.modified,right:i.original??i.modified,original:t.original??i.original,modified:t.modified??i.modified}}getLeftResource(e){switch(e.type){case 0:case 3:case 10:case 11:return{original:(0,R.toGitUri)(e.original,"HEAD")};case 5:return{original:(0,R.toGitUri)(e.resourceUri,"~")};case 14:case 15:return{original:(0,R.toGitUri)(e.resourceUri,"~1")}}return{}}getRightResource(e){switch(e.type){case 0:case 1:case 4:case 3:return{modified:(0,R.toGitUri)(e.resourceUri,"")};case 2:case 6:return{original:(0,R.toGitUri)(e.resourceUri,"HEAD")};case 14:return{original:(0,R.toGitUri)(e.resourceUri,"~3")};case 15:return{original:(0,R.toGitUri)(e.resourceUri,"~2")};case 5:case 7:case 8:case 9:case 10:case 11:{const t=e.resourceUri.toString(),[i]=this.repository.indexGroup.resourceStates.filter(e=>e.resourceUri.toString()===t);return i&&i.renameResourceUri?{modified:i.renameResourceUri}:{modified:e.resourceUri}}case 16:case 18:return{modified:e.resourceUri}}return{}}getTitle(e){const t=h.basename(e.resourceUri.fsPath);switch(e.type){case 0:case 3:case 1:return d.l10n.t("{0} (Index)",t);case 5:case 16:case 18:return d.l10n.t("{0} (Working Tree)",t);case 2:case 6:return d.l10n.t("{0} (Deleted)",t);case 14:return d.l10n.t("{0} (Theirs)",t);case 15:return d.l10n.t("{0} (Ours)",t);case 7:return d.l10n.t("{0} (Untracked)",t);case 9:case 10:return d.l10n.t("{0} (Intent to add)",t);case 11:return d.l10n.t("{0} (Type changed)",t);default:return""}}}class B{get onDidChangeOperations(){return(0,E.anyEvent)(this.onRunOperation,this.onDidRunOperation)}get sourceControl(){return this._sourceControl}get inputBox(){return this._sourceControl.inputBox}get mergeGroup(){return this._mergeGroup}get indexGroup(){return this._indexGroup}get workingTreeGroup(){return this._workingTreeGroup}get untrackedGroup(){return this._untrackedGroup}get HEAD(){return this._HEAD}get refs(){return this._refs}get headShortName(){if(!this.HEAD)return;const e=this.HEAD;return e.name?e.name:(e.commit||"").substr(0,8)}get remotes(){return this._remotes}get submodules(){return this._submodules}get worktrees(){return this._worktrees}set rebaseCommit(e){this._rebaseCommit&&!e?this.inputBox.value="":!e||this._rebaseCommit&&this._rebaseCommit.hash===e.hash||(this.inputBox.value=e.message);const t=!!this._rebaseCommit!=!!e;this._rebaseCommit=e,t&&d.commands.executeCommand("setContext","gitRebaseInProgress",!!this._rebaseCommit)}get rebaseCommit(){return this._rebaseCommit}set mergeInProgress(e){this._mergeInProgress!==e&&(this._mergeInProgress=e,d.commands.executeCommand("setContext","gitMergeInProgress",e))}get mergeInProgress(){return this._mergeInProgress}set cherryPickInProgress(e){this._cherryPickInProgress!==e&&(this._cherryPickInProgress=e,d.commands.executeCommand("setContext","gitCherryPickInProgress",e))}get cherryPickInProgress(){return this._cherryPickInProgress}get operations(){return this._operations}get state(){return this._state}set state(e){this._state=e,this._onDidChangeState.fire(e),this._HEAD=void 0,this._remotes=[],this.mergeGroup.resourceStates=[],this.indexGroup.resourceStates=[],this.workingTreeGroup.resourceStates=[],this.untrackedGroup.resourceStates=[],this._sourceControl.count=0}get root(){return this.repository.root}get rootRealPath(){return this.repository.rootRealPath}get dotGit(){return this.repository.dotGit}get kind(){return this.repository.kind}get historyProvider(){return this._historyProvider}constructor(e,t,i,r,o,n,s,a,l){this.repository=e,this.repositoryResolver=t,this.pushErrorHandlerRegistry=i,this.branchProtectionProviderRegistry=n,this.logger=l,this._onDidChangeRepository=new d.EventEmitter,this.onDidChangeRepository=this._onDidChangeRepository.event,this._onDidChangeState=new d.EventEmitter,this.onDidChangeState=this._onDidChangeState.event,this._onDidChangeStatus=new d.EventEmitter,this.onDidRunGitStatus=this._onDidChangeStatus.event,this._onDidChangeOriginalResource=new d.EventEmitter,this.onDidChangeOriginalResource=this._onDidChangeOriginalResource.event,this._onRunOperation=new d.EventEmitter,this.onRunOperation=this._onRunOperation.event,this._onDidRunOperation=new d.EventEmitter,this.onDidRunOperation=this._onDidRunOperation.event,this._onDidChangeBranchProtection=new d.EventEmitter,this.onDidChangeBranchProtection=this._onDidChangeBranchProtection.event,this._refs=[],this._remotes=[],this._submodules=[],this._worktrees=[],this._rebaseCommit=void 0,this._mergeInProgress=!1,this._cherryPickInProgress=!1,this._operations=new C.OperationManager(this.logger),this._state=0,this.isRepositoryHuge=!1,this.didWarnAboutLimit=!1,this.unpublishedCommits=void 0,this.branchProtection=new Map,this.resourceCommandResolver=new I(this),this.disposables=[];const c=d.workspace.createFileSystemWatcher(new d.RelativePattern(d.Uri.file(e.root),"**"));this.disposables.push(c);const u=(0,E.anyEvent)(c.onDidChange,c.onDidCreate,c.onDidDelete),m=(0,E.filterEvent)(u,t=>!/\.git($|\\|\/)/.test((0,E.relativePath)(e.root,t.fsPath)));let y;try{const e=new M(this,l);y=e.event,this.disposables.push(e)}catch(e){l.error(`Failed to watch path:'${this.dotGit.path}' or commonPath:'${this.dotGit.commonPath}', reverting to legacy API file watched. Some events might be lost.\n${e.stack||e}`),y=(0,E.filterEvent)(u,e=>/\.git($|\\|\/)/.test(e.path))}(0,E.anyEvent)(m,y)(this.onFileChange,this,this.disposables),y(this._onDidChangeRepository.fire,this._onDidChangeRepository,this.disposables),this.disposables.push(new T(m,y,l));const w="submodule"===e.kind?e.dotGit.superProjectPath:"worktree"===e.kind&&e.dotGit.commonPath?h.dirname(e.dotGit.commonPath):void 0,R=this.repositoryResolver.getRepository(w)?.sourceControl,S="submodule"===e.kind?new d.ThemeIcon("archive"):"worktree"===e.kind?new d.ThemeIcon("list-tree"):new d.ThemeIcon("repo"),D=d.Uri.file(e.root);this._sourceControl=d.scm.createSourceControl("git","Git",D,S,R),this._sourceControl.contextValue=e.kind,this._sourceControl.quickDiffProvider=this,this._sourceControl.secondaryQuickDiffProvider=new O(this,l),this._historyProvider=new b.GitHistoryProvider(s,this,l),this._sourceControl.historyProvider=this._historyProvider,this.disposables.push(this._historyProvider),this._sourceControl.acceptInputCommand={command:"git.commit",title:d.l10n.t("Commit"),arguments:[this._sourceControl]},this._sourceControl.inputBox.validateInput=this.validateInput.bind(this),this.disposables.push(this._sourceControl),this.updateInputBoxPlaceholder(),this.disposables.push(this.onDidRunGitStatus(()=>this.updateInputBoxPlaceholder())),this._mergeGroup=this._sourceControl.createResourceGroup("merge",d.l10n.t("Merge Changes")),this._indexGroup=this._sourceControl.createResourceGroup("index",d.l10n.t("Staged Changes"),{multiDiffEditorEnableViewChanges:!0}),this._workingTreeGroup=this._sourceControl.createResourceGroup("workingTree",d.l10n.t("Changes"),{multiDiffEditorEnableViewChanges:!0}),this._untrackedGroup=this._sourceControl.createResourceGroup("untracked",d.l10n.t("Untracked Changes"),{multiDiffEditorEnableViewChanges:!0});const A=()=>{const e=d.workspace.getConfiguration("git",D);this.indexGroup.hideWhenEmpty=!e.get("alwaysShowStagedChangesResourceGroup")};(0,E.filterEvent)(d.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git.alwaysShowStagedChangesResourceGroup",D))(A,this,this.disposables),A(),d.workspace.onDidChangeConfiguration(e=>{e.affectsConfiguration("git.mergeEditor")&&(this.mergeGroup.resourceStates=this.mergeGroup.resourceStates.map(e=>e.clone()))},void 0,this.disposables),(0,E.filterEvent)(d.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git.branchSortOrder",D)||e.affectsConfiguration("git.untrackedChanges",D)||e.affectsConfiguration("git.ignoreSubmodules",D)||e.affectsConfiguration("git.openDiffOnClick",D)||e.affectsConfiguration("git.showActionButton",D)||e.affectsConfiguration("git.similarityThreshold",D))(()=>this.updateModelState(),this,this.disposables);const _=()=>{const e=d.workspace.getConfiguration("git",D);this._sourceControl.inputBox.visible=e.get("showCommitInput",!0)};if((0,E.filterEvent)(d.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git.showCommitInput",D))(_,this,this.disposables),_(),this.mergeGroup.hideWhenEmpty=!0,this.untrackedGroup.hideWhenEmpty=!0,this.disposables.push(this.mergeGroup),this.disposables.push(this.indexGroup),this.disposables.push(this.workingTreeGroup),this.disposables.push(this.untrackedGroup),d.workspace.isTrusted)this.disposables.push(new g.AutoFetcher(this,a));else{const e=d.workspace.onDidGrantWorkspaceTrust(()=>{e.dispose(),this.disposables.push(new g.AutoFetcher(this,a))});this.disposables.push(e)}(0,E.filterEvent)(this.onDidRunOperation,e=>"Push"===e.operation.kind&&!e.error)(()=>{d.workspace.getConfiguration("git").get("showPushSuccessNotification")&&d.window.showInformationMessage(d.l10n.t("Successfully pushed."))},null,this.disposables);const P=(0,E.filterEvent)(this.branchProtectionProviderRegistry.onDidChangeBranchProtectionProviders,e=>(0,E.pathEquals)(e.fsPath,D.fsPath));this.disposables.push(P(e=>this.updateBranchProtectionMatchers(e))),this.disposables.push(this.branchProtectionProviderRegistry.registerBranchProtectionProvider(D,new f.GitBranchProtectionProvider(D)));const B=new k.StatusBarCommands(this,r);this.disposables.push(B),B.onDidChange(()=>this._sourceControl.statusBarCommands=B.commands,null,this.disposables),this._sourceControl.statusBarCommands=B.commands,this.commitCommandCenter=new v.CommitCommandsCenter(a,this,o),this.disposables.push(this.commitCommandCenter);const L=new p.ActionButton(this,this.commitCommandCenter,this.logger);this.disposables.push(L),L.onDidChange(()=>this._sourceControl.actionButton=L.button,this,this.disposables),this._sourceControl.actionButton=L.button;const G=new x(this);this.disposables.push(G),(0,E.filterEvent)(d.workspace.onDidChangeConfiguration,e=>e.affectsConfiguration("git.countBadge",D))(this.setCountBadge,this,this.disposables),this.setCountBadge()}validateInput(e,t){return this.isRepositoryHuge?{message:d.l10n.t("Too many changes were detected. Only the first {0} changes will be shown below.",this.isRepositoryHuge.limit),type:d.SourceControlInputBoxValidationType.Warning}:this.rebaseCommit&&this.rebaseCommit.message!==e?{message:d.l10n.t("It's not possible to change the commit message in the middle of a rebase. Please complete the rebase operation and use interactive rebase instead."),type:d.SourceControlInputBoxValidationType.Warning}:void 0}get label(){return d.l10n.t("Git Local Changes (Working Tree)")}async provideOriginalResource(e){if(this.logger.trace(`[Repository][provideOriginalResource] Resource: ${e.toString()}`),"file"!==e.scheme)return void this.logger.trace(`[Repository][provideOriginalResource] Resource is not a file: ${e.scheme}`);if(0!==((await d.workspace.fs.stat(e)).type&d.FileType.SymbolicLink))return void this.logger.trace(`[Repository][provideOriginalResource] Resource is a symbolic link: ${e.toString()}`);if(this.repositoryResolver.getRepository(e)!==this)return void this.logger.trace(`[Repository][provideOriginalResource] Resource is not part of the repository: ${e.toString()}`);if(this.mergeGroup.resourceStates.some(t=>(0,E.pathEquals)(t.resourceUri.fsPath,e.fsPath)))return void this.logger.trace(`[Repository][provideOriginalResource] Resource is part of a merge group: ${e.toString()}`);if(this.untrackedGroup.resourceStates.some(t=>(0,E.pathEquals)(t.resourceUri.path,e.path))||this.workingTreeGroup.resourceStates.some(t=>(0,E.pathEquals)(t.resourceUri.path,e.path)&&7===t.type))return void this.logger.trace(`[Repository][provideOriginalResource] Resource is untracked: ${e.toString()}`);const t=d.window.tabGroups.activeTabGroup.activeTab?.input;if(t instanceof d.TabInputTextDiff&&(0,E.pathEquals)(t.modified.fsPath,e.fsPath))return void this.logger.trace(`[Repository][provideOriginalResource] Resource is on the right-hand side of a diff editor: ${e.toString()}`);if(t instanceof d.TabInputTextMultiDiff&&t.textDiffs.some(t=>(0,E.pathEquals)(t.modified.fsPath,e.fsPath)))return void this.logger.trace(`[Repository][provideOriginalResource] Resource is on the right-hand side of a multi-file diff editor: ${e.toString()}`);const i=(0,R.toGitUri)(e,"",{replaceFileExtension:!0});return this.logger.trace(`[Repository][provideOriginalResource] Original resource: ${i.toString()}`),i}async getInputTemplate(){return(await Promise.all([this.repository.getMergeMessage(),this.repository.getSquashMessage()])).find(e=>!!e)||await this.repository.getCommitTemplate()}getConfigs(){return this.run(C.Operation.Config(!0),()=>this.repository.getConfigs("local"))}getConfig(e){return this.run(C.Operation.Config(!0),()=>this.repository.config("get","local",e))}getGlobalConfig(e){return this.run(C.Operation.Config(!0),()=>this.repository.config("get","global",e))}setConfig(e,t){return this.run(C.Operation.Config(!1),()=>this.repository.config("add","local",e,t))}unsetConfig(e){return this.run(C.Operation.Config(!1),()=>this.repository.config("unset","local",e))}log(e,t){const i=!e||!0!==e.silent;return this.run(C.Operation.Log(i),()=>this.repository.log(e,t))}logFile(e,t,i){return this.run(C.Operation.LogFile,()=>this.repository.logFile(e,t,i))}async status(){await this.run(C.Operation.Status)}async refresh(){await this.run(C.Operation.Refresh)}diff(e){return this.run(C.Operation.Diff,()=>this.repository.diff(e))}diffWithHEAD(e){return this.run(C.Operation.Diff,()=>this.repository.diffWithHEAD(e))}diffWith(e,t){return this.run(C.Operation.Diff,()=>this.repository.diffWith(e,t))}diffIndexWithHEAD(e){return this.run(C.Operation.Diff,()=>this.repository.diffIndexWithHEAD(e))}diffIndexWith(e,t){return this.run(C.Operation.Diff,()=>this.repository.diffIndexWith(e,t))}diffBlobs(e,t){return this.run(C.Operation.Diff,()=>this.repository.diffBlobs(e,t))}diffBetween(e,t,i){return this.run(C.Operation.Diff,()=>this.repository.diffBetween(e,t,i))}diffBetweenShortStat(e,t){return this.run(C.Operation.Diff,()=>this.repository.diffBetweenShortStat(e,t))}diffTrees(e,t){const i=d.workspace.getConfiguration("git",d.Uri.file(this.root)).get("similarityThreshold",50);return this.run(C.Operation.Diff,()=>this.repository.diffTrees(e,t,{similarityThreshold:i}))}getMergeBase(e,t,...i){return this.run(C.Operation.MergeBase,()=>this.repository.getMergeBase(e,t,...i))}async hashObject(e){return this.run(C.Operation.HashObject,()=>this.repository.hashObject(e))}async add(e,t){await this.run(C.Operation.Add(!this.optimisticUpdateEnabled()),async()=>{await this.repository.add(e.map(e=>e.fsPath),t),this.closeDiffEditors([],[...e.map(e=>e.fsPath)])},()=>{const t=e.map(e=>e.fsPath),i=this.indexGroup.resourceStates.map(e=>e.resourceUri.fsPath),r=[];for(const e of[...this.mergeGroup.resourceStates,...this.untrackedGroup.resourceStates,...this.workingTreeGroup.resourceStates])t.includes(e.resourceUri.fsPath)&&!i.includes(e.resourceUri.fsPath)&&r.push(e.clone(1));return{indexGroup:[...this.indexGroup.resourceStates,...r],mergeGroup:this.mergeGroup.resourceStates.filter(e=>!t.includes(e.resourceUri.fsPath)),workingTreeGroup:this.workingTreeGroup.resourceStates.filter(e=>!t.includes(e.resourceUri.fsPath)),untrackedGroup:this.untrackedGroup.resourceStates.filter(e=>!t.includes(e.resourceUri.fsPath))}})}async rm(e){await this.run(C.Operation.Remove,()=>this.repository.rm(e.map(e=>e.fsPath)))}async stage(e,t,i){await this.run(C.Operation.Stage,async()=>{const r=await d.workspace.encode(t,{encoding:i});await this.repository.stage(e.fsPath,r),this._onDidChangeOriginalResource.fire(e),this.closeDiffEditors([],[...e.fsPath])})}async revert(e){await this.run(C.Operation.RevertFiles(!this.optimisticUpdateEnabled()),async()=>{await this.repository.revert("HEAD",e.map(e=>e.fsPath));for(const t of e)this._onDidChangeOriginalResource.fire(t);this.closeDiffEditors([...0!==e.length?e.map(e=>e.fsPath):this.indexGroup.resourceStates.map(e=>e.resourceUri.fsPath)],[])},()=>{const t=d.workspace.getConfiguration("git",d.Uri.file(this.repository.root)).get("untrackedChanges"),i="mixed"===t?2:3,r=0===e.length?this.indexGroup.resourceStates.map(e=>e.resourceUri.fsPath):e.map(e=>e.fsPath),o=[],n=[];for(const e of this.indexGroup.resourceStates)r.includes(e.resourceUri.fsPath)&&(1===e.type?n.push(e.clone(i)):o.push(e.clone(2)));return{indexGroup:this.indexGroup.resourceStates.filter(e=>!r.includes(e.resourceUri.fsPath)),workingTreeGroup:"mixed"===t?[...this.workingTreeGroup.resourceStates,...o,...n]:[...this.workingTreeGroup.resourceStates,...o],untrackedGroup:"separate"===t?[...this.untrackedGroup.resourceStates,...n]:void 0}})}async commit(e,t=Object.create(null)){const i=[...this.indexGroup.resourceStates.map(e=>e.resourceUri.fsPath)],r=t.all&&"tracked"!==t.all?[...this.workingTreeGroup.resourceStates.map(e=>e.resourceUri.fsPath)]:[];this.rebaseCommit?await this.run(C.Operation.RebaseContinue,async()=>{if(t.all){const e="tracked"===t.all?{update:!0}:{};await this.repository.add([],e)}await this.repository.rebaseContinue(),await this.commitOperationCleanup(e,i,r)},()=>this.commitOperationGetOptimisticResourceGroups(t)):(this.commitCommandCenter.postCommitCommand=t.postCommitCommand,await this.run(C.Operation.Commit,async()=>{if(t.all){const e="tracked"===t.all?{update:!0}:{};await this.repository.add([],e)}if(delete t.all,void 0===t.requireUserConfig||null===t.requireUserConfig){const e=d.workspace.getConfiguration("git",d.Uri.file(this.root));t.requireUserConfig=e.get("requireGitUserConfig")}await this.repository.commit(e,t),await this.commitOperationCleanup(e,i,r)},()=>this.commitOperationGetOptimisticResourceGroups(t)),await this.run(C.Operation.PostCommitCommand,async()=>{await this.commitCommandCenter.executePostCommitCommand(t.postCommitCommand)}))}async commitOperationCleanup(e,t,i){e&&(this.inputBox.value=await this.getInputTemplate()),this.closeDiffEditors(t,i)}commitOperationGetOptimisticResourceGroups(e){let t,i;return"tracked"===e.all?i=this.workingTreeGroup.resourceStates.filter(e=>7===e.type):e.all&&(t=i=[]),{indexGroup:[],mergeGroup:[],untrackedGroup:t,workingTreeGroup:i}}async clean(e){const t=d.workspace.getConfiguration("git").get("discardUntrackedChangesToTrash",!0)&&!E.isRemote&&!E.isLinuxSnap;await this.run(C.Operation.Clean(!this.optimisticUpdateEnabled()),async()=>{const i=[],r=[],o=[],n=[...this.workingTreeGroup.resourceStates,...this.untrackedGroup.resourceStates];if(e.forEach(e=>{const t=e.fsPath;for(const e of this.submodules)if(h.join(this.root,e.path)===t)return void o.push(t);const s=e.toString(),a=(0,E.find)(n,e=>e.resourceUri.toString()===s);if(a)switch(a.type){case 7:case 8:i.push(t);break;default:r.push(t)}}),i.length>0)if(t)try{await d.workspace.fs.delete(d.Uri.file(i[0]),{useTrash:!0});const e=new E.Limiter(5);await Promise.all(i.slice(1).map(t=>e.queue(async()=>await d.workspace.fs.delete(d.Uri.file(t),{useTrash:!0}))))}catch{const t=E.isWindows?d.l10n.t("Failed to delete using the Recycle Bin. Do you want to permanently delete instead?"):d.l10n.t("Failed to delete using the Trash. Do you want to permanently delete instead?"),r=1===i.length?d.l10n.t("Delete File"):d.l10n.t("Delete All {0} Files",e.length);await d.window.showWarningMessage(t,{modal:!0},r)===r&&await this.repository.clean(i)}else await this.repository.clean(i);if(r.length>0)try{await this.repository.checkout("",r)}catch(e){if("BranchNotYetBorn"!==e.gitErrorCode)throw e}o.length>0&&await this.repository.updateSubmodules(o),this.closeDiffEditors([],[...i,...r])},()=>{const t=e.map(e=>e.fsPath);return{workingTreeGroup:this.workingTreeGroup.resourceStates.filter(e=>!t.includes(e.resourceUri.fsPath)),untrackedGroup:this.untrackedGroup.resourceStates.filter(e=>!t.includes(e.resourceUri.fsPath))}})}closeDiffEditors(e,t,i=!1){if(!d.workspace.getConfiguration("git",d.Uri.file(this.root)).get("closeDiffOnOperation",!1)&&!i)return;function r(i){return!("git"!==i.modified.scheme||void 0!==e&&!e.some(e=>(0,E.pathEquals)(e,i.modified.fsPath)))||!("file"!==i.modified.scheme||"git"!==i.original.scheme||void 0!==t&&!t.some(e=>(0,E.pathEquals)(e,i.modified.fsPath)))}const o=d.window.tabGroups.all.flatMap(e=>e.tabs).filter(({input:e})=>e instanceof d.TabInputTextDiff||e instanceof d.TabInputNotebookDiff?r(e):e instanceof d.TabInputTextMultiDiff&&e.textDiffs.every(r));d.window.tabGroups.close(o,!0)}async branch(e,t,i){await this.run(C.Operation.Branch,()=>this.repository.branch(e,t,i))}async deleteBranch(e,t){return this.run(C.Operation.DeleteBranch,async()=>{await this.repository.deleteBranch(e,t),await this.repository.config("unset","local",`branch.${e}.vscode-merge-base`)})}async renameBranch(e){await this.run(C.Operation.RenameBranch,()=>this.repository.renameBranch(e))}async fastForwardBranch(e){const t=await this.getBranch(e);if(t.upstream?.remote&&t.upstream?.name&&t.name)try{const e={remote:t.upstream.remote,ref:`${t.upstream.name}:${t.name}`};await this.run(C.Operation.Fetch(!0),async()=>this.repository.fetch(e))}catch(e){if("BranchFastForwardRejected"===e.gitErrorCode)return;throw e}}async cherryPick(e){await this.run(C.Operation.CherryPick,()=>this.repository.cherryPick(e))}async cherryPickAbort(){await this.run(C.Operation.CherryPick,()=>this.repository.cherryPickAbort())}async move(e,t){await this.run(C.Operation.Move,()=>this.repository.move(e,t))}async getBranch(e){return await this.run(C.Operation.GetBranch,()=>this.repository.getBranch(e))}async getBranches(e={},t){return await this.run(C.Operation.GetBranches,async()=>(await this.getRefs(e,t)).filter(t=>0===t.type||1===t.type&&e.remote))}async getBranchBase(e){const t=`branch.${(await this.getBranch(e)).name}.vscode-merge-base`;try{const e=await this.getConfig(t),i=""!==e?await this.getBranch(e):void 0;if(i&&i.remote)return i}catch(e){}const i=await this.getBranchBaseFromReflog(e);let r;if(1===i?.type?r=i:0===i?.type&&(r=await this.getUpstreamBranch(i)),r)return await this.setConfig(t,`${r.remote}/${r.name}`),r;const o=await this.getDefaultBranch();return o?(await this.setConfig(t,`${o.remote}/${o.name}`),o):void 0}async getBranchBaseFromReflog(e){try{const t=await this.repository.reflog(e,"branch: Created from *.");if(1!==t.length)return;const i=t[0].match(/branch: Created from (?<name>.*)$/);if(i&&2===i.length&&"HEAD"!==i[1])return await this.getBranch(i[1]);const r=await this.repository.reflog("HEAD",`checkout: moving from .* to ${e.replace("refs/heads/","")}`);if(0===r.length)return;const o=r[r.length-1].match(/checkout: moving from ([^\s]+)\s/);if(o&&2===o.length)return await this.getBranch(o[1])}catch(e){}}async getDefaultBranch(){const e=this.getDefaultRemote();if(e)try{return await this.repository.getDefaultBranch(e.name)}catch(e){return void this.logger.warn(`[Repository][getDefaultBranch] Failed to get default branch details: ${e.message}.`)}}async getUpstreamBranch(e){if(e.upstream)try{return await this.getBranch(`refs/remotes/${e.upstream.remote}/${e.upstream.name}`)}catch(t){return void this.logger.warn(`[Repository][getUpstreamBranch] Failed to get branch details for 'refs/remotes/${e.upstream.remote}/${e.upstream.name}': ${t.message}.`)}}async getRefs(e={},t){let i=d.workspace.getConfiguration("git").get("branchSortOrder");return"alphabetically"!==i&&"committerdate"!==i&&(i="alphabetically"),e={...e,sort:e?.sort??i},await this.run(C.Operation.GetRefs,()=>this.repository.getRefs(e,t))}async getWorktrees(){return await this.run(C.Operation.GetWorktrees,()=>this.repository.getWorktrees())}async getRemoteRefs(e,t){return await this.run(C.Operation.GetRemoteRefs,()=>this.repository.getRemoteRefs(e,t))}async setBranchUpstream(e,t){await this.run(C.Operation.SetBranchUpstream,()=>this.repository.setBranchUpstream(e,t))}async merge(e){await this.run(C.Operation.Merge,()=>this.repository.merge(e))}async mergeAbort(){await this.run(C.Operation.MergeAbort,async()=>await this.repository.mergeAbort())}async rebase(e){await this.run(C.Operation.Rebase,()=>this.repository.rebase(e))}async tag(e){await this.run(C.Operation.Tag,()=>this.repository.tag(e))}async deleteTag(e){await this.run(C.Operation.DeleteTag,()=>this.repository.deleteTag(e))}async addWorktree(e){await this.run(C.Operation.Worktree,()=>this.repository.addWorktree(e))}async deleteWorktree(e,t){await this.run(C.Operation.DeleteWorktree,()=>this.repository.deleteWorktree(e,t))}async deleteRemoteRef(e,t,i){await this.run(C.Operation.DeleteRemoteRef,()=>this.repository.deleteRemoteRef(e,t,i))}async checkout(e,t){const i=t?.detached?(0,E.getCommitShortHash)(d.Uri.file(this.root),e):e;await this.run(C.Operation.Checkout(i),async()=>{if(t?.pullBeforeCheckout&&!t?.detached)try{await this.fastForwardBranch(e)}catch(e){}await this.repository.checkout(e,[],t)})}async checkoutTracking(e,t={}){const i=t.detached?(0,E.getCommitShortHash)(d.Uri.file(this.root),e):e;await this.run(C.Operation.CheckoutTracking(i),()=>this.repository.checkout(e,[],{...t,track:!0}))}async findTrackingBranches(e){return await this.run(C.Operation.FindTrackingBranches,()=>this.repository.findTrackingBranches(e))}async getCommit(e){return await this.repository.getCommit(e)}async showCommit(e){return await this.run(C.Operation.Show,()=>this.repository.showCommit(e))}async getEmptyTree(){if(!this._EMPTY_TREE){const e=await this.repository.exec(["hash-object","-t","tree","/dev/null"]);this._EMPTY_TREE=e.stdout.trim()}return this._EMPTY_TREE}async reset(e,t){await this.run(C.Operation.Reset,()=>this.repository.reset(e,t))}async deleteRef(e){await this.run(C.Operation.DeleteRef,()=>this.repository.deleteRef(e))}getDefaultRemote(){if(0!==this.remotes.length)return this.remotes.find(e=>"origin"===e.name)??this.remotes[0]}async addRemote(e,t){await this.run(C.Operation.Remote,()=>this.repository.addRemote(e,t))}async removeRemote(e){await this.run(C.Operation.Remote,()=>this.repository.removeRemote(e))}async renameRemote(e,t){await this.run(C.Operation.Remote,()=>this.repository.renameRemote(e,t))}async fetchDefault(e={}){await this._fetch({silent:e.silent})}async fetchPrune(){await this._fetch({prune:!0})}async fetchAll(e={},t){await this._fetch({all:!0,silent:e.silent,cancellationToken:t})}async fetch(e){await this._fetch(e)}async _fetch(e={}){if(!e.prune){const t=d.workspace.getConfiguration("git",d.Uri.file(this.root)).get("pruneOnFetch");e.prune=t}await this.run(C.Operation.Fetch(!0!==e.silent),async()=>this.repository.fetch(e))}async pullWithRebase(e){let t,i;return e&&e.name&&e.upstream&&(t=e.upstream.remote,i=`${e.upstream.name}`),this.pullFrom(!0,t,i)}async pull(e,t){let i,r;return e&&e.name&&e.upstream&&(i=e.upstream.remote,r=`${e.upstream.name}`),this.pullFrom(!1,i,r,t)}async pullFrom(e,t,i,r){await this.run(C.Operation.Pull,async()=>{await this.maybeAutoStash(async()=>{const o=d.workspace.getConfiguration("git",d.Uri.file(this.root)),n=o.get("autoStash"),s=o.get("fetchOnPull"),a=o.get("pullTags");s&&await this.fetchAll(),await this.checkIfMaybeRebased(this.HEAD?.name)&&await this._pullAndHandleTagConflict(e,t,i,{unshallow:r,tags:a,autoStash:n})})})}async _pullAndHandleTagConflict(e,t,i,r={}){try{await this.repository.pull(e,t,i,r)}catch(o){if("TagConflict"!==o.gitErrorCode)throw o;await this.handleTagConflict(t,o.stderr)&&await this.repository.pull(e,t,i,r)}}async push(e,t){let i,r;e&&e.name&&e.upstream&&(i=e.upstream.remote,r=`${e.name}:${e.upstream.name}`),await this.run(C.Operation.Push,()=>this._push(i,r,void 0,void 0,t))}async pushTo(e,t,i=!1,r){await this.run(C.Operation.Push,()=>this._push(e,t,i,void 0,r))}async pushFollowTags(e,t){await this.run(C.Operation.Push,()=>this._push(e,void 0,!1,!0,t))}async pushTags(e,t){await this.run(C.Operation.Push,()=>this._push(e,void 0,!1,!1,t,!0))}async blame(e){return await this.run(C.Operation.Blame(!0),()=>this.repository.blame(e))}async blame2(e,t){return await this.run(C.Operation.Blame(!1),()=>this.repository.blame2(e,t))}sync(e,t){return this._sync(e,t)}async _sync(e,t){let i,r,o;e.name&&e.upstream&&(i=e.upstream.remote,r=`${e.upstream.name}`,o=`${e.name}:${e.upstream.name}`),await this.run(C.Operation.Sync,async()=>{await this.maybeAutoStash(async()=>{const e=d.workspace.getConfiguration("git",d.Uri.file(this.root)),n=e.get("autoStash"),s=e.get("fetchOnPull"),a=e.get("pullTags"),l=e.get("followTagsWhenSync"),c=e.get("supportCancellation"),h=async e=>{s&&await this.fetchAll({},e),await this.checkIfMaybeRebased(this.HEAD?.name)&&await this._pullAndHandleTagConflict(t,i,r,{tags:a,cancellationToken:e,autoStash:n})};if(c){const e={location:d.ProgressLocation.Notification,title:d.l10n.t("Syncing. Cancelling may cause serious damages to the repository"),cancellable:!0};await d.window.withProgress(e,(e,t)=>h(t))}else await h();const u=this.remotes.find(e=>e.name===i);u&&u.isReadOnly||this.HEAD&&("number"!=typeof this.HEAD.ahead||this.HEAD.ahead>0)&&await this._push(i,o,!1,l)})})}async checkIfMaybeRebased(e){const t=d.workspace.getConfiguration("git");if(!0===t.get("ignoreRebaseWarning"))return!0;const i=await this.run(C.Operation.Log(!0),async()=>{try{const t=await this.repository.exec(["log","--oneline","--cherry",`${e??""}...${e??""}@{upstream}`,"--"]);return!t.exitCode&&/^=/.test(t.stdout)}catch{return!1}});if(!i)return!0;const r={title:d.l10n.t("Always Pull")},o={title:d.l10n.t("Pull")},n={title:d.l10n.t("Don't Pull")},s=await d.window.showWarningMessage(e?d.l10n.t('It looks like the current branch "{0}" might have been rebased. Are you sure you still want to pull into it?',e):d.l10n.t("It looks like the current branch might have been rebased. Are you sure you still want to pull into it?"),r,o,n);return s===o||s===r&&(await t.update("ignoreRebaseWarning",!0,!0),!0)}async show(e,t){return await this.run(C.Operation.Show,async()=>{try{const i=await this.repository.buffer(e,t);return await d.workspace.decode(i,{uri:d.Uri.file(t)})}catch(i){if("WrongCase"===i.gitErrorCode){const i=await this.repository.getGitFilePath(e,t),r=await this.repository.buffer(e,i);return await d.workspace.decode(r,{uri:d.Uri.file(t)})}throw i}})}async buffer(e,t){return this.run(C.Operation.Show,()=>this.repository.buffer(e,t))}getObjectFiles(e){return this.run(C.Operation.GetObjectFiles,()=>this.repository.lstree(e))}getObjectDetails(e,t){return this.run(C.Operation.GetObjectDetails,()=>this.repository.getObjectDetails(e,t))}detectObjectType(e){return this.run(C.Operation.Show,()=>this.repository.detectObjectType(e))}async apply(e,t){return await this.run(C.Operation.Apply,()=>this.repository.apply(e,t))}async getStashes(){return this.run(C.Operation.Stash,()=>this.repository.getStashes())}async createStash(e,t,i){const r=[...this.indexGroup.resourceStates.map(e=>e.resourceUri.fsPath)],o=[...i?[]:this.workingTreeGroup.resourceStates.map(e=>e.resourceUri.fsPath),...t?this.untrackedGroup.resourceStates.map(e=>e.resourceUri.fsPath):[]];return await this.run(C.Operation.Stash,async()=>{await this.repository.createStash(e,t,i),this.closeDiffEditors(r,o)})}async popStash(e){return await this.run(C.Operation.Stash,()=>this.repository.popStash(e))}async dropStash(e){return await this.run(C.Operation.Stash,()=>this.repository.dropStash(e))}async applyStash(e){return await this.run(C.Operation.Stash,()=>this.repository.applyStash(e))}async showStash(e){return await this.run(C.Operation.Stash,()=>this.repository.showStash(e))}async getCommitTemplate(){return await this.run(C.Operation.GetCommitTemplate,async()=>this.repository.getCommitTemplate())}async ignore(e){return await this.run(C.Operation.Ignore,async()=>{const t=`${this.repository.root}${h.sep}.gitignore`,i=e.map(e=>(0,E.relativePath)(this.repository.root,e.fsPath).replace(/\\|\[/g,e=>"\\"===e?"/":`\\${e}`)).join("\n"),r=await new Promise(e=>c.exists(t,e))?await d.workspace.openTextDocument(t):await d.workspace.openTextDocument(d.Uri.file(t).with({scheme:"untitled"}));await d.window.showTextDocument(r);const o=new d.WorkspaceEdit,n=r.lineAt(r.lineCount-1),s=n.isEmptyOrWhitespace?`${i}\n`:`\n${i}\n`;o.insert(r.uri,n.range.end,s),await d.workspace.applyEdit(o),await r.save()})}async rebaseAbort(){await this.run(C.Operation.RebaseAbort,async()=>await this.repository.rebaseAbort())}checkIgnore(e){return this.run(C.Operation.CheckIgnore,()=>new Promise((t,i)=>{if(0===(e=e.filter(e=>(0,E.isDescendant)(this.root,e))).length)return t(new Set);const r=this.repository.stream(["check-ignore","-v","-z","--stdin"],{stdio:[null,null,null]});r.stdin.end(e.join("\0"),"utf8");let o="";r.stdout.setEncoding("utf8"),r.stdout.on("data",e=>{o+=e});let n="";r.stderr.setEncoding("utf8"),r.stderr.on("data",e=>n+=e),r.on("error",i),r.on("exit",e=>{1===e?t(new Set):0===e?t(new Set(this.parseIgnoreCheck(o))):/ is in submodule /.test(n)?i(new w.GitError({stdout:o,stderr:n,exitCode:e,gitErrorCode:"IsInSubmodule"})):i(new w.GitError({stdout:o,stderr:n,exitCode:e}))})}))}parseIgnoreCheck(e){const t=[],i=e.split("\0");for(let e=0;e<i.length;e+=4){const r=i[e+2],o=i[e+3];r&&!r.startsWith("!")&&t.push(o)}return t}async _push(e,t,i=!1,r=!1,o,n=!1){try{await this.repository.push(e,t,i,r,o,n)}catch(i){if(!e||!t)throw i;const r=new m.ApiRepository(this),o=r.state.remotes.find(t=>t.name===e);if(!o)throw i;for(const e of this.pushErrorHandlerRegistry.getPushErrorHandlers())if(await e.handlePushError(r,o,t,i))return;throw i}}async run(e,t=()=>Promise.resolve(null),i=()=>{}){if(0!==this.state)throw new Error("Repository not initialized");let r=null;this._operations.start(e),this._onRunOperation.fire(e.kind);try{const r=await this.retryRun(e,t);return e.readOnly||await this.updateModelState(this.optimisticUpdateEnabled()?i():void 0),r}catch(t){throw r=t,"NotAGitRepository"===t.gitErrorCode&&(this.state=1),e.readOnly||await this.updateModelState(),t}finally{this._operations.end(e),this._onDidRunOperation.fire({operation:e,error:r})}}async retryRun(e,t=()=>Promise.resolve(null)){let i=0;for(;;)try{return i++,await t()}catch(t){if(!(i<=10)||"RepositoryIsLocked"!==t.gitErrorCode&&(!e.retry||"CantLockRef"!==t.gitErrorCode&&"CantRebaseMultipleBranches"!==t.gitErrorCode))throw t;await D(50*Math.pow(i,2))}}async findKnownHugeFolderPathsToIgnore(){const e=[];for(const t of B.KnownHugeFolderNames){const i=h.join(this.repository.root,t);await new Promise(e=>c.exists(i,e))&&e.push(i)}const t=await this.checkIgnore(e);return e.filter(e=>!t.has(e))}async updateModelState(e){this.updateModelStateCancellationTokenSource?.cancel(),this.updateModelStateCancellationTokenSource=new d.CancellationTokenSource,await this._updateModelState(e,this.updateModelStateCancellationTokenSource.token)}async _updateModelState(e,t){try{e&&this._updateResourceGroupsState(e);const[i,r,o,n,s,a,l,c]=await Promise.all([this.repository.getHEADRef(),this.repository.getRemotes(),this.repository.getSubmodules(),this.repository.getWorktrees(),this.getRebaseCommit(),this.isMergeInProgress(),this.isCherryPickInProgress(),this.getInputTemplate()]);this.HEAD?.name===i?.name&&this.HEAD?.commit===i?.commit&&this.HEAD?.ahead===i?.ahead&&this.HEAD?.upstream===i?.upstream||(this.unpublishedCommits=void 0),this._HEAD=i,this._remotes=r,this._submodules=o,this._worktrees=n,this.rebaseCommit=s,this.mergeInProgress=a,this.cherryPickInProgress=l,this._sourceControl.commitTemplate=c;const[h,u]=await Promise.all([this.getStatus(t),this.getRefs({},t)]);this._refs=u,this._updateResourceGroupsState(h),this._onDidChangeStatus.fire()}catch(e){if(e instanceof d.CancellationError)return;throw e}}_updateResourceGroupsState(e){e.indexGroup&&(this.indexGroup.resourceStates=e.indexGroup),e.mergeGroup&&(this.mergeGroup.resourceStates=e.mergeGroup),e.untrackedGroup&&(this.untrackedGroup.resourceStates=e.untrackedGroup),e.workingTreeGroup&&(this.workingTreeGroup.resourceStates=e.workingTreeGroup),this.setCountBadge()}async getStatus(e){if(e&&e.isCancellationRequested)throw new d.CancellationError;const t=d.workspace.getConfiguration("git",d.Uri.file(this.repository.root)),i=t.get("untrackedChanges"),r=t.get("ignoreSubmodules"),o=t.get("statusLimit",1e4),n=t.get("similarityThreshold",50),{status:s,statusLength:a,didHitLimit:l}=((new Date).getTime(),await this.repository.getStatus({limit:o,ignoreSubmodules:r,similarityThreshold:n,untrackedChanges:i,cancellationToken:e}));(new Date).getTime(),this.isRepositoryHuge=!!l&&{limit:o},this._sourceControl.inputBox.validateInput=this._sourceControl.inputBox.validateInput;const c=d.workspace.getConfiguration("git"),u=!0===c.get("ignoreLimitWarning"),p=!c.get("decorations.enabled",!0);if(l&&!u&&!this.didWarnAboutLimit){const e=await this.findKnownHugeFolderPathsToIgnore(),t=d.l10n.t('The git repository at "{0}" has too many active changes, only a subset of Git features will be enabled.',this.repository.root),i={title:d.l10n.t("Don't Show Again")};if(e.length>0){const r=e[0],o=h.basename(r),n=d.l10n.t('Would you like to add "{0}" to .gitignore?',o),s={title:d.l10n.t("Yes")},a={title:d.l10n.t("No")};d.window.showWarningMessage(`${t} ${n}`,s,a,i).then(e=>{e===s?this.ignore([d.Uri.file(r)]):(e===i&&c.update("ignoreLimitWarning",!0,!1),this.didWarnAboutLimit=!0)})}else{const e={title:d.l10n.t("OK")};d.window.showWarningMessage(t,e,i).then(e=>{e===i&&c.update("ignoreLimitWarning",!0,!1),this.didWarnAboutLimit=!0})}}const m=[],g=[],f=[],y=[];return s.forEach(e=>{const t=d.Uri.file(h.join(this.repository.root,e.path)),r=e.rename?d.Uri.file(h.join(this.repository.root,e.rename)):void 0;switch(e.x+e.y){case"??":switch(i){case"mixed":return y.push(new P(this.resourceCommandResolver,2,t,7,p));case"separate":return f.push(new P(this.resourceCommandResolver,3,t,7,p));default:return}case"!!":switch(i){case"mixed":return y.push(new P(this.resourceCommandResolver,2,t,8,p));case"separate":return f.push(new P(this.resourceCommandResolver,3,t,8,p));default:return}case"DD":return g.push(new P(this.resourceCommandResolver,0,t,17,p));case"AU":return g.push(new P(this.resourceCommandResolver,0,t,12,p));case"UD":return g.push(new P(this.resourceCommandResolver,0,t,15,p));case"UA":return g.push(new P(this.resourceCommandResolver,0,t,13,p));case"DU":return g.push(new P(this.resourceCommandResolver,0,t,14,p));case"AA":return g.push(new P(this.resourceCommandResolver,0,t,16,p));case"UU":return g.push(new P(this.resourceCommandResolver,0,t,18,p))}switch(e.x){case"M":m.push(new P(this.resourceCommandResolver,1,t,0,p));break;case"A":m.push(new P(this.resourceCommandResolver,1,t,1,p));break;case"D":m.push(new P(this.resourceCommandResolver,1,t,2,p));break;case"R":m.push(new P(this.resourceCommandResolver,1,t,3,p,r));break;case"C":m.push(new P(this.resourceCommandResolver,1,t,4,p,r))}switch(e.y){case"M":y.push(new P(this.resourceCommandResolver,2,t,5,p,r));break;case"D":y.push(new P(this.resourceCommandResolver,2,t,6,p,r));break;case"A":y.push(new P(this.resourceCommandResolver,2,t,9,p,r));break;case"R":y.push(new P(this.resourceCommandResolver,2,t,10,p,r));break;case"T":y.push(new P(this.resourceCommandResolver,2,t,11,p,r))}}),{indexGroup:m,mergeGroup:g,untrackedGroup:f,workingTreeGroup:y}}setCountBadge(){const e=d.workspace.getConfiguration("git",d.Uri.file(this.repository.root)),t=e.get("countBadge"),i=e.get("untrackedChanges");let r=this.mergeGroup.resourceStates.length+this.indexGroup.resourceStates.length+this.workingTreeGroup.resourceStates.length;switch(t){case"off":r=0;break;case"tracked":"mixed"===i&&(r-=this.workingTreeGroup.resourceStates.filter(e=>7===e.type||8===e.type).length);break;case"all":"separate"===i&&(r+=this.untrackedGroup.resourceStates.length)}this._sourceControl.count=r}async getRebaseCommit(){const e=h.join(this.repository.root,".git","REBASE_HEAD"),t=h.join(this.repository.root,".git","rebase-apply"),i=h.join(this.repository.root,".git","rebase-merge");try{const[r,o,n]=await Promise.all([new Promise(e=>c.exists(t,e)),new Promise(e=>c.exists(i,e)),new Promise((t,i)=>c.readFile(e,"utf8",(e,r)=>e?i(e):t(r)))]);if(!r&&!o)return;return await this.getCommit(n.trim())}catch(e){return}}isMergeInProgress(){const e=h.join(this.repository.root,".git","MERGE_HEAD");return new Promise(t=>c.exists(e,t))}isCherryPickInProgress(){const e=h.join(this.repository.root,".git","CHERRY_PICK_HEAD");return new Promise(t=>c.exists(e,t))}async maybeAutoStash(e){if(!(d.workspace.getConfiguration("git",d.Uri.file(this.root)).get("autoStash")&&this.repository.git.compareGitVersionTo("2.27.0")<0&&(this.indexGroup.resourceStates.length>0||this.workingTreeGroup.resourceStates.some(e=>7!==e.type&&8!==e.type))))return await e();await this.repository.createStash(void 0,!0);try{return await e()}finally{await this.repository.popStash()}}onFileChange(e){d.workspace.getConfiguration("git").get("autorefresh")?this.isRepositoryHuge?this.logger.trace("[Repository][onFileChange] Skip running git status because repository is huge."):this.operations.isIdle()?this.eventuallyUpdateWhenIdleAndWait():this.logger.trace("[Repository][onFileChange] Skip running git status because an operation is running."):this.logger.trace("[Repository][onFileChange] Skip running git status because autorefresh setting is disabled.")}eventuallyUpdateWhenIdleAndWait(){this.updateWhenIdleAndWait()}async updateWhenIdleAndWait(){await this.whenIdleAndFocused(),await this.status(),await D(5e3)}async whenIdleAndFocused(){for(;;){if(this.operations.isIdle()){if(!d.window.state.focused){const e=(0,E.filterEvent)(d.window.onDidChangeWindowState,e=>e.focused);await(0,E.eventToPromise)(e);continue}return}await(0,E.eventToPromise)(this.onDidRunOperation)}}get headLabel(){const e=this.HEAD;return e?(e.name||(e.commit||"").substr(0,8))+(this.workingTreeGroup.resourceStates.length+this.untrackedGroup.resourceStates.length>0?"*":"")+(this.indexGroup.resourceStates.length>0?"+":"")+(this.mergeInProgress||this.rebaseCommit?"!":""):""}get syncLabel(){if(!(this.HEAD&&this.HEAD.name&&this.HEAD.commit&&this.HEAD.upstream&&(this.HEAD.ahead||this.HEAD.behind)))return"";const e=this.HEAD&&this.HEAD.remote||this.HEAD.upstream.remote,t=this.remotes.find(t=>t.name===e);return t&&t.isReadOnly?`${this.HEAD.behind}↓`:`${this.HEAD.behind}↓ ${this.HEAD.ahead}↑`}get syncTooltip(){if(!(this.HEAD&&this.HEAD.name&&this.HEAD.commit&&this.HEAD.upstream&&(this.HEAD.ahead||this.HEAD.behind)))return d.l10n.t("Synchronize Changes");const e=this.HEAD&&this.HEAD.remote||this.HEAD.upstream.remote,t=this.remotes.find(t=>t.name===e);return t&&t.isReadOnly||!this.HEAD.ahead?d.l10n.t("Pull {0} commits from {1}/{2}",this.HEAD.behind,this.HEAD.upstream.remote,this.HEAD.upstream.name):this.HEAD.behind?d.l10n.t("Pull {0} and push {1} commits between {2}/{3}",this.HEAD.behind,this.HEAD.ahead,this.HEAD.upstream.remote,this.HEAD.upstream.name):d.l10n.t("Push {0} commits to {1}/{2}",this.HEAD.ahead,this.HEAD.upstream.remote,this.HEAD.upstream.name)}updateInputBoxPlaceholder(){const e=this.headShortName;this._sourceControl.inputBox.placeholder=e?d.l10n.t('Message ({0} to commit on "{1}")',"{0}",e):d.l10n.t("Message ({0} to commit)")}updateBranchProtectionMatchers(e){this.branchProtection.clear();for(const t of this.branchProtectionProviderRegistry.getBranchProtectionProviders(e))for(const{remote:e,rules:i}of t.provideBranchProtection()){const t=[];for(const e of i){const i=e.include&&0!==e.include.length?(0,u.default)(e.include):void 0,r=e.exclude&&0!==e.exclude.length?(0,u.default)(e.exclude):void 0;(i||r)&&t.push({include:i,exclude:r})}0!==t.length&&this.branchProtection.set(e,t)}this._onDidChangeBranchProtection.fire()}optimisticUpdateEnabled(){return!0===d.workspace.getConfiguration("git",d.Uri.file(this.root)).get("optimisticUpdate")}async handleTagConflict(e,t){if(!(e=e??this.HEAD?.upstream?.remote))throw new Error("Unable to resolve tag conflict due to missing remote.");const i=[];for(const e of t.matchAll(/^ ! \[rejected\]\s+([^\s]+)\s+->\s+([^\s]+)\s+\(would clobber existing tag\)$/gm))3===e.length&&i.push(e[1]);if(0===i.length)throw new Error(`Unable to extract tag names from error message: ${t}`);const r=d.workspace.getConfiguration("git",d.Uri.file(this.repository.root));if(!0!==r.get("replaceTagsWhenPull",!1)){const e=d.l10n.t("Replace Local Tag(s)"),t=d.l10n.t("Always Replace Local Tag(s)"),o=d.l10n.t("Unable to pull from remote repository due to conflicting tag(s): {0}. Would you like to resolve the conflict by replacing the local tag(s)?",i.join(", ")),n=await d.window.showErrorMessage(o,{modal:!0},e,t);if(n!==e&&n!==t)return!1;n===t&&await r.update("replaceTagsWhenPull",!0,!0)}return await this.repository.fetchTags({remote:e,tags:i,force:!0}),!0}isBranchProtected(e=this.HEAD){if(e?.name){const t=this.branchProtection.get("");if(1===t?.length&&t[0].include&&t[0].include(e.name))return!0;if(e.upstream?.remote){const t=this.branchProtection.get(e.upstream.remote);if(t&&0!==t?.length)return t.some(t=>{const i=!t.include||t.include(e.name),r=!!t.exclude&&t.exclude(e.name);return i&&!r})}}return!1}async getUnpublishedCommits(){if(this.unpublishedCommits)return this.unpublishedCommits;if(!this.HEAD?.name)return this.unpublishedCommits=new Set,this.unpublishedCommits;if(this.HEAD.upstream)if(0===this.HEAD.ahead)this.unpublishedCommits=new Set;else{const e=`${this.HEAD.upstream.remote}/${this.HEAD.upstream.name}`,t=this.HEAD.name,i=await this.repository.revList(e,t);this.unpublishedCommits=new Set(i)}else if(this.historyProvider.currentHistoryItemBaseRef){const e=this.historyProvider.currentHistoryItemBaseRef.id,t=this.HEAD.name,i=await this.repository.revList(e,t);this.unpublishedCommits=new Set(i)}else this.unpublishedCommits=new Set;return this.unpublishedCommits}dispose(){this.disposables=(0,E.dispose)(this.disposables)}}t.Repository=B,B.KnownHugeFolderNames=["node_modules"],s([y.memoize],B.prototype,"onDidChangeOperations",null),s([y.throttle],B.prototype,"status",null),s([y.throttle],B.prototype,"refresh",null),s([y.throttle],B.prototype,"fastForwardBranch",null),s([y.sequentialize],B.prototype,"getBranchBase",null),s([y.throttle],B.prototype,"fetchDefault",null),s([y.throttle],B.prototype,"fetchPrune",null),s([y.throttle],B.prototype,"fetchAll",null),s([y.throttle],B.prototype,"pullWithRebase",null),s([y.throttle],B.prototype,"pull",null),s([y.throttle],B.prototype,"push",null),s([y.throttle],B.prototype,"sync",null),s([(0,y.debounce)(1e3)],B.prototype,"eventuallyUpdateWhenIdleAndWait",null),s([y.throttle],B.prototype,"updateWhenIdleAndWait",null);class O{constructor(e,t){this._repository=e,this.logger=t,this.label=d.l10n.t("Git Local Changes (Index)")}async provideOriginalResource(e){if(this.logger.trace(`[StagedResourceQuickDiffProvider][provideOriginalResource] Resource: ${e.toString()}`),"file"!==e.scheme)return void this.logger.trace(`[StagedResourceQuickDiffProvider][provideOriginalResource] Resource is not a file: ${e.scheme}`);if(0!==((await d.workspace.fs.stat(e)).type&d.FileType.SymbolicLink))return void this.logger.trace(`[StagedResourceQuickDiffProvider][provideOriginalResource] Resource is a symbolic link: ${e.toString()}`);if(!this._repository.indexGroup.resourceStates.some(t=>(0,E.pathEquals)(t.resourceUri.fsPath,e.fsPath)))return void this.logger.trace(`[StagedResourceQuickDiffProvider][provideOriginalResource] Resource is not part of a index group: ${e.toString()}`);const t=(0,R.toGitUri)(e,"HEAD",{replaceFileExtension:!0});return this.logger.trace(`[StagedResourceQuickDiffProvider][provideOriginalResource] Original resource: ${t.toString()}`),t}}t.StagedResourceQuickDiffProvider=O},7937:function(e,t,i){"use strict";var r=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(t,"__esModule",{value:!0}),t.Versions=t.PromiseSource=t.Limiter=t.EmptyDisposable=t.isLinuxSnap=t.isLinux=t.isRemote=t.isWindows=t.isMacintosh=void 0,t.log=function(...e){console.log.apply(console,["git:",...e])},t.dispose=l,t.toDisposable=c,t.combinedDisposable=h,t.fireEvent=function(e){return(t,i,r)=>e(e=>t.call(i),null,r)},t.mapEvent=function(e,t){return(i,r,o)=>e(e=>i.call(r,t(e)),null,o)},t.filterEvent=function(e,t){return(i,r,o)=>e(e=>t(e)&&i.call(r,e),null,o)},t.runAndSubscribeEvent=function(e,t,i){return t(i),e(e=>t(e))},t.anyEvent=function(...e){return(t,i,r)=>{const o=h(e.map(e=>e(e=>t.call(i,e))));return r?.push(o),o}},t.done=function(e){return e.then(()=>{})},t.onceEvent=u,t.debounceEvent=function(e,t){return(i,r,o)=>{let n;return e(e=>{clearTimeout(n),n=setTimeout(()=>i.call(r,e),t)},null,o)}},t.eventToPromise=d,t.once=function(e){return(...t)=>e(...t)},t.assign=function(e,...t){for(const i of t)Object.keys(i).forEach(t=>e[t]=i[t]);return e},t.uniqBy=function(e,t){const i=Object.create(null);return e.filter(e=>{const r=t(e);return!i[r]&&(i[r]=!0,!0)})},t.groupBy=function(e,t){return e.reduce((e,i)=>{const r=t(i);return e[r]=[...e[r]||[],i],e},Object.create(null))},t.mkdirp=async function e(t,i){const r=async()=>{try{await s.promises.mkdir(t,i)}catch(e){if("EEXIST"===e.code){if((await s.promises.stat(t)).isDirectory())return;throw new Error(`'${t}' exists and is not a directory.`)}throw e}};if(t===(0,n.dirname)(t))return!0;try{await r()}catch(o){if("ENOENT"!==o.code)throw o;await e((0,n.dirname)(t),i),await r()}return!0},t.uniqueFilter=function(e){const t=Object.create(null);return i=>{const r=e(i);return!t[r]&&(t[r]=!0,!0)}},t.find=function(e,t){let i;return e.some(e=>!!t(e)&&(i=e,!0)),i},t.grep=async function(e,t){return new Promise((i,r)=>{const o=(0,s.createReadStream)(e,{encoding:"utf8"}),n=(0,a.default)(o);n.on("data",e=>{t.test(e)&&(o.close(),i(!0))}),n.on("error",r),n.on("end",()=>i(!1))})},t.readBytes=function(e,t){return new Promise((i,r)=>{let o=!1;const n=Buffer.allocUnsafe(t);let s=0;e.on("data",i=>{const r=Math.min(t-s,i.length);i.copy(n,s,0,r),s+=r,s===t&&e.destroy()}),e.on("error",e=>{o||(o=!0,r(e))}),e.on("close",()=>{o||(o=!0,i(n.slice(0,s)))})})},t.detectUnicodeEncoding=function(e){if(e.length<2)return null;const t=e.readUInt8(0),i=e.readUInt8(1);if(254===t&&255===i)return"utf16be";if(255===t&&254===i)return"utf16le";if(e.length<3)return null;const r=e.readUInt8(2);return 239===t&&187===i&&191===r?"utf8":null},t.truncate=function(e,t=20,i=!0){return e.length<=t?e:`${e.substring(0,t)}${i?"…":""}`},t.isDescendant=m,t.pathEquals=function(e,t){return p(e)===p(t)},t.relativePath=function(e,t){return g(e,t)??(0,n.relative)(e,t)},t.relativePathWithNoFallback=g,t.splitInChunks=function*(e,t){let i=[],r=0;for(const o of e){let e=r+o.length;e>t&&i.length>0&&(yield i,i=[],e=o.length),i.push(o),r=e}i.length>0&&(yield i)},t.isDefined=function(e){return!f(e)},t.isUndefinedOrNull=f,t.isUndefined=y,t.deltaHistoryItemRefs=function(e,t){if(0===e.length)return{added:t,modified:[],removed:[]};const i=[],r=[],o=[];let n=0,s=0;for(;;){if(n===e.length){i.push(...t.slice(s));break}if(s===t.length){o.push(...e.slice(n));break}const a=e[n],l=t[s],c=a.id.localeCompare(l.id);0===c?(a.revision!==l.revision&&r.push(l),n+=1,s+=1):c<0?(o.push(a),n+=1):c>0&&(i.push(l),s+=1)}return{added:i,modified:r,removed:o}},t.fromNow=function e(t,i,r,n){"number"!=typeof t&&(t=t.getTime());const s=Math.round(((new Date).getTime()-t)/1e3);if(s<-30)return o.l10n.t("in {0}",e((new Date).getTime()+1e3*s,!1));if(!n&&s<30)return o.l10n.t("now");let a;return s<b?(a=s,i?1===a?r?o.l10n.t("{0} second ago",a):o.l10n.t("{0} sec ago",a):r?o.l10n.t("{0} seconds ago",a):o.l10n.t("{0} secs ago",a):1===a?r?o.l10n.t("{0} second",a):o.l10n.t("{0} sec",a):r?o.l10n.t("{0} seconds",a):o.l10n.t("{0} secs",a)):s<C?(a=Math.floor(s/b),i?1===a?r?o.l10n.t("{0} minute ago",a):o.l10n.t("{0} min ago",a):r?o.l10n.t("{0} minutes ago",a):o.l10n.t("{0} mins ago",a):1===a?r?o.l10n.t("{0} minute",a):o.l10n.t("{0} min",a):r?o.l10n.t("{0} minutes",a):o.l10n.t("{0} mins",a)):s<v?(a=Math.floor(s/C),i?1===a?r?o.l10n.t("{0} hour ago",a):o.l10n.t("{0} hr ago",a):r?o.l10n.t("{0} hours ago",a):o.l10n.t("{0} hrs ago",a):1===a?r?o.l10n.t("{0} hour",a):o.l10n.t("{0} hr",a):r?o.l10n.t("{0} hours",a):o.l10n.t("{0} hrs",a)):s<k?(a=Math.floor(s/v),i?1===a?o.l10n.t("{0} day ago",a):o.l10n.t("{0} days ago",a):1===a?o.l10n.t("{0} day",a):o.l10n.t("{0} days",a)):s<R?(a=Math.floor(s/k),i?1===a?r?o.l10n.t("{0} week ago",a):o.l10n.t("{0} wk ago",a):r?o.l10n.t("{0} weeks ago",a):o.l10n.t("{0} wks ago",a):1===a?r?o.l10n.t("{0} week",a):o.l10n.t("{0} wk",a):r?o.l10n.t("{0} weeks",a):o.l10n.t("{0} wks",a)):s<E?(a=Math.floor(s/R),i?1===a?r?o.l10n.t("{0} month ago",a):o.l10n.t("{0} mo ago",a):r?o.l10n.t("{0} months ago",a):o.l10n.t("{0} mos ago",a):1===a?r?o.l10n.t("{0} month",a):o.l10n.t("{0} mo",a):r?o.l10n.t("{0} months",a):o.l10n.t("{0} mos",a)):(a=Math.floor(s/E),i?1===a?r?o.l10n.t("{0} year ago",a):o.l10n.t("{0} yr ago",a):r?o.l10n.t("{0} years ago",a):o.l10n.t("{0} yrs ago",a):1===a?r?o.l10n.t("{0} year",a):o.l10n.t("{0} yr",a):r?o.l10n.t("{0} years",a):o.l10n.t("{0} yrs",a))},t.getCommitShortHash=function(e,t){const i=o.workspace.getConfiguration("git",e).get("commitShortHashLength",7);return t.substring(0,i)},t.toDiagnosticSeverity=function(e){return"error"===e?o.DiagnosticSeverity.Error:"warning"===e?o.DiagnosticSeverity.Warning:"information"===e?o.DiagnosticSeverity.Information:o.DiagnosticSeverity.Hint},t.extractFilePathFromArgs=function(e,t){const i=e[t];if(!i.match(/^["']/))return i.replace(/^["']+|["':]+$/g,"");const r=i[0];if(i.endsWith(r)&&i.length>1)return i.slice(1,-1);let o=i;for(let i=t+1;i<e.length;i++)if(o=`${o} ${e[i]}`,e[i].endsWith(r))return o.slice(1,-1);return o.slice(1)};const o=i(1398),n=i(6928),s=i(9896),a=r(i(5607));function l(e){return e.forEach(e=>e.dispose()),[]}function c(e){return{dispose:e}}function h(e){return c(()=>l(e))}function u(e){return(t,i,r)=>{const o=e(e=>(o.dispose(),t.call(i,e)),null,r);return o}}function d(e){return new Promise(t=>u(e)(t))}function p(e){return t.isWindows||t.isMacintosh?e.toLowerCase():e}function m(e,t){return e===t||(e.charAt(e.length-1)!==n.sep&&(e+=n.sep),p(t).startsWith(p(e)))}function g(e,t){if(e.charAt(e.length-1)!==n.sep&&(e+=n.sep),m(e,t)&&e.length<t.length)return t.substring(e.length)}function f(e){return y(e)||null===e}function y(e){return void 0===e}var w;t.isMacintosh="darwin"===process.platform,t.isWindows="win32"===process.platform,t.isRemote=void 0!==o.env.remoteName,t.isLinux="linux"===process.platform,t.isLinuxSnap=t.isLinux&&!!process.env.SNAP&&!!process.env.SNAP_REVISION,t.EmptyDisposable=c(()=>null),t.Limiter=class{constructor(e){this.maxDegreeOfParalellism=e,this.outstandingPromises=[],this.runningPromises=0}queue(e){return new Promise((t,i)=>{this.outstandingPromises.push({factory:e,c:t,e:i}),this.consume()})}consume(){for(;this.outstandingPromises.length&&this.runningPromises<this.maxDegreeOfParalellism;){const e=this.outstandingPromises.shift();this.runningPromises++;const t=e.factory();t.then(e.c,e.e),t.then(()=>this.consumed(),()=>this.consumed())}}consumed(){this.runningPromises--,this.outstandingPromises.length>0&&this.consume()}},t.PromiseSource=class{constructor(){this._onDidComplete=new o.EventEmitter}get promise(){return this._promise?this._promise:d(this._onDidComplete.event).then(e=>{if(e.success)return e.value;throw e.err})}resolve(e){this._promise||(this._promise=Promise.resolve(e),this._onDidComplete.fire({success:!0,value:e}))}reject(e){this._promise||(this._promise=Promise.reject(e),this._onDidComplete.fire({success:!1,err:e}))}},function(e){function t(e,t,i,r){return{major:"string"==typeof e?parseInt(e,10):e,minor:"string"==typeof t?parseInt(t,10):t,patch:null==i?0:"string"==typeof i?parseInt(i,10):i,pre:r}}function i(e){const[i,r]=e.split("-"),[o,n,s]=i.split(".");return t(o,n,s,r)}e.compare=function(e,t){return"string"==typeof e&&(e=i(e)),"string"==typeof t&&(t=i(t)),e.major>t.major?1:e.major<t.major?-1:e.minor>t.minor?1:e.minor<t.minor?-1:e.patch>t.patch?1:e.patch<t.patch?-1:void 0===e.pre&&void 0!==t.pre?1:void 0!==e.pre&&void 0===t.pre?-1:void 0!==e.pre&&void 0!==t.pre?e.pre.localeCompare(t.pre):0},e.from=t,e.fromString=i}(w||(t.Versions=w={}));const b=60,C=60*b,v=24*C,k=7*v,R=30*v,E=365*v},8e3:function(e,t,i){"use strict";var r=this&&this.__decorate||function(e,t,i,r){var o,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,i):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,r);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(n<3?o(s):n>3?o(t,i,s):o(t,i))||s);return n>3&&s&&Object.defineProperty(t,i,s),s};Object.defineProperty(t,"__esModule",{value:!0}),t.GitHistoryProvider=void 0;const o=i(1398),n=i(7681),s=i(7937),a=i(4847),l=i(6867),c=i(8107),h=i(4399);function u(e,t){const i=e=>e.id.startsWith("refs/heads/")?1:e.id.startsWith("refs/remotes/")?2:e.id.startsWith("refs/tags/")?3:99,r=i(e),o=i(t);return r!==o?r-o:e.name.localeCompare(t.name)}class d{get currentHistoryItemRef(){return this._currentHistoryItemRef}get currentHistoryItemRemoteRef(){return this._currentHistoryItemRemoteRef}get currentHistoryItemBaseRef(){return this._currentHistoryItemBaseRef}constructor(e,t,i){this.historyItemDetailProviderRegistry=e,this.repository=t,this.logger=i,this._onDidChangeDecorations=new o.EventEmitter,this.onDidChangeFileDecorations=this._onDidChangeDecorations.event,this._onDidChangeCurrentHistoryItemRefs=new o.EventEmitter,this.onDidChangeCurrentHistoryItemRefs=this._onDidChangeCurrentHistoryItemRefs.event,this._onDidChangeHistoryItemRefs=new o.EventEmitter,this.onDidChangeHistoryItemRefs=this._onDidChangeHistoryItemRefs.event,this._historyItemRefs=[],this.commitShortHashLength=7,this.historyItemDecorations=new Map,this.disposables=[],this.disposables.push(o.workspace.onDidChangeConfiguration(this.onDidChangeConfiguration)),this.onDidChangeConfiguration();const r=(0,s.filterEvent)(t.onDidRunOperation,e=>!e.operation.readOnly);this.disposables.push(r(this.onDidRunWriteOperation,this)),this.disposables.push(o.window.registerFileDecorationProvider(this))}onDidChangeConfiguration(e){if(e&&!e.affectsConfiguration("git.commitShortHashLength"))return;const t=o.workspace.getConfiguration("git",o.Uri.file(this.repository.root));this.commitShortHashLength=t.get("commitShortHashLength",7)}async onDidRunWriteOperation(e){if(!this.repository.HEAD)return this.logger.trace("[GitHistoryProvider][onDidRunWriteOperation] repository.HEAD is undefined"),this._currentHistoryItemRef=this._currentHistoryItemRemoteRef=this._currentHistoryItemBaseRef=void 0,void this._onDidChangeCurrentHistoryItemRefs.fire();const t=this.repository.refs.map(e=>this.toSourceControlHistoryItemRef(e)).sort((e,t)=>e.id.localeCompare(t.id)),i=(0,s.deltaHistoryItemRefs)(this._historyItemRefs,t);this._historyItemRefs=t;let r="",n="";switch(this.repository.HEAD.type){case 0:if(void 0!==this.repository.HEAD.name)if(r=`refs/heads/${this.repository.HEAD.name}`,n=this.repository.HEAD.name,this.repository.HEAD.upstream?"."===this.repository.HEAD.upstream.remote?this._currentHistoryItemRemoteRef={id:`refs/heads/${this.repository.HEAD.upstream.name}`,name:this.repository.HEAD.upstream.name,revision:this.repository.HEAD.upstream.commit,icon:new o.ThemeIcon("gi-branch")}:this._currentHistoryItemRemoteRef={id:`refs/remotes/${this.repository.HEAD.upstream.remote}/${this.repository.HEAD.upstream.name}`,name:`${this.repository.HEAD.upstream.remote}/${this.repository.HEAD.upstream.name}`,revision:this.repository.HEAD.upstream.commit,icon:new o.ThemeIcon("cloud")}:this._currentHistoryItemRemoteRef=void 0,this._HEAD?.name!==this.repository.HEAD.name){const e=await this.resolveHEADMergeBase();this._currentHistoryItemBaseRef=e&&e.name&&e.remote&&(e.remote!==this.repository.HEAD.upstream?.remote||e.name!==this.repository.HEAD.upstream?.name)?{id:`refs/remotes/${e.remote}/${e.name}`,name:`${e.remote}/${e.name}`,revision:e.commit,icon:new o.ThemeIcon("cloud")}:void 0}else{const e=i.modified.find(e=>e.id===this._currentHistoryItemBaseRef?.id);this._currentHistoryItemBaseRef&&e&&(this._currentHistoryItemBaseRef={...this._currentHistoryItemBaseRef,revision:e.revision})}else r=this.repository.HEAD.commit??"",n=this.repository.HEAD.commit??"",this._currentHistoryItemRemoteRef=void 0,this._currentHistoryItemBaseRef=void 0;break;case 2:r=`refs/tags/${this.repository.HEAD.name}`,n=this.repository.HEAD.name??this.repository.HEAD.commit??"",this._currentHistoryItemRemoteRef=void 0,this._currentHistoryItemBaseRef=void 0}this._HEAD=this.repository.HEAD,this._currentHistoryItemRef={id:r,name:n,revision:this.repository.HEAD.commit,icon:new o.ThemeIcon("target")},this._onDidChangeCurrentHistoryItemRefs.fire(),this.logger.trace(`[GitHistoryProvider][onDidRunWriteOperation] currentHistoryItemRef: ${JSON.stringify(this._currentHistoryItemRef)}`),this.logger.trace(`[GitHistoryProvider][onDidRunWriteOperation] currentHistoryItemRemoteRef: ${JSON.stringify(this._currentHistoryItemRemoteRef)}`),this.logger.trace(`[GitHistoryProvider][onDidRunWriteOperation] currentHistoryItemBaseRef: ${JSON.stringify(this._currentHistoryItemBaseRef)}`);const a="Fetch"===e.operation.kind&&!1===e.operation.showProgress;this._onDidChangeHistoryItemRefs.fire({...i,silent:a});const l={added:i.added.map(e=>e.id),modified:i.modified.map(e=>e.id),removed:i.removed.map(e=>e.id),silent:a};this.logger.trace(`[GitHistoryProvider][onDidRunWriteOperation] historyItemRefs: ${JSON.stringify(l)}`)}async provideHistoryItemRefs(e){const t=await this.repository.getRefs({pattern:e}),i=[],r=[],o=[];for(const e of t)switch(e.type){case 1:r.push(this.toSourceControlHistoryItemRef(e));break;case 2:o.push(this.toSourceControlHistoryItemRef(e));break;default:i.push(this.toSourceControlHistoryItemRef(e))}return[...i,...r,...o]}async provideHistoryItems(e,t){if(!this.currentHistoryItemRef||!e.historyItemRefs)return[];let i={refNames:Array.from(new Set(e.historyItemRefs)),shortStats:!0};try{if(void 0===e.limit||"number"==typeof e.limit)i={...i,maxEntries:e.limit??50};else if("string"==typeof e.limit.id){const t=await this.repository.getCommit(e.limit.id),r=t.parents.length>0?t.parents[0]:await this.repository.getEmptyTree();i={...i,range:`${r}..`}}"number"==typeof e.skip&&(i={...i,skip:e.skip});const r="string"==typeof e.filterText&&""!==e.filterText?await this._searchHistoryItems(e.filterText.trim(),i,t):await this.repository.log({...i,silent:!0},t);if(t.isCancellationRequested)return[];const n={commits:r.map(e=>({hash:e.hash,authorName:e.authorName,authorEmail:e.authorEmail})),size:20},a=await(0,c.provideSourceControlHistoryItemAvatar)(this.historyItemDetailProviderRegistry,this.repository,n);await(0,l.ensureEmojis)();const h=[];for(const e of r){const t=(0,l.emojify)(e.message),i=await(0,c.provideSourceControlHistoryItemMessageLinks)(this.historyItemDetailProviderRegistry,this.repository,t)??t,r=t.indexOf("\n"),n=-1!==r?`${(0,s.truncate)(t,r,!1)}`:t,u=a?.get(e.hash),d=this._resolveHistoryItemRefs(e);h.push({id:e.hash,parentIds:e.parents,subject:n,message:i,author:e.authorName,authorEmail:e.authorEmail,authorIcon:u?o.Uri.parse(u):new o.ThemeIcon("account"),displayId:(0,s.truncate)(e.hash,this.commitShortHashLength,!1),timestamp:e.authorDate?.getTime(),statistics:e.shortStat??{files:0,insertions:0,deletions:0},references:0!==d.length?d:void 0})}return h}catch(t){return this.logger.error(`[GitHistoryProvider][provideHistoryItems] Failed to get history items with options '${JSON.stringify(e)}': ${t}`),[]}}async provideHistoryItemChanges(e,t){t=t??await this.repository.getEmptyTree();const i=[],r=[],s=await this.repository.diffTrees(t,e);for(const l of s){const s=l.uri.with({query:`ref=${e}`});r.push({uri:s,...(0,a.toMultiFileDiffEditorUris)(l,t,e)});const c=n.Resource.getStatusLetter(l.status),h=n.Resource.getStatusText(l.status),u=n.Resource.getStatusColor(l.status),d=new o.FileDecoration(c,h,u);this.historyItemDecorations.set(s.toString(),d),i.push(s)}return this._onDidChangeDecorations.fire(i),r}async resolveHistoryItemChatContext(e){try{return await this.repository.showCommit(e)}catch(t){this.logger.error(`[GitHistoryProvider][resolveHistoryItemChatContext] Failed to resolve history item '${e}': ${t}`)}}async resolveHistoryItemRefsCommonAncestor(e){try{if(0===e.length)return;if(1===e.length&&e[0]===this.currentHistoryItemRef?.id){if(this.currentHistoryItemRemoteRef)return await this.repository.getMergeBase(e[0],this.currentHistoryItemRemoteRef.id);if(this.currentHistoryItemBaseRef)return await this.repository.getMergeBase(e[0],this.currentHistoryItemBaseRef.id);const t=await this.repository.log({maxParents:0,refNames:["HEAD"]});if(t.length>0)return t[0].hash}else if(e.length>1)return await this.repository.getMergeBase(e[0],e[1],...e.slice(2))}catch(t){this.logger.error(`[GitHistoryProvider][resolveHistoryItemRefsCommonAncestor] Failed to resolve common ancestor for ${e.join(",")}: ${t}`)}}provideFileDecoration(e){return this.historyItemDecorations.get(e.toString())}_resolveHistoryItemRefs(e){const t=[];for(const i of e.refNames)if("refs/remotes/origin/HEAD"!==i)switch(!0){case i.startsWith("HEAD -> refs/heads/"):t.push({id:i.substring(8),name:i.substring(19),revision:e.hash,category:o.l10n.t("branches"),icon:new o.ThemeIcon("target")});break;case i.startsWith("refs/heads/"):t.push({id:i,name:i.substring(11),revision:e.hash,category:o.l10n.t("branches"),icon:new o.ThemeIcon("git-branch")});break;case i.startsWith("refs/remotes/"):t.push({id:i,name:i.substring(13),revision:e.hash,category:o.l10n.t("remote branches"),icon:new o.ThemeIcon("cloud")});break;case i.startsWith("tag: refs/tags/"):t.push({id:i.substring(5),name:i.substring(15),revision:e.hash,category:o.l10n.t("tags"),icon:new o.ThemeIcon("tag")})}return t.sort(u)}async resolveHEADMergeBase(){try{if(0!==this.repository.HEAD?.type||!this.repository.HEAD?.name)return;return await this.repository.getBranchBase(this.repository.HEAD.name)}catch(e){return void this.logger.error(`[GitHistoryProvider][resolveHEADMergeBase] Failed to resolve merge base for ${this.repository.HEAD?.name}: ${e}`)}}async _searchHistoryItems(e,t,i){if(i.isCancellationRequested)return[];const r=new Map,[o,n]=await Promise.all([this.repository.log({...t,refNames:void 0,author:e,silent:!0},i),this.repository.log({...t,refNames:void 0,grep:e,silent:!0},i)]);for(const e of[...o,...n])r.has(e.hash)||r.set(e.hash,e);return Array.from(r.values()).slice(0,t.maxEntries??50)}toSourceControlHistoryItemRef(e){switch(e.type){case 1:return{id:`refs/remotes/${e.name}`,name:e.name??"",description:e.commit?o.l10n.t("Remote branch at {0}",(0,s.truncate)(e.commit,this.commitShortHashLength,!1)):void 0,revision:e.commit,icon:new o.ThemeIcon("cloud"),category:o.l10n.t("remote branches")};case 2:return{id:`refs/tags/${e.name}`,name:e.name??"",description:e.commit?o.l10n.t("Tag at {0}",(0,s.truncate)(e.commit,this.commitShortHashLength,!1)):void 0,revision:e.commit,icon:new o.ThemeIcon("tag"),category:o.l10n.t("tags")};default:return{id:`refs/heads/${e.name}`,name:e.name??"",description:e.commit?(0,s.truncate)(e.commit,this.commitShortHashLength,!1):void 0,revision:e.commit,icon:new o.ThemeIcon("git-branch"),category:o.l10n.t("branches")}}}dispose(){(0,s.dispose)(this.disposables)}}t.GitHistoryProvider=d,r([h.throttle],d.prototype,"onDidRunWriteOperation",null)},8107:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.provideSourceControlHistoryItemAvatar=async function(e,t,i){for(const o of e.getSourceControlHistoryItemDetailsProviders()){const e=await o.provideAvatar(new r.ApiRepository(t),i);if(e)return e}},t.provideSourceControlHistoryItemHoverCommands=async function(e,t){for(const i of e.getSourceControlHistoryItemDetailsProviders()){const e=await i.provideHoverCommands(new r.ApiRepository(t));if(e)return e}},t.provideSourceControlHistoryItemMessageLinks=async function(e,t,i){for(const o of e.getSourceControlHistoryItemDetailsProviders()){const e=await o.provideMessageLinks(new r.ApiRepository(t),i);if(e)return e}};const r=i(6199)},8122:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.Deferred=void 0,t.Deferred=class{constructor(){this.resolve=()=>null,this.reject=()=>null,this.promise=new Promise((e,t)=>{this.reject=t,this.resolve=e})}}},8611:e=>{"use strict";e.exports=require("http")},8623:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.GitBaseApi=void 0;const r=i(1398);t.GitBaseApi=class{static getAPI(){if(!this._gitBaseApi){const e=r.extensions.getExtension("vscode.git-base").exports,t=t=>{this._gitBaseApi=t?e.getAPI(1):void 0};if(e.onDidChangeEnablement(t),t(e.enabled),!this._gitBaseApi)throw new Error("vscode.git-base extension is not enabled.")}return this._gitBaseApi}}},8632:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.AbstractTokenizer=void 0;const r=i(8705);t.AbstractTokenizer=class{constructor(e){this.position=0,this.numBuffer=new Uint8Array(8),this.fileInfo=e||{}}async readToken(e,t=this.position){const i=Buffer.alloc(e.len);if(await this.readBuffer(i,{position:t})<e.len)throw new r.EndOfStreamError;return e.get(i,0)}async peekToken(e,t=this.position){const i=Buffer.alloc(e.len);if(await this.peekBuffer(i,{position:t})<e.len)throw new r.EndOfStreamError;return e.get(i,0)}async readNumber(e){if(await this.readBuffer(this.numBuffer,{length:e.len})<e.len)throw new r.EndOfStreamError;return e.get(this.numBuffer,0)}async peekNumber(e){if(await this.peekBuffer(this.numBuffer,{length:e.len})<e.len)throw new r.EndOfStreamError;return e.get(this.numBuffer,0)}async ignore(e){if(void 0!==this.fileInfo.size){const t=this.fileInfo.size-this.position;if(e>t)return this.position+=t,t}return this.position+=e,e}async close(){}normalizeOptions(e,t){if(t&&void 0!==t.position&&t.position<this.position)throw new Error("`options.position` must be equal or greater than `tokenizer.position`");return t?{mayBeLess:!0===t.mayBeLess,offset:t.offset?t.offset:0,length:t.length?t.length:e.length-(t.offset?t.offset:0),position:t.position?t.position:this.position}:{mayBeLess:!1,offset:0,length:e.length,position:this.position}}}},8672:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.CommitCommandsCenter=t.GitPostCommitCommandsProvider=void 0;const r=i(1398),o=i(6199),n=i(7937);t.GitPostCommitCommandsProvider=class{constructor(e){this._repositoryResolver=e}getCommands(e){const t=this._repositoryResolver.getRepository(e.rootUri);if(!t)return[];const i=r.workspace.getConfiguration("git",r.Uri.file(t.root)),o=t.isBranchProtected(),n=i.get("branchProtectionPrompt"),s=o&&"alwaysPrompt"===n,a=o&&"alwaysCommitToNewBranch"===n,l=t.operations.isRunning("Commit")||t.operations.isRunning("PostCommitCommand"),c=l?"$(sync~spin)":s?"$(lock)":a?"$(git-branch)":void 0;let h=a?r.l10n.t("Commit to New Branch & Push Changes"):r.l10n.t("Commit & Push Changes"),u=a?r.l10n.t("Commit to New Branch & Synchronize Changes"):r.l10n.t("Commit & Sync Changes");return l&&(h=a?r.l10n.t("Committing to New Branch & Pushing Changes..."):r.l10n.t("Committing & Pushing Changes..."),u=a?r.l10n.t("Committing to New Branch & Synchronizing Changes..."):r.l10n.t("Committing & Synchronizing Changes...")),[{command:"git.push",title:r.l10n.t("{0} Commit & Push",c??"$(arrow-up)"),tooltip:h},{command:"git.sync",title:r.l10n.t("{0} Commit & Sync",c??"$(sync)"),tooltip:u}]}},t.CommitCommandsCenter=class{get onDidChange(){return this._onDidChange.event}set postCommitCommand(e){void 0!==e&&this.globalState.update(this.getGlobalStateKey(),e).then(()=>this._onDidChange.fire())}constructor(e,t,i){this.globalState=e,this.repository=t,this.postCommitCommandsProviderRegistry=i,this._onDidChange=new r.EventEmitter,this.disposables=[];const o=r.Uri.file(t.root);this.migratePostCommitCommandStorage().then(()=>{const e=async()=>{r.workspace.getConfiguration("git",o).get("rememberPostCommitCommand")||await this.globalState.update(this.getGlobalStateKey(),void 0)};this.disposables.push(r.workspace.onDidChangeConfiguration(t=>{t.affectsConfiguration("git.rememberPostCommitCommand",o)&&e()})),e(),this.disposables.push(i.onDidChangePostCommitCommandsProviders(()=>this._onDidChange.fire()))})}getPrimaryCommand(){const e=this.getSecondaryCommands().map(e=>e).flat(),t=e.find(e=>2===e.arguments?.length&&e.arguments[1]===this.getPostCommitCommandStringFromStorage()),i=e.find(e=>2===e.arguments?.length&&e.arguments[1]===this.getPostCommitCommandStringFromSetting());return t??i??this.getCommitCommands()[0]}getSecondaryCommands(){const e=[];for(const t of this.postCommitCommandsProviderRegistry.getPostCommitCommandsProviders()){const i=t.getCommands(new o.ApiRepository(this.repository));e.push((i??[]).map(e=>({command:"git.commit",title:e.title,tooltip:e.tooltip,arguments:[this.repository.sourceControl,e.command]})))}return e.length>0&&e.splice(0,0,this.getCommitCommands()),e}async executePostCommitCommand(e){try{if(null===e)return;if(void 0===e){const t=this.getPrimaryCommand();e=2===t.arguments?.length?t.arguments[1]:null}null!==e&&await r.commands.executeCommand(e.toString(),new o.ApiRepository(this.repository))}catch(e){throw e}finally{this.isRememberPostCommitCommandEnabled()||(await this.globalState.update(this.getGlobalStateKey(),void 0),this._onDidChange.fire())}}getGlobalStateKey(){return`postCommitCommand:${this.repository.root}`}getCommitCommands(){const e=r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)),t=this.repository.isBranchProtected(),i=e.get("branchProtectionPrompt"),o=t&&"alwaysCommitToNewBranch"===i,n=t&&"alwaysPrompt"===i?"$(lock)":o?"$(git-branch)":void 0,s=this.repository.HEAD?.name;let a=o?r.l10n.t("Commit Changes to New Branch"):s?r.l10n.t('Commit Changes on "{0}"',s):r.l10n.t("Commit Changes");return this.repository.operations.isRunning("Commit")&&(a=o?r.l10n.t("Committing Changes to New Branch..."):r.l10n.t("Committing Changes...")),[{command:"git.commit",title:r.l10n.t("{0} Commit",n??"$(check)"),tooltip:a,arguments:[this.repository.sourceControl,null]},{command:"git.commitAmend",title:r.l10n.t("{0} Commit (Amend)",n??"$(check)"),tooltip:a,arguments:[this.repository.sourceControl,null]}]}getPostCommitCommandStringFromSetting(){const e=r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)).get("postCommitCommand");return"push"===e||"sync"===e?`git.${e}`:void 0}getPostCommitCommandStringFromStorage(){return this.globalState.get(this.getGlobalStateKey())}async migratePostCommitCommandStorage(){const e=this.globalState.get(this.repository.root);void 0!==e&&(await this.globalState.update(this.getGlobalStateKey(),e),await this.globalState.update(this.repository.root,void 0))}isRememberPostCommitCommandEnabled(){return!0===r.workspace.getConfiguration("git",r.Uri.file(this.repository.root)).get("rememberPostCommitCommand")}dispose(){this.disposables=(0,n.dispose)(this.disposables)}}},8705:(e,t,i)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.StreamReader=t.EndOfStreamError=void 0;var r=i(5523);Object.defineProperty(t,"EndOfStreamError",{enumerable:!0,get:function(){return r.EndOfStreamError}});var o=i(1510);Object.defineProperty(t,"StreamReader",{enumerable:!0,get:function(){return o.StreamReader}})},9023:e=>{"use strict";e.exports=require("util")},9212:(e,t)=>{"use strict";Object.defineProperty(t,"__esModule",{value:!0}),t.OperationManager=t.Operation=void 0,t.Operation={Add:e=>({kind:"Add",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:e}),Apply:{kind:"Apply",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Blame:e=>({kind:"Blame",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:e}),Branch:{kind:"Branch",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},CheckIgnore:{kind:"CheckIgnore",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},CherryPick:{kind:"CherryPick",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Checkout:e=>({kind:"Checkout",blocking:!0,readOnly:!1,remote:!1,retry:!1,showProgress:!0,refLabel:e}),CheckoutTracking:e=>({kind:"CheckoutTracking",blocking:!0,readOnly:!1,remote:!1,retry:!1,showProgress:!0,refLabel:e}),Clean:e=>({kind:"Clean",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:e}),Commit:{kind:"Commit",blocking:!0,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Config:e=>({kind:"Config",blocking:!1,readOnly:e,remote:!1,retry:!1,showProgress:!1}),DeleteBranch:{kind:"DeleteBranch",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},DeleteRef:{kind:"DeleteRef",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},DeleteRemoteRef:{kind:"DeleteRemoteRef",blocking:!1,readOnly:!1,remote:!0,retry:!1,showProgress:!0},DeleteTag:{kind:"DeleteTag",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},DeleteWorktree:{kind:"DeleteWorktree",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Diff:{kind:"Diff",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},Fetch:e=>({kind:"Fetch",blocking:!1,readOnly:!1,remote:!0,retry:!0,showProgress:e}),FindTrackingBranches:{kind:"GetTracking",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!0},GetBranch:{kind:"GetBranch",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},GetBranches:{kind:"GetBranches",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!0},GetCommitTemplate:{kind:"GetCommitTemplate",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!0},GetObjectDetails:{kind:"GetObjectDetails",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},GetObjectFiles:{kind:"GetObjectFiles",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},GetRefs:{kind:"GetRefs",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},GetWorktrees:{kind:"GetWorktrees",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},GetRemoteRefs:{kind:"GetRemoteRefs",blocking:!1,readOnly:!0,remote:!0,retry:!1,showProgress:!1},HashObject:{kind:"HashObject",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Ignore:{kind:"Ignore",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Log:e=>({kind:"Log",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:e}),LogFile:{kind:"LogFile",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},Merge:{kind:"Merge",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},MergeAbort:{kind:"MergeAbort",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},MergeBase:{kind:"MergeBase",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!0},Move:{kind:"Move",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},PostCommitCommand:{kind:"PostCommitCommand",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Pull:{kind:"Pull",blocking:!0,readOnly:!1,remote:!0,retry:!0,showProgress:!0},Push:{kind:"Push",blocking:!0,readOnly:!1,remote:!0,retry:!1,showProgress:!0},Remote:{kind:"Remote",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},RenameBranch:{kind:"RenameBranch",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Remove:{kind:"Remove",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Reset:{kind:"Reset",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Rebase:{kind:"Rebase",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},RebaseAbort:{kind:"RebaseAbort",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},RebaseContinue:{kind:"RebaseContinue",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Refresh:{kind:"Refresh",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},RevertFiles:e=>({kind:"RevertFiles",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:e}),RevList:{kind:"RevList",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},RevParse:{kind:"RevParse",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},SetBranchUpstream:{kind:"SetBranchUpstream",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Show:{kind:"Show",blocking:!1,readOnly:!0,remote:!1,retry:!1,showProgress:!1},Stage:{kind:"Stage",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Status:{kind:"Status",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Stash:{kind:"Stash",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},SubmoduleUpdate:{kind:"SubmoduleUpdate",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Sync:{kind:"Sync",blocking:!0,readOnly:!1,remote:!0,retry:!0,showProgress:!0},Tag:{kind:"Tag",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0},Worktree:{kind:"Worktree",blocking:!1,readOnly:!1,remote:!1,retry:!1,showProgress:!0}},t.OperationManager=class{constructor(e){this.logger=e,this.operations=new Map}start(e){this.operations.has(e.kind)?this.operations.get(e.kind).add(e):this.operations.set(e.kind,new Set([e])),this.logger.trace(`[OperationManager][start] ${e.kind} (blocking: ${e.blocking}, readOnly: ${e.readOnly}; retry: ${e.retry}; showProgress: ${e.showProgress})`)}end(e){const t=this.operations.get(e.kind);t&&(t.delete(e),0===t.size&&this.operations.delete(e.kind)),this.logger.trace(`[OperationManager][end] ${e.kind} (blocking: ${e.blocking}, readOnly: ${e.readOnly}; retry: ${e.retry}; showProgress: ${e.showProgress})`)}getOperations(e){const t=this.operations.get(e);return t?Array.from(t):[]}isIdle(){const e=this.operations.values();for(const t of e)for(const e of t)if(!e.readOnly)return!1;return!0}isRunning(e){return this.operations.has(e)}shouldDisableCommands(){const e=this.operations.values();for(const t of e)for(const e of t)if(e.blocking)return!0;return!1}shouldShowProgress(){const e=this.operations.values();for(const t of e)for(const e of t)if(e.showProgress)return!0;return!1}}},9522:function(e,t,i){"use strict";var r,o=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var o=Object.getOwnPropertyDescriptor(t,i);o&&!("get"in o?!t.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,o)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),n=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),s=this&&this.__importStar||(r=function(e){return r=Object.getOwnPropertyNames||function(e){var t=[];for(var i in e)Object.prototype.hasOwnProperty.call(e,i)&&(t[t.length]=i);return t},r(e)},function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i=r(e),s=0;s<i.length;s++)"default"!==i[s]&&o(t,e,i[s]);return n(t,e),t});Object.defineProperty(t,"__esModule",{value:!0}),t.GitEditSessionIdentityProvider=void 0;const a=s(i(6928)),l=s(i(1398));function c(e){let{remote:t,ref:i,sha:r}=JSON.parse(e);return"string"==typeof t&&t.endsWith(".git")&&(t=t.slice(0,t.length-4)),{remote:t,ref:i,sha:r}}t.GitEditSessionIdentityProvider=class{constructor(e){this.model=e,this.providerRegistration=l.Disposable.from(l.workspace.registerEditSessionIdentityProvider("file",this),l.workspace.onWillCreateEditSessionIdentity(e=>{e.waitUntil(this._onWillCreateEditSessionIdentity(e.workspaceFolder).catch(e=>{if(e instanceof l.CancellationError)throw e}))}))}dispose(){this.providerRegistration.dispose()}async provideEditSessionIdentity(e,t){await this.model.openRepository(a.dirname(e.uri.fsPath));const i=this.model.getRepository(e.uri);if(await(i?.status()),!i||!i?.HEAD?.upstream)return;const r=i.remotes.find(e=>e.name===i.HEAD?.upstream?.remote)?.pushUrl?.replace(/^(git@[^\/:]+)(:)/i,"ssh://$1/"),o=r?await l.workspace.getCanonicalUri(l.Uri.parse(r),{targetScheme:"https"},t):null;return JSON.stringify({remote:o?.toString()??r,ref:i.HEAD?.upstream?.name??null,sha:i.HEAD?.commit??null})}provideEditSessionIdentityMatch(e,t){try{const i=c(e),r=c(t);return i.remote===r.remote&&i.ref===r.ref&&i.sha===r.sha?l.EditSessionIdentityMatch.Complete:i.remote===r.remote&&i.ref===r.ref&&i.sha!==r.sha?l.EditSessionIdentityMatch.Partial:l.EditSessionIdentityMatch.None}catch(e){return l.EditSessionIdentityMatch.Partial}}async _onWillCreateEditSessionIdentity(e){await this._doPublish(e)}async _doPublish(e){await this.model.openRepository(a.dirname(e.uri.fsPath));const t=this.model.getRepository(e.uri);if(t)if(await t.status(),t.HEAD?.commit){if(!t.HEAD?.upstream&&0===t.HEAD?.type){const e=l.l10n.t("Publish Branch");if(await l.window.showInformationMessage(l.l10n.t("The current branch is not published to the remote. Would you like to publish it to access your changes elsewhere?"),{modal:!0},e)!==e)throw new l.CancellationError;await l.commands.executeCommand("git.publish")}}else{const e=l.l10n.t("Yes");if(await l.window.showInformationMessage(l.l10n.t("Would you like to publish this repository to continue working on it elsewhere?"),{modal:!0},e)!==e)throw new l.CancellationError;await t.commit("Initial commit",{all:!0}),await l.commands.executeCommand("git.publish")}}}},9815:function(e,t,i){"use strict";var r=this&&this.__decorate||function(e,t,i,r){var o,n=arguments.length,s=n<3?t:null===r?r=Object.getOwnPropertyDescriptor(t,i):r;if("object"==typeof Reflect&&"function"==typeof Reflect.decorate)s=Reflect.decorate(e,t,i,r);else for(var a=e.length-1;a>=0;a--)(o=e[a])&&(s=(n<3?o(s):n>3?o(t,i,s):o(t,i))||s);return n>3&&s&&Object.defineProperty(t,i,s),s};Object.defineProperty(t,"__esModule",{value:!0}),t.GitExtensionImpl=void 0,t.deprecated=s;const o=i(6199),n=i(1398);function s(e,t,i){if("function"!=typeof i.value)throw new Error("not supported");const r=i.value;i.value=function(){return console.warn(`Git extension API method '${t}' is deprecated.`),r.apply(this,arguments)}}class a{set model(e){this._model=e;const t=!!e;this.enabled!==t&&(this.enabled=t,this._onDidChangeEnablement.fire(this.enabled))}get model(){return this._model}constructor(e){this.enabled=!1,this._onDidChangeEnablement=new n.EventEmitter,this.onDidChangeEnablement=this._onDidChangeEnablement.event,this._model=void 0,e&&(this.enabled=!0,this._model=e)}async getGitPath(){if(!this._model)throw new Error("Git model not found");return this._model.git.path}async getRepositories(){if(!this._model)throw new Error("Git model not found");return this._model.repositories.map(e=>new o.ApiRepository(e))}getAPI(e){if(!this._model)throw new Error("Git model not found");if(1!==e)throw new Error(`No API version ${e} found.`);return new o.ApiImpl(this._model)}}t.GitExtensionImpl=a,r([s],a.prototype,"getGitPath",null),r([s],a.prototype,"getRepositories",null)},9896:e=>{"use strict";e.exports=require("fs")}},__webpack_module_cache__={};function __webpack_require__(e){var t=__webpack_module_cache__[e];if(void 0!==t)return t.exports;var i=__webpack_module_cache__[e]={exports:{}};return __webpack_modules__[e].call(i.exports,i,i.exports,__webpack_require__),i.exports}__webpack_require__.d=(e,t)=>{for(var i in t)__webpack_require__.o(t,i)&&!__webpack_require__.o(e,i)&&Object.defineProperty(e,i,{enumerable:!0,get:t[i]})},__webpack_require__.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),__webpack_require__.r=e=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})};var __webpack_exports__=__webpack_require__(1184),__webpack_export_target__=exports;for(var __webpack_i__ in __webpack_exports__)__webpack_export_target__[__webpack_i__]=__webpack_exports__[__webpack_i__];__webpack_exports__.__esModule&&Object.defineProperty(__webpack_export_target__,"__esModule",{value:!0})})();
//# sourceMappingURL=/extensions/git/dist/main.js.map